/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.task;

import com.obs.services.AbstractClient;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.task.AbstractObsTask;
import com.obs.services.internal.task.DefaultTaskProgressStatus;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RestoreObjectResult;
import com.obs.services.model.TaskCallback;
import com.obs.services.model.TaskProgressListener;

public class RestoreObjectTask
extends AbstractObsTask {
    private RestoreObjectRequest taskRequest;
    protected TaskCallback<RestoreObjectResult, RestoreObjectRequest> callback;

    public RestoreObjectTask(ObsClient obsClient, String bucketName) {
        super(obsClient, bucketName);
    }

    public RestoreObjectTask(AbstractClient obsClient, String bucketName, RestoreObjectRequest taskRequest, TaskCallback<RestoreObjectResult, RestoreObjectRequest> callback) {
        super(obsClient, bucketName);
        this.taskRequest = taskRequest;
        this.callback = callback;
    }

    public RestoreObjectTask(AbstractClient obsClient, String bucketName, RestoreObjectRequest taskRequest, TaskCallback<RestoreObjectResult, RestoreObjectRequest> callback, TaskProgressListener listener, DefaultTaskProgressStatus progressStatus, int taskProgressInterval) {
        super(obsClient, bucketName, progressStatus, listener, taskProgressInterval);
        this.taskRequest = taskRequest;
        this.callback = callback;
    }

    public RestoreObjectRequest getTaskRequest() {
        return this.taskRequest;
    }

    public void setTaskRequest(RestoreObjectRequest taskRequest) {
        this.taskRequest = taskRequest;
    }

    public TaskCallback<RestoreObjectResult, RestoreObjectRequest> getCallback() {
        return this.callback;
    }

    public void setCallback(TaskCallback<RestoreObjectResult, RestoreObjectRequest> callback) {
        this.callback = callback;
    }

    private void restoreObjects() {
        try {
            RestoreObjectResult result = this.getObsClient().restoreObjectV2(this.taskRequest);
            this.getProgressStatus().succeedTaskIncrement();
            this.callback.onSuccess(result);
        }
        catch (ObsException e) {
            this.getProgressStatus().failTaskIncrement();
            this.callback.onException(e, this.taskRequest);
        }
        this.getProgressStatus().execTaskIncrement();
        if (this.getProgressListener() != null) {
            if (this.getProgressStatus().getExecTaskNum() % this.getTaskProgressInterval() == 0) {
                this.getProgressListener().progressChanged(this.getProgressStatus());
            }
            if (this.getProgressStatus().getExecTaskNum() == this.getProgressStatus().getTotalTaskNum()) {
                this.getProgressListener().progressChanged(this.getProgressStatus());
            }
        }
    }

    @Override
    public void run() {
        this.restoreObjects();
    }
}

