/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.ServerConfiguration;
import io.questdb.cutlass.auth.UsernamePasswordMatcher;
import io.questdb.cutlass.pgwire.PGConfiguration;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.QuietCloseable;
import io.questdb.std.SimpleReadWriteLock;
import io.questdb.std.str.DirectUtf8Sink;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.Nullable;

public class DynamicUsernamePasswordMatcher
implements UsernamePasswordMatcher,
QuietCloseable {
    private final DirectUtf8Sink defaultPassword;
    private final SimpleReadWriteLock lock;
    private final PGConfiguration pgWireConfig;
    private final DirectUtf8Sink readOnlyPassword;
    private final ServerConfiguration serverConfig;
    private long serverConfigVersion;

    public DynamicUsernamePasswordMatcher(@Nullable ServerConfiguration serverConfig, PGConfiguration pgWireConfig) {
        this.serverConfig = serverConfig;
        this.serverConfigVersion = serverConfig != null ? serverConfig.getVersion() : 0L;
        this.pgWireConfig = pgWireConfig;
        this.defaultPassword = new DirectUtf8Sink(4L);
        this.defaultPassword.put(pgWireConfig.getDefaultPassword());
        this.readOnlyPassword = new DirectUtf8Sink(4L);
        this.readOnlyPassword.put(pgWireConfig.getReadOnlyPassword());
        this.lock = new SimpleReadWriteLock();
    }

    @Override
    public void close() {
        Misc.free(this.defaultPassword);
        Misc.free(this.readOnlyPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte verifyPassword(CharSequence username, long passwordPtr, int passwordLen) {
        if (this.serverConfig != null && this.serverConfig.getVersion() != this.serverConfigVersion && this.lock.writeLock().tryLock()) {
            try {
                if (this.serverConfig.getVersion() != this.serverConfigVersion) {
                    this.defaultPassword.clear();
                    this.defaultPassword.put(this.pgWireConfig.getDefaultPassword());
                    this.readOnlyPassword.clear();
                    this.readOnlyPassword.put(this.pgWireConfig.getReadOnlyPassword());
                    this.serverConfigVersion = this.serverConfig.getVersion();
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            if (username.length() == 0) {
                byte by = 0;
                return by;
            }
            if (Chars.equals(username, (CharSequence)this.pgWireConfig.getDefaultUsername())) {
                byte by = this.verifyPassword(this.defaultPassword, passwordPtr, passwordLen);
                return by;
            }
            if (this.pgWireConfig.isReadOnlyUserEnabled() && Chars.equals(username, (CharSequence)this.pgWireConfig.getReadOnlyUsername())) {
                byte by = this.verifyPassword(this.readOnlyPassword, passwordPtr, passwordLen);
                return by;
            }
            byte by = 0;
            return by;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private byte verifyPassword(DirectUtf8Sink expectedPwd, long passwordPtr, int passwordLen) {
        if (Utf8s.equals(expectedPwd, passwordPtr, passwordLen)) {
            return 1;
        }
        return 0;
    }
}

