/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ReverseTableMapItem;
import io.questdb.cairo.TableFlagResolver;
import io.questdb.cairo.TableNameRegistry;
import io.questdb.cairo.TableNameRegistryStore;
import io.questdb.cairo.TableToken;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjHashSet;
import java.util.Map;

public abstract class AbstractTableNameRegistry
implements TableNameRegistry {
    protected final CairoEngine engine;
    protected final TableNameRegistryStore nameStore;
    protected final TableFlagResolver tableFlagResolver;
    protected ConcurrentHashMap<ReverseTableMapItem> dirNameToTableTokenMap;
    protected ConcurrentHashMap<TableToken> tableNameToTableTokenMap;

    public AbstractTableNameRegistry(CairoEngine engine, TableFlagResolver tableFlagResolver) {
        this.engine = engine;
        this.nameStore = new TableNameRegistryStore(engine.configuration, tableFlagResolver);
        this.tableFlagResolver = tableFlagResolver;
    }

    @Override
    public synchronized void close() {
        this.tableNameToTableTokenMap.clear();
        this.dirNameToTableTokenMap.clear();
        Misc.free(this.nameStore);
    }

    @Override
    public TableToken getTableToken(CharSequence tableName) {
        return this.tableNameToTableTokenMap.get(tableName);
    }

    @Override
    public TableToken getTableTokenByDirName(CharSequence dirName) {
        ReverseTableMapItem rmi = this.dirNameToTableTokenMap.get(dirName);
        if (rmi != null && !rmi.isDropped()) {
            return rmi.getToken();
        }
        return null;
    }

    @Override
    public int getTableTokenCount(boolean includeDropped) {
        int count = 0;
        for (ReverseTableMapItem entry : this.dirNameToTableTokenMap.values()) {
            if (!includeDropped && entry.isDropped()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void getTableTokens(ObjHashSet<TableToken> target, boolean includeDropped) {
        target.clear();
        for (ReverseTableMapItem entry : this.dirNameToTableTokenMap.values()) {
            if (!includeDropped && entry.isDropped()) continue;
            target.add(entry.getToken());
        }
    }

    @Override
    public TableToken getTokenByDirName(CharSequence dirName) {
        ReverseTableMapItem entry = this.dirNameToTableTokenMap.get(dirName);
        return entry == null ? null : entry.getToken();
    }

    @Override
    public boolean isTableDropped(TableToken tableToken) {
        if (tableToken.isWal()) {
            return this.isWalTableDropped(tableToken.getDirName());
        }
        TableToken currentTableToken = this.tableNameToTableTokenMap.get(tableToken.getTableName());
        return currentTableToken == LOCKED_DROP_TOKEN;
    }

    @Override
    public boolean isWalTableDropped(CharSequence tableDir) {
        ReverseTableMapItem rmi = this.dirNameToTableTokenMap.get(tableDir);
        return rmi != null && rmi.isDropped();
    }

    @Override
    public synchronized void reconcile() {
        for (Map.Entry<CharSequence, TableToken> entry : this.tableNameToTableTokenMap.entrySet()) {
            TableToken tableNameTableToken = entry.getValue();
            if (TableNameRegistry.isLocked(tableNameTableToken)) continue;
            ReverseTableMapItem dirNameTableToken = this.dirNameToTableTokenMap.get(tableNameTableToken.getDirName());
            if (dirNameTableToken == null) {
                throw new IllegalStateException("table " + String.valueOf(tableNameTableToken) + " does not have directory mapping");
            }
            if (dirNameTableToken.isDropped()) {
                throw new IllegalStateException("table " + String.valueOf(tableNameTableToken) + " should not be in dropped state");
            }
            if (dirNameTableToken.getToken().getTableId() == tableNameTableToken.getTableId()) continue;
            throw new IllegalStateException("table " + String.valueOf(tableNameTableToken) + " ID mismatch");
        }
        for (Map.Entry<CharSequence, Object> entry : this.dirNameToTableTokenMap.entrySet()) {
            ReverseTableMapItem item = (ReverseTableMapItem)entry.getValue();
            TableToken dirToNameToken = item.getToken();
            TableToken tokenByName = this.tableNameToTableTokenMap.get(dirToNameToken.getTableName());
            if (item.isDropped()) {
                if (tokenByName == null || !tokenByName.equals(dirToNameToken)) continue;
                throw new IllegalStateException("table " + tokenByName.getTableName() + " is dropped but still present in table name registry");
            }
            if (tokenByName == null) {
                throw new IllegalStateException("table " + dirToNameToken.getTableName() + " is not dropped but name is not present in table name registry");
            }
            if (dirToNameToken.equals(tokenByName)) continue;
            throw new IllegalStateException("table " + dirToNameToken.getTableName() + " tokens mismatch");
        }
    }

    @Override
    public synchronized void resetMemory() {
        this.nameStore.resetMemory();
    }

    void setNameMaps(ConcurrentHashMap<TableToken> tableNameToTableTokenMap, ConcurrentHashMap<ReverseTableMapItem> dirNameToTableTokenMap) {
        this.tableNameToTableTokenMap = tableNameToTableTokenMap;
        this.dirNameToTableTokenMap = dirNameToTableTokenMap;
    }
}

