/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.NullIndexFrameCursor;
import io.questdb.cairo.AbstractIndexReader;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.IndexFrame;
import io.questdb.cairo.IndexFrameCursor;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;

public class BitmapIndexFwdReader
extends AbstractIndexReader {
    private static final Log LOG = LogFactory.getLog(BitmapIndexFwdReader.class);
    private final Cursor cursor = new Cursor();
    private final NullCursor nullCursor = new NullCursor();

    public BitmapIndexFwdReader(CairoConfiguration configuration, Path path, CharSequence name, long columnNameTxn, long partitionTxn, long columnTop) {
        this.of(configuration, path, name, columnNameTxn, partitionTxn, columnTop);
    }

    @Override
    public RowCursor getCursor(boolean cachedInstance, int key, long minValue, long maxValue) {
        if (key >= this.keyCount) {
            this.updateKeyCount();
        }
        if (key == 0 && this.columnTop > 0L && minValue < this.columnTop) {
            NullCursor nullCursor = this.getNullCursor(cachedInstance);
            nullCursor.nullPos = minValue;
            long hi = maxValue == Long.MAX_VALUE ? Long.MAX_VALUE : maxValue + 1L;
            nullCursor.nullCount = Math.min(this.columnTop, hi);
            nullCursor.of(key, minValue, maxValue, this.keyCount);
            return nullCursor;
        }
        if (key < this.keyCount) {
            Cursor cursor = this.getCursor(cachedInstance);
            cursor.of(key, minValue, maxValue, this.keyCount);
            return cursor;
        }
        return EmptyRowCursor.INSTANCE;
    }

    @Override
    public IndexFrameCursor getFrameCursor(int key, long minRowId, long maxRowId) {
        if (key >= this.keyCount) {
            this.updateKeyCount();
        }
        if (key < this.keyCount) {
            Cursor cursor = this.getCursor(false);
            cursor.of(key, minRowId, maxRowId, this.keyCount);
            return cursor;
        }
        return NullIndexFrameCursor.INSTANCE;
    }

    private Cursor getCursor(boolean cachedInstance) {
        return cachedInstance ? this.cursor : new Cursor();
    }

    private NullCursor getNullCursor(boolean cachedInstance) {
        return cachedInstance ? this.nullCursor : new NullCursor();
    }

    private class Cursor
    implements RowCursor,
    IndexFrameCursor {
        private final IndexFrame indexFrame = new IndexFrame();
        protected long next;
        protected long position;
        protected long valueCount;
        private long maxValue;
        private long minValue;
        private long valueBlockOffset;
        private final BitmapIndexUtils.ValueBlockSeeker SEEKER = this::seekValue;

        private Cursor() {
        }

        @Override
        public boolean hasNext() {
            if (this.position < this.valueCount) {
                long cellIndex;
                long result;
                if ((result = BitmapIndexFwdReader.this.valueMem.getLong(this.valueBlockOffset + (cellIndex = this.getValueCellIndex(this.position++)) * 8L)) > this.maxValue) {
                    this.valueCount = 0L;
                    return false;
                }
                if (cellIndex == (long)BitmapIndexFwdReader.this.blockValueCountMod && this.position < this.valueCount) {
                    this.jumpToNextValueBlock();
                }
                this.next = result;
                return true;
            }
            return false;
        }

        @Override
        public long next() {
            return this.next - this.minValue;
        }

        @Override
        public IndexFrame nextIndexFrame() {
            if (this.position < this.valueCount) {
                long cellIndex = this.getValueCellIndex(this.position);
                long address = BitmapIndexFwdReader.this.valueMem.addressOf(this.valueBlockOffset + cellIndex * 8L);
                long pageSize = Math.min(this.valueCount - this.position, (long)BitmapIndexFwdReader.this.blockValueCountMod - cellIndex + 1L);
                this.position += pageSize;
                if (this.position < this.valueCount) {
                    this.jumpToNextValueBlock();
                }
                return this.indexFrame.of(address, pageSize);
            }
            return IndexFrame.NULL_INSTANCE;
        }

        private long getNextBlock(long currentValueBlockOffset) {
            return BitmapIndexFwdReader.this.valueMem.getLong(currentValueBlockOffset + (long)BitmapIndexFwdReader.this.blockCapacity - 16L + 8L);
        }

        private long getValueCellIndex(long absoluteValueIndex) {
            return absoluteValueIndex & (long)BitmapIndexFwdReader.this.blockValueCountMod;
        }

        private void jumpToNextValueBlock() {
            this.valueBlockOffset = this.getNextBlock(this.valueBlockOffset);
        }

        private void seekValue(long count, long offset) {
            this.position = count;
            this.valueBlockOffset = offset;
        }

        void of(int key, long minValue, long maxValue, long keyCount) {
            if (keyCount == 0L) {
                this.valueCount = 0L;
            } else {
                long lastValueBlockOffset;
                long valueBlockOffset;
                long valueCount;
                block6: {
                    assert (key > -1) : "key must be positive integer: " + key;
                    long offset = BitmapIndexUtils.getKeyEntryOffset(key);
                    BitmapIndexFwdReader.this.keyMem.extend(offset + 32L);
                    long deadline = BitmapIndexFwdReader.this.clock.getTicks() + BitmapIndexFwdReader.this.spinLockTimeoutMs;
                    do {
                        valueCount = BitmapIndexFwdReader.this.keyMem.getLong(offset + 0L);
                        Unsafe.getUnsafe().loadFence();
                        if (BitmapIndexFwdReader.this.keyMem.getLong(offset + 24L) != valueCount) continue;
                        valueBlockOffset = BitmapIndexFwdReader.this.keyMem.getLong(offset + 8L);
                        lastValueBlockOffset = BitmapIndexFwdReader.this.keyMem.getLong(offset + 16L);
                        Unsafe.getUnsafe().loadFence();
                        if (BitmapIndexFwdReader.this.keyMem.getLong(offset + 0L) == valueCount) break block6;
                    } while (BitmapIndexFwdReader.this.clock.getTicks() <= deadline);
                    LOG.error().$("cursor could not consistently read index header [corrupt?]").$(" [timeout=").$(BitmapIndexFwdReader.this.spinLockTimeoutMs).$("ms, key=").$(key).$(", offset=").$(offset).$(']').$();
                    throw CairoException.critical(0).put("cursor could not consistently read index header [corrupt?]");
                }
                BitmapIndexFwdReader.this.valueMem.extend(lastValueBlockOffset + (long)BitmapIndexFwdReader.this.blockCapacity);
                this.valueCount = valueCount;
                if (valueCount > 0L) {
                    BitmapIndexUtils.seekValueBlockLTR(valueCount, valueBlockOffset, BitmapIndexFwdReader.this.valueMem, minValue, BitmapIndexFwdReader.this.blockValueCountMod, this.SEEKER);
                } else {
                    this.seekValue(valueCount, valueBlockOffset);
                }
                this.minValue = minValue;
                this.maxValue = maxValue;
            }
        }
    }

    private class NullCursor
    extends Cursor {
        private long nullCount;
        private long nullPos;

        private NullCursor() {
        }

        @Override
        public boolean hasNext() {
            if (this.nullPos < this.nullCount) {
                this.next = this.nullPos++;
                return true;
            }
            return super.hasNext();
        }
    }
}

