/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableToken;
import io.questdb.std.Files;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Os;
import io.questdb.std.ThreadLocal;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CairoException
extends RuntimeException
implements Sinkable,
FlyweightMessageContainer {
    public static final int ERRNO_ACCESS_DENIED_WIN = 5;
    public static final int ERRNO_FILE_DOES_NOT_EXIST = 2;
    public static final int ERRNO_FILE_DOES_NOT_EXIST_WIN = 3;
    public static final int METADATA_VALIDATION = -100;
    public static final int ILLEGAL_OPERATION = -101;
    private static final int TABLE_DROPPED = -102;
    public static final int METADATA_VALIDATION_RECOVERABLE = -103;
    public static final int PARTITION_MANIPULATION_RECOVERABLE = -104;
    public static final int TABLE_DOES_NOT_EXIST = -105;
    public static final int MAT_VIEW_DOES_NOT_EXIST = -106;
    public static final int TXN_BLOCK_APPLY_FAILED = -107;
    public static final int NON_CRITICAL = -1;
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final ThreadLocal<CairoException> tlException = new ThreadLocal<CairoException>(CairoException::new);
    protected final StringSink message = new StringSink();
    protected final StringSink nativeBacktrace = new StringSink();
    protected int errno;
    private boolean authorizationError = false;
    private boolean cacheable;
    private boolean cancellation;
    private boolean housekeeping;
    private boolean interruption;
    private int messagePosition;
    private boolean outOfMemory;
    private boolean preferencesOutOfDateError = false;

    public static CairoException authorization() {
        return CairoException.nonCritical().setAuthorizationError();
    }

    public static CairoException critical(int errno) {
        return CairoException.instance(errno);
    }

    public static CairoException detachedColumnMetadataMismatch(int columnIndex, CharSequence columnName, CharSequence attribute) {
        return CairoException.critical(-100).put("Detached column [index=").put(columnIndex).put(", name=").put(columnName).put(", attribute=").put(attribute).put("] does not match current table metadata");
    }

    public static CairoException detachedMetadataMismatch(CharSequence attribute) {
        return CairoException.critical(-100).put("Detached partition metadata [").put(attribute).put("] is not compatible with current table metadata");
    }

    public static CairoException duplicateColumn(CharSequence column, CharSequence columnAlias) {
        CairoException exception = CairoException.critical(-100).put("duplicate column [name=").put(column);
        if (columnAlias != null) {
            exception.put(", alias=").put(columnAlias);
        }
        return exception.put(']');
    }

    public static CairoException duplicateColumn(CharSequence columnName) {
        return CairoException.duplicateColumn(columnName, null);
    }

    public static CairoException entityIsDisabled(CharSequence entityName) {
        return CairoException.nonCritical().put("entity is disabled [name=").put(entityName).put(']');
    }

    public static CairoException fileNotFound() {
        return CairoException.instance(Os.errno());
    }

    public static CairoException invalidMetadataRecoverable(@NotNull CharSequence msg, @NotNull CharSequence columnName) {
        return CairoException.critical(-103).put(msg).put(" [column=").put(columnName).put(']');
    }

    public static boolean isCairoOomError(Throwable t) {
        return t instanceof CairoException && ((CairoException)t).isOutOfMemory();
    }

    public static CairoException matViewDoesNotExist(CharSequence matViewName) {
        return CairoException.critical(-106).put("materialized view does not exist [view=").put(matViewName).put(']');
    }

    public static CairoException nonCritical() {
        return CairoException.instance(-1);
    }

    public static CairoException partitionManipulationRecoverable() {
        return CairoException.instance(-104);
    }

    public static CairoException preferencesOutOfDate(long currentVersion, long expectedVersion) {
        return CairoException.nonCritical().setPreferencesOutOfDateError().put("preferences view is out of date [currentVersion=").put(currentVersion).put(", expectedVersion=").put(expectedVersion).put(']');
    }

    public static CairoException queryCancelled(long fd) {
        CairoException exception = CairoException.nonCritical().put("cancelled by user").setInterruption(true).setCancellation(true);
        if (fd > -1L) {
            exception.put(" [fd=").put(fd).put(']');
        }
        return exception;
    }

    public static CairoException queryCancelled() {
        return CairoException.nonCritical().put("cancelled by user").setInterruption(true).setCancellation(true);
    }

    public static CairoException queryTimedOut(long fd, long runtime, long timeout) {
        return CairoException.nonCritical().put("timeout, query aborted [fd=").put(fd).put(", runtime=").put(runtime).put("ms").put(", timeout=").put(timeout).put("ms").put(']').setInterruption(true);
    }

    public static CairoException queryTimedOut() {
        return CairoException.nonCritical().put("timeout, query aborted").setInterruption(true);
    }

    public static CairoException tableDoesNotExist(CharSequence tableName) {
        return CairoException.critical(-105).put("table does not exist [table=").put(tableName).put(']');
    }

    public static CairoException tableDropped(TableToken tableToken) {
        return CairoException.critical(-102).put("table is dropped [dirName=").put(tableToken.getDirName()).put(", tableName=").put(tableToken.getTableName()).put(']');
    }

    public static CairoException txnApplyBlockError(TableToken tableToken) {
        return CairoException.critical(-107).put("sorting transaction block failed, need to be re-run in 1 by 1 apply mode [dirName=").put(tableToken.getDirName()).put(", tableName=").put(tableToken.getTableName()).put(']');
    }

    public boolean errnoFileCannotRead() {
        return Files.errnoFileCannotRead(this.errno);
    }

    public int getErrno() {
        return this.errno;
    }

    @Override
    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    public int getInterruptionReason() {
        if (this.isCancellation()) {
            return 3;
        }
        if (this.isInterruption()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getMessage() {
        return "[" + this.errno + "] " + String.valueOf(this.message);
    }

    @Override
    public int getPosition() {
        return this.messagePosition;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] result = EMPTY_STACK_TRACE;
        assert ((result = super.getStackTrace()) != null);
        return result;
    }

    public boolean isAuthorizationError() {
        return this.authorizationError;
    }

    public boolean isBlockApplyError() {
        return this.errno == -107;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public boolean isCancellation() {
        return this.cancellation;
    }

    public boolean isCritical() {
        return this.errno != -1 && this.errno != -104 && this.errno != -103 && this.errno != -102 && this.errno != -106 && this.errno != -105;
    }

    public boolean isHousekeeping() {
        return this.housekeeping;
    }

    public boolean isInterruption() {
        return this.interruption;
    }

    public boolean isMetadataValidation() {
        return this.errno == -100 || this.errno == -103;
    }

    public boolean isOutOfMemory() {
        return this.outOfMemory;
    }

    public boolean isPreferencesOutOfDateError() {
        return this.preferencesOutOfDateError;
    }

    public boolean isTableDoesNotExist() {
        return this.errno == -105;
    }

    public boolean isTableDropped() {
        return this.errno == -102;
    }

    public boolean isWALTolerable() {
        return this.errno == -104 || this.errno == -103;
    }

    public CairoException position(int position) {
        this.messagePosition = position;
        return this;
    }

    public CairoException put(long value) {
        this.message.put(value);
        return this;
    }

    public CairoException put(double value) {
        this.message.put(value);
        return this;
    }

    public CairoException put(@Nullable CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public CairoException put(@Nullable Utf8Sequence us) {
        this.message.put(us);
        return this;
    }

    public CairoException put(Sinkable sinkable) {
        sinkable.toSink(this.message);
        return this;
    }

    public CairoException put(char c) {
        this.message.put(c);
        return this;
    }

    public CairoException put(boolean value) {
        this.message.put(value);
        return this;
    }

    public CairoException putAsPrintable(CharSequence nonPrintable) {
        this.message.putAsPrintable(nonPrintable);
        return this;
    }

    public CairoException setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public CairoException setCancellation(boolean cancellation) {
        this.cancellation = cancellation;
        return this;
    }

    public void setHousekeeping(boolean housekeeping) {
        this.housekeeping = housekeeping;
    }

    public CairoException setInterruption(boolean interruption) {
        this.interruption = interruption;
        return this;
    }

    public CairoException setOutOfMemory(boolean outOfMemory) {
        this.outOfMemory = outOfMemory;
        return this;
    }

    public boolean tableDoesNotExist() {
        return this.errno == -105;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii('[').put(this.errno).putAscii("]: ").put(this.message);
    }

    public CairoException ts(long timestamp) {
        TimestampFormatUtils.appendDateTime(this.message, timestamp);
        return this;
    }

    private static CairoException instance(int errno) {
        CairoException ex = tlException.get();
        assert ((ex = new CairoException()) != null);
        ex.clear(errno);
        return ex;
    }

    private static CairoException paramInstance(int errno, boolean outOfMemory, CharSequence message, @Nullable CharSequence nativeBacktrace) {
        CairoException ex = CairoException.instance(errno).setOutOfMemory(outOfMemory).put(message);
        ex.nativeBacktrace.put(nativeBacktrace);
        return ex;
    }

    private CairoException setAuthorizationError() {
        this.authorizationError = true;
        return this;
    }

    private CairoException setPreferencesOutOfDateError() {
        this.preferencesOutOfDateError = true;
        return this;
    }

    protected void clear(int errno) {
        this.message.clear();
        this.nativeBacktrace.clear();
        this.errno = errno;
        this.cacheable = false;
        this.interruption = false;
        this.authorizationError = false;
        this.messagePosition = 0;
        this.outOfMemory = false;
        this.housekeeping = false;
    }
}

