/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexBwdNullReader;
import io.questdb.cairo.BitmapIndexBwdReader;
import io.questdb.cairo.BitmapIndexFwdNullReader;
import io.questdb.cairo.BitmapIndexFwdReader;
import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.PartitionOverwriteControl;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableReaderMetadataTransitionIndex;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.cairo.TxnScoreboardPool;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.vm.MemoryCMRDetachedImpl;
import io.questdb.cairo.vm.NullMemoryCMR;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf16Sink;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableReader
implements Closeable,
SymbolTableSource {
    private static final Log LOG = LogFactory.getLog(TableReader.class);
    private static final int PARTITIONS_SLOT_OFFSET_SIZE = 1;
    private static final int PARTITIONS_SLOT_OFFSET_NAME_TXN = 2;
    private static final int PARTITIONS_SLOT_OFFSET_COLUMN_VERSION = 3;
    private static final int PARTITIONS_SLOT_OFFSET_FORMAT = 4;
    private static final int PARTITIONS_SLOT_SIZE = 8;
    private static final int PARTITIONS_SLOT_SIZE_MSB = Numbers.msb(8);
    private final MillisecondClock clock;
    private final ColumnVersionReader columnVersionReader;
    private final CairoConfiguration configuration;
    private final int dbRootSize;
    private final FilesFacade ff;
    private final int id;
    private final int maxOpenPartitions;
    private final MessageBus messageBus;
    private final TableReaderMetadata metadata;
    private final int partitionBy;
    private final PartitionOverwriteControl partitionOverwriteControl;
    private final Path path;
    private final int rootLen;
    private final ObjList<SymbolMapReader> symbolMapReaders = new ObjList();
    private final MemoryMR todoMem = Vm.getCMRInstance();
    private final TxReader txFile;
    private final TxnScoreboard txnScoreboard;
    private ObjList<BitmapIndexReader> bitmapIndexes;
    private int columnCount;
    private int columnCountShl;
    private LongList columnTops;
    private ObjList<MemoryCMR> columns;
    private int openPartitionCount;
    private LongList openPartitionInfo;
    private ObjList<MemoryCMR> parquetPartitions;
    private int partitionCount;
    private long rowCount;
    private TableToken tableToken;
    private long tempMem8b = Unsafe.malloc(8L, 55);
    private long txColumnVersion;
    private long txPartitionVersion;
    private long txTruncateVersion;
    private long txn = 0L;
    private boolean txnAcquired = false;

    public TableReader(int id, CairoConfiguration configuration, @NotNull TableToken tableToken, TxnScoreboardPool scoreboardFactory) {
        this(id, configuration, tableToken, scoreboardFactory, null, null);
    }

    public TableReader(int id, CairoConfiguration configuration, @NotNull TableToken tableToken, TxnScoreboardPool scoreboardPool, @Nullable MessageBus messageBus, @Nullable PartitionOverwriteControl partitionOverwriteControl) {
        this.id = id;
        this.configuration = configuration;
        this.clock = configuration.getMillisecondClock();
        this.maxOpenPartitions = configuration.getInactiveReaderMaxOpenPartitions();
        this.ff = configuration.getFilesFacade();
        this.tableToken = tableToken;
        this.messageBus = messageBus;
        try {
            this.path = new Path();
            this.path.of(configuration.getDbRoot());
            this.dbRootSize = this.path.size();
            this.path.concat(tableToken.getDirName());
            this.rootLen = this.path.size();
            this.path.trimTo(this.rootLen);
            this.metadata = this.openMetaFile();
            this.partitionBy = this.metadata.getPartitionBy();
            this.columnVersionReader = new ColumnVersionReader().ofRO(this.ff, this.path.trimTo(this.rootLen).concat("_cv").$());
            this.txnScoreboard = scoreboardPool.getTxnScoreboard(tableToken);
            LOG.debug().$("open [id=").$(this.metadata.getTableId()).$(", table=").$(tableToken).I$();
            this.txFile = new TxReader(this.ff).ofRO(this.path.trimTo(this.rootLen).concat("_txn").$(), this.partitionBy);
            this.path.trimTo(this.rootLen);
            this.reloadSlow(false);
            this.init();
            this.partitionOverwriteControl = partitionOverwriteControl;
            if (partitionOverwriteControl != null) {
                partitionOverwriteControl.acquirePartitions(this);
            }
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    public TableReader(int id, CairoConfiguration configuration, TableReader srcReader, TxnScoreboardPool scoreboardPool, @Nullable MessageBus messageBus, @Nullable PartitionOverwriteControl partitionOverwriteControl) {
        assert (srcReader.isOpen() && srcReader.isActive());
        this.id = id;
        this.configuration = configuration;
        this.clock = configuration.getMillisecondClock();
        this.maxOpenPartitions = configuration.getInactiveReaderMaxOpenPartitions();
        this.ff = configuration.getFilesFacade();
        this.tableToken = srcReader.getTableToken();
        this.messageBus = messageBus;
        try {
            this.path = new Path();
            this.path.of(configuration.getDbRoot());
            this.dbRootSize = this.path.size();
            this.path.concat(this.tableToken.getDirName());
            this.rootLen = this.path.size();
            this.path.trimTo(this.rootLen);
            this.metadata = this.copyMeta(srcReader.metadata);
            this.partitionBy = this.metadata.getPartitionBy();
            this.columnVersionReader = new ColumnVersionReader().ofRO(this.ff, this.path.trimTo(this.rootLen).concat("_cv").$());
            this.txnScoreboard = scoreboardPool.getTxnScoreboard(this.tableToken);
            LOG.debug().$("open as copy [id=").$(this.metadata.getTableId()).$(", table=").$(this.tableToken).$(", srcTxn=").$(srcReader.getTxn()).I$();
            this.txFile = new TxReader(this.ff).ofRO(this.path.trimTo(this.rootLen).concat("_txn").$(), this.partitionBy);
            this.path.trimTo(this.rootLen);
            this.reloadAtTxn(srcReader, false);
            this.txPartitionVersion = this.txFile.getPartitionTableVersion();
            this.txColumnVersion = this.txFile.getColumnVersion();
            this.txTruncateVersion = this.txFile.getTruncateVersion();
            this.init();
            this.partitionOverwriteControl = partitionOverwriteControl;
            if (partitionOverwriteControl != null) {
                partitionOverwriteControl.acquirePartitions(this);
            }
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    public static int getPrimaryColumnIndex(int base, int index) {
        return 2 + base + index * 2;
    }

    public int calculateOpenPartitionCount() {
        int openPartitionCount = 0;
        for (int partitionIndex = this.partitionCount - 1; partitionIndex > -1; --partitionIndex) {
            int offset = partitionIndex * 8;
            long partitionSize = this.openPartitionInfo.getQuick(offset + 1);
            if (partitionSize <= -1L) continue;
            ++openPartitionCount;
        }
        return openPartitionCount;
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.goPassive();
            this.freeSymbolMapReaders();
            this.freeBitmapIndexCache();
            Misc.free(this.metadata);
            Misc.free(this.txFile);
            Misc.free(this.todoMem);
            this.freeColumns();
            this.freeParquetPartitions();
            this.freeTempMem();
            Misc.free(this.txnScoreboard);
            Misc.free(this.path);
            Misc.free(this.columnVersionReader);
            LOG.debug().$("closed '").$safe(this.tableToken.getTableName()).$('\'').$();
        }
    }

    public void dumpRawTxPartitionInfo(LongList container) {
        this.txFile.dumpRawTxPartitionInfo(container);
    }

    public long floorToPartitionTimestamp(long timestamp) {
        return this.txFile.getPartitionTimestampByTimestamp(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitmapIndexReader getBitmapIndexReader(int partitionIndex, int columnIndex, int direction) {
        int columnBase = this.getColumnBase(partitionIndex);
        int index = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
        long partitionTimestamp = this.txFile.getPartitionTimestampByIndex(partitionIndex);
        long columnNameTxn = this.columnVersionReader.getColumnNameTxn(partitionTimestamp, this.metadata.getWriterIndex(columnIndex));
        long partitionTxn = this.txFile.getPartitionNameTxn(partitionIndex);
        BitmapIndexReader reader = this.getBitmapIndexReaderIfExists(partitionIndex, columnIndex, direction);
        if (reader != null) {
            if (reader.isOpen()) {
                assert (reader.getPartitionTxn() == partitionTxn);
                assert (reader.getColumnTxn() == columnNameTxn);
                reader.reloadConditionally();
            } else {
                int plen = this.path.size();
                try {
                    reader.of(this.configuration, this.pathGenNativePartition(partitionIndex, partitionTxn), this.metadata.getColumnName(columnIndex), columnNameTxn, partitionTxn, this.getColumnTop(columnBase, columnIndex));
                }
                finally {
                    this.path.trimTo(plen);
                }
            }
            return reader;
        }
        return this.createBitmapIndexReaderAt(index, columnBase, columnIndex, columnNameTxn, direction, partitionTxn);
    }

    public BitmapIndexReader getBitmapIndexReaderIfExists(int partitionIndex, int columnIndex, int direction) {
        int columnBase = this.getColumnBase(partitionIndex);
        int index = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
        int indexIndex = direction == 2 ? index : index + 1;
        return this.bitmapIndexes.getQuick(indexIndex);
    }

    public MemoryCR getColumn(int absoluteIndex) {
        return this.columns.getQuick(absoluteIndex);
    }

    public int getColumnBase(int partitionIndex) {
        return partitionIndex << this.columnCountShl;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public long getColumnTop(int base, int columnIndex) {
        return this.columnTops.getQuick(base / 2 + columnIndex);
    }

    public ColumnVersionReader getColumnVersionReader() {
        return this.columnVersionReader;
    }

    public long getDataVersion() {
        return this.txFile.getDataVersion();
    }

    public long getMaxTimestamp() {
        return this.txFile.getMaxTimestamp();
    }

    public int getMaxUncommittedRows() {
        return this.metadata.getMaxUncommittedRows();
    }

    public TableReaderMetadata getMetadata() {
        return this.metadata;
    }

    public long getMetadataVersion() {
        return this.txFile.getMetadataVersion();
    }

    public long getMinTimestamp() {
        return this.txFile.getMinTimestamp();
    }

    public long getO3MaxLag() {
        return this.metadata.getO3MaxLag();
    }

    public int getOpenPartitionCount() {
        return this.openPartitionCount;
    }

    public long getParquetAddr(int partitionIndex) {
        return this.parquetPartitions.getQuick(partitionIndex).addressOf(0L);
    }

    public long getParquetFileSize(int partitionIndex) {
        return this.parquetPartitions.getQuick(partitionIndex).size();
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public byte getPartitionFormat(int partitionIndex) {
        return (byte)this.openPartitionInfo.getQuick(partitionIndex * 8 + 4);
    }

    public byte getPartitionFormatFromMetadata(int partitionIndex) {
        if (this.txFile.isPartitionParquet(partitionIndex)) {
            return 1;
        }
        return 0;
    }

    public int getPartitionIndex(int columnBase) {
        return columnBase >>> this.columnCountShl;
    }

    public int getPartitionIndexByTimestamp(long timestamp) {
        int end = this.openPartitionInfo.binarySearchBlock(PARTITIONS_SLOT_SIZE_MSB, timestamp, -1);
        if (end < 0) {
            return (-end - 2) / 8;
        }
        return end / 8;
    }

    public long getPartitionMaxTimestampFromMetadata(int partitionIndex) {
        int next = partitionIndex + 1;
        long minTimestampCeil = this.txFile.getNextLogicalPartitionTimestamp(this.getPartitionMinTimestampFromMetadata(partitionIndex));
        return next < this.getPartitionCount() ? Math.min(this.getPartitionMinTimestampFromMetadata(next), minTimestampCeil) - 1L : minTimestampCeil;
    }

    public long getPartitionMinTimestampFromMetadata(int partitionIndex) {
        return this.txFile.getPartitionTimestampByIndex(partitionIndex);
    }

    public long getPartitionRowCount(int partitionIndex) {
        return this.openPartitionInfo.getQuick(partitionIndex * 8 + 1);
    }

    public long getPartitionRowCountFromMetadata(int partitionIndex) {
        return this.txFile.getPartitionSize(partitionIndex);
    }

    public long getPartitionTimestampByIndex(int partitionIndex) {
        return this.txFile.getPartitionTimestampByIndex(partitionIndex);
    }

    public int getPartitionedBy() {
        return this.metadata.getPartitionBy();
    }

    public long getSeqTxn() {
        return this.txFile.getSeqTxn();
    }

    public SymbolMapReader getSymbolMapReader(int columnIndex) {
        return this.symbolMapReaders.getQuick(columnIndex);
    }

    @Override
    public StaticSymbolTable getSymbolTable(int columnIndex) {
        return this.getSymbolMapReader(columnIndex);
    }

    public TableToken getTableToken() {
        return this.tableToken;
    }

    public long getTransientRowCount() {
        return this.txFile.getTransientRowCount();
    }

    public TxReader getTxFile() {
        return this.txFile;
    }

    public long getTxn() {
        return this.txn;
    }

    public long getTxnMetadataVersion() {
        return this.txFile.getMetadataVersion();
    }

    public TxnScoreboard getTxnScoreboard() {
        return this.txnScoreboard;
    }

    public void goActive() {
        this.reload();
        if (this.partitionOverwriteControl != null) {
            this.partitionOverwriteControl.acquirePartitions(this);
        }
    }

    public void goActiveAtTxn(TableReader srcReader) {
        boolean needsDowngrade;
        assert (srcReader.isOpen() && srcReader.isActive());
        assert (this.tableToken.equals(srcReader.getTableToken()));
        boolean bl = needsDowngrade = this.txn > srcReader.txn;
        if (needsDowngrade) {
            if (this.partitionOverwriteControl != null) {
                this.partitionOverwriteControl.releasePartitions(this);
            }
            if (PartitionBy.isPartitioned(this.partitionBy)) {
                for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
                    int offset = partitionIndex * 8;
                    long partitionSize = this.openPartitionInfo.getQuick(offset + 1);
                    if (partitionSize <= -1L) continue;
                    this.closePartition(partitionIndex);
                }
            }
            this.freeSymbolMapReaders();
            this.freeBitmapIndexCache();
            this.freeColumns();
            this.freeParquetPartitions();
            this.metadata.loadFrom(srcReader.metadata);
        }
        this.reloadAtTxn(srcReader, true);
        if (needsDowngrade) {
            this.init();
        }
        this.reconcileOpenPartitions(this.txPartitionVersion, this.txColumnVersion, this.txTruncateVersion);
        this.txPartitionVersion = this.txFile.getPartitionTableVersion();
        this.txColumnVersion = this.txFile.getColumnVersion();
        this.txTruncateVersion = this.txFile.getTruncateVersion();
        if (this.partitionOverwriteControl != null) {
            this.partitionOverwriteControl.acquirePartitions(this);
        }
    }

    public void goPassive() {
        if (!this.isActive()) {
            return;
        }
        if (this.partitionOverwriteControl != null) {
            this.partitionOverwriteControl.releasePartitions(this);
        }
        if (this.releaseTxn() && PartitionBy.isPartitioned(this.partitionBy)) {
            this.checkSchedulePurgeO3Partitions();
        }
        if (PartitionBy.isPartitioned(this.partitionBy) && this.openPartitionCount > this.maxOpenPartitions) {
            int originallyOpen = this.openPartitionCount;
            int openCount = 0;
            for (int partitionIndex = this.partitionCount - 1; partitionIndex > -1; --partitionIndex) {
                int offset = partitionIndex * 8;
                long partitionSize = this.openPartitionInfo.getQuick(offset + 1);
                if (partitionSize <= -1L || ++openCount <= this.maxOpenPartitions) continue;
                this.closePartition(partitionIndex);
                if (openCount == originallyOpen) break;
            }
        }
    }

    public boolean isActive() {
        return this.txnAcquired;
    }

    public boolean isColumnCached(int columnIndex) {
        return this.symbolMapReaders.getQuick(columnIndex).isCached();
    }

    public boolean isOpen() {
        return this.tempMem8b != 0L;
    }

    @Override
    public StaticSymbolTable newSymbolTable(int columnIndex) {
        return this.getSymbolMapReader(columnIndex).newSymbolTableView();
    }

    public long openPartition(int partitionIndex) {
        long size = this.getPartitionRowCount(partitionIndex);
        if (size != -1L) {
            return size;
        }
        return this.openPartition0(partitionIndex);
    }

    public boolean reload() {
        if (this.acquireTxn()) {
            return false;
        }
        try {
            this.reloadSlow(true);
            this.reconcileOpenPartitions(this.txPartitionVersion, this.txColumnVersion, this.txTruncateVersion);
            this.txPartitionVersion = this.txFile.getPartitionTableVersion();
            this.txColumnVersion = this.txFile.getColumnVersion();
            this.txTruncateVersion = this.txFile.getTruncateVersion();
            return true;
        }
        catch (Throwable e) {
            this.releaseTxn();
            throw e;
        }
    }

    public long size() {
        return this.rowCount;
    }

    public void updateTableToken(TableToken tableToken) {
        this.tableToken = tableToken;
        this.metadata.updateTableToken(tableToken);
    }

    private static int getColumnBits(int columnCount) {
        return Numbers.msb(Numbers.ceilPow2(columnCount) * 2);
    }

    private static boolean growColumn(MemoryCMRDetachedImpl mem1, MemoryCMRDetachedImpl mem2, int columnType, long rowCount) {
        if (rowCount > 0L) {
            if (ColumnType.isVarSize(columnType)) {
                if (mem2 == null) {
                    return false;
                }
                ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
                long newSize = columnTypeDriver.getAuxVectorSize(rowCount);
                if (!mem2.tryChangeSize(newSize)) {
                    return false;
                }
                long dataSize = columnTypeDriver.getDataVectorSizeAt(mem2.addressOf(0L), rowCount - 1L);
                if (mem1 != null) {
                    return mem1.tryChangeSize(dataSize);
                }
                return dataSize == 0L;
            }
            if (mem1 == null) {
                return false;
            }
            return mem1.tryChangeSize(rowCount << ColumnType.pow2SizeOf(columnType));
        }
        return true;
    }

    private boolean acquireTxn() {
        if (!this.txnAcquired) {
            try {
                if (!this.txnScoreboard.acquireTxn(this.id, this.txn)) {
                    return false;
                }
                this.txnAcquired = true;
            }
            catch (CairoException ex) {
                LOG.critical().$("cannot lock txn in scoreboard [table=").$(this.tableToken).$(", txn=").$(this.txn).$(", error=").$safe(ex.getFlyweightMessage()).I$();
                throw ex;
            }
        }
        if (this.txn == this.txFile.getTxn()) {
            Unsafe.getUnsafe().loadFence();
            return this.txFile.getVersion() == this.txFile.unsafeReadVersion();
        }
        return false;
    }

    private void checkSchedulePurgeO3Partitions() {
        if (this.txnScoreboard.isOutdated(this.txn)) {
            long partitionTableVersion = this.txFile.getPartitionTableVersion();
            if (this.txFile.unsafeLoadAll() && this.txFile.getPartitionTableVersion() > partitionTableVersion && this.txnScoreboard.isTxnAvailable(this.txn)) {
                if (TableUtils.schedulePurgeO3Partitions(this.messageBus, this.tableToken, this.partitionBy)) {
                    return;
                }
                LOG.error().$("could not queue purge partition task, queue is full [").$("table=").$(this.tableToken).$(", txn=").$(this.txn).$(']').$();
            }
        }
    }

    private void closeDeletedPartition(int partitionIndex) {
        int offset = partitionIndex * 8;
        long partitionTimestamp = this.openPartitionInfo.getQuick(offset);
        long partitionSize = this.openPartitionInfo.getQuick(offset + 1);
        int columnBase = this.getColumnBase(partitionIndex);
        if (partitionSize > -1L) {
            this.closePartitionResources(partitionIndex, offset);
            --this.openPartitionCount;
        }
        int baseIndex = TableReader.getPrimaryColumnIndex(columnBase, 0);
        int newBaseIndex = TableReader.getPrimaryColumnIndex(this.getColumnBase(partitionIndex + 1), 0);
        int n = newBaseIndex - 1;
        for (int i = baseIndex; i < n; ++i) {
            Misc.free(this.columns.get(i));
        }
        this.columns.remove(baseIndex, newBaseIndex - 1);
        int colTopStart = columnBase / 2;
        int columnSlotSize = this.getColumnBase(1);
        this.columnTops.removeIndexBlock(colTopStart, columnSlotSize / 2);
        Misc.free(this.parquetPartitions.get(partitionIndex));
        this.parquetPartitions.remove(partitionIndex);
        this.openPartitionInfo.removeIndexBlock(offset, 8);
        LOG.info().$("closed deleted partition [table=").$(this.tableToken).$(", ts=").$ts(partitionTimestamp).$(", partitionIndex=").$(partitionIndex).I$();
        --this.partitionCount;
    }

    private void closeIndexReader(int base, int columnIndex) {
        int index = TableReader.getPrimaryColumnIndex(base, columnIndex);
        Misc.free(this.bitmapIndexes.getQuick(index));
        Misc.free(this.bitmapIndexes.getQuick(index + 1));
    }

    private void closeParquetPartition(int partitionIndex) {
        Misc.free(this.parquetPartitions.getQuick(partitionIndex));
        int columnBase = this.getColumnBase(partitionIndex);
        for (int i = 0; i < this.columnCount; ++i) {
            this.closeIndexReader(columnBase, i);
        }
    }

    private void closePartition(int partitionIndex) {
        int offset = partitionIndex * 8;
        long partitionTimestamp = this.openPartitionInfo.getQuick(offset);
        long partitionSize = this.openPartitionInfo.getQuick(offset + 1);
        this.closePartitionResources(partitionIndex, offset);
        LOG.infoW().$("closed partition [path=").$substr(this.dbRootSize, this.path).$(", timestamp=").$ts(partitionTimestamp).I$();
        if (partitionSize > -1L) {
            --this.openPartitionCount;
        }
    }

    private void closePartitionColumn(int base, int columnIndex) {
        int index = TableReader.getPrimaryColumnIndex(base, columnIndex);
        Misc.free(this.columns.get(index));
        Misc.free(this.columns.get(index + 1));
        this.closeIndexReader(base, columnIndex);
    }

    private void closePartitionColumns(int columnBase) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.closePartitionColumn(columnBase, i);
        }
    }

    private void closePartitionResources(int partitionIndex, int offset) {
        byte format = this.getPartitionFormat(partitionIndex);
        switch (format) {
            case 1: {
                this.closeParquetPartition(partitionIndex);
                break;
            }
            case 0: {
                int columnBase = this.getColumnBase(partitionIndex);
                this.closePartitionColumns(columnBase);
                break;
            }
        }
        this.openPartitionInfo.setQuick(offset + 1, -1L);
    }

    private long closeRewrittenPartitionFiles(int partitionIndex, int oldBase) {
        int offset = partitionIndex * 8;
        long partitionTs = this.openPartitionInfo.getQuick(offset);
        long existingPartitionNameTxn = this.openPartitionInfo.getQuick(offset + 2);
        long newNameTxn = this.txFile.getPartitionNameTxnByPartitionTimestamp(partitionTs);
        long newSize = this.txFile.getPartitionRowCountByTimestamp(partitionTs);
        if (existingPartitionNameTxn != newNameTxn || newSize < 0L) {
            LOG.debug().$("close outdated partition files [table=").$safe(this.tableToken.getTableName()).$(", ts=").$ts(partitionTs).$(", nameTxn=").$(newNameTxn).$();
            if (this.getPartitionFormat(partitionIndex) == 0) {
                for (int i = 0; i < this.columnCount; ++i) {
                    this.closePartitionColumn(oldBase, i);
                }
            }
            this.openPartitionInfo.setQuick(offset + 1, -1L);
            --this.openPartitionCount;
            return -1L;
        }
        long nameTxn = this.openPartitionInfo.getQuick(partitionIndex * 8 + 2);
        this.pathGenNativePartition(partitionIndex, nameTxn);
        return newSize;
    }

    private void copyColumns(int fromBase, int fromColumnIndex, ObjList<MemoryCMR> toColumns, LongList toColumnTops, ObjList<BitmapIndexReader> toIndexReaders, int toBase, int toColumnIndex) {
        int fromIndex = TableReader.getPrimaryColumnIndex(fromBase, fromColumnIndex);
        int toIndex = TableReader.getPrimaryColumnIndex(toBase, toColumnIndex);
        toColumns.setQuick(toIndex, this.columns.getAndSetQuick(fromIndex, null));
        toColumns.setQuick(toIndex + 1, this.columns.getAndSetQuick(fromIndex + 1, null));
        toColumnTops.setQuick(toBase / 2 + toColumnIndex, this.columnTops.getQuick(fromBase / 2 + fromColumnIndex));
        toIndexReaders.setQuick(toIndex, this.bitmapIndexes.getAndSetQuick(fromIndex, null));
        toIndexReaders.setQuick(toIndex + 1, this.bitmapIndexes.getAndSetQuick(fromIndex + 1, null));
    }

    private TableReaderMetadata copyMeta(TableReaderMetadata srcMeta) {
        TableReaderMetadata metadata = new TableReaderMetadata(this.configuration, this.tableToken);
        try {
            metadata.loadFrom(srcMeta);
            return metadata;
        }
        catch (Throwable th) {
            metadata.close();
            throw th;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BitmapIndexReader createBitmapIndexReaderAt(int globalIndex, int columnBase, int columnIndex, long columnNameTxn, int direction, long partitionTxn) {
        BitmapIndexReader reader;
        if (!this.metadata.isColumnIndexed(columnIndex)) {
            throw CairoException.critical(0).put("Not indexed: ").put(this.metadata.getColumnName(columnIndex));
        }
        MemoryR col = this.columns.getQuick(globalIndex);
        if (col instanceof NullMemoryCMR) {
            if (direction == 2) {
                reader = new BitmapIndexBwdNullReader(columnNameTxn, partitionTxn);
                this.bitmapIndexes.setQuick(globalIndex, reader);
            } else {
                reader = new BitmapIndexFwdNullReader(columnNameTxn, partitionTxn);
                this.bitmapIndexes.setQuick(globalIndex + 1, reader);
            }
        } else {
            Path path = this.pathGenNativePartition(this.getPartitionIndex(columnBase), partitionTxn);
            try {
                if (direction == 2) {
                    reader = new BitmapIndexBwdReader(this.configuration, path, this.metadata.getColumnName(columnIndex), columnNameTxn, partitionTxn, this.getColumnTop(columnBase, columnIndex));
                    this.bitmapIndexes.setQuick(globalIndex, reader);
                } else {
                    reader = new BitmapIndexFwdReader(this.configuration, path, this.metadata.getColumnName(columnIndex), columnNameTxn, partitionTxn, this.getColumnTop(columnBase, columnIndex));
                    this.bitmapIndexes.setQuick(globalIndex + 1, reader);
                }
            }
            finally {
                path.trimTo(this.rootLen);
            }
        }
        return reader;
    }

    private void createNewColumnList(int columnCount, TableReaderMetadataTransitionIndex transitionIndex, int columnCountShl) {
        LOG.debug().$("resizing columns file list [table=").$safe(this.tableToken.getTableName()).I$();
        int capacity = this.partitionCount << columnCountShl;
        ObjList<MemoryCMR> toColumns = new ObjList<MemoryCMR>(capacity + 2);
        LongList toColumnTops = new LongList(capacity / 2);
        ObjList<BitmapIndexReader> toIndexReaders = new ObjList<BitmapIndexReader>(capacity);
        toColumns.setPos(capacity + 2);
        toColumns.setQuick(0, NullMemoryCMR.INSTANCE);
        toColumns.setQuick(1, NullMemoryCMR.INSTANCE);
        toColumnTops.setPos(capacity / 2);
        toIndexReaders.setPos(capacity + 2);
        int iterateCount = Math.max(columnCount, this.columnCount);
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            int toBase = partitionIndex << columnCountShl;
            int fromBase = partitionIndex << this.columnCountShl;
            try {
                long partitionRowCount = this.openPartitionInfo.getQuick(partitionIndex * 8 + 1);
                if (partitionRowCount <= -1L || (partitionRowCount = this.closeRewrittenPartitionFiles(partitionIndex, fromBase)) <= -1L) continue;
                for (int i = 0; i < iterateCount; ++i) {
                    if (transitionIndex.closeColumn(i)) {
                        this.closePartitionColumn(fromBase, i);
                    }
                    if (transitionIndex.replaceWithNew(i)) {
                        this.reloadColumnAt(partitionIndex, this.path, toColumns, toColumnTops, toIndexReaders, toBase, i, partitionRowCount);
                        continue;
                    }
                    int fromColumnIndex = transitionIndex.getCopyFromIndex(i);
                    assert (fromColumnIndex < this.columnCount);
                    this.copyColumns(fromBase, fromColumnIndex, toColumns, toColumnTops, toIndexReaders, toBase, i);
                }
                continue;
            }
            catch (Throwable th) {
                this.closePartitionColumns(fromBase);
                this.openPartitionInfo.setQuick(partitionIndex * 8 + 1, -1L);
                Misc.freeObjListIfCloseable(toColumns);
                throw th;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
        this.columns = toColumns;
        this.columnTops = toColumnTops;
        this.columnCountShl = columnCountShl;
        this.bitmapIndexes = toIndexReaders;
    }

    private void formatErrorPartitionDirName(int partitionIndex, Utf16Sink sink) {
        TableUtils.setSinkForNativePartition(sink, this.partitionBy, this.openPartitionInfo.getQuick(partitionIndex * 8), -1L);
    }

    private void formatNativePartitionDirName(int partitionIndex, Path sink, long nameTxn) {
        TableUtils.setPathForNativePartition(sink, this.partitionBy, this.openPartitionInfo.getQuick(partitionIndex * 8), nameTxn);
    }

    private void formatParquetPartitionFileName(int partitionIndex, Path sink, long nameTxn) {
        TableUtils.setPathForParquetPartition(sink, this.partitionBy, this.openPartitionInfo.getQuick(partitionIndex * 8), nameTxn);
    }

    private void freeBitmapIndexCache() {
        Misc.freeObjList(this.bitmapIndexes);
    }

    private void freeColumns() {
        Misc.freeObjList(this.columns);
    }

    private void freeParquetPartitions() {
        Misc.freeObjList(this.parquetPartitions);
    }

    private void freeSymbolMapReaders() {
        int n = this.symbolMapReaders.size();
        for (int i = 0; i < n; ++i) {
            Misc.freeIfCloseable(this.symbolMapReaders.getQuick(i));
        }
        this.symbolMapReaders.clear();
    }

    private void freeTempMem() {
        if (this.tempMem8b != 0L) {
            this.tempMem8b = Unsafe.free(this.tempMem8b, 8L, 55);
        }
    }

    private void init() {
        this.txPartitionVersion = this.txFile.getPartitionTableVersion();
        this.txColumnVersion = this.txFile.getColumnVersion();
        this.txTruncateVersion = this.txFile.getTruncateVersion();
        this.columnCount = this.metadata.getColumnCount();
        this.columnCountShl = TableReader.getColumnBits(this.columnCount);
        this.openSymbolMaps();
        this.partitionCount = this.txFile.getPartitionCount();
        int capacity = this.getColumnBase(this.partitionCount);
        this.parquetPartitions = new ObjList(this.partitionCount);
        this.parquetPartitions.setAll(this.partitionCount, NullMemoryCMR.INSTANCE);
        this.columns = new ObjList(capacity + 2);
        this.columns.setPos(capacity + 2);
        this.columns.setQuick(0, NullMemoryCMR.INSTANCE);
        this.columns.setQuick(1, NullMemoryCMR.INSTANCE);
        this.bitmapIndexes = new ObjList(capacity + 2);
        this.bitmapIndexes.setPos(capacity + 2);
        this.openPartitionInfo = this.initOpenPartitionInfo();
        this.columnTops = new LongList(capacity / 2);
        this.columnTops.setPos(capacity / 2);
    }

    @NotNull
    private LongList initOpenPartitionInfo() {
        LongList openPartitionInfo = new LongList(this.partitionCount * 8);
        openPartitionInfo.setPos(this.partitionCount * 8);
        for (int i = 0; i < this.partitionCount; ++i) {
            int baseOffset = i * 8;
            long partitionTimestamp = this.txFile.getPartitionTimestampByIndex(i);
            boolean isParquet = this.txFile.isPartitionParquet(i);
            openPartitionInfo.setQuick(baseOffset, partitionTimestamp);
            openPartitionInfo.setQuick(baseOffset + 1, -1L);
            openPartitionInfo.setQuick(baseOffset + 2, this.txFile.getPartitionNameTxn(i));
            openPartitionInfo.setQuick(baseOffset + 3, this.columnVersionReader.getMaxPartitionVersion(partitionTimestamp));
            openPartitionInfo.setQuick(baseOffset + 4, isParquet ? 1L : 0L);
        }
        return openPartitionInfo;
    }

    private void insertPartition(int partitionIndex, long timestamp) {
        int columnBase = this.getColumnBase(partitionIndex);
        int columnSlotSize = this.getColumnBase(1);
        int idx = TableReader.getPrimaryColumnIndex(columnBase, 0);
        this.columns.insert(idx, columnSlotSize, NullMemoryCMR.INSTANCE);
        this.bitmapIndexes.insert(idx, columnSlotSize, null);
        this.parquetPartitions.insert(partitionIndex, 1, NullMemoryCMR.INSTANCE);
        int topBase = columnBase / 2;
        int topSlotSize = columnSlotSize / 2;
        this.columnTops.insert(topBase, topSlotSize);
        this.columnTops.seed(topBase, topSlotSize, 0L);
        int offset = partitionIndex * 8;
        this.openPartitionInfo.insert(offset, 8);
        this.openPartitionInfo.setQuick(offset, timestamp);
        this.openPartitionInfo.setQuick(offset + 1, -1L);
        this.openPartitionInfo.setQuick(offset + 2, -1L);
        this.openPartitionInfo.setQuick(offset + 3, -1L);
        this.openPartitionInfo.setQuick(offset + 4, -1L);
        ++this.partitionCount;
        LOG.debug().$("inserted partition [index=").$(partitionIndex).$(", table=").$(this.tableToken).$(", timestamp=").$ts(timestamp).I$();
    }

    @NotNull
    private SymbolMapReaderImpl newSymbolMapReader(int symbolColumnIndex, int columnIndex) {
        return new SymbolMapReaderImpl(this.configuration, this.path, this.metadata.getColumnName(columnIndex), this.columnVersionReader.getDefaultColumnNameTxn(this.metadata.getWriterIndex(columnIndex)), this.txFile.getSymbolValueCount(symbolColumnIndex));
    }

    private TableReaderMetadata openMetaFile() {
        TableReaderMetadata metadata = new TableReaderMetadata(this.configuration, this.tableToken);
        try {
            metadata.load();
            return metadata;
        }
        catch (Throwable th) {
            metadata.close();
            throw th;
        }
    }

    @NotNull
    private MemoryCMRDetachedImpl openOrCreateColumnMemory(Path path, ObjList<MemoryCMR> columns, int primaryIndex, @Nullable MemoryCMR mem, long columnSize, boolean keepFdOpen) {
        MemoryCMRDetachedImpl memory;
        if (mem != null && mem != NullMemoryCMR.INSTANCE) {
            memory = (MemoryCMRDetachedImpl)mem;
            memory.of(this.ff, path.$(), columnSize, columnSize, 9, 0, -1, keepFdOpen);
        } else {
            memory = new MemoryCMRDetachedImpl(this.ff, path.$(), columnSize, 9, keepFdOpen);
            columns.setQuick(primaryIndex, memory);
        }
        return memory;
    }

    private long openPartition0(int partitionIndex) {
        int offset = partitionIndex * 8;
        if (this.txFile.getPartitionCount() < 2 && this.txFile.getTransientRowCount() == 0L) {
            return -1L;
        }
        try {
            Path path;
            long partitionNameTxn = this.txFile.getPartitionNameTxn(partitionIndex);
            if (this.txFile.isPartitionParquet(partitionIndex)) {
                path = this.pathGenParquetPartition(partitionIndex, partitionNameTxn);
                if (this.ff.exists(path.$())) {
                    long partitionTimestamp;
                    long partitionSize = this.getPartitionRowCountFromMetadata(partitionIndex);
                    if (partitionSize > -1L) {
                        LOG.info().$("open partition [path=").$substr(this.dbRootSize, path).$(", rowCount=").$(partitionSize).$(", partitionIndex=").$(partitionIndex).$(", partitionCount=").$(this.partitionCount).$(", format=parquet").I$();
                        partitionTimestamp = this.openPartitionInfo.getQuick(partitionIndex * 8);
                        this.openPartitionInfo.setQuick(offset + 1, partitionSize);
                        this.openPartitionInfo.setQuick(offset + 2, partitionNameTxn);
                        this.openPartitionInfo.setQuick(offset + 3, this.columnVersionReader.getMaxPartitionVersion(partitionTimestamp));
                        this.openPartitionInfo.setQuick(offset + 4, 1L);
                        long parquetSize = this.txFile.getPartitionParquetFileSize(partitionIndex);
                        assert (parquetSize > 0L);
                        MemoryCMR parquetMem = this.parquetPartitions.getQuick(partitionIndex);
                        if (parquetMem != null && parquetMem != NullMemoryCMR.INSTANCE) {
                            parquetMem.of(this.ff, path.$(), parquetSize, parquetSize, 9);
                        } else {
                            parquetMem = new MemoryCMRDetachedImpl(this.ff, path.$(), parquetSize, 9, false);
                            this.parquetPartitions.setQuick(partitionIndex, parquetMem);
                        }
                        ++this.openPartitionCount;
                    }
                    partitionTimestamp = partitionSize;
                    return partitionTimestamp;
                }
            } else {
                path = this.pathGenNativePartition(partitionIndex, partitionNameTxn);
                if (this.ff.exists(path.$())) {
                    long partitionSize = this.getPartitionRowCountFromMetadata(partitionIndex);
                    if (partitionSize > -1L) {
                        LOG.debug().$("open partition [path=").$substr(this.dbRootSize, path).$(", rowCount=").$(partitionSize).$(", partitionIndex=").$(partitionIndex).$(", partitionCount=").$(this.partitionCount).$(", format=native").I$();
                        long partitionTimestamp = this.openPartitionInfo.getQuick(partitionIndex * 8);
                        this.openPartitionInfo.setQuick(offset + 2, partitionNameTxn);
                        this.openPartitionInfo.setQuick(offset + 3, this.columnVersionReader.getMaxPartitionVersion(partitionTimestamp));
                        this.openPartitionInfo.setQuick(offset + 4, 0L);
                        this.openPartitionColumns(partitionIndex, path, this.getColumnBase(partitionIndex), partitionSize);
                        this.openPartitionInfo.setQuick(offset + 1, partitionSize);
                        ++this.openPartitionCount;
                    }
                    long l = partitionSize;
                    return l;
                }
            }
            LOG.error().$("open partition failed, partition does not exist on the disk [path=").$(this.path).I$();
            if (PartitionBy.isPartitioned(this.getPartitionedBy())) {
                CairoException exception = CairoException.critical(0).put("Partition '");
                this.formatErrorPartitionDirName(partitionIndex, exception.message);
                exception.put("' does not exist in table '").put(this.tableToken.getTableName()).put("' directory. Run [ALTER TABLE ").put(this.tableToken.getTableName()).put(" FORCE DROP PARTITION LIST '");
                this.formatErrorPartitionDirName(partitionIndex, exception.message);
                exception.put("'] to repair the table or the database from the backup.");
                throw exception;
            }
            throw CairoException.critical(0).put("Table '").put(this.tableToken.getTableName()).put("' data directory does not exist on the disk at ").put(this.path).put(". Restore data on disk or drop the table.");
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void openPartitionColumns(int partitionIndex, Path path, int columnBase, long partitionRowCount) {
        try {
            for (int i = 0; i < this.columnCount; ++i) {
                this.reloadColumnAt(partitionIndex, path, this.columns, this.columnTops, this.bitmapIndexes, columnBase, i, partitionRowCount);
            }
        }
        catch (Throwable th) {
            this.closePartitionColumns(columnBase);
            this.openPartitionInfo.setQuick(partitionIndex * 8 + 1, -1L);
            throw th;
        }
    }

    private void openSymbolMaps() {
        int columnCount = this.metadata.getColumnCount();
        this.symbolMapReaders.setPos(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            if (!ColumnType.isSymbol(this.metadata.getColumnType(i))) continue;
            this.symbolMapReaders.set(i, this.newSymbolMapReader(this.metadata.getDenseSymbolIndex(i), i));
        }
    }

    private Path pathGenNativePartition(int partitionIndex, long nameTxn) {
        this.formatNativePartitionDirName(partitionIndex, this.path.slash(), nameTxn);
        return this.path;
    }

    private Path pathGenParquetPartition(int partitionIndex, long nameTxn) {
        this.formatParquetPartitionFileName(partitionIndex, this.path.slash(), nameTxn);
        return this.path;
    }

    private void prepareForLazyOpen(int partitionIndex) {
        this.closePartition(partitionIndex);
    }

    private void readTxnSlow(long deadline) {
        long txn;
        int count = 0;
        while (true) {
            if (this.txFile.unsafeLoadAll()) {
                txn = this.txFile.getTxn();
                this.releaseTxn();
                this.txn = txn;
                if (this.acquireTxn()) break;
            }
            ++count;
            if (this.clock.getTicks() > deadline) {
                throw CairoException.critical(0).put("Transaction read timeout [src=reader, table=").put(this.tableToken).put(", timeout=").put(this.configuration.getSpinLockTimeout()).put("ms]");
            }
            Os.pause();
        }
        this.rowCount = this.txFile.getFixedRowCount() + this.txFile.getTransientRowCount();
        LOG.debug().$("new transaction [txn=").$(txn).$(", transientRowCount=").$(this.txFile.getTransientRowCount()).$(", fixedRowCount=").$(this.txFile.getFixedRowCount()).$(", maxTimestamp=").$ts(this.txFile.getMaxTimestamp()).$(", attempts=").$(count).$(", thread=").$(Thread.currentThread().getName()).I$();
    }

    private void reconcileOpenPartitions(long prevPartitionVersion, long prevColumnVersion, long prevTruncateVersion) {
        boolean truncateHappened;
        boolean bl = truncateHappened = this.txFile.getTruncateVersion() != prevTruncateVersion;
        if (this.txFile.getPartitionTableVersion() == prevPartitionVersion && this.txFile.getColumnVersion() == prevColumnVersion && !truncateHappened) {
            int txPartitionCount;
            int partitionIndex = Math.max(0, this.partitionCount - 1);
            if (partitionIndex < (txPartitionCount = this.txFile.getPartitionCount())) {
                if (partitionIndex < this.partitionCount) {
                    int offset = partitionIndex * 8;
                    long openPartitionSize = this.openPartitionInfo.getQuick(offset + 1);
                    if (openPartitionSize > -1L) {
                        long openPartitionNameTxn = this.openPartitionInfo.getQuick(offset + 2);
                        long txPartitionSize = this.getPartitionRowCountFromMetadata(partitionIndex);
                        long txPartitionNameTxn = this.txFile.getPartitionNameTxn(partitionIndex);
                        if (openPartitionNameTxn == txPartitionNameTxn) {
                            byte format = this.getPartitionFormat(partitionIndex);
                            assert (format != -1);
                            if (format == 0) {
                                if (this.reloadColumnFiles(partitionIndex, txPartitionSize)) {
                                    this.openPartitionInfo.setQuick(offset + 1, txPartitionSize);
                                    LOG.debug().$("updated partition size [partition=").$(this.openPartitionInfo.getQuick(offset)).I$();
                                } else {
                                    this.prepareForLazyOpen(partitionIndex);
                                }
                            } else {
                                long parquetSize = this.txFile.getPartitionParquetFileSize(partitionIndex);
                                if (this.reloadParquetFile(partitionIndex, parquetSize)) {
                                    this.openPartitionInfo.setQuick(offset + 1, txPartitionSize);
                                    LOG.debug().$("updated parquet partition size [partition=").$(this.openPartitionInfo.getQuick(offset)).I$();
                                } else {
                                    this.prepareForLazyOpen(partitionIndex);
                                }
                            }
                        } else {
                            this.prepareForLazyOpen(partitionIndex);
                        }
                    }
                    ++partitionIndex;
                }
                while (partitionIndex < txPartitionCount) {
                    this.insertPartition(partitionIndex, this.txFile.getPartitionTimestampByIndex(partitionIndex));
                    ++partitionIndex;
                }
                this.reloadSymbolMapCounts();
            }
            return;
        }
        this.reconcileOpenPartitions0(truncateHappened);
    }

    private void reconcileOpenPartitions0(boolean forceTruncate) {
        int partitionIndex = 0;
        int txPartitionCount = this.txFile.getPartitionCount();
        int txPartitionIndex = partitionIndex;
        boolean changed = false;
        while (partitionIndex < this.partitionCount && txPartitionIndex < txPartitionCount) {
            int offset = partitionIndex * 8;
            long txPartTs = this.txFile.getPartitionTimestampByIndex(txPartitionIndex);
            long openPartitionTimestamp = this.openPartitionInfo.getQuick(offset);
            if (openPartitionTimestamp < txPartTs) {
                this.closeDeletedPartition(partitionIndex);
                continue;
            }
            if (openPartitionTimestamp > txPartTs) {
                this.insertPartition(partitionIndex, txPartTs);
                changed = true;
                ++txPartitionIndex;
                ++partitionIndex;
                continue;
            }
            long txPartitionSize = this.txFile.getPartitionSize(txPartitionIndex);
            long txPartitionNameTxn = this.txFile.getPartitionNameTxn(partitionIndex);
            long openPartitionSize = this.openPartitionInfo.getQuick(offset + 1);
            long openPartitionNameTxn = this.openPartitionInfo.getQuick(offset + 2);
            long openPartitionColumnVersion = this.openPartitionInfo.getQuick(offset + 3);
            if (!forceTruncate) {
                if (openPartitionNameTxn == txPartitionNameTxn && openPartitionColumnVersion == this.columnVersionReader.getMaxPartitionVersion(txPartTs)) {
                    if (openPartitionSize > -1L) {
                        byte format = this.getPartitionFormat(partitionIndex);
                        assert (format != -1);
                        if (format == 0) {
                            if (this.reloadColumnFiles(partitionIndex, txPartitionSize)) {
                                this.openPartitionInfo.setQuick(offset + 1, txPartitionSize);
                                LOG.debug().$("updated partition size [partition=").$(openPartitionTimestamp).I$();
                            } else {
                                this.prepareForLazyOpen(partitionIndex);
                            }
                        } else {
                            long parquetSize = this.txFile.getPartitionParquetFileSize(partitionIndex);
                            if (this.reloadParquetFile(partitionIndex, parquetSize)) {
                                this.openPartitionInfo.setQuick(offset + 1, txPartitionSize);
                                LOG.debug().$("updated parquet partition size [partition=").$(this.openPartitionInfo.getQuick(offset)).I$();
                            } else {
                                this.prepareForLazyOpen(partitionIndex);
                            }
                        }
                    }
                } else {
                    this.prepareForLazyOpen(partitionIndex);
                }
                changed = true;
            } else if (openPartitionSize > -1L && txPartitionSize > -1L) {
                this.prepareForLazyOpen(partitionIndex);
            }
            ++txPartitionIndex;
            ++partitionIndex;
        }
        while (partitionIndex < this.partitionCount) {
            this.closeDeletedPartition(partitionIndex);
            changed = true;
        }
        while (partitionIndex < txPartitionCount) {
            this.insertPartition(partitionIndex, this.txFile.getPartitionTimestampByIndex(partitionIndex));
            changed = true;
            ++partitionIndex;
        }
        if (forceTruncate) {
            this.reloadAllSymbols();
        } else if (changed) {
            this.reloadSymbolMapCounts();
        }
    }

    private boolean releaseTxn() {
        if (this.txnAcquired) {
            long readerCount = this.txnScoreboard.releaseTxn(this.id, this.txn);
            this.txnAcquired = false;
            return readerCount == 0L;
        }
        return false;
    }

    private void reloadAllSymbols() {
        for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            SymbolMapReader symbolMapReader;
            if (!ColumnType.isSymbol(this.metadata.getColumnType(columnIndex)) || !((symbolMapReader = this.symbolMapReaders.getQuick(columnIndex)) instanceof SymbolMapReaderImpl)) continue;
            int writerColumnIndex = this.metadata.getWriterIndex(columnIndex);
            long columnNameTxn = this.columnVersionReader.getDefaultColumnNameTxn(writerColumnIndex);
            int symbolCount = this.txFile.getSymbolValueCount(this.metadata.getDenseSymbolIndex(columnIndex));
            ((SymbolMapReaderImpl)symbolMapReader).of(this.configuration, this.path, this.metadata.getColumnName(columnIndex), columnNameTxn, symbolCount);
        }
    }

    private void reloadAtTxn(TableReader srcReader, boolean reshuffle) {
        this.releaseTxn();
        long txn = srcReader.getTxn();
        if (!this.txnScoreboard.incrementTxn(this.id, txn)) {
            throw CairoException.critical(0).put("could not acquire txn for copy, source reader has to be active [table=").put(this.tableToken.getTableName()).put(", txn=").put(txn).put(']');
        }
        this.txn = txn;
        this.txnAcquired = true;
        this.txFile.loadAllFrom(srcReader.txFile);
        this.columnVersionReader.readFrom(srcReader.columnVersionReader);
        this.reloadMetadataFrom(srcReader.metadata, reshuffle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadColumnAt(int partitionIndex, Path path, ObjList<MemoryCMR> columns, LongList columnTops, ObjList<BitmapIndexReader> indexReaders, int columnBase, int columnIndex, long partitionRowCount) {
        int plen = path.size();
        try {
            long columnRowCount;
            long columnTxn;
            CharSequence name = this.metadata.getColumnName(columnIndex);
            int primaryIndex = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
            int secondaryIndex = primaryIndex + 1;
            long partitionTimestamp = this.openPartitionInfo.getQuick(partitionIndex * 8);
            byte partitionFormat = (byte)this.openPartitionInfo.getQuick(partitionIndex * 8 + 4);
            long partitionTxn = this.openPartitionInfo.getQuick(partitionIndex * 8 + 2);
            int writerIndex = this.metadata.getWriterIndex(columnIndex);
            int versionRecordIndex = this.columnVersionReader.getRecordIndex(partitionTimestamp, writerIndex);
            long columnTop = versionRecordIndex > -1 ? this.columnVersionReader.getColumnTopByIndex(versionRecordIndex) : 0L;
            long l = columnTxn = versionRecordIndex > -1 ? this.columnVersionReader.getColumnNameTxnByIndex(versionRecordIndex) : -1L;
            if (columnTxn == -1L) {
                columnTxn = this.columnVersionReader.getDefaultColumnNameTxn(writerIndex);
            }
            if ((columnRowCount = partitionRowCount - columnTop) > 0L && (versionRecordIndex > -1 || this.columnVersionReader.getColumnTopPartitionTimestamp(writerIndex) <= partitionTimestamp)) {
                if (partitionFormat == 0) {
                    boolean lastPartition;
                    int columnType = this.metadata.getColumnType(columnIndex);
                    MemoryCMR dataMem = columns.getQuick(primaryIndex);
                    boolean bl = lastPartition = partitionIndex == this.partitionCount - 1;
                    if (ColumnType.isVarSize(columnType)) {
                        ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
                        long auxSize = columnTypeDriver.getAuxVectorSize(columnRowCount);
                        TableUtils.iFile(path.trimTo(plen), name, columnTxn);
                        MemoryCMR auxMem = columns.getQuick(secondaryIndex);
                        auxMem = this.openOrCreateColumnMemory(path, columns, secondaryIndex, auxMem, auxSize, lastPartition);
                        long dataSize = columnTypeDriver.getDataVectorSizeAt(auxMem.addressOf(0L), columnRowCount - 1L);
                        if (dataSize < columnTypeDriver.getDataVectorMinEntrySize() || dataSize >= 0x10000000000L) {
                            LOG.critical().$("Invalid var len column size [column=").$safe(name).$(", size=").$(dataSize).$(", path=").$(path).I$();
                            throw CairoException.critical(0).put("Invalid column size [column=").put(path).put(", size=").put(dataSize).put(']');
                        }
                        TableUtils.dFile(path.trimTo(plen), name, columnTxn);
                        this.openOrCreateColumnMemory(path, columns, primaryIndex, dataMem, dataSize, lastPartition);
                    } else {
                        TableUtils.dFile(path.trimTo(plen), name, columnTxn);
                        this.openOrCreateColumnMemory(path, columns, primaryIndex, dataMem, columnRowCount << ColumnType.pow2SizeOf(columnType), lastPartition);
                        Misc.free(columns.getAndSetQuick(secondaryIndex, null));
                    }
                } else {
                    assert (partitionFormat == 1);
                    Misc.free(columns.getAndSetQuick(primaryIndex, null));
                    Misc.free(columns.getAndSetQuick(secondaryIndex, null));
                }
                columnTops.setQuick(columnBase / 2 + columnIndex, columnTop);
                if (this.metadata.isColumnIndexed(columnIndex)) {
                    BitmapIndexReader indexReader = indexReaders.getQuick(primaryIndex);
                    if (indexReader != null) {
                        indexReader.of(this.configuration, path.trimTo(plen), name, columnTxn, partitionTxn, columnTop);
                    }
                } else {
                    Misc.free(indexReaders.getAndSetQuick(primaryIndex, null));
                    Misc.free(indexReaders.getAndSetQuick(secondaryIndex, null));
                }
            } else {
                Misc.free(columns.getAndSetQuick(primaryIndex, NullMemoryCMR.INSTANCE));
                Misc.free(columns.getAndSetQuick(secondaryIndex, NullMemoryCMR.INSTANCE));
                Misc.free(indexReaders.getAndSetQuick(primaryIndex, null));
                Misc.free(indexReaders.getAndSetQuick(secondaryIndex, null));
                columnTops.setQuick(columnBase / 2 + columnIndex, partitionRowCount);
            }
        }
        finally {
            path.trimTo(plen);
        }
    }

    private boolean reloadColumnFiles(int partitionIndex, long rowCount) {
        int columnBase = this.getColumnBase(partitionIndex);
        for (int i = 0; i < this.columnCount; ++i) {
            int index = TableReader.getPrimaryColumnIndex(columnBase, i);
            MemoryCMR mem1 = this.columns.getQuick(index);
            long columnFilesRowCount = rowCount - this.getColumnTop(columnBase, i);
            if (!(columnFilesRowCount <= 0L || mem1 != NullMemoryCMR.INSTANCE && TableReader.growColumn((MemoryCMRDetachedImpl)mem1, (MemoryCMRDetachedImpl)this.columns.getQuick(index + 1), this.metadata.getColumnType(i), columnFilesRowCount))) {
                return false;
            }
            this.closeIndexReader(columnBase, i);
        }
        return true;
    }

    private boolean reloadColumnVersion(long columnVersion, long deadline) {
        if (this.columnVersionReader.getVersion() != columnVersion) {
            this.columnVersionReader.readSafe(this.clock, deadline);
        }
        return this.columnVersionReader.getVersion() == columnVersion;
    }

    private boolean reloadMetadata(int txnMetadataVersion, long deadline, boolean reshuffleColumns) {
        if ((long)txnMetadataVersion == this.metadata.getMetadataVersion()) {
            return true;
        }
        while (true) {
            try {
                if (!this.metadata.prepareTransition(txnMetadataVersion)) {
                    if (this.clock.getTicks() < deadline) {
                        return false;
                    }
                    throw CairoException.critical(0).put("Metadata read timeout [src=reader, timeout=").put(this.configuration.getSpinLockTimeout()).put("ms]");
                }
            }
            catch (CairoException ex) {
                TableUtils.handleMetadataLoadException(this.tableToken.getTableName(), deadline, ex, this.configuration.getMillisecondClock(), this.configuration.getSpinLockTimeout());
                continue;
            }
            break;
        }
        assert (!reshuffleColumns || this.metadata.getColumnCount() == this.columnCount);
        TableReaderMetadataTransitionIndex transitionIndex = this.metadata.applyTransition();
        if (reshuffleColumns) {
            this.reshuffleColumns(transitionIndex);
        }
        return true;
    }

    private void reloadMetadataFrom(TableReaderMetadata srcMeta, boolean reshuffleColumns) {
        if (srcMeta.getMetadataVersion() == this.metadata.getMetadataVersion()) {
            return;
        }
        assert (!reshuffleColumns || this.metadata.getColumnCount() == this.columnCount);
        TableReaderMetadataTransitionIndex transitionIndex = this.metadata.applyTransitionFrom(srcMeta);
        if (reshuffleColumns) {
            this.reshuffleColumns(transitionIndex);
        }
    }

    private boolean reloadParquetFile(int partitionIndex, long parquetSize) {
        MemoryCMR parquetMem = this.parquetPartitions.getQuick(partitionIndex);
        if (parquetMem == null || parquetMem == NullMemoryCMR.INSTANCE) {
            return false;
        }
        return ((MemoryCMRDetachedImpl)parquetMem).tryChangeSize(parquetSize);
    }

    private void reloadSlow(boolean reshuffle) {
        long deadline = this.clock.getTicks() + this.configuration.getSpinLockTimeout();
        do {
            this.readTxnSlow(deadline);
        } while (!this.reloadColumnVersion(this.txFile.getColumnVersion(), deadline) || !this.reloadMetadata(this.txFile.getMetadataVersion(), deadline, reshuffle));
    }

    private void reloadSymbolMapCounts() {
        for (int i = 0; i < this.columnCount; ++i) {
            if (!ColumnType.isSymbol(this.metadata.getColumnType(i))) continue;
            this.symbolMapReaders.getQuick(i).updateSymbolCount(this.txFile.getSymbolValueCount(this.metadata.getDenseSymbolIndex(i)));
        }
    }

    private void renewSymbolMapReader(SymbolMapReader reader, int columnIndex) {
        if (ColumnType.isSymbol(this.metadata.getColumnType(columnIndex))) {
            int writerColumnIndex = this.metadata.getWriterIndex(columnIndex);
            long columnNameTxn = this.columnVersionReader.getDefaultColumnNameTxn(writerColumnIndex);
            CharSequence columnName = this.metadata.getColumnName(columnIndex);
            if (!(reader instanceof SymbolMapReaderImpl)) {
                reader = new SymbolMapReaderImpl(this.configuration, this.path, columnName, columnNameTxn, 0);
            } else {
                SymbolMapReaderImpl symbolMapReader = (SymbolMapReaderImpl)reader;
                if (symbolMapReader.needsReopen(columnNameTxn)) {
                    ((SymbolMapReaderImpl)reader).of(this.configuration, this.path, columnName, columnNameTxn, 0);
                }
            }
        } else if (reader instanceof SymbolMapReaderImpl) {
            ((SymbolMapReaderImpl)reader).close();
            reader = null;
        }
        this.symbolMapReaders.setQuick(columnIndex, reader);
    }

    private void reshuffleColumns(TableReaderMetadataTransitionIndex transitionIndex) {
        int columnCount = this.metadata.getColumnCount();
        int columnCountShl = TableReader.getColumnBits(columnCount);
        if (columnCountShl > this.columnCountShl) {
            this.createNewColumnList(columnCount, transitionIndex, columnCountShl);
        } else {
            this.reshuffleColumns(columnCount, transitionIndex);
        }
        this.reshuffleSymbolMapReaders(transitionIndex, columnCount);
        this.columnCount = columnCount;
        this.reloadSymbolMapCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reshuffleColumns(int columnCount, TableReaderMetadataTransitionIndex transitionIndex) {
        LOG.debug().$("reshuffling columns file list [table=").$safe(this.tableToken.getTableName()).I$();
        int iterateCount = Math.max(columnCount, this.columnCount);
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            int base = this.getColumnBase(partitionIndex);
            try {
                long partitionRowCount = this.openPartitionInfo.getQuick(partitionIndex * 8 + 1);
                if (partitionRowCount <= -1L || (partitionRowCount = this.closeRewrittenPartitionFiles(partitionIndex, base)) <= -1L) continue;
                for (int i = 0; i < iterateCount; ++i) {
                    int copyFrom = transitionIndex.getCopyFromIndex(i);
                    if (transitionIndex.closeColumn(i)) {
                        this.closePartitionColumn(base, i);
                    }
                    if (i >= columnCount) continue;
                    if (copyFrom == i) {
                        MemoryMR col = this.columns.getQuick(TableReader.getPrimaryColumnIndex(base, i));
                        if (!(col instanceof NullMemoryCMR) && (col == null || col.isOpen())) continue;
                        this.reloadColumnAt(partitionIndex, this.path, this.columns, this.columnTops, this.bitmapIndexes, base, i, partitionRowCount);
                        continue;
                    }
                    if (copyFrom > -1) {
                        this.copyColumns(base, copyFrom, this.columns, this.columnTops, this.bitmapIndexes, base, i);
                        continue;
                    }
                    if (copyFrom == Integer.MIN_VALUE) continue;
                    this.reloadColumnAt(partitionIndex, this.path, this.columns, this.columnTops, this.bitmapIndexes, base, i, partitionRowCount);
                }
                continue;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    private void reshuffleSymbolMapReaders(TableReaderMetadataTransitionIndex transitionIndex, int columnCount) {
        if (columnCount > this.columnCount) {
            this.symbolMapReaders.setPos(columnCount);
        }
        int n = Math.max(columnCount, this.columnCount);
        for (int i = 0; i < n; ++i) {
            int replaceWith;
            if (transitionIndex.closeColumn(i)) {
                Misc.freeIfCloseable(this.symbolMapReaders.getAndSetQuick(i, null));
            }
            if ((replaceWith = transitionIndex.getCopyFromIndex(i)) > -1) {
                SymbolMapReader rdr = this.symbolMapReaders.getQuick(replaceWith);
                this.renewSymbolMapReader(rdr, i);
                continue;
            }
            if (replaceWith == Integer.MIN_VALUE) continue;
            this.renewSymbolMapReader(null, i);
        }
    }
}

