/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.arr;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.FlatArrayView;
import io.questdb.cairo.arr.MutableArray;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.std.DoubleList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;

public final class DoubleArrayParser
extends MutableArray
implements FlatArrayView {
    private static final int STATE_IDLE = 0;
    private static final int STATE_IN_NUMBER = 2;
    private static final int STATE_IN_QUOTE = 1;
    private final DoubleList values = new DoubleList();

    public DoubleArrayParser() {
        this.flatView = this;
    }

    @Override
    public void appendToMemFlat(MemoryA mem, int offset, int length) {
        int n = Math.min(this.values.size(), length);
        for (int i = 0; i < n; ++i) {
            mem.putDouble(this.values.getQuick(i + offset));
        }
    }

    @Override
    public double getDoubleAtAbsIndex(int elemIndex) {
        return this.values.getQuick(elemIndex);
    }

    @Override
    public long getLongAtAbsIndex(int elemIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int length() {
        return this.values.size();
    }

    public void of(CharSequence input) {
        this.of(input, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void of(CharSequence input, int expectedDimCount) {
        this.values.clear();
        this.shape.clear();
        this.strides.clear();
        this.flatViewLength = 0;
        if (input == null) {
            this.type = 33;
            return;
        }
        this.parse(input);
        if (expectedDimCount != -1) {
            if (this.shape.size() < expectedDimCount) {
                if (!this.isEmpty()) throw new IllegalArgumentException("expected " + expectedDimCount + " dimensions, got " + this.shape.size());
                this.shape.extendAndSet(expectedDimCount - 1, 0);
            } else if (this.shape.size() > expectedDimCount) {
                throw new IllegalArgumentException("expected " + expectedDimCount + " dimensions, got " + this.shape.size());
            }
        }
        this.type = ColumnType.encodeArrayType((short)10, this.shape.size());
        this.resetToDefaultStrides();
    }

    private void parse(CharSequence input) {
        assert (this.strides.size() == 0);
        int numberStart = -1;
        int state = 0;
        block6: for (int position = 0; position < input.length(); ++position) {
            char c = input.charAt(position);
            if (c == '\"') {
                if (state == 1) {
                    this.parseAndAddNumber(input, numberStart, position);
                    state = 0;
                    continue;
                }
                numberStart = position + 1;
                state = 1;
                continue;
            }
            if (state == 1) continue;
            switch (c) {
                case '[': 
                case '{': {
                    this.strides.add(0);
                    continue block6;
                }
                case ']': 
                case '}': {
                    int depth;
                    if (state == 2) {
                        this.parseAndAddNumber(input, numberStart, position);
                        state = 0;
                    }
                    if ((depth = this.strides.size() - 1) > 0) {
                        this.strides.increment(depth - 1);
                    }
                    int currentCount = this.strides.getQuick(depth);
                    this.updateShapeInfo(depth, currentCount, position);
                    this.strides.removeIndex(depth);
                    continue block6;
                }
                case ',': {
                    if (state != 2) continue block6;
                    this.parseAndAddNumber(input, numberStart, position);
                    state = 0;
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block6;
                }
                default: {
                    if (state == 2) continue block6;
                    numberStart = position;
                    state = 2;
                }
            }
        }
    }

    private void parseAndAddNumber(CharSequence input, int numberStart, int i) {
        int len = i - numberStart;
        if (len == 4 && (input.charAt(numberStart) | 0x20) == 110 && (input.charAt(numberStart + 1) | 0x20) == 117 && (input.charAt(numberStart + 2) | 0x20) == 108 && (input.charAt(numberStart + 3) | 0x20) == 108) {
            throw new IllegalArgumentException("NULL is not supported in arrays");
        }
        try {
            this.values.add(Numbers.parseDouble(input, numberStart, len));
        }
        catch (NumericException e) {
            throw new IllegalArgumentException("Invalid number format at position " + numberStart, e);
        }
        this.strides.increment(this.strides.size() - 1);
        ++this.flatViewLength;
    }

    private void updateShapeInfo(int depth, int currentCount, int position) {
        if (this.shape.size() <= depth) {
            for (int i = this.shape.size(); i < depth; ++i) {
                this.shape.add(0);
            }
            this.shape.add(currentCount);
        } else {
            int alreadyObservedCount = this.shape.getQuick(depth);
            if (alreadyObservedCount == 0) {
                this.shape.setQuick(depth, currentCount);
            } else if (currentCount != alreadyObservedCount) {
                throw new IllegalArgumentException("element counts in sub-arrays don't match [depth=" + depth + ", currentCount=" + currentCount + ", alreadyObservedCount=" + alreadyObservedCount + ", position=" + position + "]");
            }
        }
    }
}

