/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm.file;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.frm.FrameColumn;
import io.questdb.cairo.frm.file.ContiguousFileFixFrameColumn;
import io.questdb.cairo.frm.file.RecycleBin;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;

public class ContiguousFileVarFrameColumn
implements FrameColumn {
    private static final Log LOG = LogFactory.getLog(ContiguousFileFixFrameColumn.class);
    private static final int MEMORY_TAG = 12;
    private final FilesFacade ff;
    private final int fileOpts;
    private final boolean mixedIOFlag;
    private long appendOffsetRowCount = -1L;
    private long auxFd = -1L;
    private long auxMapAddr;
    private long auxMapSize;
    private boolean closed = false;
    private int columnIndex;
    private long columnTop;
    private int columnType;
    private ColumnTypeDriver columnTypeDriver;
    private long dataAppendOffsetBytes = -1L;
    private long dataFd = -1L;
    private long dataMapAddr;
    private long dataMapSize;
    private boolean isReadOnly;
    private RecycleBin<FrameColumn> recycleBin;

    public ContiguousFileVarFrameColumn(CairoConfiguration configuration) {
        this.ff = configuration.getFilesFacade();
        this.fileOpts = configuration.getWriterFileOpenOpts();
        this.mixedIOFlag = configuration.isWriterMixedIOEnabled();
    }

    @Override
    public void addTop(long value) {
        this.columnTop += value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(long appendOffsetRowCount, FrameColumn sourceColumn, long sourceLo, long sourceHi, int commitMode) {
        if (sourceColumn.getStorageType() != 0) {
            throw new UnsupportedOperationException();
        }
        sourceLo -= sourceColumn.getColumnTop();
        appendOffsetRowCount -= this.columnTop;
        assert ((sourceHi -= sourceColumn.getColumnTop()) >= 0L);
        assert (sourceLo >= 0L);
        assert (appendOffsetRowCount >= 0L);
        if (sourceHi > 0L) {
            long targetDataOffset = this.getDataAppendOffsetBytes(appendOffsetRowCount);
            long srcAuxMemSize = this.columnTypeDriver.getAuxVectorSize(sourceHi);
            long srcAuxMemAddr = TableUtils.mapAppendColumnBuffer(this.ff, sourceColumn.getSecondaryFd(), 0L, srcAuxMemSize, false, 12);
            try {
                long srcDataOffset = this.columnTypeDriver.getDataVectorOffset(srcAuxMemAddr, sourceLo);
                assert (sourceLo == 0L && srcDataOffset == 0L || sourceLo > 0L && srcDataOffset >= this.columnTypeDriver.getDataVectorMinEntrySize() && srcDataOffset < 0x10000000000L);
                long srcDataSize = this.columnTypeDriver.getDataVectorSize(srcAuxMemAddr, sourceLo, sourceHi - 1L);
                if (srcDataSize > 0L) {
                    assert (srcDataSize < 0x10000000000L);
                    TableUtils.allocateDiskSpaceToPage(this.ff, this.dataFd, targetDataOffset + srcDataSize);
                    if (this.mixedIOFlag) {
                        if (this.ff.copyData(sourceColumn.getPrimaryFd(), this.dataFd, srcDataOffset, targetDataOffset, srcDataSize) != srcDataSize) {
                            throw CairoException.critical(this.ff.errno()).put("Cannot copy data [fd=").put(this.dataFd).put(", destOffset=").put(targetDataOffset).put(", size=").put(srcDataSize).put(", fileSize=").put(this.ff.length(this.dataFd)).put(", srcFd=").put(sourceColumn.getPrimaryFd()).put(", srcOffset=").put(srcDataOffset).put(", srcFileSize=").put(this.ff.length(sourceColumn.getPrimaryFd())).put(']');
                        }
                        if (commitMode != 2) {
                            this.ff.fsync(this.dataFd);
                        }
                    } else {
                        long srcDataAddress = 0L;
                        long dstDataAddress = 0L;
                        try {
                            srcDataAddress = TableUtils.mapAppendColumnBuffer(this.ff, sourceColumn.getPrimaryFd(), srcDataOffset, srcDataSize, false, 12);
                            dstDataAddress = TableUtils.mapAppendColumnBuffer(this.ff, this.dataFd, targetDataOffset, srcDataSize, true, 12);
                            Vect.memcpy(dstDataAddress, srcDataAddress, srcDataSize);
                            if (commitMode != 2) {
                                TableUtils.msync(this.ff, dstDataAddress, srcDataSize, commitMode == 0);
                            }
                        }
                        finally {
                            if (srcDataAddress != 0L) {
                                TableUtils.mapAppendColumnBufferRelease(this.ff, srcDataAddress, srcDataOffset, srcDataSize, 12);
                            }
                            if (dstDataAddress != 0L) {
                                TableUtils.mapAppendColumnBufferRelease(this.ff, dstDataAddress, targetDataOffset, srcDataSize, 12);
                            }
                        }
                    }
                }
                long dstAuxOffset = this.columnTypeDriver.getAuxVectorOffset(appendOffsetRowCount);
                TableUtils.allocateDiskSpaceToPage(this.ff, this.auxFd, dstAuxOffset + srcAuxMemSize);
                long dstAuxAddr = TableUtils.mapAppendColumnBuffer(this.ff, this.auxFd, dstAuxOffset, srcAuxMemSize, true, 12);
                try {
                    this.columnTypeDriver.shiftCopyAuxVector(srcDataOffset - targetDataOffset, srcAuxMemAddr, sourceLo, sourceHi - 1L, dstAuxAddr, srcAuxMemSize);
                    if (commitMode != 2) {
                        TableUtils.msync(this.ff, dstAuxAddr, srcAuxMemSize, commitMode == 0);
                    }
                }
                finally {
                    TableUtils.mapAppendColumnBufferRelease(this.ff, dstAuxAddr, dstAuxOffset, srcAuxMemSize, 12);
                }
                this.appendOffsetRowCount = appendOffsetRowCount + (sourceHi - sourceLo);
                this.dataAppendOffsetBytes = targetDataOffset + srcDataSize;
            }
            finally {
                TableUtils.mapAppendColumnBufferRelease(this.ff, srcAuxMemAddr, 0L, srcAuxMemSize, 12);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendNulls(long rowCount, long sourceColumnTop, int commitMode) {
        assert ((rowCount -= this.columnTop) >= 0L);
        if (sourceColumnTop > 0L) {
            long targetDataOffset = this.getDataAppendOffsetBytes(rowCount);
            long srcDataSize = sourceColumnTop * this.columnTypeDriver.getDataVectorMinEntrySize();
            if (srcDataSize > 0L) {
                TableUtils.allocateDiskSpaceToPage(this.ff, this.dataFd, targetDataOffset + srcDataSize);
                long targetDataMemAddr = TableUtils.mapAppendColumnBuffer(this.ff, this.dataFd, targetDataOffset, srcDataSize, true, 12);
                try {
                    this.columnTypeDriver.setDataVectorEntriesToNull(targetDataMemAddr, sourceColumnTop);
                    if (commitMode != 2) {
                        TableUtils.msync(this.ff, targetDataMemAddr, srcDataSize, commitMode == 0);
                    }
                }
                finally {
                    TableUtils.mapAppendColumnBufferRelease(this.ff, targetDataMemAddr, targetDataOffset, srcDataSize, 12);
                }
                this.appendOffsetRowCount = rowCount + sourceColumnTop;
                this.dataAppendOffsetBytes = targetDataOffset + srcDataSize;
            }
            long srcAuxSize = this.columnTypeDriver.getAuxVectorSize(sourceColumnTop);
            long dstAuxOffset = this.columnTypeDriver.getAuxVectorSize(rowCount);
            TableUtils.allocateDiskSpaceToPage(this.ff, this.auxFd, dstAuxOffset + srcAuxSize);
            long targetAuxMemAddr = TableUtils.mapAppendColumnBuffer(this.ff, this.auxFd, dstAuxOffset, srcAuxSize, true, 12);
            try {
                this.columnTypeDriver.setPartAuxVectorNull(targetAuxMemAddr, targetDataOffset + this.columnTypeDriver.getDataVectorMinEntrySize(), sourceColumnTop);
                if (commitMode != 2) {
                    TableUtils.msync(this.ff, targetAuxMemAddr, srcAuxSize, commitMode == 0);
                }
            }
            finally {
                TableUtils.mapAppendColumnBufferRelease(this.ff, targetAuxMemAddr, dstAuxOffset, srcAuxSize, 12);
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.auxMapAddr != 0L) {
                this.ff.munmap(this.auxMapAddr, this.auxMapSize, 12);
                this.auxMapAddr = 0L;
                this.auxMapSize = 0L;
            }
            if (this.dataMapAddr != 0L) {
                this.ff.munmap(this.dataMapAddr, this.dataMapSize, 12);
                this.dataMapAddr = 0L;
                this.dataMapSize = 0L;
            }
            if (this.auxFd != -1L) {
                this.ff.close(this.auxFd);
                this.auxFd = -1L;
            }
            if (this.dataFd != -1L) {
                this.ff.close(this.dataFd);
                this.dataFd = -1L;
            }
            this.closed = true;
            if (this.recycleBin != null && !this.recycleBin.isClosed()) {
                this.appendOffsetRowCount = 0L;
                this.dataAppendOffsetBytes = 0L;
                this.recycleBin.put(this);
            }
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public long getColumnTop() {
        return this.columnTop;
    }

    @Override
    public int getColumnType() {
        return this.columnType;
    }

    @Override
    public long getContiguousAuxAddr(long rowHi) {
        if (rowHi <= this.columnTop) {
            return 0L;
        }
        this.mapAllRows(rowHi);
        return this.auxMapAddr;
    }

    @Override
    public long getContiguousDataAddr(long rowHi) {
        if (rowHi <= this.columnTop) {
            return 0L;
        }
        this.mapAllRows(rowHi);
        return this.dataMapAddr;
    }

    @Override
    public long getPrimaryFd() {
        return this.dataFd;
    }

    @Override
    public long getSecondaryFd() {
        return this.auxFd;
    }

    @Override
    public int getStorageType() {
        return 0;
    }

    public void ofRO(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, long columnTop, int columnIndex, boolean isEmpty) {
        assert (this.auxFd == -1L);
        this.closed = false;
        int plen = partitionPath.size();
        try {
            this.columnType = columnType;
            this.columnTypeDriver = ColumnType.getDriver(columnType);
            this.columnTop = columnTop;
            this.columnIndex = columnIndex;
            this.appendOffsetRowCount = -1L;
            if (!isEmpty) {
                TableUtils.dFile(partitionPath, columnName, columnTxn);
                this.dataFd = TableUtils.openRO(this.ff, partitionPath.$(), LOG);
                partitionPath.trimTo(plen);
                TableUtils.iFile(partitionPath, columnName, columnTxn);
                this.auxFd = TableUtils.openRO(this.ff, partitionPath.$(), LOG);
            }
            this.isReadOnly = true;
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        finally {
            partitionPath.trimTo(plen);
        }
    }

    public void ofRW(Path partitionPath, CharSequence columnName, long columnTxn, int columnType, long columnTop, int columnIndex) {
        assert (this.auxFd == -1L);
        this.closed = false;
        int plen = partitionPath.size();
        try {
            this.columnType = columnType;
            this.columnTypeDriver = ColumnType.getDriver(columnType);
            this.columnTop = columnTop;
            this.columnIndex = columnIndex;
            this.appendOffsetRowCount = -1L;
            TableUtils.dFile(partitionPath, columnName, columnTxn);
            this.dataFd = TableUtils.openRW(this.ff, partitionPath.$(), LOG, this.fileOpts);
            partitionPath.trimTo(plen);
            TableUtils.iFile(partitionPath, columnName, columnTxn);
            this.auxFd = TableUtils.openRW(this.ff, partitionPath.$(), LOG, this.fileOpts);
            this.isReadOnly = false;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        finally {
            partitionPath.trimTo(plen);
        }
    }

    @Override
    public void setRecycleBin(RecycleBin<FrameColumn> recycleBin) {
        assert (this.recycleBin == null);
        this.recycleBin = recycleBin;
    }

    private long getDataAppendOffsetBytes(long appendOffsetRowCount) {
        if (this.appendOffsetRowCount != appendOffsetRowCount) {
            this.dataAppendOffsetBytes = this.columnTypeDriver.getDataVectorSizeAtFromFd(this.ff, this.auxFd, appendOffsetRowCount - 1L);
            this.appendOffsetRowCount = appendOffsetRowCount;
        }
        return this.dataAppendOffsetBytes;
    }

    private void mapAllRows(long rowHi) {
        if (!this.isReadOnly) {
            throw new UnsupportedOperationException("Cannot map writable column");
        }
        long newAuxMemSize = this.columnTypeDriver.getAuxVectorSize(rowHi - this.columnTop);
        if (this.auxMapSize > 0L) {
            if (this.auxMapSize <= newAuxMemSize) {
                return;
            }
            throw new UnsupportedOperationException("Remap not supported for frame columns yet");
        }
        this.auxMapSize = newAuxMemSize;
        if (newAuxMemSize > 0L) {
            this.auxMapAddr = TableUtils.mapRO(this.ff, this.auxFd, this.auxMapSize, 0L, 12);
        }
        this.dataMapSize = this.columnTypeDriver.getDataVectorSize(this.auxMapAddr, 0L, rowHi - this.columnTop - 1L);
        if (this.dataMapSize > 0L) {
            this.dataMapAddr = TableUtils.mapRO(this.ff, this.dataFd, this.dataMapSize, 0L, 12);
        }
    }
}

