/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.UnorderedVarcharMap;
import io.questdb.cairo.map.UnorderedVarcharMapRecord;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.std.DirectLongLongSortedList;

public final class UnorderedVarcharMapCursor
implements MapRecordCursor {
    private final long entrySize;
    private final UnorderedVarcharMap map;
    private final UnorderedVarcharMapRecord recordA;
    private final UnorderedVarcharMapRecord recordB;
    private long address;
    private int count;
    private long memLimit;
    private long memStart;
    private int remaining;

    UnorderedVarcharMapCursor(UnorderedVarcharMapRecord record, UnorderedVarcharMap map) {
        this.recordA = record;
        this.recordB = record.clone();
        this.map = map;
        this.entrySize = map.entrySize();
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        if (this.remaining > 0) {
            counter.add(this.remaining);
            this.remaining = 0;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public MapRecord getRecord() {
        return this.recordA;
    }

    @Override
    public MapRecord getRecordB() {
        return this.recordB;
    }

    @Override
    public boolean hasNext() {
        if (this.remaining > 0) {
            this.recordA.of(this.address);
            this.skipToNonZeroKey();
            --this.remaining;
            return true;
        }
        return false;
    }

    @Override
    public void longTopK(DirectLongLongSortedList list, Function recordFunction) {
        for (long addr = this.memStart; addr < this.memLimit; addr += this.entrySize) {
            if (this.map.isZeroKey(addr)) continue;
            this.recordA.of(addr);
            long v = recordFunction.getLong(this.recordA);
            list.add(addr, v);
        }
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((UnorderedVarcharMapRecord)record).of(atRowId);
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public void toTop() {
        this.address = this.memStart;
        this.remaining = this.count;
        if (this.count > 0 && this.map.isZeroKey(this.address)) {
            this.skipToNonZeroKey();
        }
    }

    private void skipToNonZeroKey() {
        do {
            this.address += this.entrySize;
        } while (this.address < this.memLimit && this.map.isZeroKey(this.address));
    }

    UnorderedVarcharMapCursor init(long memStart, long memLimit, int count) {
        this.memStart = memStart;
        this.memLimit = memLimit;
        this.count = count;
        this.toTop();
        this.recordA.setLimit(memLimit);
        this.recordB.setLimit(memLimit);
        return this;
    }
}

