/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.mig;

import io.questdb.cairo.mig.EngineMigration;
import io.questdb.cairo.mig.MigrationActions;
import io.questdb.cairo.mig.MigrationContext;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.std.FilesFacade;
import io.questdb.std.Rnd;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;

final class Mig608 {
    Mig608() {
    }

    static void migrate(MigrationContext migrationContext) {
        FilesFacade ff = migrationContext.getFf();
        Path path = migrationContext.getTablePath();
        int plen = path.size();
        path.concat("_meta");
        if (!ff.exists(path.$())) {
            MigrationActions.LOG.error().$("meta file does not exist, nothing to migrate [path=").$(path).I$();
            return;
        }
        try (MemoryMARW rwMem = migrationContext.getRwMemory();){
            long oldNameOffset;
            long thatMetaColumnDataSize = 16L;
            long thisMetaColumnDataSize = 32L;
            rwMem.of(ff, path.$(), ff.getPageSize(), ff.length(path.$()), 44);
            int columnCount = rwMem.getInt(0L);
            long offset = 128L;
            long newNameOffset = offset + 32L * (long)columnCount;
            long o = oldNameOffset = offset + 16L * (long)columnCount;
            for (int i = 0; i < columnCount; ++i) {
                int len = rwMem.getStrLen(o);
                o += Vm.getStorageLength(len);
            }
            long nameSegmentLen = o - oldNameOffset;
            rwMem.extend(newNameOffset + nameSegmentLen);
            Vect.memmove(rwMem.addressOf(newNameOffset), rwMem.addressOf(oldNameOffset), nameSegmentLen);
            o = offset + 16L * (long)(columnCount - 1);
            long o2 = offset + 32L * (long)(columnCount - 1);
            Rnd rnd = SharedRandom.getRandom(migrationContext.getConfiguration());
            while (o >= offset) {
                rwMem.putInt(o2, rwMem.getInt(o));
                rwMem.putLong(o2 + 4L, rwMem.getInt(o + 4L));
                rwMem.putInt(o2 + 12L, rwMem.getInt(o + 12L));
                rwMem.putLong(o2 + 20L, rnd.nextLong());
                o -= 16L;
                o2 -= 32L;
            }
            rwMem.jumpTo(newNameOffset + nameSegmentLen);
        }
        path.trimTo(plen).concat("_txn");
        if (!ff.exists(path.$())) {
            MigrationActions.LOG.error().$("tx file does not exist, nothing to migrate [path=").$(path).I$();
            return;
        }
        EngineMigration.backupFile(ff, path, migrationContext.getTablePath2(), "_txn", 422);
        MigrationActions.LOG.debug().$("opening for rw [path=").$(path).I$();
        try (MemoryMARW txMem = migrationContext.createRwMemoryOf(ff, path.$());){
            long thatTxOffsetMapWriterCount = 72L;
            long thisTxOffsetMapWriterCount = 128L;
            int longsPerAttachedPartition = 4;
            int symbolCount = txMem.getInt(72L);
            int partitionTableSize = txMem.getInt(76L + (long)symbolCount * 8L) * 8 * 4;
            long thatSize = 76L + (long)symbolCount * 8L + 4L + (long)partitionTableSize;
            long thisSize = 132L + (long)symbolCount * 8L + 4L + (long)partitionTableSize;
            txMem.extend(thisSize);
            txMem.jumpTo(thisSize);
            Vect.memmove(txMem.addressOf(128L), txMem.addressOf(72L), thatSize - 72L);
            Vect.memset(txMem.addressOf(72L), 56L, 0);
        }
    }
}

