/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.TableToken;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sequence;

public class TableReferenceOutOfDateException
extends RuntimeException
implements FlyweightMessageContainer {
    private static final String prefix = "cached query plan cannot be used because table schema has changed [table='";
    private static final ThreadLocal<TableReferenceOutOfDateException> tlException = new ThreadLocal<TableReferenceOutOfDateException>(TableReferenceOutOfDateException::new);
    private final StringSink message = (StringSink)new StringSink().put("cached query plan cannot be used because table schema has changed [table='");

    public static TableReferenceOutOfDateException of(CharSequence outdatedTableName) {
        TableReferenceOutOfDateException ex = tlException.get();
        assert ((ex = new TableReferenceOutOfDateException()) != null);
        ex.message.clear(prefix.length());
        ex.message.put(outdatedTableName).put("']");
        return ex;
    }

    public static TableReferenceOutOfDateException of(Utf8Sequence outdatedTableName) {
        TableReferenceOutOfDateException ex = tlException.get();
        assert ((ex = new TableReferenceOutOfDateException()) != null);
        ex.message.clear(prefix.length());
        ex.message.put(outdatedTableName).put("']");
        return ex;
    }

    public static TableReferenceOutOfDateException of(TableToken tableToken) {
        TableReferenceOutOfDateException ex = tlException.get();
        assert ((ex = new TableReferenceOutOfDateException()) != null);
        ex.message.clear(prefix.length());
        ex.message.put(tableToken.getTableName()).put("']");
        return ex;
    }

    public static TableReferenceOutOfDateException of(TableToken tableToken, int expectedTableId, int actualTableId, long expectedMetadataVersion, long actualMetadataVersion) {
        TableReferenceOutOfDateException ex = tlException.get();
        assert ((ex = new TableReferenceOutOfDateException()) != null);
        ex.message.clear(prefix.length());
        ((Utf16Sink)((Utf16Sink)((Utf16Sink)((Utf16Sink)((Utf16Sink)((Utf16Sink)((Utf16Sink)((Utf16Sink)ex.message.put(tableToken.getTableName()).put("', expectedTableId=")).put(expectedTableId)).put(", actualTableId=")).put(actualTableId)).put(", expectedMetadataVersion=")).put(expectedMetadataVersion)).put(", actualMetadataVersion=")).put(actualMetadataVersion)).put(']');
        return ex;
    }

    @Override
    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return this.message.toString();
    }
}

