/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.vm.api.NullMemory;
import io.questdb.cairo.wal.SymbolMapDiff;
import io.questdb.cairo.wal.SymbolMapDiffEntry;
import io.questdb.cairo.wal.WalEventCursor;

public class SymbolMapDiffImpl
implements SymbolMapDiff {
    public static final int END_OF_SYMBOL_DIFFS = -1;
    public static final int END_OF_SYMBOL_ENTRIES = -1;
    private final WalEventCursor cursor;
    private final Entry entry = new Entry();
    private int cleanSymbolCount;
    private int columnIndex = -1;
    private boolean nullFlag;
    private int recordCount;

    SymbolMapDiffImpl(WalEventCursor cursor) {
        this.cursor = cursor;
    }

    @Override
    public void drain() {
        this.cursor.drain();
    }

    @Override
    public int getCleanSymbolCount() {
        return this.cleanSymbolCount;
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    public boolean hasNullValue() {
        return this.nullFlag;
    }

    @Override
    public SymbolMapDiffEntry nextEntry() {
        return this.cursor.readNextSymbolMapDiffEntry(this.entry);
    }

    void of(int columnIndex, int cleanSymbolCount, int size, boolean nullFlag) {
        this.columnIndex = columnIndex;
        this.cleanSymbolCount = cleanSymbolCount;
        this.recordCount = size;
        this.nullFlag = nullFlag;
        this.entry.clear();
    }

    public static class Entry
    implements SymbolMapDiffEntry {
        private int key;
        private MemoryCR memoryR;
        private long symbolOffset;

        @Override
        public void appendSymbolTo(MemoryARW symbolMem) {
            int len = this.memoryR.getInt(this.symbolOffset);
            symbolMem.putBlockOfBytes(this.memoryR.addressOf(this.symbolOffset), len < 0 ? 4L : Vm.getStorageLength(len));
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        public CharSequence getSymbol() {
            return this.memoryR.getStrA(this.symbolOffset);
        }

        void clear() {
            this.of(-1, 0L, NullMemory.INSTANCE);
        }

        void of(int key, long symbolOffset, MemoryCR symbolMem) {
            this.key = key;
            this.symbolOffset = symbolOffset;
            this.memoryR = symbolMem;
        }
    }
}

