/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.HttpChunkedResponse;
import io.questdb.cutlass.http.HttpConstants;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpRawSocket;
import io.questdb.cutlass.http.HttpResponseHeader;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.Net;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.Socket;
import io.questdb.std.Chars;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.Zip;
import io.questdb.std.bytes.Bytes;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.ex.ZLibException;
import io.questdb.std.str.StdoutSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpResponseSink
implements Closeable,
Mutable {
    private static final int HTTP_RANGE_NOT_SATISFIABLE = 416;
    private static final int HTTP_REQUEST_HEADER_FIELDS_TOO_LARGE = 431;
    private static final Log LOG = LogFactory.getLog(HttpResponseSink.class);
    private static final IntObjHashMap<Utf8Sequence> httpStatusMap = new IntObjHashMap();
    private final ChunkUtf8Sink buffer;
    private final ChunkedResponseImpl chunkedResponse = new ChunkedResponseImpl();
    private final ChunkUtf8Sink compressOutBuffer;
    private final boolean connectionCloseHeader;
    private final boolean cookiesEnabled;
    private final boolean dumpNetworkTraffic;
    private final int forceSendFragmentationChunkSize;
    private final HttpResponseHeaderImpl headerImpl;
    private final String httpVersion;
    private final NetworkFacade nf;
    private final HttpRawSocketImpl rawSocket = new HttpRawSocketImpl();
    private final SimpleResponseImpl simpleResponse = new SimpleResponseImpl();
    private final ResponseSinkImpl sink = new ResponseSinkImpl();
    private boolean chunkedRequestDone;
    private boolean compressedHeaderDone;
    private boolean compressedOutputReady;
    private boolean compressionComplete;
    private int crc = 0;
    private boolean deflateBeforeSend = false;
    private boolean headersSent;
    private Socket socket;
    private long total = 0L;
    private long totalBytesSent = 0L;
    private long zStreamPtr = 0L;

    public HttpResponseSink(HttpServerConfiguration configuration) {
        int responseBufferSize = configuration.getSendBufferSize();
        this.nf = configuration.getNetworkFacade();
        this.buffer = new ChunkUtf8Sink(responseBufferSize);
        this.compressOutBuffer = new ChunkUtf8Sink(responseBufferSize);
        HttpContextConfiguration contextConfiguration = configuration.getHttpContextConfiguration();
        this.headerImpl = new HttpResponseHeaderImpl(contextConfiguration.getMillisecondClock());
        this.dumpNetworkTraffic = contextConfiguration.getDumpNetworkTraffic();
        this.httpVersion = contextConfiguration.getHttpVersion();
        this.connectionCloseHeader = !contextConfiguration.getServerKeepAlive();
        this.cookiesEnabled = contextConfiguration.areCookiesEnabled();
        this.forceSendFragmentationChunkSize = contextConfiguration.getForceSendFragmentationChunkSize();
    }

    @Override
    public void clear() {
        this.headerImpl.clear();
        this.totalBytesSent = 0L;
        this.headersSent = false;
        this.chunkedRequestDone = false;
        this.simpleResponse.clear();
        this.resetZip();
    }

    @Override
    public void close() {
        if (this.zStreamPtr != 0L) {
            Zip.deflateEnd(this.zStreamPtr);
            this.zStreamPtr = 0L;
            this.compressOutBuffer.close();
        }
        this.buffer.close();
        this.socket = null;
    }

    public HttpChunkedResponse getChunkedResponse() {
        return this.chunkedResponse;
    }

    public int getCode() {
        return this.headerImpl.getCode();
    }

    public void resumeSend() throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (!this.headersSent || !this.deflateBeforeSend) {
            this.sendBuffer(this.buffer);
            return;
        }
        do {
            if (!this.compressedOutputReady && !this.compressionComplete) {
                this.deflate();
            }
            if (!this.compressedOutputReady) break;
            this.sendBuffer(this.compressOutBuffer);
            this.compressedOutputReady = false;
        } while (!this.compressionComplete);
    }

    public void setDeflateBeforeSend(boolean deflateBeforeSend, long bufferSize) {
        this.deflateBeforeSend = deflateBeforeSend;
        if (this.zStreamPtr == 0L && deflateBeforeSend) {
            this.zStreamPtr = Zip.deflateInit();
            this.compressOutBuffer.reopen(bufferSize);
        }
    }

    public SimpleResponseImpl simpleResponse() {
        return this.simpleResponse;
    }

    private void deflate() {
        boolean finished;
        int ret;
        long p;
        int len;
        int nInAvailable;
        if (!this.compressedHeaderDone) {
            int len2 = 10;
            Vect.memcpy(this.compressOutBuffer.getWriteAddress(len2), Zip.gzipHeader, len2);
            this.compressOutBuffer.onWrite(len2);
            this.compressedHeaderDone = true;
        }
        if ((nInAvailable = (int)this.buffer.getReadNAvailable()) > 0) {
            long inAddress = this.buffer.getReadAddress();
            LOG.debug().$("Zip.setInput [inAddress=").$(inAddress).$(", nInAvailable=").$(nInAvailable).I$();
            this.buffer.write64BitZeroPadding();
            Zip.setInput(this.zStreamPtr, inAddress, nInAvailable);
        }
        do {
            int sz = (int)this.compressOutBuffer.getWriteNAvailable() - 8;
            p = this.compressOutBuffer.getWriteAddress(0L);
            LOG.debug().$("deflate starting [p=").$(p).$(", sz=").$(sz).$(", chunkedRequestDone=").$(this.chunkedRequestDone).I$();
            ret = Zip.deflate(this.zStreamPtr, p, sz, this.chunkedRequestDone);
            len = sz - Zip.availOut(this.zStreamPtr);
            this.compressOutBuffer.onWrite(len);
            if (ret < 0 && (ret != -5 || len != 0)) {
                throw HttpException.instance("could not deflate [ret=").put(ret);
            }
            int availIn = Zip.availIn(this.zStreamPtr);
            int nInConsumed = nInAvailable - availIn;
            if (nInConsumed > 0) {
                this.crc = Zip.crc32(this.crc, this.buffer.getReadAddress(), nInConsumed);
                this.total += (long)nInConsumed;
                this.buffer.onRead(nInConsumed);
                nInAvailable = availIn;
            }
            LOG.debug().$("deflate finished [ret=").$(ret).$(", len=").$(len).$(", availIn=").$(availIn).I$();
        } while (len == 0 && nInAvailable > 0);
        if (nInAvailable == 0) {
            this.buffer.clearAndPrepareToWriteToBuffer();
        }
        if (len == 0) {
            this.compressedOutputReady = false;
            return;
        }
        this.compressedOutputReady = true;
        if (len < 0) {
            throw ZLibException.INSTANCE;
        }
        boolean bl = finished = this.chunkedRequestDone && ret == 1;
        if (finished) {
            p = this.compressOutBuffer.getWriteAddress(0L);
            Unsafe.getUnsafe().putInt(p, this.crc);
            Unsafe.getUnsafe().putInt(p + 4L, (int)this.total);
            this.compressOutBuffer.onWrite(8);
            this.compressionComplete = true;
        }
        this.compressOutBuffer.prepareToReadFromBuffer(true, finished);
    }

    private void dumpBuffer(long buffer, int size) {
        if (this.dumpNetworkTraffic && size > 0) {
            StdoutSink.INSTANCE.put('<');
            Net.dump(buffer, size);
        }
    }

    private void flushSingle() throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.sendBuffer(this.buffer);
    }

    private long getFd() {
        return this.socket != null ? this.socket.getFd() : -1L;
    }

    private void prepareHeaderSink() {
        this.buffer.prepareToReadFromBuffer(false, false);
        this.headerImpl.prepareToSend();
    }

    private void resetZip() {
        if (this.zStreamPtr != 0L) {
            Zip.deflateReset(this.zStreamPtr);
            this.compressOutBuffer.clear();
            this.crc = 0;
            this.total = 0L;
            this.compressedHeaderDone = false;
            this.compressedOutputReady = false;
            this.compressionComplete = false;
        }
    }

    private void sendBuffer(ChunkUtf8Sink sendBuf) throws PeerDisconnectedException, PeerIsSlowToReadException {
        int available = (int)sendBuf.getReadNAvailable();
        int nSend = Math.min(this.forceSendFragmentationChunkSize, available);
        while (nSend > 0) {
            int n = this.socket.send(sendBuf.getReadAddress(), nSend);
            if (n < 0) {
                LOG.error().$("disconnected [errno=").$(this.nf.errno()).$(", fd=").$(this.socket.getFd()).I$();
                throw PeerDisconnectedException.INSTANCE;
            }
            if (n == 0) {
                throw PeerIsSlowToReadException.INSTANCE;
            }
            if (available <= this.forceSendFragmentationChunkSize) {
                this.dumpBuffer(sendBuf.getReadAddress(), n);
                sendBuf.onRead(n);
                nSend -= n;
                this.totalBytesSent += (long)n;
                continue;
            }
            sendBuf.onRead(n);
            throw PeerIsSlowToReadException.INSTANCE;
        }
        assert (sendBuf.getReadNAvailable() == 0L);
        sendBuf.clearAndPrepareToWriteToBuffer();
    }

    HttpResponseHeader getHeader() {
        return this.headerImpl;
    }

    HttpRawSocket getRawSocket() {
        return this.rawSocket;
    }

    long getTotalBytesSent() {
        return this.totalBytesSent;
    }

    void of(Socket socket, long bufferSize) {
        this.socket = socket;
        if (socket != null) {
            this.buffer.reopen(bufferSize);
        }
    }

    void open(long bufferSize) {
        this.buffer.reopen(bufferSize);
    }

    static {
        httpStatusMap.put(200, new Utf8String("OK"));
        httpStatusMap.put(204, new Utf8String("OK"));
        httpStatusMap.put(206, new Utf8String("Partial content"));
        httpStatusMap.put(301, new Utf8String("Moved Permanently"));
        httpStatusMap.put(302, new Utf8String("Temporarily Moved"));
        httpStatusMap.put(304, new Utf8String("Not Modified"));
        httpStatusMap.put(400, new Utf8String("Bad request"));
        httpStatusMap.put(401, new Utf8String("Unauthorized"));
        httpStatusMap.put(403, new Utf8String("Forbidden"));
        httpStatusMap.put(404, new Utf8String("Not Found"));
        httpStatusMap.put(405, new Utf8String("Method Not Allowed"));
        httpStatusMap.put(409, new Utf8String("Conflict"));
        httpStatusMap.put(408, new Utf8String("Request Timeout"));
        httpStatusMap.put(411, new Utf8String("Length Required"));
        httpStatusMap.put(413, new Utf8String("Content Too Large"));
        httpStatusMap.put(415, new Utf8String("Bad request"));
        httpStatusMap.put(416, new Utf8String("Request range not satisfiable"));
        httpStatusMap.put(431, new Utf8String("Headers too large"));
        httpStatusMap.put(500, new Utf8String("Internal server error"));
    }

    private class ChunkedResponseImpl
    extends ResponseSinkImpl
    implements HttpChunkedResponse {
        private long bookmark;

        private ChunkedResponseImpl() {
            this.bookmark = 0L;
        }

        @Override
        public void bookmark() {
            this.bookmark = HttpResponseSink.this.buffer._wptr;
        }

        @Override
        public void done() throws PeerDisconnectedException, PeerIsSlowToReadException {
            if (!HttpResponseSink.this.chunkedRequestDone) {
                this.sendChunk(true);
            }
        }

        @Override
        public HttpResponseHeader headers() {
            return HttpResponseSink.this.headerImpl;
        }

        @Override
        public boolean resetToBookmark() {
            if (this.bookmark != 0L) {
                HttpResponseSink.this.buffer._wptr = this.bookmark;
                return this.bookmark != HttpResponseSink.this.buffer.bufStartOfData;
            }
            return false;
        }

        @Override
        public void sendChunk(boolean done) throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.headersSent = true;
            HttpResponseSink.this.chunkedRequestDone = done;
            if (HttpResponseSink.this.buffer.getReadNAvailable() > 0L || done) {
                if (!HttpResponseSink.this.deflateBeforeSend) {
                    HttpResponseSink.this.buffer.prepareToReadFromBuffer(true, HttpResponseSink.this.chunkedRequestDone);
                }
                HttpResponseSink.this.resumeSend();
            }
        }

        @Override
        public void sendHeader() throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.chunkedRequestDone = false;
            HttpResponseSink.this.prepareHeaderSink();
            HttpResponseSink.this.flushSingle();
            HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
        }

        @Override
        public void shutdownWrite() {
            HttpResponseSink.this.socket.shutdown(1);
        }

        @Override
        public void status(int status, CharSequence contentType) {
            super.status(status, contentType);
            if (HttpResponseSink.this.deflateBeforeSend) {
                HttpResponseSink.this.headerImpl.putAscii("Content-Encoding: gzip").putEOL();
            }
        }

        @Override
        public int writeBytes(long srcAddr, int len) {
            assert (len > 0);
            len = (int)Math.min((long)len, HttpResponseSink.this.buffer.getWriteNAvailable());
            this.putNonAscii(srcAddr, srcAddr + (long)len);
            return len;
        }
    }

    public class HttpRawSocketImpl
    implements HttpRawSocket {
        @Override
        public long getBufferAddress() {
            return HttpResponseSink.this.buffer.getWriteAddress(1L);
        }

        @Override
        public int getBufferSize() {
            return (int)HttpResponseSink.this.buffer.getWriteNAvailable();
        }

        @Override
        public void send(int size) throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.buffer.onWrite(size);
            HttpResponseSink.this.buffer.prepareToReadFromBuffer(false, false);
            HttpResponseSink.this.flushSingle();
            HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
        }
    }

    public class SimpleResponseImpl {
        private boolean contentSent = false;
        private boolean headerSent = false;

        public void clear() {
            this.contentSent = false;
            this.headerSent = false;
        }

        public void sendStatusJsonContent(int code) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.sendStatusJsonContent(code, null, null, null, null, -1L, true);
        }

        public void sendStatusJsonContent(int code, @Nullable Utf8Sequence message) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.sendStatusJsonContent(code, message, true);
        }

        public void sendStatusJsonContent(int code, @Nullable Utf8Sequence message, boolean appendEOL) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.sendStatusJsonContent(code, message, null, null, null, message != null ? (long)message.size() : -1L, appendEOL);
        }

        public void sendStatusJsonContent(int code, @Nullable Utf8Sequence message, @Nullable CharSequence header, @Nullable CharSequence cookieName, @Nullable CharSequence cookieValue, long contentLength, boolean appendEOL) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.sendStatusWithContent("application/json; charset=utf-8", code, message, header, cookieName, cookieValue, contentLength, appendEOL);
        }

        public void sendStatusNoContent(int code, @Nullable CharSequence header) throws PeerDisconnectedException, PeerIsSlowToReadException {
            if (!this.headerSent) {
                HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
                HttpResponseSink.this.headerImpl.status(HttpResponseSink.this.httpVersion, code, null, -2L);
                if (header != null) {
                    HttpResponseSink.this.headerImpl.put(header).put("\r\n");
                }
                HttpResponseSink.this.prepareHeaderSink();
                this.headerSent = true;
            }
            HttpResponseSink.this.flushSingle();
        }

        public void sendStatusNoContent(int code, @NotNull Utf8Sequence header) throws PeerDisconnectedException, PeerIsSlowToReadException {
            if (!this.headerSent) {
                HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
                HttpResponseSink.this.headerImpl.status(HttpResponseSink.this.httpVersion, code, null, -2L);
                HttpResponseSink.this.headerImpl.put(header).put("\r\n");
                HttpResponseSink.this.prepareHeaderSink();
                this.headerSent = true;
            }
            HttpResponseSink.this.flushSingle();
        }

        public void sendStatusNoContent(int code) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.sendStatusNoContent(code, (CharSequence)null);
        }

        public void sendStatusTextContent(int code, @Nullable Utf8Sequence message, @Nullable CharSequence header, @Nullable CharSequence cookieName, @Nullable CharSequence cookieValue) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.sendStatusWithContent("text/plain; charset=utf-8", code, message, header, cookieName, cookieValue, -1L, true);
        }

        public void sendStatusTextContent(int code, Utf8Sequence message, CharSequence header) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.sendStatusTextContent(code, message, header, null, null);
        }

        public void sendStatusTextContent(int code) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.sendStatusTextContent(code, null, null);
        }

        public void sendStatusTextContent(int code, CharSequence header) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.sendStatusTextContent(code, null, header);
        }

        public void sendStatusWithCookie(int code, Utf8Sequence message, CharSequence cookieName, CharSequence cookieValue) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.sendStatusTextContent(code, message, null, cookieName, cookieValue);
        }

        public void shutdownWrite() {
            HttpResponseSink.this.socket.shutdown(1);
        }

        private void sendStatusWithContent(String contentType, int code, @Nullable Utf8Sequence message, @Nullable CharSequence header, @Nullable CharSequence cookieName, @Nullable CharSequence cookieValue, long contentLength, boolean appendEOL) throws PeerDisconnectedException, PeerIsSlowToReadException {
            if (!this.headerSent) {
                HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
                HttpResponseSink.this.headerImpl.status(HttpResponseSink.this.httpVersion, code, contentType, contentLength);
                if (header != null) {
                    HttpResponseSink.this.headerImpl.put(header).put("\r\n");
                }
                if (cookieName != null) {
                    this.setCookie(cookieName, cookieValue);
                }
                HttpResponseSink.this.prepareHeaderSink();
                this.headerSent = true;
            }
            if (!this.contentSent) {
                HttpResponseSink.this.flushSingle();
                HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
                HttpResponseSink.this.sink.put(message == null ? httpStatusMap.get(code) : message);
                if (appendEOL) {
                    HttpResponseSink.this.sink.putEOL();
                }
                boolean chunked = HttpResponseSink.this.headerImpl.isChunked();
                HttpResponseSink.this.buffer.prepareToReadFromBuffer(chunked, chunked);
                this.contentSent = true;
            }
            HttpResponseSink.this.resumeSend();
        }

        private void setCookie(CharSequence name, CharSequence value) {
            if (HttpResponseSink.this.cookiesEnabled) {
                HttpResponseSink.this.headerImpl.put(HttpConstants.HEADER_SET_COOKIE).putAscii(": ").put(name).putAscii('=').put(!Chars.isBlank(value) ? value : "").putEOL();
            }
        }
    }

    private class ResponseSinkImpl
    implements Utf8Sink {
        private ResponseSinkImpl() {
        }

        @Override
        public Utf8Sink put(@Nullable Utf8Sequence us) {
            HttpResponseSink.this.buffer.put(us);
            return this;
        }

        @Override
        public Utf8Sink put(byte b) {
            HttpResponseSink.this.buffer.put(b);
            return this;
        }

        @Override
        public Utf8Sink put(double value) {
            if (Numbers.isNull(value)) {
                this.putAscii("null");
                return this;
            }
            return (Utf8Sink)Utf8Sink.super.put(value);
        }

        @Override
        public Utf8Sink put(float value) {
            if (Numbers.isNull(value)) {
                this.putAscii("null");
                return this;
            }
            return (Utf8Sink)Utf8Sink.super.put(value);
        }

        @Override
        public Utf8Sink putNonAscii(long lo, long hi) {
            HttpResponseSink.this.buffer.putNonAscii(lo, hi);
            return this;
        }

        public void status(int status, CharSequence contentType) {
            HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
            HttpResponseSink.this.headerImpl.status("HTTP/1.1 ", status, contentType, -1L);
        }
    }

    private class ChunkUtf8Sink
    implements Utf8Sink,
    Closeable,
    Mutable {
        private static final String EOF_CHUNK = "\r\n00\r\n\r\n";
        private static final int MAX_CHUNK_HEADER_SIZE = 12;
        private long _rptr;
        private long _wptr;
        private long bufSize;
        private long bufStart;
        private long bufStartOfData;

        private ChunkUtf8Sink(int bufSize) {
            this.bufSize = bufSize;
        }

        @Override
        public void clear() {
            this._wptr = this._rptr = this.bufStartOfData;
        }

        @Override
        public void close() {
            if (this.bufStart != 0L) {
                Unsafe.free(this.bufStart, this.bufSize + 12L + (long)EOF_CHUNK.length(), 33);
                this._rptr = 0L;
                this._wptr = 0L;
                this.bufStartOfData = 0L;
                this.bufStart = 0L;
            }
        }

        @Override
        public Utf8Sink put(byte b) {
            Unsafe.getUnsafe().putByte(this.getWriteAddress(1L), b);
            this.onWrite(1);
            return this;
        }

        @Override
        public Utf8Sink put(@Nullable Utf8Sequence us) {
            if (us != null) {
                int size = us.size();
                Utf8s.strCpy(us, size, this.getWriteAddress(size));
                this.onWrite(size);
            }
            return this;
        }

        @Override
        public Utf8Sink putNonAscii(long lo, long hi) {
            int size = Bytes.checkedLoHiSize(lo, hi, 0);
            long dest = this.getWriteAddress(size);
            Vect.memcpy(dest, lo, size);
            this.onWrite(size);
            return this;
        }

        public void reopen(long bufSize) {
            if (this.bufStart == 0L) {
                this.bufSize = bufSize;
                this.bufStart = Unsafe.malloc(bufSize + 12L + (long)EOF_CHUNK.length(), 33);
                this.bufStartOfData = this.bufStart + 12L;
                this.clear();
            }
        }

        void clearAndPrepareToWriteToBuffer() {
            this._rptr = this._wptr = this.bufStartOfData;
        }

        long getReadAddress() {
            assert (this._rptr != 0L);
            return this._rptr;
        }

        long getReadNAvailable() {
            return this._wptr - this._rptr;
        }

        long getWriteAddress(long size) {
            assert (this._wptr != 0L);
            if (this.getWriteNAvailable() >= size) {
                return this._wptr;
            }
            throw NoSpaceLeftInResponseBufferException.instance(size);
        }

        long getWriteNAvailable() {
            return this.bufStartOfData + this.bufSize - this._wptr;
        }

        void onRead(int nRead) {
            assert (nRead >= 0 && (long)nRead <= this.getReadNAvailable());
            this._rptr += (long)nRead;
        }

        void onWrite(int nWrite) {
            assert (nWrite >= 0 && (long)nWrite <= this.getWriteNAvailable());
            this._wptr += (long)nWrite;
        }

        void prepareToReadFromBuffer(boolean addChunkHeader, boolean addEofChunk) {
            int len;
            if (addChunkHeader) {
                len = (int)(this._wptr - this.bufStartOfData);
                int padding = len == 0 ? 6 : Integer.numberOfLeadingZeros(len) >> 3 << 1;
                long tmp = this._wptr;
                this._rptr = this._wptr = this.bufStart + (long)padding;
                this.putEOL();
                Numbers.appendHex(this, len);
                this.putEOL();
                this._wptr = tmp;
            }
            if (addEofChunk) {
                len = EOF_CHUNK.length();
                Utf8s.strCpyAscii(EOF_CHUNK, len, this._wptr);
                this._wptr += (long)len;
                LOG.debug().$("end chunk sent [fd=").$(HttpResponseSink.this.getFd()).I$();
            }
        }

        void write64BitZeroPadding() {
            Unsafe.getUnsafe().putLong(this.bufStartOfData - 8L, 0L);
            Unsafe.getUnsafe().putLong(this._wptr, 0L);
        }
    }

    public class HttpResponseHeaderImpl
    implements Utf8Sink,
    HttpResponseHeader,
    Mutable {
        private final MillisecondClock clock;
        private boolean chunked;
        private int code;

        public HttpResponseHeaderImpl(MillisecondClock clock) {
            this.clock = clock;
        }

        @Override
        public void clear() {
            HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
            this.chunked = false;
        }

        public int getCode() {
            return this.code;
        }

        public boolean isChunked() {
            return this.chunked;
        }

        @Override
        public Utf8Sink put(byte b) {
            Unsafe.getUnsafe().putByte(HttpResponseSink.this.buffer.getWriteAddress(1L), b);
            HttpResponseSink.this.buffer.onWrite(1);
            return this;
        }

        @Override
        public Utf8Sink put(@Nullable Utf8Sequence us) {
            if (us != null) {
                int size = us.size();
                Utf8s.strCpy(us, size, HttpResponseSink.this.buffer.getWriteAddress(size));
                HttpResponseSink.this.buffer.onWrite(size);
            }
            return this;
        }

        @Override
        public Utf8Sink putNonAscii(long lo, long hi) {
            HttpResponseSink.this.buffer.putNonAscii(lo, hi);
            return this;
        }

        @Override
        public void send() throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.headerImpl.prepareToSend();
            HttpResponseSink.this.flushSingle();
        }

        @Override
        public void setCookie(CharSequence name, CharSequence value) {
            if (HttpResponseSink.this.cookiesEnabled) {
                this.put(HttpConstants.HEADER_SET_COOKIE).putAscii(": ").put(name).putAscii('=').put(value).putEOL();
            }
        }

        @Override
        public void status(CharSequence httpProtocolVersion, int code, CharSequence contentType, long contentLength) {
            this.code = code;
            Utf8Sequence status = httpStatusMap.get(code);
            if (status == null) {
                throw new IllegalArgumentException("Illegal status code: " + code);
            }
            HttpResponseSink.this.buffer.clearAndPrepareToWriteToBuffer();
            ((Utf8Sink)((Utf8Sink)this.putAscii(httpProtocolVersion).put(code)).put(' ').put(status)).putEOL();
            this.putAscii("Server: ").putAscii("questDB/1.0").putEOL();
            this.putAscii("Date: ");
            DateFormatUtils.formatHTTP(this, this.clock.getTicks());
            this.putEOL();
            if (contentLength > -2L) {
                boolean bl = this.chunked = contentLength == -1L;
                if (this.chunked) {
                    this.putAscii("Transfer-Encoding: chunked").putEOL();
                } else {
                    ((Utf8Sink)this.putAscii("Content-Length: ").put(contentLength)).putEOL();
                }
                this.putAscii("Content-Type: ").put(contentType).putEOL();
            }
            if (HttpResponseSink.this.connectionCloseHeader) {
                this.putAscii("Connection: close").putEOL();
            }
        }

        private void prepareToSend() {
            if (!this.chunked) {
                this.putEOL();
            }
        }
    }
}

