/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.Telemetry;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.security.DenyAllSecurityContext;
import io.questdb.cairo.sql.AtomicBooleanCircuitBreaker;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.griffin.QueryFutureUpdateListener;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.rnd.SharedRandom;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.griffin.engine.window.WindowContextImpl;
import io.questdb.std.IntStack;
import io.questdb.std.Rnd;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.CharSink;
import io.questdb.tasks.TelemetryTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlExecutionContextImpl
implements SqlExecutionContext {
    private final CairoConfiguration cairoConfiguration;
    private final CairoEngine cairoEngine;
    private final int sharedQueryWorkerCount;
    private final AtomicBooleanCircuitBreaker simpleCircuitBreaker;
    private final Telemetry<TelemetryTask> telemetry;
    private final TelemetryFacade telemetryFacade;
    private final IntStack timestampRequiredStack = new IntStack();
    private final WindowContextImpl windowContext = new WindowContextImpl();
    protected BindVariableService bindVariableService;
    protected SecurityContext securityContext;
    private boolean allowNonDeterministicFunction = true;
    private boolean cacheHit;
    private SqlExecutionCircuitBreaker circuitBreaker = SqlExecutionCircuitBreaker.NOOP_CIRCUIT_BREAKER;
    private MicrosecondClock clock;
    private boolean cloneSymbolTables;
    private boolean columnPreTouchEnabled = true;
    private boolean columnPreTouchEnabledOverride = true;
    private boolean containsSecret;
    private int jitMode;
    private long now;
    private final MicrosecondClock nowClock = () -> this.now;
    private boolean parallelFilterEnabled;
    private boolean parallelGroupByEnabled;
    private boolean parallelReadParquetEnabled;
    private boolean parallelTopKEnabled;
    private Rnd random;
    private long requestFd = -1L;
    private boolean useSimpleCircuitBreaker;

    public SqlExecutionContextImpl(CairoEngine cairoEngine, int sharedQueryWorkerCount) {
        assert (sharedQueryWorkerCount >= 0);
        this.sharedQueryWorkerCount = sharedQueryWorkerCount;
        this.cairoEngine = cairoEngine;
        this.cairoConfiguration = cairoEngine.getConfiguration();
        this.clock = this.cairoConfiguration.getMicrosecondClock();
        this.securityContext = DenyAllSecurityContext.INSTANCE;
        this.jitMode = this.cairoConfiguration.getSqlJitMode();
        this.parallelFilterEnabled = this.cairoConfiguration.isSqlParallelFilterEnabled() && sharedQueryWorkerCount > 0;
        this.parallelGroupByEnabled = this.cairoConfiguration.isSqlParallelGroupByEnabled() && sharedQueryWorkerCount > 0;
        this.parallelTopKEnabled = this.cairoConfiguration.isSqlParallelTopKEnabled() && sharedQueryWorkerCount > 0;
        this.parallelReadParquetEnabled = this.cairoConfiguration.isSqlParallelReadParquetEnabled() && sharedQueryWorkerCount > 0;
        this.telemetry = cairoEngine.getTelemetry();
        this.telemetryFacade = this.telemetry.isEnabled() ? this::doStoreTelemetry : this::storeTelemetryNoOp;
        this.containsSecret = false;
        this.useSimpleCircuitBreaker = false;
        this.simpleCircuitBreaker = new AtomicBooleanCircuitBreaker(this.cairoConfiguration.getCircuitBreakerConfiguration().getCircuitBreakerThrottle());
    }

    @Override
    public boolean allowNonDeterministicFunctions() {
        return this.allowNonDeterministicFunction;
    }

    @Override
    public void clearWindowContext() {
        this.windowContext.clear();
    }

    @Override
    public void configureWindowContext(@Nullable VirtualRecord partitionByRecord, @Nullable RecordSink partitionBySink, @Nullable ColumnTypes partitionByKeyTypes, boolean ordered, int orderByDirection, int orderByPos, boolean baseSupportsRandomAccess, int framingMode, long rowsLo, int rowsLoKindPos, long rowsHi, int rowsHiKindPos, int exclusionKind, int exclusionKindPos, int timestampIndex, boolean ignoreNulls, int nullsDescPos) {
        this.windowContext.of(partitionByRecord, partitionBySink, partitionByKeyTypes, ordered, orderByDirection, orderByPos, baseSupportsRandomAccess, framingMode, rowsLo, rowsLoKindPos, rowsHi, rowsHiKindPos, exclusionKind, exclusionKindPos, timestampIndex, ignoreNulls, nullsDescPos);
    }

    @Override
    public boolean containsSecret() {
        return this.containsSecret;
    }

    @Override
    public void containsSecret(boolean containsSecret) {
        this.containsSecret = containsSecret;
    }

    @Override
    public BindVariableService getBindVariableService() {
        return this.bindVariableService;
    }

    @Override
    @NotNull
    public CairoEngine getCairoEngine() {
        return this.cairoEngine;
    }

    @Override
    @NotNull
    public SqlExecutionCircuitBreaker getCircuitBreaker() {
        if (this.useSimpleCircuitBreaker) {
            return this.simpleCircuitBreaker;
        }
        return this.circuitBreaker;
    }

    @Override
    public boolean getCloneSymbolTables() {
        return this.cloneSymbolTables;
    }

    @Override
    public int getJitMode() {
        return this.jitMode;
    }

    @Override
    public long getMicrosecondTimestamp() {
        return this.clock.getTicks();
    }

    @Override
    public long getNow() {
        return this.now;
    }

    @Override
    public QueryFutureUpdateListener getQueryFutureUpdateListener() {
        return QueryFutureUpdateListener.EMPTY;
    }

    @Override
    public Rnd getRandom() {
        return this.random != null ? this.random : SharedRandom.getRandom(this.cairoConfiguration);
    }

    @Override
    public long getRequestFd() {
        return this.requestFd;
    }

    @Override
    @NotNull
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public int getSharedQueryWorkerCount() {
        return this.sharedQueryWorkerCount;
    }

    @Override
    public SqlExecutionCircuitBreaker getSimpleCircuitBreaker() {
        return this.simpleCircuitBreaker;
    }

    @Override
    public WindowContext getWindowContext() {
        return this.windowContext;
    }

    @Override
    public void initNow() {
        this.now = this.clock.getTicks();
    }

    @Override
    public boolean isCacheHit() {
        return this.cacheHit;
    }

    @Override
    public boolean isColumnPreTouchEnabled() {
        return this.columnPreTouchEnabled;
    }

    @Override
    public boolean isColumnPreTouchEnabledOverride() {
        return this.columnPreTouchEnabledOverride;
    }

    @Override
    public boolean isParallelFilterEnabled() {
        return this.parallelFilterEnabled;
    }

    @Override
    public boolean isParallelGroupByEnabled() {
        return this.parallelGroupByEnabled;
    }

    @Override
    public boolean isParallelReadParquetEnabled() {
        return this.parallelReadParquetEnabled;
    }

    @Override
    public boolean isParallelTopKEnabled() {
        return this.parallelTopKEnabled;
    }

    @Override
    public boolean isTimestampRequired() {
        return this.timestampRequiredStack.notEmpty() && this.timestampRequiredStack.peek() == 1;
    }

    @Override
    public boolean isWalApplication() {
        return false;
    }

    @Override
    public void popTimestampRequiredFlag() {
        this.timestampRequiredStack.pop();
    }

    @Override
    public void pushTimestampRequiredFlag(boolean flag) {
        this.timestampRequiredStack.push(flag ? 1 : 0);
    }

    @Override
    public void resetFlags() {
        this.containsSecret = false;
        this.useSimpleCircuitBreaker = false;
        this.cacheHit = false;
        this.columnPreTouchEnabled = true;
        this.columnPreTouchEnabledOverride = true;
        this.allowNonDeterministicFunction = true;
    }

    @Override
    public void setAllowNonDeterministicFunction(boolean value) {
        this.allowNonDeterministicFunction = value;
    }

    @Override
    public void setCacheHit(boolean value) {
        this.cacheHit = value;
    }

    @Override
    public void setCancelledFlag(AtomicBoolean cancelled) {
        this.circuitBreaker.setCancelledFlag(cancelled);
        this.simpleCircuitBreaker.setCancelledFlag(cancelled);
    }

    @Override
    public void setCloneSymbolTables(boolean cloneSymbolTables) {
        this.cloneSymbolTables = cloneSymbolTables;
    }

    @Override
    public void setColumnPreTouchEnabled(boolean columnPreTouchEnabled) {
        this.columnPreTouchEnabled = columnPreTouchEnabled;
    }

    @Override
    public void setColumnPreTouchEnabledOverride(boolean columnPreTouchEnabledOverride) {
        this.columnPreTouchEnabledOverride = columnPreTouchEnabledOverride;
    }

    @Override
    public void setJitMode(int jitMode) {
        this.jitMode = jitMode;
    }

    @Override
    public void setNowAndFixClock(long now) {
        this.now = now;
        this.clock = this.nowClock;
    }

    @Override
    public void setParallelFilterEnabled(boolean parallelFilterEnabled) {
        this.parallelFilterEnabled = parallelFilterEnabled;
    }

    @Override
    public void setParallelGroupByEnabled(boolean parallelGroupByEnabled) {
        this.parallelGroupByEnabled = parallelGroupByEnabled;
    }

    @Override
    public void setParallelReadParquetEnabled(boolean parallelReadParquetEnabled) {
        this.parallelReadParquetEnabled = parallelReadParquetEnabled;
    }

    @Override
    public void setParallelTopKEnabled(boolean parallelTopKEnabled) {
        this.parallelTopKEnabled = parallelTopKEnabled;
    }

    @Override
    public void setRandom(Rnd rnd) {
        this.random = rnd;
    }

    @Override
    public void setUseSimpleCircuitBreaker(boolean value) {
        this.useSimpleCircuitBreaker = value;
    }

    @Override
    public void storeTelemetry(short event, short origin) {
        this.telemetryFacade.store(event, origin);
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii("principal=").put(this.securityContext.getPrincipal()).putAscii(", cache=").put(this.isCacheHit());
    }

    public SqlExecutionContextImpl with(@NotNull SecurityContext securityContext, @Nullable BindVariableService bindVariableService, @Nullable Rnd rnd) {
        this.securityContext = securityContext;
        this.bindVariableService = bindVariableService;
        this.random = rnd;
        this.resetFlags();
        return this;
    }

    public void with(long requestFd) {
        this.requestFd = requestFd;
        this.resetFlags();
    }

    public void with(BindVariableService bindVariableService) {
        this.bindVariableService = bindVariableService;
    }

    public void with(SqlExecutionCircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public SqlExecutionContextImpl with(@NotNull SecurityContext securityContext) {
        return this.with(securityContext, null, null, -1L, null);
    }

    public SqlExecutionContextImpl with(@NotNull SecurityContext securityContext, @Nullable BindVariableService bindVariableService) {
        return this.with(securityContext, bindVariableService, null, -1L, null);
    }

    public SqlExecutionContextImpl with(@NotNull SecurityContext securityContext, @Nullable BindVariableService bindVariableService, @Nullable Rnd rnd, long requestFd, @Nullable SqlExecutionCircuitBreaker circuitBreaker) {
        this.securityContext = securityContext;
        this.bindVariableService = bindVariableService;
        this.random = rnd;
        this.requestFd = requestFd;
        this.circuitBreaker = circuitBreaker == null ? SqlExecutionCircuitBreaker.NOOP_CIRCUIT_BREAKER : circuitBreaker;
        this.resetFlags();
        return this;
    }

    private void doStoreTelemetry(short event, short origin) {
        TelemetryTask.store(this.telemetry, origin, event);
    }

    private void storeTelemetryNoOp(short event, short origin) {
    }

    @FunctionalInterface
    private static interface TelemetryFacade {
        public void store(short var1, short var2);
    }
}

