/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.pool.ex.EntryLockedException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.EmptyRecordMetadata;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.OperatorRegistry;
import io.questdb.griffin.PostOrderTreeTraversalAlgo;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.SqlParserCallback;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.catalogue.AllTablesFunctionFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowDateStyleCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowMaxIdentifierLengthCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowParametersCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowSearchPathCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowServerVersionCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowServerVersionNumCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowStandardConformingStringsCursorFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowTimeZoneFactory;
import io.questdb.griffin.engine.functions.catalogue.ShowTransactionIsolationLevelCursorFactory;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.griffin.engine.table.ShowColumnsRecordCursorFactory;
import io.questdb.griffin.engine.table.ShowPartitionsRecordCursorFactory;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.JoinContext;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.griffin.model.WindowColumn;
import io.questdb.std.BoolList;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.IntSortedList;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.str.FlyweightCharSequence;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlOptimiser
implements Mutable {
    public static final int REWRITE_STATUS_FORCE_INNER_MODEL = 64;
    public static final int REWRITE_STATUS_OUTER_VIRTUAL_IS_SELECT_CHOOSE = 32;
    public static final int REWRITE_STATUS_USE_DISTINCT_MODEL = 16;
    public static final int REWRITE_STATUS_USE_GROUP_BY_MODEL = 4;
    public static final int REWRITE_STATUS_USE_INNER_MODEL = 1;
    public static final int REWRITE_STATUS_USE_OUTER_MODEL = 8;
    public static final int REWRITE_STATUS_USE_WINDOW_MODEL = 2;
    private static final int JOIN_OP_AND = 2;
    private static final int JOIN_OP_EQUAL = 1;
    private static final int JOIN_OP_OR = 3;
    private static final int JOIN_OP_REGEX = 4;
    private static final String LONG_MAX_VALUE_STR = "9223372036854775807";
    private static final int NOT_OP_AND = 2;
    private static final int NOT_OP_EQUAL = 8;
    private static final int NOT_OP_GREATER = 4;
    private static final int NOT_OP_GREATER_EQ = 5;
    private static final int NOT_OP_LESS = 6;
    private static final int NOT_OP_LESS_EQ = 7;
    private static final int NOT_OP_NOT = 1;
    private static final int NOT_OP_NOT_EQ = 9;
    private static final int NOT_OP_OR = 3;
    private static final int SAMPLE_BY_REWRITE_NO_WRAP = 0;
    private static final int SAMPLE_BY_REWRITE_WRAP_ADD_TIMESTAMP_COPIES = 2;
    private static final int SAMPLE_BY_REWRITE_WRAP_CONVERT_TIME_ZONE = 4;
    private static final int SAMPLE_BY_REWRITE_WRAP_REMOVE_TIMESTAMP = 1;
    private static final IntHashSet flexColumnModelTypes = new IntHashSet();
    private static final IntHashSet joinBarriers;
    private static final CharSequenceIntHashMap joinOps;
    private static final boolean[] joinsRequiringTimestamp;
    private static final IntHashSet limitTypes;
    private static final CharSequenceIntHashMap notOps;
    private static final CharSequenceHashSet nullConstants;
    protected final ObjList<CharSequence> literalCollectorANames = new ObjList();
    private final CharacterStore characterStore;
    private final IntList clausesToSteal = new IntList();
    private final ColumnPrefixEraser columnPrefixEraser = new ColumnPrefixEraser();
    private final CairoConfiguration configuration;
    private final CharSequenceIntHashMap constNameToIndex = new CharSequenceIntHashMap();
    private final CharSequenceObjHashMap<ExpressionNode> constNameToNode = new CharSequenceObjHashMap();
    private final CharSequenceObjHashMap<CharSequence> constNameToToken = new CharSequenceObjHashMap();
    private final ObjectPool<JoinContext> contextPool;
    private final IntHashSet deletedContexts = new IntHashSet();
    private final CharSequenceHashSet existsDependedTokens = new CharSequenceHashSet();
    private final ObjectPool<ExpressionNode> expressionNodePool;
    private final FunctionParser functionParser;
    private final ObjList<CharSequence> groupByAliases = new ObjList();
    private final ObjList<ExpressionNode> groupByNodes = new ObjList();
    private final BoolList groupByUsed = new BoolList();
    private final ObjectPool<IntHashSet> intHashSetPool = new ObjectPool<IntHashSet>(IntHashSet::new, 16);
    private final ObjList<JoinContext> joinClausesSwap1 = new ObjList();
    private final ObjList<JoinContext> joinClausesSwap2 = new ObjList();
    private final LiteralCheckingVisitor literalCheckingVisitor = new LiteralCheckingVisitor();
    private final LiteralCollector literalCollector = new LiteralCollector();
    private final IntHashSet literalCollectorAIndexes = new IntHashSet();
    private final IntHashSet literalCollectorBIndexes = new IntHashSet();
    private final ObjList<CharSequence> literalCollectorBNames = new ObjList();
    private final LiteralRewritingVisitor literalRewritingVisitor = new LiteralRewritingVisitor();
    private final int maxRecursion;
    private final CharSequenceHashSet missingDependedTokens = new CharSequenceHashSet();
    private final AtomicInteger nonAggSelectCount = new AtomicInteger(0);
    private final ObjList<ExpressionNode> orderByAdvice = new ObjList();
    private final IntSortedList orderingStack = new IntSortedList();
    private final Path path;
    private final IntHashSet postFilterRemoved = new IntHashSet();
    private final ObjList<IntHashSet> postFilterTableRefs = new ObjList();
    private final ObjectPool<QueryColumn> queryColumnPool;
    private final ObjectPool<QueryModel> queryModelPool;
    private final ArrayDeque<ExpressionNode> sqlNodeStack = new ArrayDeque();
    private final ObjList<RecordCursorFactory> tableFactoriesInFlight = new ObjList();
    private final FlyweightCharSequence tableLookupSequence = new FlyweightCharSequence();
    private final IntHashSet tablesSoFar = new IntHashSet();
    private final ObjList<QueryColumn> tempColumns = new ObjList();
    private final IntList tempCrossIndexes = new IntList();
    private final IntList tempCrosses = new IntList();
    private final IntList tempList = new IntList();
    private final LowerCaseCharSequenceObjHashMap<QueryColumn> tmpCursorAliases = new LowerCaseCharSequenceObjHashMap();
    private final PostOrderTreeTraversalAlgo traversalAlgo;
    private int defaultAliasCount = 0;
    private ObjList<JoinContext> emittedJoinClauses;
    private OperatorExpression opAnd;
    private OperatorExpression opGeq;
    private OperatorExpression opLt;
    private CharSequence tempColumnAlias;
    private QueryModel tempQueryModel;

    public SqlOptimiser(CairoConfiguration configuration, CharacterStore characterStore, ObjectPool<ExpressionNode> expressionNodePool, ObjectPool<QueryColumn> queryColumnPool, ObjectPool<QueryModel> queryModelPool, PostOrderTreeTraversalAlgo traversalAlgo, FunctionParser functionParser, Path path) {
        this.configuration = configuration;
        this.expressionNodePool = expressionNodePool;
        this.characterStore = characterStore;
        this.traversalAlgo = traversalAlgo;
        this.queryModelPool = queryModelPool;
        this.queryColumnPool = queryColumnPool;
        this.functionParser = functionParser;
        this.contextPool = new ObjectPool<JoinContext>(JoinContext.FACTORY, configuration.getSqlJoinContextPoolCapacity());
        this.path = path;
        this.maxRecursion = configuration.getSqlWindowMaxRecursion();
        this.initialiseOperatorExpressions();
    }

    public static boolean aliasAppearsInFuncArgs(QueryModel model, CharSequence alias, ArrayDeque<ExpressionNode> sqlNodeStack) {
        if (model == null) {
            return false;
        }
        boolean appearsInArgs = false;
        ObjList<QueryColumn> modelColumns = model.getColumns();
        int n = modelColumns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn col = modelColumns.get(i);
            switch (col.getAst().type) {
                case 6: 
                case 9: {
                    appearsInArgs |= SqlOptimiser.searchExpressionNodeForAlias(col.getAst(), alias, sqlNodeStack);
                }
            }
        }
        return appearsInArgs;
    }

    @Override
    public void clear() {
        this.clearForUnionModelInJoin();
        this.contextPool.clear();
        this.intHashSetPool.clear();
        this.joinClausesSwap1.clear();
        this.joinClausesSwap2.clear();
        this.literalCollectorAIndexes.clear();
        this.literalCollectorBIndexes.clear();
        this.literalCollectorANames.clear();
        this.literalCollectorBNames.clear();
        this.defaultAliasCount = 0;
        this.expressionNodePool.clear();
        this.characterStore.clear();
        this.tablesSoFar.clear();
        this.clausesToSteal.clear();
        this.tmpCursorAliases.clear();
        this.tableFactoriesInFlight.clear();
        this.groupByAliases.clear();
        this.groupByNodes.clear();
        this.groupByUsed.clear();
        this.tempColumnAlias = null;
        this.tempQueryModel = null;
    }

    public void clearForUnionModelInJoin() {
        this.constNameToIndex.clear();
        this.constNameToNode.clear();
        this.constNameToToken.clear();
    }

    public FunctionFactoryCache getFunctionFactoryCache() {
        return this.functionParser.getFunctionFactoryCache();
    }

    public boolean hasAggregates(ExpressionNode node) {
        this.sqlNodeStack.clear();
        block4: while (!this.sqlNodeStack.isEmpty() || node != null) {
            if (node != null) {
                switch (node.type) {
                    case 7: {
                        node = null;
                        continue block4;
                    }
                    case 6: {
                        if (!this.functionParser.getFunctionFactoryCache().isGroupBy(node.token)) break;
                        return true;
                    }
                    default: {
                        int n = node.args.size();
                        for (int i = 0; i < n; ++i) {
                            this.sqlNodeStack.add(node.args.getQuick(i));
                        }
                        if (node.rhs == null) break;
                        this.sqlNodeStack.push(node.rhs);
                    }
                }
                node = node.lhs;
                continue;
            }
            node = this.sqlNodeStack.poll();
        }
        return false;
    }

    private static boolean isOrderedByDesignatedTimestamp(QueryModel model) {
        return model.getTimestamp() != null && model.getOrderBy().size() == 1 && Chars.equals(model.getOrderBy().getQuick((int)0).token, model.getTimestamp().token);
    }

    private static boolean isSymbolColumn(ExpressionNode countDistinctExpr, QueryModel nested) {
        return countDistinctExpr.rhs.type == 7 && nested.getAliasToColumnMap().get(countDistinctExpr.rhs.token) != null && nested.getAliasToColumnMap().get(countDistinctExpr.rhs.token).getColumnType() == 12;
    }

    private static void linkDependencies(QueryModel model, int parent, int child) {
        model.getJoinModels().getQuick(parent).addDependency(child);
    }

    private static boolean modelIsFlex(QueryModel model) {
        return model != null && flexColumnModelTypes.contains(model.getSelectModelType());
    }

    private static void pushDownLimitAdvice(QueryModel model, QueryModel nestedModel, boolean useDistinctModel) {
        if ((nestedModel.getOrderBy().size() == 0 || SqlOptimiser.isOrderedByDesignatedTimestamp(nestedModel)) && !useDistinctModel) {
            nestedModel.setLimitAdvice(model.getLimitLo(), model.getLimitHi());
        }
    }

    private static boolean searchExpressionNodeForAlias(ExpressionNode node, CharSequence alias, ArrayDeque<ExpressionNode> sqlNodeStack) {
        sqlNodeStack.clear();
        while (!sqlNodeStack.isEmpty() || node != null) {
            if (node != null) {
                if (Chars.equalsIgnoreCase(node.token, alias)) {
                    return true;
                }
                int n = node.args.size();
                for (int i = 0; i < n; ++i) {
                    sqlNodeStack.add(node.args.getQuick(i));
                }
                if (node.rhs != null) {
                    sqlNodeStack.push(node.rhs);
                }
                node = node.lhs;
                continue;
            }
            node = sqlNodeStack.poll();
        }
        return false;
    }

    private static void unlinkDependencies(QueryModel model, int parent, int child) {
        model.getJoinModels().getQuick(parent).removeDependency(child);
    }

    private void addColumnToSelectModel(QueryModel model, IntList insertColumnIndexes, ObjList<QueryColumn> insertColumnAliases, CharSequence timestampAlias) {
        this.tempColumns.clear();
        this.tempColumns.addAll(model.getBottomUpColumns());
        model.clearColumnMapStructs();
        int src1ColumnCount = this.tempColumns.size();
        int src2ColumnCount = insertColumnIndexes.size();
        int i = 0;
        int k = 0;
        int m = 0;
        while (i < src1ColumnCount || k < src2ColumnCount) {
            if (k < src2ColumnCount && insertColumnIndexes.getQuick(k) == m) {
                QueryColumn column = insertColumnAliases.get(k);
                if (column.getAst().type == 7) {
                    model.addBottomUpColumnIfNotExists(this.nextColumn(column.getAlias(), timestampAlias));
                } else {
                    model.addBottomUpColumnIfNotExists(column);
                }
                ++k;
            } else {
                QueryColumn qcFrom = this.tempColumns.getQuick(i);
                model.addBottomUpColumnIfNotExists(this.nextColumn(qcFrom.getAlias()));
                ++i;
            }
            ++m;
        }
    }

    private void addColumnToTranslatingModel(QueryColumn column, QueryModel translatingModel, QueryModel innerVirtualModel, QueryModel baseModel) throws SqlException {
        if (baseModel != null) {
            CharSequence refColumn = column.getAst().token;
            int dot = Chars.indexOfLastUnquoted(refColumn, '.');
            this.validateColumnAndGetModelIndex(baseModel, innerVirtualModel, refColumn, dot, column.getAst().position, false);
            if (dot != -1 && baseModel.getJoinModels().size() == 1) {
                ExpressionNode base = column.getAst();
                column.of(column.getAlias(), this.expressionNodePool.next().of(base.type, base.token.subSequence(dot + 1, base.token.length()), base.precedence, base.position));
            }
        }
        translatingModel.addBottomUpColumn(column);
    }

    private QueryColumn addCursorFunctionAsCrossJoin(ExpressionNode node, @Nullable CharSequence alias, QueryModel cursorModel, @Nullable QueryModel innerVirtualModel, QueryModel translatingModel, QueryModel baseModel, SqlExecutionContext sqlExecutionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        QueryColumn qc = cursorModel.findBottomUpColumnByAst(node);
        if (qc == null) {
            CharSequence baseAlias = alias != null ? this.createColumnAlias(alias, baseModel) : this.createColumnAlias(node, baseModel);
            baseAlias = SqlUtil.createColumnAlias(this.characterStore, baseAlias, -1, this.tmpCursorAliases);
            QueryColumn crossColumn = this.queryColumnPool.next().of(baseAlias, node);
            QueryModel cross = this.queryModelPool.next();
            cross.setJoinType(3);
            cross.setSelectModelType(6);
            cross.setAlias(this.makeJoinAlias());
            QueryModel crossInner = this.queryModelPool.next();
            crossInner.setTableNameExpr(node);
            this.parseFunctionAndEnumerateColumns(crossInner, sqlExecutionContext, sqlParserCallback);
            cross.setNestedModel(crossInner);
            cross.addBottomUpColumn(crossColumn);
            baseModel.addJoinModel(cross);
            this.tmpCursorAliases.put(baseAlias, crossColumn);
            CharSequence translatingAlias = this.createColumnAlias(baseAlias, translatingModel);
            cursorModel.addBottomUpColumn(this.queryColumnPool.next().of(baseAlias, node));
            qc = this.queryColumnPool.next().of(translatingAlias, this.nextLiteral(baseAlias));
            translatingModel.addBottomUpColumn(qc);
        } else {
            CharSequence al = translatingModel.getColumnNameToAliasMap().get(qc.getAlias());
            if (alias != null && !Chars.equalsIgnoreCase(al, alias)) {
                QueryColumn existing = translatingModel.getAliasToColumnMap().get(alias);
                if (existing == null) {
                    qc = this.nextColumn(alias, al);
                    translatingModel.addBottomUpColumn(qc);
                    if (innerVirtualModel != null) {
                        innerVirtualModel.addBottomUpColumn(qc);
                    }
                    return qc;
                }
                if (ExpressionNode.compareNodesExact(node, existing.getAst())) {
                    return existing;
                }
                throw SqlException.invalidColumn(node.position, "duplicate alias");
            }
            qc = translatingModel.getAliasToColumnMap().get(al);
        }
        if (innerVirtualModel != null) {
            innerVirtualModel.addBottomUpColumn(qc);
        }
        return qc;
    }

    private void addFilterOrEmitJoin(QueryModel parent, int idx, int ai, CharSequence an, ExpressionNode ao, int bi, CharSequence bn, ExpressionNode bo) {
        if (ai == bi && Chars.equals(an, bn)) {
            this.deletedContexts.add(idx);
            return;
        }
        if (ai == bi) {
            OperatorExpression eqOp = OperatorExpression.chooseRegistry(this.configuration.getCairoSqlLegacyOperatorPrecedence()).getOperatorDefinition("=");
            ExpressionNode node = this.expressionNodePool.next().of(9, eqOp.operator.token, eqOp.precedence, 0);
            node.paramCount = 2;
            node.lhs = ao;
            node.rhs = bo;
            this.addWhereNode(parent, ai, node);
        } else {
            JoinContext jc = this.contextPool.next();
            jc.aIndexes.add(ai);
            jc.aNames.add(an);
            jc.aNodes.add(ao);
            jc.bIndexes.add(bi);
            jc.bNames.add(bn);
            jc.bNodes.add(bo);
            jc.slaveIndex = Math.max(ai, bi);
            jc.parents.add(Math.min(ai, bi));
            this.emittedJoinClauses.add(jc);
        }
        this.deletedContexts.add(idx);
    }

    private void addFunction(QueryColumn qc, QueryModel baseModel, QueryModel translatingModel, QueryModel innerVirtualModel, QueryModel windowModel, QueryModel groupByModel, QueryModel outerVirtualModel, QueryModel distinctModel) throws SqlException {
        QueryColumn virtualColumn = this.ensureAliasUniqueness(innerVirtualModel, qc);
        innerVirtualModel.addBottomUpColumn(virtualColumn);
        QueryColumn innerColumn = this.nextColumn(qc.getAlias(), virtualColumn.getAlias());
        this.emitLiterals(qc.getAst(), translatingModel, innerVirtualModel, false, baseModel, false);
        groupByModel.addBottomUpColumn(innerColumn);
        windowModel.addBottomUpColumn(innerColumn);
        outerVirtualModel.addBottomUpColumn(innerColumn);
        distinctModel.addBottomUpColumn(innerColumn);
    }

    private void addJoinContext(QueryModel parent, JoinContext context) {
        QueryModel jm = parent.getJoinModels().getQuick(context.slaveIndex);
        JoinContext other = jm.getContext();
        if (other == null || other.slaveIndex == -1) {
            jm.setContext(context);
        } else {
            jm.setContext(this.mergeContexts(parent, other, context));
        }
    }

    private void addMissingTablePrefixesForGroupByQueries(ExpressionNode node, QueryModel baseModel, QueryModel innerVirtualModel) throws SqlException {
        this.sqlNodeStack.clear();
        ExpressionNode temp = this.addMissingTablePrefixesForGroupByQueries0(node, baseModel, innerVirtualModel);
        if (temp != node) {
            node.of(7, temp.token, node.precedence, node.position);
            return;
        }
        while (!this.sqlNodeStack.isEmpty() || node != null) {
            if (node != null) {
                if (node.paramCount < 3) {
                    if (node.rhs != null) {
                        temp = this.addMissingTablePrefixesForGroupByQueries0(node.rhs, baseModel, innerVirtualModel);
                        if (node.rhs == temp) {
                            this.sqlNodeStack.push(node.rhs);
                        } else {
                            node.rhs = temp;
                        }
                    }
                    if (node.lhs != null) {
                        temp = this.addMissingTablePrefixesForGroupByQueries0(node.lhs, baseModel, innerVirtualModel);
                        if (temp == node.lhs) {
                            node = node.lhs;
                            continue;
                        }
                        node.lhs = temp;
                        node = null;
                        continue;
                    }
                    node = null;
                    continue;
                }
                int k = node.paramCount;
                for (int i = 1; i < k; ++i) {
                    ExpressionNode e = node.args.getQuick(i);
                    if (e == (temp = this.addMissingTablePrefixesForGroupByQueries0(e, baseModel, innerVirtualModel))) {
                        this.sqlNodeStack.push(e);
                        continue;
                    }
                    node.args.setQuick(i, temp);
                }
                ExpressionNode e = node.args.getQuick(0);
                if (e == (temp = this.addMissingTablePrefixesForGroupByQueries0(e, baseModel, innerVirtualModel))) {
                    node = e;
                    continue;
                }
                node.args.setQuick(0, temp);
                node = null;
                continue;
            }
            node = this.sqlNodeStack.poll();
        }
    }

    private ExpressionNode addMissingTablePrefixesForGroupByQueries0(ExpressionNode node, QueryModel baseModel, QueryModel innerVirtualModel) throws SqlException {
        if (node != null && node.type == 7) {
            boolean removeAlias;
            CharSequence col = node.token;
            int dot = Chars.indexOfLastUnquoted(col, '.');
            int modelIndex = this.validateColumnAndGetModelIndex(baseModel, innerVirtualModel, col, dot, node.position, true);
            boolean addAlias = dot == -1 && baseModel.getJoinModels().size() > 1;
            boolean bl = removeAlias = dot > -1 && baseModel.getJoinModels().size() == 1;
            if (addAlias || removeAlias) {
                CharacterStoreEntry entry = this.characterStore.newEntry();
                if (addAlias) {
                    CharSequence alias = (CharSequence)baseModel.getModelAliasIndexes().keys().get(modelIndex);
                    ((Utf16Sink)((Utf16Sink)entry.put(alias)).put('.')).put(col);
                } else {
                    entry.put(col, dot + 1, col.length());
                }
                CharSequence prefixedCol = entry.toImmutable();
                return this.expressionNodePool.next().of(7, prefixedCol, node.precedence, node.position);
            }
        }
        return node;
    }

    private void addOuterJoinExpression(QueryModel parent, QueryModel model, int joinIndex, ExpressionNode node) {
        model.setOuterJoinExpressionClause(this.concatFilters(model.getOuterJoinExpressionClause(), node));
        if (joinIndex > 0) {
            SqlOptimiser.linkDependencies(parent, joinIndex - 1, joinIndex);
        }
    }

    private void addPostJoinWhereClause(QueryModel model, ExpressionNode node) {
        model.setPostJoinWhereClause(this.concatFilters(model.getPostJoinWhereClause(), node));
    }

    private void addTimestampToProjection(CharSequence columnName, ExpressionNode columnAst, QueryModel baseModel, QueryModel translatingModel, QueryModel innerVirtualModel, QueryModel windowModel) throws SqlException {
        LowerCaseCharSequenceObjHashMap<CharSequence> translatingAliasMap = translatingModel.getColumnNameToAliasMap();
        int index = translatingAliasMap.keyIndex(columnAst.token);
        if (index < 0) {
            CharSequence translatedColumnName = translatingAliasMap.valueAtQuick(index);
            CharSequence innerAlias = this.createColumnAlias(columnName, innerVirtualModel);
            QueryColumn translatedColumn = this.nextColumn(innerAlias, translatedColumnName);
            innerVirtualModel.addBottomUpColumn(translatedColumn);
            CharSequence windowAlias = this.createColumnAlias(innerAlias, windowModel);
            QueryColumn windowColumn = this.nextColumn(windowAlias, innerAlias);
            windowModel.addBottomUpColumn(windowColumn);
        } else {
            CharSequence alias = this.createColumnAlias(columnName, translatingModel);
            this.addColumnToTranslatingModel(this.queryColumnPool.next().of(alias, columnAst), translatingModel, innerVirtualModel, baseModel);
            QueryColumn translatedColumn = this.nextColumn(alias);
            innerVirtualModel.addBottomUpColumn(translatedColumn);
            windowModel.addBottomUpColumn(translatedColumn);
        }
    }

    private void addTopDownColumn(ExpressionNode node, QueryModel model) {
        if (node != null && node.type == 7) {
            CharSequence columnName = node.token;
            int dotIndex = Chars.indexOfLastUnquoted(columnName, '.');
            if (dotIndex == -1) {
                this.addTopDownColumn(columnName, model);
            } else {
                int modelIndex = model.getModelAliasIndex(node.token, 0, dotIndex);
                if (modelIndex < 0) {
                    return;
                }
                this.addTopDownColumn0(node, model.getJoinModels().getQuick(modelIndex), node.token.subSequence(dotIndex + 1, node.token.length()));
            }
        }
    }

    private void addTopDownColumn(CharSequence columnName, QueryModel model) {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int joinCount = joinModels.size();
        for (int i = 0; i < joinCount; ++i) {
            QueryModel m = joinModels.getQuick(i);
            QueryColumn column = m.getAliasToColumnMap().get(columnName);
            if (column == null) continue;
            if (m.getSelectModelType() == 0) {
                m.addTopDownColumn(this.queryColumnPool.next().of(columnName, this.nextLiteral(columnName)), columnName);
                break;
            }
            m.addTopDownColumn(column, columnName);
            break;
        }
    }

    private void addTopDownColumn0(ExpressionNode node, QueryModel model, CharSequence name) {
        if (model.isTopDownNameMissing(name)) {
            model.addTopDownColumn(this.queryColumnPool.next().of(name, this.expressionNodePool.next().of(node.type, name, node.precedence, node.position)), name);
        }
    }

    private void addTransitiveFilters(QueryModel model) {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 0; i < n; ++i) {
            JoinContext jc = joinModels.getQuick(i).getContext();
            if (jc == null) continue;
            int kn = jc.bNames.size();
            for (int k = 0; k < kn; ++k) {
                CharSequence name = jc.bNames.getQuick(k);
                if (this.constNameToIndex.get(name) != jc.bIndexes.getQuick(k)) continue;
                OperatorExpression op = OperatorExpression.chooseRegistry(this.configuration.getCairoSqlLegacyOperatorPrecedence()).getOperatorDefinition(this.constNameToToken.get(name));
                ExpressionNode node = this.expressionNodePool.next().of(9, op.operator.token, op.precedence, 0);
                node.lhs = jc.aNodes.getQuick(k);
                node.rhs = this.constNameToNode.get(name);
                node.paramCount = 2;
                this.addWhereNode(model, jc.slaveIndex, node);
            }
        }
    }

    private void addWhereNode(QueryModel model, int joinModelIndex, ExpressionNode node) {
        this.addWhereNode(model.getJoinModels().getQuick(joinModelIndex), node);
    }

    private void addWhereNode(QueryModel model, ExpressionNode node) {
        model.setWhereClause(this.concatFilters(model.getWhereClause(), node));
    }

    private void alignJoinClauses(QueryModel parent) {
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        int n = joinModels.size();
        for (int i = 0; i < n; ++i) {
            JoinContext jc = joinModels.getQuick(i).getContext();
            if (jc == null) continue;
            int index = jc.slaveIndex;
            int kc = jc.aIndexes.size();
            for (int k = 0; k < kc; ++k) {
                if (jc.aIndexes.getQuick(k) == index) continue;
                int idx = jc.aIndexes.getQuick(k);
                CharSequence name = jc.aNames.getQuick(k);
                ExpressionNode node = jc.aNodes.getQuick(k);
                jc.aIndexes.setQuick(k, jc.bIndexes.getQuick(k));
                jc.aNames.setQuick(k, jc.bNames.getQuick(k));
                jc.aNodes.setQuick(k, jc.bNodes.getQuick(k));
                jc.bIndexes.setQuick(k, idx);
                jc.bNames.setQuick(k, name);
                jc.bNodes.setQuick(k, node);
            }
        }
    }

    private boolean allAdviceIsForThisTable(QueryModel model, ObjList<ExpressionNode> orderByAdvice) {
        LowerCaseCharSequenceObjHashMap<QueryColumn> columnMap = model.getAliasToColumnMap();
        int n = orderByAdvice.size();
        for (int i = 0; i < n; ++i) {
            CharSequence alias = orderByAdvice.getQuick((int)i).token;
            if (columnMap.contains(alias)) continue;
            return false;
        }
        return true;
    }

    private void analyseEquals(QueryModel parent, ExpressionNode node, boolean innerPredicate, QueryModel joinModel) throws SqlException {
        this.traverseNamesAndIndices(parent, node);
        int aSize = this.literalCollectorAIndexes.size();
        int bSize = this.literalCollectorBIndexes.size();
        boolean canMovePredicate = joinBarriers.excludes(joinModel.getJoinType());
        int joinIndex = parent.getJoinModels().indexOfRef(joinModel);
        if (this.literalCollector.functionCount > 0) {
            node.innerPredicate = innerPredicate;
            if (canMovePredicate) {
                parent.addParsedWhereNode(node, innerPredicate);
            } else {
                this.addOuterJoinExpression(parent, joinModel, joinIndex, node);
            }
            return;
        }
        switch (aSize) {
            case 0: {
                if (!canMovePredicate) {
                    this.addOuterJoinExpression(parent, joinModel, joinIndex, node);
                    break;
                }
                if (bSize == 1 && this.literalCollector.nullCount == 0 && joinBarriers.excludes(parent.getJoinModels().get(this.literalCollectorBIndexes.get(0)).getJoinType())) {
                    JoinContext jc = this.contextPool.next();
                    jc.slaveIndex = this.literalCollectorBIndexes.get(0);
                    this.addWhereNode(parent, jc.slaveIndex, node);
                    this.addJoinContext(parent, jc);
                    CharSequence cs = this.literalCollectorBNames.getQuick(0);
                    this.constNameToIndex.put(cs, jc.slaveIndex);
                    this.constNameToNode.put(cs, node.lhs);
                    this.constNameToToken.put(cs, node.token);
                    break;
                }
                parent.addParsedWhereNode(node, innerPredicate);
                break;
            }
            case 1: {
                JoinContext jc = this.contextPool.next();
                int lhi = this.literalCollectorAIndexes.get(0);
                if (bSize == 1) {
                    int rhi = this.literalCollectorBIndexes.get(0);
                    if (lhi == rhi) {
                        jc.slaveIndex = lhi;
                        if (canMovePredicate) {
                            if (jc.slaveIndex != joinIndex && joinBarriers.contains(parent.getJoinModels().get(jc.slaveIndex).getJoinType())) {
                                this.addPostJoinWhereClause(parent.getJoinModels().getQuick(jc.slaveIndex), node);
                            } else {
                                this.addWhereNode(parent, lhi, node);
                            }
                            return;
                        }
                    } else if (lhi < rhi) {
                        jc.aNodes.add(node.lhs);
                        jc.bNodes.add(node.rhs);
                        jc.aNames.add(this.literalCollectorANames.getQuick(0));
                        jc.bNames.add(this.literalCollectorBNames.getQuick(0));
                        jc.aIndexes.add(lhi);
                        jc.bIndexes.add(rhi);
                        jc.slaveIndex = rhi;
                        jc.parents.add(lhi);
                    } else {
                        jc.aNodes.add(node.rhs);
                        jc.bNodes.add(node.lhs);
                        jc.aNames.add(this.literalCollectorBNames.getQuick(0));
                        jc.bNames.add(this.literalCollectorANames.getQuick(0));
                        jc.aIndexes.add(rhi);
                        jc.bIndexes.add(lhi);
                        jc.slaveIndex = lhi;
                        jc.parents.add(rhi);
                    }
                    if (canMovePredicate || jc.slaveIndex == joinIndex) {
                        if (jc.slaveIndex != joinIndex && joinBarriers.contains(parent.getJoinModels().get(jc.slaveIndex).getJoinType())) {
                            this.addPostJoinWhereClause(parent.getJoinModels().getQuick(jc.slaveIndex), node);
                            break;
                        }
                        this.addJoinContext(parent, jc);
                        if (lhi == rhi) break;
                        SqlOptimiser.linkDependencies(parent, Math.min(lhi, rhi), Math.max(lhi, rhi));
                        break;
                    }
                    this.addOuterJoinExpression(parent, joinModel, joinIndex, node);
                    break;
                }
                if (bSize == 0 && this.literalCollector.nullCount == 0 && joinBarriers.excludes(parent.getJoinModels().get(this.literalCollectorAIndexes.get(0)).getJoinType())) {
                    if (!canMovePredicate) {
                        this.addOuterJoinExpression(parent, joinModel, joinIndex, node);
                        break;
                    }
                    jc.slaveIndex = lhi;
                    this.addWhereNode(parent, lhi, node);
                    this.addJoinContext(parent, jc);
                    CharSequence cs = this.literalCollectorANames.getQuick(0);
                    this.constNameToIndex.put(cs, lhi);
                    this.constNameToNode.put(cs, node.rhs);
                    this.constNameToToken.put(cs, node.token);
                    break;
                }
                if (canMovePredicate) {
                    parent.addParsedWhereNode(node, innerPredicate);
                    break;
                }
                this.addOuterJoinExpression(parent, joinModel, joinIndex, node);
                break;
            }
            default: {
                if (canMovePredicate) {
                    node.innerPredicate = innerPredicate;
                    parent.addParsedWhereNode(node, innerPredicate);
                    break;
                }
                this.addOuterJoinExpression(parent, joinModel, joinIndex, node);
            }
        }
    }

    private void analyseRegex(QueryModel parent, ExpressionNode node) throws SqlException {
        this.traverseNamesAndIndices(parent, node);
        if (this.literalCollector.nullCount == 0) {
            int aSize = this.literalCollectorAIndexes.size();
            int bSize = this.literalCollectorBIndexes.size();
            if (aSize == 1 && bSize == 0) {
                CharSequence name = this.literalCollectorANames.getQuick(0);
                this.constNameToIndex.put(name, this.literalCollectorAIndexes.get(0));
                this.constNameToNode.put(name, node.rhs);
                this.constNameToToken.put(name, node.token);
            }
        }
    }

    private void assignFilters(QueryModel parent) throws SqlException {
        this.tablesSoFar.clear();
        this.postFilterRemoved.clear();
        this.postFilterTableRefs.clear();
        this.literalCollector.withModel(parent);
        ObjList<ExpressionNode> filterNodes = parent.getParsedWhere();
        int pc = filterNodes.size();
        for (int i = 0; i < pc; ++i) {
            IntHashSet indexes = this.intHashSetPool.next();
            this.literalCollector.resetCounts();
            this.traversalAlgo.traverse(filterNodes.getQuick(i), this.literalCollector.to(indexes));
            this.postFilterTableRefs.add(indexes);
        }
        IntList ordered = parent.getOrderedJoinModels();
        int n = ordered.size();
        for (int i = 0; i < n; ++i) {
            int index = ordered.getQuick(i);
            this.tablesSoFar.add(index);
            for (int k = 0; k < pc; ++k) {
                if (this.postFilterRemoved.contains(k)) continue;
                ExpressionNode node = filterNodes.getQuick(k);
                IntHashSet refs = this.postFilterTableRefs.getQuick(k);
                int rs = refs.size();
                if (rs == 0) {
                    this.postFilterRemoved.add(k);
                    parent.setConstWhereClause(this.concatFilters(parent.getConstWhereClause(), node));
                    continue;
                }
                if (rs == 1 && joinBarriers.excludes(parent.getJoinModels().getQuick(refs.get(0)).getJoinType())) {
                    this.addWhereNode(parent, refs.get(0), node);
                    this.postFilterRemoved.add(k);
                    continue;
                }
                boolean qualifies = true;
                for (int y = 0; y < rs; ++y) {
                    if (!this.tablesSoFar.excludes(refs.get(y))) continue;
                    qualifies = false;
                    break;
                }
                if (!qualifies) continue;
                this.postFilterRemoved.add(k);
                QueryModel m = parent.getJoinModels().getQuick(index);
                m.setPostJoinWhereClause(this.concatFilters(m.getPostJoinWhereClause(), node));
            }
        }
        assert (this.postFilterRemoved.size() == pc);
    }

    private QueryModel bubbleUpOrderByAndLimitFromUnion(QueryModel model) throws SqlException {
        QueryModel _n;
        QueryModel m = model.getUnionModel();
        QueryModel nested = model.getNestedModel();
        if (nested != null && (_n = this.bubbleUpOrderByAndLimitFromUnion(nested)) != nested) {
            model.setNestedModel(_n);
        }
        if (m != null) {
            QueryModel m1;
            if (m.getNestedModel() != null && (m1 = this.bubbleUpOrderByAndLimitFromUnion(m.getNestedModel())) != m) {
                m.setNestedModel(m1);
            }
            while (true) {
                if (m.getUnionModel() == null) {
                    QueryModel un = m.getNestedModel();
                    if (un == null) break;
                    int n = un.getOrderBy().size();
                    ObjList<ExpressionNode> orderBy = un.getOrderBy();
                    IntList orderByDirection = un.getOrderByDirection();
                    ExpressionNode limitLo = m.getLimitLo();
                    ExpressionNode limitHi = m.getLimitHi();
                    if (n <= 0 && limitHi == null && limitLo == null) break;
                    QueryModel _nested = this.queryModelPool.next();
                    for (int i = 0; i < n; ++i) {
                        _nested.addOrderBy(orderBy.getQuick(i), orderByDirection.getQuick(i));
                    }
                    orderBy.clear();
                    orderByDirection.clear();
                    m.setLimit(null, null);
                    _nested.setNestedModel(model);
                    QueryModel _model = this.queryModelPool.next();
                    _model.setNestedModel(_nested);
                    SqlUtil.addSelectStar(_model, this.queryColumnPool, this.expressionNodePool);
                    _model.setLimit(limitLo, limitHi);
                    return _model;
                }
                m = m.getUnionModel();
            }
        }
        return model;
    }

    private boolean canPushToSampleBy(QueryModel model, ObjList<CharSequence> expressionColumns) {
        boolean isFillNone;
        ObjList<ExpressionNode> fill = model.getSampleByFill();
        int fillCount = fill.size();
        boolean bl = isFillNone = fillCount == 0 || fillCount == 1 && SqlKeywords.isNoneKeyword(fill.getQuick((int)0).token);
        if (!isFillNone || model.getSampleByOffset() == null) {
            return false;
        }
        CharSequence timestamp = this.findTimestamp(model);
        if (timestamp == null) {
            return true;
        }
        int n = expressionColumns.size();
        for (int i = 0; i < n; ++i) {
            if (!Chars.equalsIgnoreCase(expressionColumns.get(i), timestamp)) continue;
            return false;
        }
        return true;
    }

    private boolean checkForChildAggregates(ExpressionNode node) {
        this.sqlNodeStack.clear();
        while (node != null) {
            if (node.rhs != null) {
                if (node.rhs.type == 6 && this.functionParser.getFunctionFactoryCache().isGroupBy(node.rhs.token)) {
                    return true;
                }
                this.sqlNodeStack.push(node.rhs);
            }
            if (node.lhs != null) {
                if (node.lhs.type == 6 && this.functionParser.getFunctionFactoryCache().isGroupBy(node.lhs.token)) {
                    return true;
                }
                node = node.lhs;
                continue;
            }
            if (!this.sqlNodeStack.isEmpty()) {
                node = this.sqlNodeStack.poll();
                continue;
            }
            node = null;
        }
        return false;
    }

    private boolean checkForConsistentPrefix(ObjList<ExpressionNode> orderByAdvice) {
        CharSequence prefix = "";
        int n = orderByAdvice.size();
        for (int i = 0; i < n; ++i) {
            CharSequence token = orderByAdvice.getQuick((int)i).token;
            int loc = Chars.indexOfLastUnquoted(token, '.');
            if (loc <= -1) continue;
            if (prefix.length() == 0) {
                prefix = token.subSequence(0, loc);
                continue;
            }
            if (Chars.equalsIgnoreCase(prefix, token, 0, loc)) continue;
            return false;
        }
        return true;
    }

    private boolean checkForDot(ObjList<ExpressionNode> orderByAdvice) {
        int n = orderByAdvice.size();
        for (int i = 0; i < n; ++i) {
            if (Chars.indexOfLastUnquoted(orderByAdvice.getQuick((int)i).token, '.') <= -1) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfTranslatingModelIsRedundant(boolean useInnerModel, boolean useGroupByModel, boolean useWindowModel, boolean forceTranslatingModel, boolean checkTranslatingModel, QueryModel translatingModel) {
        boolean translationIsRedundant;
        boolean bl = translationIsRedundant = (useInnerModel || useGroupByModel || useWindowModel) && !forceTranslatingModel;
        if (translationIsRedundant && checkTranslatingModel) {
            int n = translatingModel.getBottomUpColumns().size();
            for (int i = 0; i < n; ++i) {
                QueryColumn column = translatingModel.getBottomUpColumns().getQuick(i);
                if (Chars.equalsIgnoreCase(column.getAst().token, column.getAlias())) continue;
                translationIsRedundant = false;
                break;
            }
        }
        return translationIsRedundant;
    }

    private QueryColumn checkSimpleIntegerColumn(ExpressionNode column, QueryModel model) {
        if (column == null || column.type != 7) {
            return null;
        }
        CharSequence tok = column.token;
        int dot = Chars.indexOfLastUnquoted(tok, '.');
        QueryColumn qc = this.getQueryColumn(model, tok, dot);
        if (qc != null && (qc.getColumnType() == 2 || qc.getColumnType() == 3 || qc.getColumnType() == 5 || qc.getColumnType() == 6)) {
            return qc;
        }
        return null;
    }

    private void collapseStackedChooseModels(@Nullable QueryModel model) {
        if (model == null) {
            return;
        }
        QueryModel nested = model.getNestedModel();
        if (model.getSelectModelType() == 1 && nested != null && nested.getSelectModelType() == 1 && nested.getBottomUpColumns().size() <= model.getBottomUpColumns().size()) {
            QueryModel nn = nested.getNestedModel();
            model.mergePartially(nested, this.queryColumnPool);
            model.setNestedModel(nn);
            this.collapseStackedChooseModels(model);
        } else {
            this.collapseStackedChooseModels(nested);
        }
        int n = model.getJoinModels().size();
        for (int i = 1; i < n; ++i) {
            this.collapseStackedChooseModels(model.getJoinModels().getQuick(i));
        }
        this.collapseStackedChooseModels(model.getUnionModel());
    }

    private void collectModelAlias(QueryModel parent, int modelIndex, QueryModel model) throws SqlException {
        ExpressionNode alias;
        ExpressionNode expressionNode = alias = model.getAlias() != null ? model.getAlias() : model.getTableNameExpr();
        if (parent.addModelAliasIndex(alias, modelIndex)) {
            return;
        }
        if (parent != model) {
            throw SqlException.position(alias.position).put("Duplicate table or alias: ").put(alias.token);
        }
    }

    private ExpressionNode concatFilters(ExpressionNode old, ExpressionNode filter) {
        if (old == null) {
            return filter;
        }
        OperatorExpression andOp = OperatorExpression.chooseRegistry(this.configuration.getCairoSqlLegacyOperatorPrecedence()).getOperatorDefinition("and");
        ExpressionNode node = this.expressionNodePool.next().of(9, andOp.operator.token, andOp.precedence, filter.position);
        node.paramCount = 2;
        node.lhs = old;
        node.rhs = filter;
        return node;
    }

    private void copyColumnTypesFromMetadata(QueryModel model, TableRecordMetadata m) {
        int k = m.getColumnCount();
        for (int i = 0; i < k; ++i) {
            model.addUpdateTableColumnMetadata(m.getColumnType(i), m.getColumnName(i));
        }
    }

    private void copyColumnsFromMetadata(QueryModel model, RecordMetadata m) throws SqlException {
        int k = m.getColumnCount();
        for (int i = 0; i < k; ++i) {
            CharSequence columnName = this.createColumnAlias(m.getColumnName(i), model, false);
            QueryColumn column = this.queryColumnPool.next().of(columnName, this.expressionNodePool.next().of(7, columnName, 0, 0), true, m.getColumnType(i));
            model.addField(column);
        }
        ExpressionNode timestamp = model.getTimestamp();
        if (timestamp == null) {
            if (m.getTimestampIndex() != -1) {
                model.setTimestamp(this.expressionNodePool.next().of(7, m.getColumnName(m.getTimestampIndex()), 0, 0));
            }
        } else {
            int index = m.getColumnIndexQuiet(timestamp.token);
            if (index == -1) {
                throw SqlException.invalidColumn(timestamp.position, timestamp.token);
            }
            if (!ColumnType.isTimestamp(m.getColumnType(index))) {
                throw SqlException.$(timestamp.position, "not a TIMESTAMP");
            }
        }
    }

    private CharSequence createColumnAlias(CharSequence name, QueryModel model, boolean nonLiteral) {
        return SqlUtil.createColumnAlias(this.characterStore, name, Chars.indexOfLastUnquoted(name, '.'), model.getAliasToColumnMap(), nonLiteral);
    }

    private CharSequence createColumnAlias(CharSequence name, QueryModel model) {
        return SqlUtil.createColumnAlias(this.characterStore, name, Chars.indexOfLastUnquoted(name, '.'), model.getAliasToColumnMap());
    }

    private CharSequence createColumnAlias(ExpressionNode node, QueryModel model) {
        return SqlUtil.createColumnAlias(this.characterStore, node.token, Chars.indexOfLastUnquoted(node.token, '.'), model.getAliasToColumnMap());
    }

    private QueryColumn createGroupByColumn(CharSequence columnAlias, ExpressionNode columnAst, QueryModel baseModel, QueryModel translatingModel, QueryModel innerVirtualModel, QueryModel groupByModel) throws SqlException {
        LowerCaseCharSequenceObjHashMap<CharSequence> translatingAliasMap = translatingModel.getColumnNameToAliasMap();
        int index = translatingAliasMap.keyIndex(columnAst.token);
        if (index < 0) {
            CharSequence translatedColumnName = translatingAliasMap.valueAtQuick(index);
            CharSequence innerAlias = this.createColumnAlias(columnAlias, groupByModel);
            QueryColumn translatedColumn = this.nextColumn(innerAlias, translatedColumnName);
            innerVirtualModel.addBottomUpColumn(columnAst.position, translatedColumn, true);
            groupByModel.addBottomUpColumn(translatedColumn);
            return translatedColumn;
        }
        CharSequence alias = this.createColumnAlias(columnAlias, translatingModel);
        this.addColumnToTranslatingModel(this.queryColumnPool.next().of(alias, columnAst), translatingModel, innerVirtualModel, baseModel);
        QueryColumn translatedColumn = this.nextColumn(alias);
        groupByModel.addBottomUpColumn(translatedColumn);
        return translatedColumn;
    }

    private void createImpliedDependencies(QueryModel parent) {
        ObjList<QueryModel> models = parent.getJoinModels();
        int n = models.size();
        for (int i = 0; i < n; ++i) {
            QueryModel m = models.getQuick(i);
            if (!joinsRequiringTimestamp[m.getJoinType()]) continue;
            SqlOptimiser.linkDependencies(parent, 0, i);
            if (m.getContext() != null) continue;
            JoinContext jc = this.contextPool.next();
            m.setContext(jc);
            jc.parents.add(0);
            jc.slaveIndex = i;
        }
    }

    private void createOrderHash(QueryModel model) {
        QueryModel nestedModel;
        LowerCaseCharSequenceIntHashMap hash = model.getOrderHash();
        hash.clear();
        ObjList<ExpressionNode> orderBy = model.getOrderBy();
        int n = orderBy.size();
        if (n > 0) {
            IntList orderByDirection = model.getOrderByDirection();
            for (int i = 0; i < n; ++i) {
                hash.putIfAbsent(orderBy.getQuick((int)i).token, orderByDirection.getQuick(i));
            }
        }
        if ((nestedModel = model.getNestedModel()) != null) {
            this.createOrderHash(nestedModel);
        }
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int z = joinModels.size();
        for (int i = 1; i < z; ++i) {
            this.createOrderHash(joinModels.getQuick(i));
        }
        QueryModel union = model.getUnionModel();
        if (union != null) {
            this.createOrderHash(union);
        }
    }

    private boolean createSelectColumn(CharSequence alias, CharSequence columnName, QueryModel groupByModel, QueryModel outerModel, QueryModel distinctModel) throws SqlException {
        QueryColumn groupByColumn = groupByModel.getAliasToColumnMap().get(columnName);
        QueryColumn outerColumn = this.nextColumn(alias, groupByColumn.getAlias());
        outerColumn = this.ensureAliasUniqueness(outerModel, outerColumn);
        outerModel.addBottomUpColumn(outerColumn);
        boolean sameAlias = Chars.equalsIgnoreCase(groupByColumn.getAlias(), outerColumn.getAlias());
        if (distinctModel != null) {
            if (sameAlias) {
                distinctModel.addBottomUpColumn(outerColumn);
            } else {
                QueryColumn distinctColumn = this.nextColumn(outerColumn.getAlias());
                distinctColumn = this.ensureAliasUniqueness(distinctModel, distinctColumn);
                distinctModel.addBottomUpColumn(distinctColumn);
            }
        }
        return sameAlias;
    }

    private void createSelectColumn(CharSequence columnName, ExpressionNode columnAst, boolean allowDuplicates, QueryModel baseModel, QueryModel translatingModel, QueryModel innerVirtualModel, QueryModel windowModel, QueryModel groupByModel, QueryModel outerModel, QueryModel distinctModel) throws SqlException {
        LowerCaseCharSequenceObjHashMap<CharSequence> translatingAliasMap = translatingModel.getColumnNameToAliasMap();
        int index = translatingAliasMap.keyIndex(columnAst.token);
        if (index < 0) {
            if (!allowDuplicates && groupByModel.getAliasToColumnMap().contains(columnName)) {
                throw SqlException.duplicateColumn(columnAst.position, columnName);
            }
            CharSequence translatedColumnName = translatingAliasMap.valueAtQuick(index);
            CharSequence innerAlias = this.createColumnAlias(columnName, groupByModel);
            QueryColumn translatedColumn = this.nextColumn(innerAlias, translatedColumnName);
            innerVirtualModel.addBottomUpColumn(columnAst.position, translatedColumn, true);
            groupByModel.addBottomUpColumn(translatedColumn);
            windowModel.addBottomUpColumn(translatedColumn);
            outerModel.addBottomUpColumn(translatedColumn);
            if (distinctModel != null) {
                distinctModel.addBottomUpColumn(translatedColumn);
            }
        } else {
            CharSequence alias;
            if (groupByModel.getAliasToColumnMap().contains(columnName)) {
                if (!allowDuplicates) {
                    throw SqlException.duplicateColumn(columnAst.position, columnName);
                }
                alias = this.createColumnAlias(columnName, groupByModel);
            } else {
                alias = this.createColumnAlias(columnName, translatingModel);
            }
            this.addColumnToTranslatingModel(this.queryColumnPool.next().of(alias, columnAst), translatingModel, innerVirtualModel, baseModel);
            QueryColumn translatedColumn = this.nextColumn(alias, columnAst.position);
            innerVirtualModel.addBottomUpColumn(translatedColumn);
            windowModel.addBottomUpColumn(translatedColumn);
            groupByModel.addBottomUpColumn(translatedColumn);
            outerModel.addBottomUpColumn(translatedColumn);
            if (distinctModel != null) {
                distinctModel.addBottomUpColumn(translatedColumn);
            }
        }
    }

    private void createSelectColumnsForWildcard(QueryColumn qc, boolean hasJoins, QueryModel baseModel, QueryModel translatingModel, QueryModel innerModel, QueryModel windowModel, QueryModel groupByModel, QueryModel outerModel, QueryModel distinctModel) throws SqlException {
        int dot = Chars.indexOfLastUnquoted(qc.getAst().token, '.');
        if (dot > -1) {
            int index = baseModel.getModelAliasIndex(qc.getAst().token, 0, dot);
            if (index == -1) {
                throw SqlException.$(qc.getAst().position, "invalid table alias");
            }
            this.createSelectColumnsForWildcard0(baseModel.getJoinModels().getQuick(index), hasJoins, qc.getAst().position, translatingModel, innerModel, windowModel, groupByModel, outerModel, distinctModel);
        } else {
            ObjList<QueryModel> models = baseModel.getJoinModels();
            int z = models.size();
            for (int j = 0; j < z; ++j) {
                this.createSelectColumnsForWildcard0(models.getQuick(j), hasJoins, qc.getAst().position, translatingModel, innerModel, windowModel, groupByModel, outerModel, distinctModel);
            }
        }
    }

    private void createSelectColumnsForWildcard0(QueryModel srcModel, boolean hasJoins, int wildcardPosition, QueryModel translatingModel, QueryModel innerModel, QueryModel windowModel, QueryModel groupByModel, QueryModel outerModel, QueryModel distinctModel) throws SqlException {
        ObjList<CharSequence> columnNames = srcModel.getWildcardColumnNames();
        int z = columnNames.size();
        for (int j = 0; j < z; ++j) {
            CharSequence token;
            CharSequence name = columnNames.getQuick(j);
            QueryColumn qc = srcModel.getAliasToColumnMap().get(name);
            if (!qc.isIncludeIntoWildcard()) continue;
            if (hasJoins) {
                CharacterStoreEntry characterStoreEntry = this.characterStore.newEntry();
                characterStoreEntry.put(srcModel.getName());
                characterStoreEntry.put('.');
                characterStoreEntry.put(name);
                token = characterStoreEntry.toImmutable();
            } else {
                token = name;
            }
            this.createSelectColumn(name, this.nextLiteral(token, wildcardPosition), true, null, translatingModel, innerModel, windowModel, groupByModel, outerModel, distinctModel);
        }
    }

    @NotNull
    private QueryModel createWrapperModel(QueryModel model) {
        QueryModel _model = this.queryModelPool.next();
        QueryModel _nested = this.queryModelPool.next();
        _model.setNestedModel(_nested);
        _nested.setNestedModel(model);
        _model.setModelPosition(model.getModelPosition());
        _nested.setModelPosition(model.getModelPosition());
        QueryModel unionModel = model.getUnionModel();
        model.setUnionModel(null);
        _model.setUnionModel(unionModel);
        return _model;
    }

    private int doReorderTables(QueryModel parent, IntList ordered) {
        int i;
        this.tempCrossIndexes.clear();
        ordered.clear();
        this.orderingStack.clear();
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        int cost = 0;
        int n = joinModels.size();
        for (i = 0; i < n; ++i) {
            QueryModel q = joinModels.getQuick(i);
            if (q.getJoinType() == 3 || q.getContext() == null || q.getContext().parents.size() == 0) {
                if (q.getDependencies().size() > 0) {
                    this.orderingStack.add(i);
                    continue;
                }
                this.tempCrossIndexes.add(i);
                continue;
            }
            q.getContext().inCount = q.getContext().parents.size();
        }
        while (this.orderingStack.notEmpty()) {
            int index = this.orderingStack.poll();
            ordered.add(index);
            QueryModel m = joinModels.getQuick(index);
            cost = m.getJoinType() == 3 ? (cost += 10) : (cost += 5);
            IntHashSet dependencies = m.getDependencies();
            int k = dependencies.size();
            for (int i2 = 0; i2 < k; ++i2) {
                int depIndex = dependencies.get(i2);
                JoinContext jc = joinModels.getQuick(depIndex).getContext();
                if (jc == null || --jc.inCount != 0) continue;
                this.orderingStack.add(depIndex);
            }
        }
        n = joinModels.size();
        for (i = 0; i < n; ++i) {
            QueryModel m = joinModels.getQuick(i);
            if (m.getContext() == null || m.getContext().inCount <= 0) continue;
            return Integer.MAX_VALUE;
        }
        n = this.tempCrossIndexes.size();
        for (i = 0; i < n; ++i) {
            ordered.add(this.tempCrossIndexes.getQuick(i));
        }
        return cost;
    }

    private ExpressionNode doReplaceLiteral(ExpressionNode node, QueryModel translatingModel, QueryModel innerVirtualModel, boolean addColumnToInnerVirtualModel, QueryModel baseModel, boolean windowCall) throws SqlException {
        if (windowCall) {
            assert (innerVirtualModel != null);
            ExpressionNode n = this.doReplaceLiteral0(node, translatingModel, innerVirtualModel, false, baseModel);
            LowerCaseCharSequenceObjHashMap<CharSequence> map = innerVirtualModel.getColumnNameToAliasMap();
            int index = map.keyIndex(n.token);
            if (index > -1) {
                CharSequence alias = this.createColumnAlias(n.token, innerVirtualModel);
                innerVirtualModel.addBottomUpColumn(this.queryColumnPool.next().of(alias, n));
                if (alias != n.token) {
                    return this.nextLiteral(alias);
                }
                return n;
            }
            return this.nextLiteral(map.valueAt(index), node.position);
        }
        return this.doReplaceLiteral0(node, translatingModel, innerVirtualModel, addColumnToInnerVirtualModel, baseModel);
    }

    private ExpressionNode doReplaceLiteral0(ExpressionNode node, QueryModel translatingModel, QueryModel innerVirtualModel, boolean addColumnToInnerVirtualModel, QueryModel baseModel) throws SqlException {
        CharSequence alias;
        LowerCaseCharSequenceObjHashMap<CharSequence> map = translatingModel.getColumnNameToAliasMap();
        int index = map.keyIndex(node.token);
        if (index > -1) {
            int joinCount = baseModel.getJoinModels().size();
            if (joinCount > 1) {
                boolean found = false;
                StringSink sink = Misc.getThreadLocalSink();
                for (int i = 0; i < joinCount; ++i) {
                    QueryModel jm = baseModel.getJoinModels().getQuick(i);
                    if (jm.getAliasToColumnMap().keyIndex(node.token) >= 0) continue;
                    if (found) {
                        throw SqlException.ambiguousColumn(node.position, node.token);
                    }
                    if (jm.getAlias() != null) {
                        sink.put(jm.getAlias().token);
                    } else {
                        sink.put(jm.getTableName());
                    }
                    sink.put('.');
                    sink.put(node.token);
                    index = map.keyIndex(sink);
                    if (index >= 0) continue;
                    found = true;
                }
                if (found) {
                    return this.nextLiteral(map.valueAtQuick(index), node.position);
                }
            }
            if (baseModel.getAliasToColumnMap().excludes(node.token) && innerVirtualModel.getAliasToColumnMap().contains(node.token)) {
                return node;
            }
            alias = this.createColumnAlias(node, translatingModel);
            QueryColumn column = this.queryColumnPool.next().of(alias, node);
            this.addColumnToTranslatingModel(column, translatingModel, innerVirtualModel, baseModel);
            if (addColumnToInnerVirtualModel) {
                ExpressionNode innerToken = this.expressionNodePool.next().of(7, alias, node.precedence, node.position);
                QueryColumn innerColumn = this.queryColumnPool.next().of(alias, innerToken);
                innerVirtualModel.addBottomUpColumn(innerColumn);
            }
        } else {
            alias = map.valueAtQuick(index);
            if (addColumnToInnerVirtualModel && innerVirtualModel.getAliasToColumnMap().excludes(alias)) {
                innerVirtualModel.addBottomUpColumn(this.nextColumn(alias), true);
            }
        }
        return this.nextLiteral(alias, node.position);
    }

    private void doRewriteOrderByPositionForUnionModels(QueryModel model, QueryModel parent, QueryModel next) throws SqlException {
        int columnCount = model.getBottomUpColumns().size();
        while (next != null) {
            if (next.getBottomUpColumns().size() != columnCount) {
                throw SqlException.$(next.getModelPosition(), "queries have different number of columns");
            }
            this.rewriteOrderByPosition(next);
            parent.setUnionModel(next);
            parent = next;
            next = next.getUnionModel();
        }
    }

    private ObjList<ExpressionNode> duplicateAdviceAndTakeSuffix() {
        ObjList<ExpressionNode> advice = new ObjList<ExpressionNode>();
        int m = this.orderByAdvice.size();
        for (int j = 0; j < m; ++j) {
            ExpressionNode node = this.orderByAdvice.getQuick(j);
            CharSequence token = node.token;
            int d = Chars.indexOfLastUnquoted(token, '.');
            advice.add(this.expressionNodePool.next().of(node.type, token.subSequence(d + 1, token.length()), node.precedence, node.position));
        }
        return advice;
    }

    private void emitAggregatesAndLiterals(ExpressionNode node, QueryModel groupByModel, QueryModel translatingModel, QueryModel innerVirtualModel, QueryModel baseModel, ObjList<ExpressionNode> groupByNodes, ObjList<CharSequence> groupByAliases) throws SqlException {
        this.sqlNodeStack.clear();
        while (!this.sqlNodeStack.isEmpty() || node != null) {
            if (node != null) {
                if (node.paramCount < 3) {
                    ExpressionNode n;
                    if (node.rhs != null) {
                        n = this.replaceIfAggregateOrLiteral(node.rhs, groupByModel, translatingModel, innerVirtualModel, baseModel, groupByNodes, groupByAliases);
                        if (node.rhs == n) {
                            this.sqlNodeStack.push(node.rhs);
                        } else {
                            node.rhs = n;
                        }
                    }
                    if ((n = this.replaceIfAggregateOrLiteral(node.lhs, groupByModel, translatingModel, innerVirtualModel, baseModel, groupByNodes, groupByAliases)) == node.lhs) {
                        node = node.lhs;
                        continue;
                    }
                    node.lhs = n;
                    node = null;
                    continue;
                }
                int k = node.paramCount;
                for (int i = 0; i < k; ++i) {
                    ExpressionNode n;
                    ExpressionNode e = node.args.getQuick(i);
                    if (e == (n = this.replaceIfAggregateOrLiteral(e, groupByModel, translatingModel, innerVirtualModel, baseModel, groupByNodes, groupByAliases))) {
                        this.sqlNodeStack.push(e);
                        continue;
                    }
                    node.args.setQuick(i, n);
                }
                node = this.sqlNodeStack.poll();
                continue;
            }
            node = this.sqlNodeStack.poll();
        }
    }

    private void emitColumnLiteralsTopDown(ObjList<QueryColumn> columns, QueryModel target) {
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn qc = columns.getQuick(i);
            this.emitLiteralsTopDown(qc.getAst(), target);
            if (!qc.isWindowColumn()) continue;
            WindowColumn ac = (WindowColumn)qc;
            this.emitLiteralsTopDown(ac.getPartitionBy(), target);
            this.emitLiteralsTopDown(ac.getOrderBy(), target);
        }
    }

    private void emitCursors(ExpressionNode node, QueryModel cursorModel, @Nullable QueryModel innerVirtualModel, QueryModel translatingModel, QueryModel baseModel, SqlExecutionContext sqlExecutionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        this.sqlNodeStack.clear();
        while (!this.sqlNodeStack.isEmpty() || node != null) {
            if (node != null) {
                ExpressionNode n;
                if (node.rhs != null) {
                    n = this.replaceIfCursor(node.rhs, cursorModel, innerVirtualModel, translatingModel, baseModel, sqlExecutionContext, sqlParserCallback);
                    if (node.rhs == n) {
                        this.sqlNodeStack.push(node.rhs);
                    } else {
                        node.rhs = n;
                    }
                }
                if ((n = this.replaceIfCursor(node.lhs, cursorModel, innerVirtualModel, translatingModel, baseModel, sqlExecutionContext, sqlParserCallback)) == node.lhs) {
                    node = node.lhs;
                    continue;
                }
                node.lhs = n;
                node = null;
                continue;
            }
            node = this.sqlNodeStack.poll();
        }
    }

    private void emitLiterals(ExpressionNode node, QueryModel translatingModel, QueryModel innerVirtualModel, boolean addColumnToInnerVirtualModel, QueryModel baseModel, boolean windowCall) throws SqlException {
        this.sqlNodeStack.clear();
        while (!this.sqlNodeStack.isEmpty() || node != null) {
            if (node != null) {
                ExpressionNode n;
                if (node.paramCount < 3) {
                    ExpressionNode n2;
                    if (node.rhs != null) {
                        n2 = this.replaceLiteral(node.rhs, translatingModel, innerVirtualModel, addColumnToInnerVirtualModel, baseModel, windowCall);
                        if (node.rhs == n2) {
                            this.sqlNodeStack.push(node.rhs);
                        } else {
                            node.rhs = n2;
                        }
                    }
                    if ((n2 = this.replaceLiteral(node.lhs, translatingModel, innerVirtualModel, addColumnToInnerVirtualModel, baseModel, windowCall)) == node.lhs) {
                        node = node.lhs;
                        continue;
                    }
                    node.lhs = n2;
                    node = null;
                    continue;
                }
                int k = node.paramCount;
                for (int i = 1; i < k; ++i) {
                    ExpressionNode n3;
                    ExpressionNode e = node.args.getQuick(i);
                    if (e == (n3 = this.replaceLiteral(e, translatingModel, innerVirtualModel, addColumnToInnerVirtualModel, baseModel, windowCall))) {
                        this.sqlNodeStack.push(e);
                        continue;
                    }
                    node.args.setQuick(i, n3);
                }
                ExpressionNode e = node.args.getQuick(0);
                if (e == (n = this.replaceLiteral(e, translatingModel, innerVirtualModel, addColumnToInnerVirtualModel, baseModel, windowCall))) {
                    node = e;
                    continue;
                }
                node.args.setQuick(0, n);
                node = null;
                continue;
            }
            node = this.sqlNodeStack.poll();
        }
    }

    private void emitLiteralsTopDown(ExpressionNode node, QueryModel model) {
        this.sqlNodeStack.clear();
        this.addTopDownColumn(node, model);
        while (!this.sqlNodeStack.isEmpty() || node != null) {
            if (node != null) {
                if (node.paramCount < 3) {
                    if (node.rhs != null) {
                        this.addTopDownColumn(node.rhs, model);
                        this.sqlNodeStack.push(node.rhs);
                    }
                    if (node.lhs != null) {
                        this.addTopDownColumn(node.lhs, model);
                    }
                    node = node.lhs;
                    continue;
                }
                int k = node.paramCount;
                for (int i = 1; i < k; ++i) {
                    ExpressionNode e = node.args.getQuick(i);
                    this.addTopDownColumn(e, model);
                    this.sqlNodeStack.push(e);
                }
                ExpressionNode e = node.args.getQuick(0);
                this.addTopDownColumn(e, model);
                node = e;
                continue;
            }
            node = this.sqlNodeStack.poll();
        }
    }

    private void emitLiteralsTopDown(ObjList<ExpressionNode> list, QueryModel nested) {
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            this.emitLiteralsTopDown(list.getQuick(i), nested);
        }
    }

    private QueryColumn ensureAliasUniqueness(QueryModel model, QueryColumn qc) {
        CharSequence alias = this.createColumnAlias(qc.getAlias(), model);
        if (alias != qc.getAlias()) {
            qc = this.queryColumnPool.next().of(alias, qc.getAst());
        }
        return qc;
    }

    private void enumerateColumns(QueryModel model, TableRecordMetadata metadata) throws SqlException {
        model.setMetadataVersion(metadata.getMetadataVersion());
        model.setTableId(metadata.getTableId());
        this.copyColumnsFromMetadata(model, metadata);
        if (model.isUpdate()) {
            this.copyColumnTypesFromMetadata(model, metadata);
        }
    }

    private void enumerateTableColumns(QueryModel model, SqlExecutionContext executionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        ObjList<QueryModel> jm = model.getJoinModels();
        ExpressionNode tableNameExpr = model.getTableNameExpr();
        if (tableNameExpr != null || model.getSelectModelType() == 7) {
            if (model.getSelectModelType() == 7 || tableNameExpr != null && tableNameExpr.type == 6) {
                this.parseFunctionAndEnumerateColumns(model, executionContext, sqlParserCallback);
            } else {
                this.openReaderAndEnumerateColumns(executionContext, model, sqlParserCallback);
            }
        } else {
            QueryModel nested = model.getNestedModel();
            if (nested != null) {
                this.enumerateTableColumns(nested, executionContext, sqlParserCallback);
                if (model.isUpdate()) {
                    model.copyUpdateTableMetadata(nested);
                }
            }
        }
        int n = jm.size();
        for (int i = 1; i < n; ++i) {
            this.enumerateTableColumns(jm.getQuick(i), executionContext, sqlParserCallback);
        }
        if (model.getUnionModel() != null) {
            this.enumerateTableColumns(model.getUnionModel(), executionContext, sqlParserCallback);
        }
    }

    private void eraseColumnPrefixInWhereClauses(QueryModel model) throws SqlException {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 0; i < n; ++i) {
            QueryModel nested;
            QueryModel m = joinModels.getQuick(i);
            ExpressionNode where = m.getWhereClause();
            if (where != null) {
                if (where.type == 7) {
                    m.setWhereClause(this.columnPrefixEraser.rewrite(where));
                } else {
                    this.traversalAlgo.traverse(where, this.columnPrefixEraser);
                }
            }
            if ((nested = m.getNestedModel()) != null) {
                this.eraseColumnPrefixInWhereClauses(nested);
            }
            if ((nested = m.getUnionModel()) == null) continue;
            this.eraseColumnPrefixInWhereClauses(nested);
        }
    }

    private long evalNonNegativeLongConstantOrDie(ExpressionNode expr, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (expr != null) {
            Function loFunc = this.functionParser.parseFunction(expr, EmptyRecordMetadata.INSTANCE, sqlExecutionContext);
            if (!loFunc.isConstant()) {
                Misc.free(loFunc);
                throw SqlException.$(expr.position, "constant expression expected");
            }
            try {
                long value;
                if (!(loFunc instanceof CharConstant)) {
                    value = loFunc.getLong(null);
                } else {
                    long tmp = (byte)(loFunc.getChar(null) - 48);
                    long l = value = tmp > -1L && tmp < 10L ? tmp : Long.MIN_VALUE;
                }
                if (value < 0L) {
                    throw SqlException.$(expr.position, "non-negative integer expression expected");
                }
                long l = value;
                return l;
            }
            catch (ImplicitCastException | UnsupportedOperationException e) {
                throw SqlException.$(expr.position, "integer expression expected");
            }
            finally {
                Misc.free(loFunc);
            }
        }
        return Long.MAX_VALUE;
    }

    private CharSequence findColumnByAst(ObjList<ExpressionNode> groupByNodes, ObjList<CharSequence> groupByAliases, ExpressionNode node) {
        int max = groupByNodes.size();
        for (int i = 0; i < max; ++i) {
            ExpressionNode n = groupByNodes.getQuick(i);
            if (!ExpressionNode.compareNodesExact(node, n)) continue;
            return groupByAliases.getQuick(i);
        }
        return null;
    }

    private int findColumnIdxByAst(ObjList<ExpressionNode> groupByNodes, ExpressionNode node) {
        int max = groupByNodes.size();
        for (int i = 0; i < max; ++i) {
            ExpressionNode n = groupByNodes.getQuick(i);
            if (!ExpressionNode.compareNodesExact(node, n)) continue;
            return i;
        }
        return -1;
    }

    private CharSequence findQueryColumnByAst(ObjList<QueryColumn> bottomUpColumns, ExpressionNode node) {
        int max = bottomUpColumns.size();
        for (int i = 0; i < max; ++i) {
            QueryColumn qc = bottomUpColumns.getQuick(i);
            if (!ExpressionNode.compareNodesExact(qc.getAst(), node)) continue;
            return qc.getAlias();
        }
        return null;
    }

    private CharSequence findTimestamp(QueryModel model) {
        CharSequence timestamp;
        if (model != null && (timestamp = model.getTimestamp() != null ? model.getTimestamp().token : this.findTimestamp(model.getNestedModel())) != null) {
            return model.getColumnNameToAliasMap().get(timestamp);
        }
        return null;
    }

    private void fixAndCollectExprToken(ExpressionNode node, CharSequence old, CharSequence newToken, CharSequenceHashSet set, CharSequenceHashSet set2) {
        this.sqlNodeStack.clear();
        while (node != null) {
            if (node.type == 7) {
                if (Chars.equalsIgnoreCase(node.token, old)) {
                    node.token = newToken;
                } else if (!set.contains(node.token)) {
                    set2.add(node.token);
                }
            }
            if (node.paramCount < 3) {
                if (node.lhs != null) {
                    this.sqlNodeStack.push(node.lhs);
                }
                if (node.rhs != null) {
                    node = node.rhs;
                    continue;
                }
            } else {
                int k = node.paramCount;
                for (int i = 1; i < k; ++i) {
                    this.sqlNodeStack.push(node.args.getQuick(i));
                }
                node = node.args.getQuick(0);
                continue;
            }
            if (!this.sqlNodeStack.isEmpty()) {
                node = this.sqlNodeStack.poll();
                continue;
            }
            node = null;
        }
    }

    private Function getLoFunction(ExpressionNode limit, SqlExecutionContext executionContext) throws SqlException {
        Function func = this.functionParser.parseFunction(limit, EmptyRecordMetadata.INSTANCE, executionContext);
        int type = func.getType();
        if (limitTypes.excludes(type)) {
            return null;
        }
        func.init(null, executionContext);
        return func;
    }

    private ObjList<ExpressionNode> getOrderByAdvice(QueryModel model, int orderByMnemonic) {
        this.orderByAdvice.clear();
        ObjList<ExpressionNode> orderBy = model.getOrderBy();
        int len = orderBy.size();
        if (len == 0) {
            if (orderByMnemonic == 2 && model.getOrderByAdvice().size() > 0) {
                orderBy = model.getOrderByAdvice();
                len = orderBy.size();
            } else {
                return this.orderByAdvice;
            }
        }
        LowerCaseCharSequenceObjHashMap<QueryColumn> map = model.getAliasToColumnMap();
        for (int i = 0; i < len; ++i) {
            ExpressionNode orderByNode = orderBy.getQuick(i);
            QueryColumn queryColumn = map.get(orderByNode.token);
            if (queryColumn == null) {
                this.orderByAdvice.clear();
                break;
            }
            if (queryColumn.getAst().type != 7) {
                this.orderByAdvice.clear();
                break;
            }
            this.orderByAdvice.add(queryColumn.getAst());
        }
        return this.orderByAdvice;
    }

    private IntList getOrderByAdviceDirection(QueryModel model, int orderByMnemonic) {
        IntList orderByDirection = model.getOrderByDirection();
        if (model.getOrderBy().size() == 0 && orderByMnemonic == 2) {
            return model.getOrderByDirectionAdvice();
        }
        return orderByDirection;
    }

    private QueryColumn getQueryColumn(QueryModel model, CharSequence columnName, int dot) {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        QueryColumn column = null;
        if (dot == -1) {
            int n = joinModels.size();
            for (int i = 0; i < n; ++i) {
                QueryColumn qc = joinModels.getQuick(i).getAliasToColumnMap().get(columnName);
                if (qc == null) continue;
                if (column != null) {
                    return null;
                }
                column = qc;
            }
        } else {
            int index = model.getModelAliasIndex(columnName, 0, dot);
            if (index == -1) {
                return null;
            }
            return joinModels.getQuick(index).getAliasToColumnMap().get(columnName, dot + 1, columnName.length());
        }
        return column;
    }

    private CharSequence getTranslatedColumnAlias(QueryModel model, QueryModel stopModel, CharSequence token) {
        if (model == stopModel) {
            return token;
        }
        CharSequence nestedAlias = this.getTranslatedColumnAlias(model.getNestedModel(), stopModel, token);
        if (nestedAlias != null) {
            CharSequence alias = model.getColumnNameToAliasMap().get(nestedAlias);
            if (alias == null) {
                this.tempQueryModel = model;
                this.tempColumnAlias = nestedAlias;
            }
            return alias;
        }
        return null;
    }

    private boolean hasNoAggregateQueryColumns(QueryModel model) {
        ObjList<QueryColumn> columns = model.getBottomUpColumns();
        int k = columns.size();
        for (int i = 0; i < k; ++i) {
            QueryColumn qc = columns.getQuick(i);
            if (qc.getAst().type == 7) continue;
            if (qc.getAst().type == 6) {
                if (this.functionParser.getFunctionFactoryCache().isGroupBy(qc.getAst().token)) {
                    return false;
                }
                if (this.functionParser.getFunctionFactoryCache().isCursor(qc.getAst().token)) continue;
            }
            if (!this.checkForChildAggregates(qc.getAst())) continue;
            return false;
        }
        return true;
    }

    private void homogenizeCrossJoins(QueryModel parent) {
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        int n = joinModels.size();
        for (int i = 0; i < n; ++i) {
            QueryModel m = joinModels.getQuick(i);
            JoinContext c = m.getContext();
            if (m.getJoinType() == 3) {
                if (c == null || c.parents.size() <= 0) continue;
                m.setJoinType(1);
                continue;
            }
            if (m.getJoinType() == 2 && c == null && m.getJoinCriteria() != null) {
                m.setJoinType(8);
                continue;
            }
            if (m.getJoinType() == 4 || m.getJoinType() == 5 || c != null && c.parents.size() != 0) continue;
            m.setJoinType(3);
        }
    }

    private void initialiseOperatorExpressions() {
        OperatorRegistry registry = OperatorExpression.getRegistry();
        this.opGeq = registry.map.get(">=");
        this.opLt = registry.map.get("<");
        this.opAnd = registry.map.get("and");
    }

    private boolean isAmbiguousColumn(QueryModel model, CharSequence columnName) {
        int dot = Chars.indexOfLastUnquoted(columnName, '.');
        if (dot == -1) {
            ObjList<QueryModel> joinModels = model.getJoinModels();
            int index = -1;
            int n = joinModels.size();
            for (int i = 0; i < n; ++i) {
                if (joinModels.getQuick(i).getColumnNameToAliasMap().excludes(columnName)) continue;
                if (index != -1) {
                    return true;
                }
                index = i;
            }
        }
        return false;
    }

    private boolean isEffectivelyConstantExpression(ExpressionNode node) {
        this.sqlNodeStack.clear();
        while (node != null) {
            if (!(node.type == 9 || node.type == 4 || node.type == 6 && this.functionParser.getFunctionFactoryCache().isRuntimeConstant(node.token))) {
                return false;
            }
            if (node.lhs != null) {
                this.sqlNodeStack.push(node.lhs);
            }
            if (node.rhs != null) {
                node = node.rhs;
                continue;
            }
            if (!this.sqlNodeStack.isEmpty()) {
                node = this.sqlNodeStack.poll();
                continue;
            }
            node = null;
        }
        return true;
    }

    private boolean isIntegerConstant(ExpressionNode n) {
        if (n.type != 4) {
            return false;
        }
        try {
            Numbers.parseLong(n.token);
            return true;
        }
        catch (NumericException ne) {
            return false;
        }
    }

    private boolean isSimpleIntegerColumn(ExpressionNode column, QueryModel model) {
        return this.checkSimpleIntegerColumn(column, model) != null;
    }

    private ExpressionNode makeJoinAlias() {
        CharacterStoreEntry characterStoreEntry = this.characterStore.newEntry();
        ((Utf16Sink)characterStoreEntry.put("_xQdbA")).put(this.defaultAliasCount++);
        return this.nextLiteral(characterStoreEntry.toImmutable());
    }

    private ExpressionNode makeModelAlias(CharSequence modelAlias, ExpressionNode node) {
        CharacterStoreEntry characterStoreEntry = this.characterStore.newEntry();
        ((Utf16Sink)((Utf16Sink)characterStoreEntry.put(modelAlias)).put('.')).put(node.token);
        return this.nextLiteral(characterStoreEntry.toImmutable(), node.position);
    }

    private ExpressionNode makeOperation(CharSequence token, ExpressionNode lhs, ExpressionNode rhs) {
        OperatorExpression op = OperatorExpression.chooseRegistry(this.configuration.getCairoSqlLegacyOperatorPrecedence()).getOperatorDefinition(token);
        ExpressionNode node = this.expressionNodePool.next().of(9, op.operator.token, op.precedence, 0);
        node.paramCount = 2;
        node.lhs = lhs;
        node.rhs = rhs;
        return node;
    }

    private boolean matchesWithOrWithoutTablePrefix(@NotNull CharSequence name, @NotNull CharSequence table, CharSequence target) {
        if (target == null) {
            return false;
        }
        int dotIndex = Chars.indexOfLastUnquoted(name, '.');
        return dotIndex > 0 ? Chars.equalsIgnoreCase(table, name, 0, dotIndex) && Chars.equalsIgnoreCase(target, name, dotIndex + 1, name.length()) : Chars.equalsIgnoreCase(name, target);
    }

    private JoinContext mergeContexts(QueryModel parent, JoinContext a, JoinContext b) {
        int i;
        assert (a.slaveIndex == b.slaveIndex);
        this.deletedContexts.clear();
        JoinContext r = this.contextPool.next();
        int n = b.aNames.size();
        for (i = 0; i < n; ++i) {
            CharSequence ban = b.aNames.getQuick(i);
            int bai = b.aIndexes.getQuick(i);
            ExpressionNode bao = b.aNodes.getQuick(i);
            CharSequence bbn = b.bNames.getQuick(i);
            int bbi = b.bIndexes.getQuick(i);
            ExpressionNode bbo = b.bNodes.getQuick(i);
            int z = a.aNames.size();
            for (int k = 0; k < z; ++k) {
                CharSequence aan = a.aNames.getQuick(k);
                int aai = a.aIndexes.getQuick(k);
                ExpressionNode aao = a.aNodes.getQuick(k);
                CharSequence abn = a.bNames.getQuick(k);
                int abi = a.bIndexes.getQuick(k);
                ExpressionNode abo = a.bNodes.getQuick(k);
                if (aai == bai && Chars.equals(aan, ban)) {
                    this.addFilterOrEmitJoin(parent, k, abi, abn, abo, bbi, bbn, bbo);
                    break;
                }
                if (abi == bai && Chars.equals(abn, ban)) {
                    this.addFilterOrEmitJoin(parent, k, aai, aan, aao, bbi, bbn, bbo);
                    break;
                }
                if (aai == bbi && Chars.equals(aan, bbn)) {
                    this.addFilterOrEmitJoin(parent, k, abi, abn, abo, bai, ban, bao);
                    break;
                }
                if (abi != bbi || !Chars.equals(abn, bbn)) continue;
                this.addFilterOrEmitJoin(parent, k, aai, aan, aao, bai, ban, bao);
                break;
            }
            r.aIndexes.add(bai);
            r.aNames.add(ban);
            r.aNodes.add(bao);
            r.bIndexes.add(bbi);
            r.bNames.add(bbn);
            r.bNodes.add(bbo);
            int max = Math.max(bai, bbi);
            int min = Math.min(bai, bbi);
            r.slaveIndex = max;
            r.parents.add(min);
            SqlOptimiser.linkDependencies(parent, min, max);
        }
        n = a.aNames.size();
        for (i = 0; i < n; ++i) {
            int max;
            int min;
            int abi;
            int aai = a.aIndexes.getQuick(i);
            if (aai < (abi = a.bIndexes.getQuick(i))) {
                min = aai;
                max = abi;
            } else {
                min = abi;
                max = aai;
            }
            if (this.deletedContexts.contains(i)) {
                if (!r.parents.excludes(min)) continue;
                SqlOptimiser.unlinkDependencies(parent, min, max);
                continue;
            }
            r.aNames.add(a.aNames.getQuick(i));
            r.bNames.add(a.bNames.getQuick(i));
            r.aIndexes.add(aai);
            r.bIndexes.add(abi);
            r.aNodes.add(a.aNodes.getQuick(i));
            r.bNodes.add(a.bNodes.getQuick(i));
            r.parents.add(min);
            r.slaveIndex = max;
            SqlOptimiser.linkDependencies(parent, min, max);
        }
        return r;
    }

    private JoinContext moveClauses(QueryModel parent, JoinContext from, JoinContext to, IntList positions) {
        int p = 0;
        int m = positions.size();
        JoinContext result = this.contextPool.next();
        result.slaveIndex = from.slaveIndex;
        int n = from.aIndexes.size();
        for (int i = 0; i < n; ++i) {
            JoinContext t = p < m && i == positions.getQuick(p) ? to : result;
            int ai = from.aIndexes.getQuick(i);
            int bi = from.bIndexes.getQuick(i);
            t.aIndexes.add(ai);
            t.aNames.add(from.aNames.getQuick(i));
            t.aNodes.add(from.aNodes.getQuick(i));
            t.bIndexes.add(bi);
            t.bNames.add(from.bNames.getQuick(i));
            t.bNodes.add(from.bNodes.getQuick(i));
            if (ai != t.slaveIndex) {
                t.parents.add(ai);
                SqlOptimiser.linkDependencies(parent, ai, bi);
                continue;
            }
            t.parents.add(bi);
            SqlOptimiser.linkDependencies(parent, bi, ai);
        }
        return result;
    }

    private QueryModel moveOrderByFunctionsIntoOuterSelect(QueryModel model) throws SqlException {
        QueryModel nested;
        QueryModel unionModel = model.getUnionModel();
        if (unionModel != null) {
            model.setUnionModel(this.moveOrderByFunctionsIntoOuterSelect(unionModel));
        }
        if ((nested = model.getNestedModel()) != null) {
            int jmn = nested.getJoinModels().size();
            for (int jm = 0; jm < jmn; ++jm) {
                QueryModel joinModel = nested.getJoinModels().getQuick(jm);
                if (joinModel == nested || joinModel.getNestedModel() == null) continue;
                joinModel.setNestedModel(this.moveOrderByFunctionsIntoOuterSelect(joinModel.getNestedModel()));
            }
            QueryModel nestedNested = nested.getNestedModel();
            if (nestedNested != null) {
                nested.setNestedModel(this.moveOrderByFunctionsIntoOuterSelect(nestedNested));
            }
            ObjList<ExpressionNode> orderBy = nested.getOrderBy();
            int n = orderBy.size();
            boolean moved = false;
            for (int i = 0; i < n; ++i) {
                ExpressionNode node = orderBy.getQuick(i);
                if (node.type != 6 && node.type != 9) continue;
                CharSequence alias = this.findQueryColumnByAst(model.getBottomUpColumns(), node);
                if (alias == null) {
                    alias = SqlUtil.createColumnAlias(this.characterStore, node.token, Chars.indexOfLastUnquoted(node.token, '.'), model.getAliasToColumnMap(), true);
                    QueryColumn qc = this.queryColumnPool.next().of(alias, node, false);
                    model.getAliasToColumnMap().put(alias, qc);
                    model.getBottomUpColumns().add(qc);
                    moved = true;
                }
                orderBy.setQuick(i, this.nextLiteral(alias));
            }
            if (moved) {
                return this.wrapWithSelectWildcard(model);
            }
        }
        return model;
    }

    private void moveTimestampToChooseModel(QueryModel model) {
        ObjList<QueryModel> joinModels;
        QueryModel nested = model.getNestedModel();
        if (nested != null) {
            this.moveTimestampToChooseModel(nested);
            ExpressionNode timestamp = nested.getTimestamp();
            if (timestamp != null && nested.getSelectModelType() == 0 && nested.getTableName() == null && nested.getTableNameFunction() == null && nested.getLatestBy().size() == 0) {
                model.setTimestamp(timestamp);
                model.setExplicitTimestamp(nested.isExplicitTimestamp());
                nested.setTimestamp(null);
                nested.setExplicitTimestamp(false);
            }
        }
        if ((joinModels = model.getJoinModels()).size() > 1) {
            int n = joinModels.size();
            for (int i = 1; i < n; ++i) {
                this.moveTimestampToChooseModel(joinModels.getQuick(i));
            }
        }
        if ((nested = model.getUnionModel()) != null) {
            this.moveTimestampToChooseModel(nested);
        }
    }

    private void moveWhereInsideSubQueries(QueryModel model) throws SqlException {
        QueryModel nested;
        int i;
        if (model.getSelectModelType() != 5 && model.getSelectModelType() != 3) {
            model.getParsedWhere().clear();
            ObjList<ExpressionNode> nodes = model.parseWhereClause();
            model.setWhereClause(null);
            int n = nodes.size();
            if (n > 0) {
                for (i = 0; i < n; ++i) {
                    ExpressionNode node = nodes.getQuick(i);
                    this.literalCollectorAIndexes.clear();
                    this.literalCollectorANames.clear();
                    this.literalCollector.withModel(model);
                    this.literalCollector.resetCounts();
                    this.traversalAlgo.traverse(node, this.literalCollector.lhs());
                    this.tempList.clear();
                    for (int j = 0; j < this.literalCollectorAIndexes.size(); ++j) {
                        int tableExpressionReference = this.literalCollectorAIndexes.get(j);
                        int position = this.tempList.binarySearchUniqueList(tableExpressionReference);
                        if (position >= 0) continue;
                        this.tempList.insert(-(position + 1), tableExpressionReference);
                    }
                    int distinctIndexes = this.tempList.size();
                    if (this.literalCollectorAIndexes.size() == 0) {
                        this.addWhereNode(model, node);
                        continue;
                    }
                    if (distinctIndexes > 1) {
                        int greatest = this.tempList.get(distinctIndexes - 1);
                        QueryModel m = model.getJoinModels().get(greatest);
                        m.setPostJoinWhereClause(this.concatFilters(m.getPostJoinWhereClause(), nodes.getQuick(i)));
                        continue;
                    }
                    int tableIndex = this.literalCollectorAIndexes.get(0);
                    QueryModel parent = model.getJoinModels().getQuick(tableIndex);
                    int joinType = parent.getJoinType();
                    if (tableIndex > 0 && joinBarriers.contains(joinType)) {
                        QueryModel joinModel = model.getJoinModels().getQuick(tableIndex);
                        joinModel.setPostJoinWhereClause(this.concatFilters(joinModel.getPostJoinWhereClause(), node));
                        continue;
                    }
                    QueryModel nested2 = parent.getNestedModel();
                    if (nested2 == null || nested2.getLatestBy().size() > 0 || nested2.getLimitLo() != null || nested2.getLimitHi() != null || nested2.getUnionModel() != null || nested2.getSampleBy() != null && !this.canPushToSampleBy(nested2, this.literalCollectorANames)) {
                        this.addWhereNode(parent, node);
                        continue;
                    }
                    try {
                        this.traversalAlgo.traverse(node, this.literalCheckingVisitor.of(parent.getAliasToColumnMap()));
                        this.traversalAlgo.traverse(node, this.literalRewritingVisitor.of(parent.getAliasToColumnNameMap()));
                        this.addWhereNode(nested2, node);
                        continue;
                    }
                    catch (NonLiteralException ignore) {
                        this.addWhereNode(parent, node);
                    }
                }
                model.getParsedWhere().clear();
            }
        }
        if ((nested = model.getNestedModel()) != null) {
            this.moveWhereInsideSubQueries(nested);
        }
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int m = joinModels.size();
        for (i = 1; i < m; ++i) {
            nested = joinModels.getQuick(i);
            if (nested == model) continue;
            this.moveWhereInsideSubQueries(nested);
        }
        nested = model.getUnionModel();
        if (nested != null) {
            this.moveWhereInsideSubQueries(nested);
        }
    }

    private QueryColumn nextColumn(CharSequence name) {
        return this.nextColumn(name, 0);
    }

    private QueryColumn nextColumn(CharSequence name, int position) {
        return SqlUtil.nextColumn(this.queryColumnPool, this.expressionNodePool, name, name, position);
    }

    private QueryColumn nextColumn(CharSequence alias, CharSequence column) {
        return SqlUtil.nextColumn(this.queryColumnPool, this.expressionNodePool, alias, column, 0);
    }

    private ExpressionNode nextLiteral(CharSequence token, int position) {
        return SqlUtil.nextLiteral(this.expressionNodePool, token, position);
    }

    private ExpressionNode nextLiteral(CharSequence token) {
        return this.nextLiteral(token, 0);
    }

    private boolean nonAggregateFunctionDependsOn(ExpressionNode node, ExpressionNode timestampNode) {
        if (timestampNode == null) {
            return false;
        }
        CharSequence timestamp = timestampNode.token;
        this.sqlNodeStack.clear();
        while (node != null) {
            if (node.type == 7 && Chars.equalsIgnoreCase(node.token, timestamp)) {
                return true;
            }
            if (node.type != 6 || !this.functionParser.getFunctionFactoryCache().isGroupBy(node.token)) {
                if (node.paramCount < 3) {
                    if (node.lhs != null) {
                        this.sqlNodeStack.push(node.lhs);
                    }
                    if (node.rhs != null) {
                        node = node.rhs;
                        continue;
                    }
                } else {
                    int k = node.paramCount;
                    for (int i = 1; i < k; ++i) {
                        this.sqlNodeStack.push(node.args.getQuick(i));
                    }
                    node = node.args.getQuick(0);
                    continue;
                }
            }
            if (!this.sqlNodeStack.isEmpty()) {
                node = this.sqlNodeStack.poll();
                continue;
            }
            node = null;
        }
        return false;
    }

    private void openReaderAndEnumerateColumns(SqlExecutionContext executionContext, QueryModel model, SqlParserCallback sqlParserCallback) throws SqlException {
        block27: {
            ExpressionNode tableNameExpr = model.getTableNameExpr();
            CharSequence tableName = tableNameExpr.token;
            int tableNamePosition = tableNameExpr.position;
            int lo = 0;
            int hi = tableName.length();
            if (Chars.startsWith(tableName, "*!*")) {
                lo += "*!*".length();
            }
            if (lo == hi) {
                throw SqlException.$(tableNamePosition, "come on, where is the table name?");
            }
            TableToken tableToken = executionContext.getTableTokenIfExists(tableName, lo, hi);
            int status = executionContext.getTableStatus(this.path, tableToken);
            if (status == 1) {
                try {
                    model.getTableNameExpr().type = 6;
                    this.parseFunctionAndEnumerateColumns(model, executionContext, sqlParserCallback);
                    return;
                }
                catch (SqlException e) {
                    throw SqlException.tableDoesNotExist(tableNamePosition, tableName);
                }
            }
            if (status == 2) {
                throw SqlException.$(tableNamePosition, "table directory is of unknown format [table=").put(tableName).put(']');
            }
            if (model.isUpdate()) {
                assert (lo == 0);
                try (TableRecordMetadata metadata = executionContext.getMetadataForWrite(tableToken, model.getMetadataVersion());){
                    this.enumerateColumns(model, metadata);
                    break block27;
                }
                catch (CairoException e) {
                    if (e.isOutOfMemory() || e.isTableDoesNotExist()) {
                        throw e;
                    }
                    throw SqlException.position(tableNamePosition).put(e);
                }
            }
            try (TableReader reader = executionContext.getReader(tableToken);){
                this.enumerateColumns(model, reader.getMetadata());
            }
            catch (EntryLockedException e) {
                throw SqlException.position(tableNamePosition).put("table is locked: ").put(tableToken.getTableName());
            }
            catch (CairoException e) {
                if (e.isOutOfMemory() || e.isTableDoesNotExist()) {
                    throw e;
                }
                throw SqlException.position(tableNamePosition).put(e);
            }
        }
    }

    private ExpressionNode optimiseBooleanNot(ExpressionNode node, boolean reverse) {
        if (node.token != null) {
            block0 : switch (notOps.get(node.token)) {
                case 1: {
                    if (reverse) {
                        return this.optimiseBooleanNot(node.rhs, false);
                    }
                    switch (node.rhs.type) {
                        case 4: 
                        case 7: {
                            break block0;
                        }
                    }
                    return this.optimiseBooleanNot(node.rhs, true);
                }
                case 2: {
                    if (reverse) {
                        node.token = "or";
                    }
                    node.lhs = this.optimiseBooleanNot(node.lhs, reverse);
                    node.rhs = this.optimiseBooleanNot(node.rhs, reverse);
                    break;
                }
                case 3: {
                    if (reverse) {
                        node.token = "and";
                    }
                    node.lhs = this.optimiseBooleanNot(node.lhs, reverse);
                    node.rhs = this.optimiseBooleanNot(node.rhs, reverse);
                    break;
                }
                case 4: {
                    if (!reverse) break;
                    node.token = "<=";
                    break;
                }
                case 5: {
                    if (!reverse) break;
                    node.token = "<";
                    break;
                }
                case 6: {
                    if (!reverse) break;
                    node.token = ">=";
                    break;
                }
                case 7: {
                    if (!reverse) break;
                    node.token = ">";
                    break;
                }
                case 8: {
                    if (!reverse) break;
                    node.token = "!=";
                    break;
                }
                case 9: {
                    if (reverse) {
                        node.token = "=";
                        break;
                    }
                    node.token = "!=";
                    break;
                }
                default: {
                    if (!reverse) break;
                    ExpressionNode n = this.expressionNodePool.next();
                    n.token = "not";
                    n.paramCount = 1;
                    n.rhs = node;
                    n.type = 9;
                    return n;
                }
            }
        }
        return node;
    }

    private void optimiseBooleanNot(QueryModel model) {
        ExpressionNode where = model.getWhereClause();
        if (where != null) {
            model.setWhereClause(this.optimiseBooleanNot(where, false));
        }
        if (model.getNestedModel() != null) {
            this.optimiseBooleanNot(model.getNestedModel());
        }
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 1; i < n; ++i) {
            this.optimiseBooleanNot(joinModels.getQuick(i));
        }
        if (model.getUnionModel() != null && model.getNestedModel() != null) {
            this.optimiseBooleanNot(model.getNestedModel());
        }
    }

    private void optimiseExpressionModels(QueryModel model, SqlExecutionContext executionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        ObjList<QueryModel> joinModels;
        int m;
        ObjList<ExpressionNode> expressionModels = model.getExpressionModels();
        int n = expressionModels.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                QueryModel optimised;
                ExpressionNode node = expressionModels.getQuick(i);
                if (node.queryModel == null || (optimised = this.optimise(node.queryModel, executionContext, sqlParserCallback)) == node.queryModel) continue;
                node.queryModel = optimised;
            }
        }
        if (model.getNestedModel() != null) {
            this.optimiseExpressionModels(model.getNestedModel(), executionContext, sqlParserCallback);
        }
        if ((m = (joinModels = model.getJoinModels()).size()) > 1) {
            for (int i = 1; i < m; ++i) {
                this.optimiseExpressionModels(joinModels.getQuick(i), executionContext, sqlParserCallback);
            }
        }
        if (model.getUnionModel() != null) {
            this.optimiseExpressionModels(model.getUnionModel(), executionContext, sqlParserCallback);
        }
    }

    private void optimiseJoins(QueryModel model) throws SqlException {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        if (n > 1) {
            this.emittedJoinClauses = this.joinClausesSwap1;
            this.emittedJoinClauses.clear();
            ExpressionNode where = model.getWhereClause();
            model.setWhereClause(null);
            this.processJoinConditions(model, where, false, model, -1);
            for (int i = 1; i < n; ++i) {
                this.processJoinConditions(model, joinModels.getQuick(i).getJoinCriteria(), true, joinModels.getQuick(i), i);
            }
            this.processEmittedJoinClauses(model);
            this.createImpliedDependencies(model);
            this.homogenizeCrossJoins(model);
            this.reorderTables(model);
            this.assignFilters(model);
            this.alignJoinClauses(model);
            this.addTransitiveFilters(model);
        }
        for (int i = 0; i < n; ++i) {
            QueryModel m = model.getJoinModels().getQuick(i).getNestedModel();
            if (m != null) {
                this.optimiseJoins(m);
            }
            if ((m = model.getJoinModels().getQuick(i).getUnionModel()) == null) continue;
            this.clearForUnionModelInJoin();
            this.optimiseJoins(m);
        }
    }

    private void optimiseOrderBy(QueryModel model, int topLevelOrderByMnemonic) {
        int orderByMnemonic;
        ObjList<QueryColumn> columns = model.getBottomUpColumns();
        int n = columns.size();
        if (model.getLimitLo() != null) {
            topLevelOrderByMnemonic = 0;
        }
        if (model.getTimestamp() != null) {
            topLevelOrderByMnemonic = 1;
        }
        if (model.getSelectModelType() == 3 && model.getOrderBy().size() > 0) {
            topLevelOrderByMnemonic = 1;
        }
        block0 : switch (topLevelOrderByMnemonic) {
            case 0: {
                orderByMnemonic = model.getOrderBy().size() > 0 && model.getSampleBy() == null ? 2 : 1;
                if (model.getSampleBy() != null || orderByMnemonic == 2) break;
                for (int i = 0; i < n; ++i) {
                    QueryColumn col = columns.getQuick(i);
                    if (!this.hasAggregates(col.getAst())) continue;
                    orderByMnemonic = 2;
                    break block0;
                }
                break;
            }
            case 1: {
                if (model.getOrderBy().size() > 0) {
                    orderByMnemonic = 2;
                    break;
                }
                orderByMnemonic = 1;
                break;
            }
            default: {
                model.getOrderBy().clear();
                orderByMnemonic = model.getSampleBy() != null ? 1 : 2;
            }
        }
        ObjList<ExpressionNode> orderByAdvice = this.getOrderByAdvice(model, orderByMnemonic);
        IntList orderByDirectionAdvice = this.getOrderByAdviceDirection(model, orderByMnemonic);
        if (model.getSelectModelType() == 3 && model.getOrderBy().size() > 0 && model.getOrderByAdvice().size() > 0 && model.getLimitLo() == null) {
            boolean orderChanges = false;
            if (orderByAdvice.size() != model.getOrderByAdvice().size()) {
                orderChanges = true;
            } else {
                int max = orderByAdvice.size();
                for (int i = 0; i < max; ++i) {
                    if (orderByAdvice.getQuick(i).equals(model.getOrderBy().getQuick(i)) && orderByDirectionAdvice.getQuick(i) == model.getOrderByDirection().getQuick(i)) continue;
                    orderChanges = true;
                }
            }
            if (orderChanges) {
                model.setLimit(this.expressionNodePool.next().of(4, LONG_MAX_VALUE_STR, Integer.MIN_VALUE, 0), null);
            }
        }
        ObjList<QueryModel> jm = model.getJoinModels();
        this.pushDownOrderByAdviceToJoinModels(model, jm, orderByMnemonic, orderByDirectionAdvice);
        QueryModel union = model.getUnionModel();
        if (union != null) {
            union.copyOrderByAdvice(orderByAdvice);
            union.copyOrderByDirectionAdvice(orderByDirectionAdvice);
            union.setOrderByAdviceMnemonic(orderByMnemonic);
            this.optimiseOrderBy(union, orderByMnemonic);
        }
    }

    private void parseFunctionAndEnumerateColumns(@NotNull QueryModel model, @NotNull SqlExecutionContext executionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        if (model.getSelectModelType() == 7) {
            RecordCursorFactory tableFactory;
            switch (model.getShowKind()) {
                case 1: {
                    tableFactory = new AllTablesFunctionFactory.AllTablesCursorFactory();
                    break;
                }
                case 2: {
                    TableToken tableToken = executionContext.getTableTokenIfExists(model.getTableNameExpr().token);
                    if (executionContext.getTableStatus(this.path, tableToken) != 0) {
                        throw SqlException.tableDoesNotExist(model.getTableNameExpr().position, model.getTableNameExpr().token);
                    }
                    tableFactory = new ShowColumnsRecordCursorFactory(tableToken, model.getTableNameExpr().position);
                    break;
                }
                case 3: {
                    TableToken tableToken = executionContext.getTableTokenIfExists(model.getTableNameExpr().token);
                    if (executionContext.getTableStatus(this.path, tableToken) != 0) {
                        throw SqlException.tableDoesNotExist(model.getTableNameExpr().position, model.getTableNameExpr().token);
                    }
                    tableFactory = new ShowPartitionsRecordCursorFactory(tableToken);
                    break;
                }
                case 4: 
                case 5: {
                    tableFactory = new ShowTransactionIsolationLevelCursorFactory();
                    break;
                }
                case 6: {
                    tableFactory = new ShowMaxIdentifierLengthCursorFactory();
                    break;
                }
                case 7: {
                    tableFactory = new ShowStandardConformingStringsCursorFactory();
                    break;
                }
                case 8: {
                    tableFactory = new ShowSearchPathCursorFactory();
                    break;
                }
                case 9: {
                    tableFactory = new ShowDateStyleCursorFactory();
                    break;
                }
                case 10: {
                    tableFactory = new ShowTimeZoneFactory();
                    break;
                }
                case 11: {
                    tableFactory = new ShowParametersCursorFactory();
                    break;
                }
                case 12: {
                    tableFactory = new ShowServerVersionCursorFactory();
                    break;
                }
                case 13: {
                    tableFactory = new ShowServerVersionNumCursorFactory();
                    break;
                }
                case 14: {
                    tableFactory = sqlParserCallback.generateShowCreateTableFactory(model, executionContext, this.path);
                    break;
                }
                case 15: {
                    tableFactory = sqlParserCallback.generateShowCreateMatViewFactory(model, executionContext, this.path);
                    break;
                }
                default: {
                    tableFactory = sqlParserCallback.generateShowSqlFactory(model);
                }
            }
            model.setTableNameFunction(tableFactory);
        } else if (model.getTableNameFunction() == null) {
            RecordCursorFactory tableFactory = TableUtils.createCursorFunction(this.functionParser, model, executionContext).getRecordCursorFactory();
            model.setTableNameFunction(tableFactory);
            this.tableFactoriesInFlight.add(tableFactory);
        }
        this.copyColumnsFromMetadata(model, model.getTableNameFunction().getMetadata());
    }

    private void processEmittedJoinClauses(QueryModel model) {
        int k = this.emittedJoinClauses.size();
        for (int i = 0; i < k; ++i) {
            this.addJoinContext(model, this.emittedJoinClauses.getQuick(i));
        }
    }

    private void processJoinConditions(QueryModel parent, ExpressionNode node, boolean innerPredicate, QueryModel joinModel, int joinIndex) throws SqlException {
        ExpressionNode n = node;
        this.sqlNodeStack.clear();
        block5: while (!this.sqlNodeStack.isEmpty() || n != null) {
            if (n != null) {
                switch (joinOps.get(n.token)) {
                    case 1: {
                        this.analyseEquals(parent, n, innerPredicate, joinModel);
                        n = null;
                        continue block5;
                    }
                    case 2: {
                        if (n.rhs != null) {
                            this.sqlNodeStack.push(n.rhs);
                        }
                        n = n.lhs;
                        continue block5;
                    }
                    case 4: {
                        this.analyseRegex(parent, n);
                        if (joinBarriers.contains(joinModel.getJoinType())) {
                            this.addOuterJoinExpression(parent, joinModel, joinIndex, n);
                        } else {
                            parent.addParsedWhereNode(n, innerPredicate);
                        }
                        n = null;
                        continue block5;
                    }
                }
                if (joinBarriers.contains(joinModel.getJoinType())) {
                    this.addOuterJoinExpression(parent, joinModel, joinIndex, n);
                } else {
                    parent.addParsedWhereNode(n, innerPredicate);
                }
                n = null;
                continue;
            }
            n = this.sqlNodeStack.poll();
        }
    }

    private void propagateHintsTo(QueryModel targetModel, LowerCaseCharSequenceObjHashMap<CharSequence> hints) {
        if (targetModel == null) {
            return;
        }
        targetModel.copyHints(hints);
        LowerCaseCharSequenceObjHashMap<CharSequence> h = targetModel.getHints();
        this.propagateHintsTo(targetModel.getNestedModel(), h);
        ObjList<QueryModel> joinModels = targetModel.getJoinModels();
        int n = joinModels.size();
        for (int i = 1; i < n; ++i) {
            this.propagateHintsTo(joinModels.getQuick(i), h);
        }
        this.propagateHintsTo(targetModel.getUnionModel(), h);
    }

    private void propagateTopDownColumns(QueryModel model, boolean allowColumnChange) {
        this.propagateTopDownColumns0(model, true, null, allowColumnChange);
    }

    private void propagateTopDownColumns0(QueryModel model, boolean topLevel, @Nullable QueryModel papaModel, boolean allowColumnsChange) {
        QueryModel unionModel;
        if (!allowColumnsChange && model.getBottomUpColumns().size() > 0) {
            model.copyBottomToTopColumns();
        }
        QueryModel nested = this.skipNoneTypeModels(model.getNestedModel());
        model.setNestedModel(nested);
        boolean nestedIsFlex = SqlOptimiser.modelIsFlex(nested);
        boolean nestedAllowsColumnChange = nested != null && nested.allowsColumnsChange() && model.allowsNestedColumnsChange();
        QueryModel union = this.skipNoneTypeModels(model.getUnionModel());
        if (!topLevel && SqlOptimiser.modelIsFlex(union)) {
            this.emitColumnLiteralsTopDown(model.getColumns(), union);
        }
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 1; i < n; ++i) {
            ExpressionNode leftJoinWhere;
            ExpressionNode postJoinWhere;
            QueryModel jm = joinModels.getQuick(i);
            JoinContext jc = jm.getContext();
            if (jc != null && jc.aIndexes.size() > 0) {
                int z = jc.aIndexes.size();
                for (int k = 0; k < z; ++k) {
                    this.emitLiteralsTopDown(jc.aNodes.getQuick(k), model);
                    this.emitLiteralsTopDown(jc.bNodes.getQuick(k), model);
                    this.emitLiteralsTopDown(jc.aNodes.getQuick(k), jm);
                    this.emitLiteralsTopDown(jc.bNodes.getQuick(k), jm);
                    if (papaModel == null) continue;
                    this.emitLiteralsTopDown(jc.aNodes.getQuick(k), papaModel);
                    this.emitLiteralsTopDown(jc.bNodes.getQuick(k), papaModel);
                }
            }
            if ((postJoinWhere = jm.getPostJoinWhereClause()) != null) {
                this.emitLiteralsTopDown(postJoinWhere, jm);
                this.emitLiteralsTopDown(postJoinWhere, model);
            }
            if ((leftJoinWhere = jm.getOuterJoinExpressionClause()) == null) continue;
            this.emitLiteralsTopDown(leftJoinWhere, jm);
            this.emitLiteralsTopDown(leftJoinWhere, model);
        }
        ExpressionNode postJoinWhere = model.getPostJoinWhereClause();
        if (postJoinWhere != null) {
            this.emitLiteralsTopDown(postJoinWhere, model);
        }
        int n2 = joinModels.size();
        for (int i = 1; i < n2; ++i) {
            QueryModel jm = joinModels.getQuick(i);
            this.propagateTopDownColumns0(jm, false, model, true);
        }
        if (model.getSelectModelType() == 4 && model.getTopDownColumns().size() > 0) {
            ObjList<QueryColumn> bottomUpColumns = model.getBottomUpColumns();
            int n3 = bottomUpColumns.size();
            for (int i = 0; i < n3; ++i) {
                QueryColumn qc = bottomUpColumns.getQuick(i);
                if (qc.getAst().type == 6 && this.functionParser.getFunctionFactoryCache().isGroupBy(qc.getAst().token)) continue;
                model.addTopDownColumn(qc, qc.getAlias());
            }
        }
        if (model.getLatestBy().size() > 0) {
            this.emitLiteralsTopDown(model.getLatestBy(), model);
        }
        if (model.getTimestamp() != null && nestedIsFlex && nestedAllowsColumnChange) {
            this.emitLiteralsTopDown(model.getTimestamp(), nested);
            for (QueryModel unionModel2 = nested.getUnionModel(); unionModel2 != null; unionModel2 = unionModel2.getUnionModel()) {
                this.emitLiteralsTopDown(model.getTimestamp(), unionModel2);
            }
        }
        if (model.getWhereClause() != null) {
            if (allowColumnsChange) {
                this.emitLiteralsTopDown(model.getWhereClause(), model);
            }
            if (nestedAllowsColumnChange) {
                this.emitLiteralsTopDown(model.getWhereClause(), nested);
                for (QueryModel unionModel3 = nested.getUnionModel(); unionModel3 != null; unionModel3 = unionModel3.getUnionModel()) {
                    this.emitLiteralsTopDown(model.getWhereClause(), unionModel3);
                }
            }
        }
        if (!topLevel) {
            this.emitLiteralsTopDown(model.getOrderBy(), model);
        }
        if (nestedIsFlex && nestedAllowsColumnChange) {
            this.emitColumnLiteralsTopDown(model.getColumns(), nested);
            IntList unionColumnIndexes = this.tempList;
            unionColumnIndexes.clear();
            ObjList<QueryColumn> nestedTopDownColumns = nested.getTopDownColumns();
            int n4 = nestedTopDownColumns.size();
            for (int i = 0; i < n4; ++i) {
                unionColumnIndexes.add(nested.getColumnAliasIndex(nestedTopDownColumns.getQuick(i).getAlias()));
            }
            for (QueryModel unionModel4 = nested.getUnionModel(); unionModel4 != null; unionModel4 = unionModel4.getUnionModel()) {
                ObjList<QueryColumn> cols = unionModel4.getBottomUpColumns();
                int n5 = unionColumnIndexes.size();
                for (int i = 0; i < n5; ++i) {
                    QueryColumn qc = cols.getQuick(unionColumnIndexes.getQuick(i));
                    unionModel4.addTopDownColumn(qc, qc.getAlias());
                }
            }
        }
        if (nested != null) {
            this.propagateTopDownColumns0(nested, false, null, nestedAllowsColumnChange);
        }
        if ((unionModel = model.getUnionModel()) != null) {
            this.propagateTopDownColumns(unionModel, allowColumnsChange);
        }
    }

    private void pushDownOrderByAdviceToJoinModels(QueryModel model, ObjList<QueryModel> jm, int orderByMnemonic, IntList orderByDirectionAdvice) {
        boolean orderByAdviceHasDot;
        if (model == null) {
            return;
        }
        QueryModel jm1 = jm.getQuiet(0);
        QueryModel queryModel = jm1 = jm1 != null ? jm1.getNestedModel() : null;
        if (jm1 == null) {
            return;
        }
        QueryModel jm2 = jm1.getJoinModels().getQuiet(1);
        if (model.getGroupBy().size() != 0 || model.getSampleBy() != null || model.getSelectModelType() == 5 || model.windowStopPropagate()) {
            jm1.setAllowPropagationOfOrderByAdvice(false);
            if (jm2 != null) {
                jm2.setAllowPropagationOfOrderByAdvice(false);
            }
        }
        if (!(orderByAdviceHasDot = this.checkForDot(this.orderByAdvice))) {
            if (this.allAdviceIsForThisTable(jm1, this.orderByAdvice)) {
                orderByMnemonic = this.setAndCopyAdvice(jm1, this.orderByAdvice, orderByMnemonic, orderByDirectionAdvice);
            }
            this.optimiseOrderBy(jm1, orderByMnemonic);
            return;
        }
        if (!this.checkForConsistentPrefix(this.orderByAdvice)) {
            return;
        }
        CharSequence adviceToken = this.orderByAdvice.getQuick((int)0).token;
        int dotLoc = Chars.indexOfLastUnquoted(adviceToken, '.');
        if (!(Chars.equalsNc(jm1.getTableName(), adviceToken, 0, dotLoc) || jm1.getAlias() != null && Chars.equals(jm1.getAlias().token, adviceToken, 0, dotLoc))) {
            this.optimiseOrderBy(jm1, orderByMnemonic);
            return;
        }
        ObjList<ExpressionNode> advice = this.duplicateAdviceAndTakeSuffix();
        if (jm2 != null) {
            int joinType = jm2.getJoinType();
            switch (joinType) {
                case 4: 
                case 6: {
                    orderByMnemonic = 0;
                    break;
                }
                default: {
                    orderByMnemonic = this.setAndCopyAdvice(jm1, advice, orderByMnemonic, orderByDirectionAdvice);
                    break;
                }
            }
        } else {
            orderByMnemonic = this.setAndCopyAdvice(jm1, advice, orderByMnemonic, orderByDirectionAdvice);
        }
        this.optimiseOrderBy(jm1, orderByMnemonic);
    }

    private void pushLimitFromChooseToNone(QueryModel model, SqlExecutionContext executionContext) throws SqlException {
        long limitValue;
        Function loFunction;
        if (model == null) {
            return;
        }
        QueryModel nested = model.getNestedModel();
        if (model.getSelectModelType() == 1 && model.getLimitLo() != null && model.getLimitHi() == null && model.getUnionModel() == null && model.getJoinModels().size() == 1 && model.getGroupBy().size() == 0 && model.getSampleBy() == null && !model.isDistinct() && this.hasNoAggregateQueryColumns(model) && nested != null && nested.getSelectModelType() == 0 && nested.getOrderBy().size() > 1 && nested.getWhereClause() == null && nested.getTimestamp() != null && Chars.equalsIgnoreCase(nested.getTimestamp().token, nested.getOrderBy().get((int)0).token) && nested.getOrderByDirection().get(0) == 1 && (loFunction = this.getLoFunction(model.getLimitLo(), executionContext)) != null && (loFunction.isConstant() || loFunction.isRuntimeConstant()) && (limitValue = loFunction.getLong(null)) > 0L && limitValue >= (long)(-executionContext.getCairoEngine().getConfiguration().getSqlMaxNegativeLimit())) {
            nested.setLimit(model.getLimitLo(), null);
            model.setLimit(null, null);
            if (nested.getOrderByAdvice().size() == 0) {
                int n = nested.getOrderBy().size();
                for (int i = 0; i < n; ++i) {
                    nested.getOrderByAdvice().add(nested.getOrderBy().get(i));
                    nested.getOrderByDirectionAdvice().add(nested.getOrderByDirection().get(i));
                }
                nested.setAllowPropagationOfOrderByAdvice(false);
            }
        } else {
            this.pushLimitFromChooseToNone(model.getNestedModel(), executionContext);
        }
    }

    private ExpressionNode pushOperationOutsideAgg(ExpressionNode agg, ExpressionNode op, ExpressionNode column, ExpressionNode constant, QueryModel model) {
        QueryColumn qc = this.checkSimpleIntegerColumn(column, model);
        if (qc == null) {
            return agg;
        }
        agg.rhs = column;
        ExpressionNode count = this.expressionNodePool.next();
        count.token = "COUNT";
        count.type = 6;
        if (qc.getColumnType() == 5 || qc.getColumnType() == 6) {
            count.paramCount = 1;
            count.rhs = column;
        } else {
            count.paramCount = 0;
        }
        count.position = agg.position;
        OperatorExpression mulOp = OperatorExpression.chooseRegistry(this.configuration.getCairoSqlLegacyOperatorPrecedence()).getOperatorDefinition("*");
        ExpressionNode mul = this.expressionNodePool.next().of(9, mulOp.operator.token, mulOp.precedence, agg.position);
        mul.paramCount = 2;
        mul.lhs = count;
        mul.rhs = constant;
        if (op.lhs == column) {
            op.lhs = agg;
            op.rhs = mul;
        } else {
            op.lhs = mul;
            op.rhs = agg;
        }
        return op;
    }

    private void reorderTables(QueryModel model) {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        this.tempCrosses.clear();
        for (int i = 0; i < n; ++i) {
            QueryModel q = joinModels.getQuick(i);
            if (q.getContext() != null && q.getContext().parents.size() != 0) continue;
            this.tempCrosses.add(i);
        }
        int cost = Integer.MAX_VALUE;
        int root = -1;
        int zc = this.tempCrosses.size();
        for (int z = 0; z < zc; ++z) {
            for (int i = 0; i < zc; ++i) {
                int k;
                if (z == i) continue;
                int to = this.tempCrosses.getQuick(i);
                JoinContext jc = joinModels.getQuick(to).getContext();
                for (k = i - 1; k > -1 && this.swapJoinOrder(model, to, k, jc); --k) {
                }
                for (k = i + 1; k < n && this.swapJoinOrder(model, to, k, jc); ++k) {
                }
            }
            IntList ordered = model.nextOrderedJoinModels();
            int thisCost = this.doReorderTables(model, ordered);
            if (thisCost >= cost && root != -1) continue;
            root = z;
            cost = thisCost;
            model.setOrderedJoinModels(ordered);
        }
        assert (root != -1);
    }

    private ExpressionNode replaceColumnWithAlias(ExpressionNode node, QueryModel model) throws SqlException {
        int dot;
        CharSequence col;
        CharSequence alias;
        if (node != null && node.type == 7 && (alias = this.validateColumnAndGetAlias(model, col = node.token, dot = Chars.indexOfLastUnquoted(col, '.'), node.position)) != null) {
            return this.expressionNodePool.next().of(7, alias, node.precedence, node.position);
        }
        return node;
    }

    private void replaceColumnsWithAliases(ExpressionNode node, QueryModel model) throws SqlException {
        this.sqlNodeStack.clear();
        ExpressionNode temp = this.replaceColumnWithAlias(node, model);
        if (temp != node) {
            node.of(7, temp.token, node.precedence, node.position);
            return;
        }
        while (!this.sqlNodeStack.isEmpty() || node != null) {
            if (node != null) {
                if (node.paramCount < 3) {
                    if (node.rhs != null) {
                        temp = this.replaceColumnWithAlias(node.rhs, model);
                        if (node.rhs == temp) {
                            this.sqlNodeStack.push(node.rhs);
                        } else {
                            node.rhs = temp;
                        }
                    }
                    if (node.lhs != null) {
                        temp = this.replaceColumnWithAlias(node.lhs, model);
                        if (temp == node.lhs) {
                            node = node.lhs;
                            continue;
                        }
                        node.lhs = temp;
                        node = null;
                        continue;
                    }
                    node = null;
                    continue;
                }
                int k = node.paramCount;
                for (int i = 1; i < k; ++i) {
                    ExpressionNode e = node.args.getQuick(i);
                    if (e == (temp = this.replaceColumnWithAlias(e, model))) {
                        this.sqlNodeStack.push(e);
                        continue;
                    }
                    node.args.setQuick(i, temp);
                }
                ExpressionNode e = node.args.getQuick(0);
                if (e == (temp = this.replaceColumnWithAlias(e, model))) {
                    node = e;
                    continue;
                }
                node.args.setQuick(0, temp);
                node = null;
                continue;
            }
            node = this.sqlNodeStack.poll();
        }
    }

    private ExpressionNode replaceIfAggregateOrLiteral(ExpressionNode node, QueryModel groupByModel, QueryModel translatingModel, QueryModel innerVirtualModel, QueryModel baseModel, ObjList<ExpressionNode> groupByNodes, ObjList<CharSequence> groupByAliases) throws SqlException {
        if (node != null && (node.type == 6 && this.functionParser.getFunctionFactoryCache().isGroupBy(node.token) || node.type == 7)) {
            CharSequence alias = this.findColumnByAst(groupByNodes, groupByAliases, node);
            if (alias == null) {
                QueryColumn qc = this.queryColumnPool.next().of(this.createColumnAlias(node, groupByModel), node);
                groupByModel.addBottomUpColumn(qc);
                alias = qc.getAlias();
                groupByNodes.add(ExpressionNode.deepClone(this.expressionNodePool, node));
                groupByAliases.add(alias);
                if (node.type == 7) {
                    this.doReplaceLiteral(node, translatingModel, innerVirtualModel, true, baseModel, false);
                }
            }
            return this.nextLiteral(alias);
        }
        return node;
    }

    private ExpressionNode replaceIfCursor(ExpressionNode node, QueryModel cursorModel, @Nullable QueryModel innerVirtualModel, QueryModel translatingModel, QueryModel baseModel, SqlExecutionContext sqlExecutionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        if (node != null && this.functionParser.getFunctionFactoryCache().isCursor(node.token)) {
            return this.nextLiteral(this.addCursorFunctionAsCrossJoin(node, null, cursorModel, innerVirtualModel, translatingModel, baseModel, sqlExecutionContext, sqlParserCallback).getAlias());
        }
        return node;
    }

    private ExpressionNode replaceIfGroupByExpressionOrAggregate(ExpressionNode node, QueryModel groupByModel, ObjList<ExpressionNode> groupByNodes, ObjList<CharSequence> groupByAliases) throws SqlException {
        CharSequence alias = this.findColumnByAst(groupByNodes, groupByAliases, node);
        if (alias != null) {
            return this.nextLiteral(alias);
        }
        if (node.type == 6 && this.functionParser.getFunctionFactoryCache().isGroupBy(node.token)) {
            QueryColumn qc = this.queryColumnPool.next().of(this.createColumnAlias(node, groupByModel), node);
            groupByModel.addBottomUpColumn(qc);
            return this.nextLiteral(qc.getAlias());
        }
        if (node.type == 7) {
            throw SqlException.$(node.position, "column must appear in GROUP BY clause or aggregate function");
        }
        return node;
    }

    private ExpressionNode replaceLiteral(ExpressionNode node, QueryModel translatingModel, QueryModel innerVirtualModel, boolean addColumnToInnerVirtualModel, QueryModel baseModel, boolean windowCall) throws SqlException {
        if (node != null && node.type == 7) {
            try {
                return this.doReplaceLiteral(node, translatingModel, innerVirtualModel, addColumnToInnerVirtualModel, baseModel, windowCall);
            }
            catch (SqlException e) {
                if (this.functionParser.findNoArgFunction(node)) {
                    node.type = 6;
                }
                throw e;
            }
        }
        return node;
    }

    private void replaceLiteralList(QueryModel innerVirtualModel, QueryModel translatingModel, QueryModel baseModel, ObjList<ExpressionNode> list) throws SqlException {
        int n = list.size();
        for (int j = 0; j < n; ++j) {
            ExpressionNode node = list.getQuick(j);
            this.emitLiterals(node, translatingModel, innerVirtualModel, true, baseModel, true);
            list.setQuick(j, this.replaceLiteral(node, translatingModel, innerVirtualModel, true, baseModel, true));
        }
    }

    private void resolveJoinColumns(QueryModel model) throws SqlException {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int size = joinModels.size();
        CharSequence modelAlias = this.setAndGetModelAlias(model);
        this.collectModelAlias(model, 0, model);
        if (size > 1) {
            for (int i = 1; i < size; ++i) {
                QueryModel jm = joinModels.getQuick(i);
                ObjList<ExpressionNode> jc = jm.getJoinColumns();
                int joinColumnsSize = jc.size();
                if (joinColumnsSize > 0) {
                    CharSequence jmAlias = this.setAndGetModelAlias(jm);
                    ExpressionNode joinCriteria = jm.getJoinCriteria();
                    for (int j = 0; j < joinColumnsSize; ++j) {
                        ExpressionNode node = jc.getQuick(j);
                        ExpressionNode eq = this.makeOperation("=", this.makeModelAlias(modelAlias, node), this.makeModelAlias(jmAlias, node));
                        joinCriteria = joinCriteria == null ? eq : this.makeOperation("and", joinCriteria, eq);
                    }
                    jm.setJoinCriteria(joinCriteria);
                }
                this.resolveJoinColumns(jm);
                this.collectModelAlias(model, i, jm);
            }
        }
        if (model.getNestedModel() != null) {
            this.resolveJoinColumns(model.getNestedModel());
        }
        if (model.getUnionModel() != null) {
            this.resolveJoinColumns(model.getUnionModel());
        }
    }

    private ExpressionNode rewriteAggregate(ExpressionNode agg, QueryModel model) {
        if (agg == null) {
            return null;
        }
        ExpressionNode op = agg.rhs;
        if (op != null && agg.type == 6 && this.functionParser.getFunctionFactoryCache().isGroupBy(agg.token) && Chars.equalsIgnoreCase("sum", agg.token) && op.type == 9) {
            if (Chars.equals(op.token, '*')) {
                if (this.isIntegerConstant(op.rhs) && this.isSimpleIntegerColumn(op.lhs, model)) {
                    agg.rhs = op.lhs;
                    op.lhs = agg;
                    return op;
                }
                if (this.isIntegerConstant(op.lhs) && this.isSimpleIntegerColumn(op.rhs, model)) {
                    agg.rhs = op.rhs;
                    op.rhs = agg;
                    return op;
                }
            } else if (Chars.equals(op.token, '+') || Chars.equals(op.token, '-')) {
                if (this.isIntegerConstant(op.rhs)) {
                    return this.pushOperationOutsideAgg(agg, op, op.lhs, op.rhs, model);
                }
                if (this.isIntegerConstant(op.lhs)) {
                    return this.pushOperationOutsideAgg(agg, op, op.rhs, op.lhs, model);
                }
            }
        }
        return agg;
    }

    private void rewriteCount(QueryModel model) {
        if (model == null) {
            return;
        }
        if (model.getModelType() == 1) {
            ObjList<QueryColumn> columns = model.getBottomUpColumns();
            int columnCount = columns.size();
            for (int i = 0; i < columnCount; ++i) {
                ExpressionNode expr = columns.getQuick(i).getAst();
                if (!SqlKeywords.isCountKeyword(expr.token) || expr.paramCount != 1 || expr.rhs.type != 4 || SqlKeywords.isNullKeyword(expr.rhs.token)) continue;
                expr.rhs = null;
                expr.paramCount = 0;
            }
        }
        this.rewriteCount(model.getNestedModel());
        this.rewriteCount(model.getUnionModel());
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 1; i < n; ++i) {
            this.rewriteCount(joinModels.getQuick(i));
        }
    }

    private void rewriteCountDistinct(QueryModel model) throws SqlException {
        QueryModel union;
        QueryModel nested = model.getNestedModel();
        if (nested != null && nested.getNestedModel() == null && nested.getTableName() != null && model.getColumns().size() == 1) {
            ExpressionNode countDistinctExpr = model.getColumns().getQuick(0).getAst();
            if (countDistinctExpr.type == 6 && Chars.equalsIgnoreCase("count_distinct", countDistinctExpr.token) && countDistinctExpr.paramCount == 1 && countDistinctExpr.rhs != null && countDistinctExpr.rhs.type != 4 && !SqlOptimiser.isSymbolColumn(countDistinctExpr, nested) && model.getJoinModels().size() == 1 && model.getWhereClause() == null && model.getSampleBy() == null && model.getGroupBy().size() == 0) {
                ExpressionNode distinctExpr = countDistinctExpr.rhs;
                QueryModel middle = this.queryModelPool.next();
                middle.setNestedModel(nested);
                middle.setSelectModelType(4);
                model.setNestedModel(middle);
                CharSequence innerAlias = this.createColumnAlias(distinctExpr.token, middle, true);
                QueryColumn qc = this.queryColumnPool.next().of(innerAlias, distinctExpr);
                middle.addBottomUpColumn(qc);
                ExpressionNode nullExpr = this.expressionNodePool.next();
                nullExpr.type = 4;
                nullExpr.token = "null";
                nullExpr.precedence = 0;
                OperatorExpression neqOp = OperatorExpression.chooseRegistry(this.configuration.getCairoSqlLegacyOperatorPrecedence()).getOperatorDefinition("!=");
                ExpressionNode node = this.expressionNodePool.next().of(9, neqOp.operator.token, neqOp.precedence, 0);
                node.paramCount = 2;
                node.lhs = nullExpr;
                node.rhs = distinctExpr;
                nested.setWhereClause(this.concatFilters(nested.getWhereClause(), node));
                middle.addGroupBy(distinctExpr);
                countDistinctExpr.token = "count";
                countDistinctExpr.paramCount = 0;
                countDistinctExpr.rhs = null;
            }
        }
        if (nested != null) {
            this.rewriteCountDistinct(nested);
        }
        if ((union = model.getUnionModel()) != null) {
            this.rewriteCountDistinct(union);
        }
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 1; i < n; ++i) {
            this.rewriteCountDistinct(joinModels.getQuick(i));
        }
    }

    private QueryModel rewriteDistinct(QueryModel model) throws SqlException {
        if (model == null) {
            return null;
        }
        if (model.isDistinct()) {
            QueryModel wrapperNested = this.queryModelPool.next();
            wrapperNested.setNestedModel(model);
            QueryModel wrapperModel = this.queryModelPool.next();
            wrapperModel.setNestedModel(wrapperNested);
            ObjList<QueryColumn> bottomUpColumns = model.getBottomUpColumns();
            boolean abandonRewrite = false;
            int n = bottomUpColumns.size();
            for (int i = 0; i < n; ++i) {
                QueryColumn qc = bottomUpColumns.getQuick(i);
                ExpressionNode ast = qc.getAst();
                CharSequence alias = qc.getAlias();
                if (qc.isWindowColumn() || ast.type == 6 && this.functionParser.getFunctionFactoryCache().isGroupBy(ast.token)) {
                    abandonRewrite = true;
                    break;
                }
                if (alias == ast.token && ast.type != 6 && ast.type != 1 && ast.type != 2) {
                    wrapperModel.addBottomUpColumn(qc);
                    continue;
                }
                wrapperModel.addBottomUpColumn(this.queryColumnPool.next().of(alias, this.nextLiteral(alias)));
            }
            if (!abandonRewrite) {
                model.setDistinct(false);
                ExpressionNode countAst = this.expressionNodePool.next();
                countAst.token = "count";
                countAst.paramCount = 0;
                countAst.type = 6;
                QueryColumn countColumn = this.queryColumnPool.next();
                countColumn.of(this.createColumnAlias("count", model), countAst, false, -1);
                model.getBottomUpColumns().add(countColumn);
                wrapperModel.setAlias(model.getAlias());
                wrapperModel.setTimestamp(model.getTimestamp());
                wrapperNested.setAlias(model.getAlias());
                wrapperNested.setTimestamp(model.getTimestamp());
                model.getNestedModel().setNestedModel(this.rewriteDistinct(model.getNestedModel().getNestedModel()));
                wrapperModel.setUnionModel(this.rewriteDistinct(model.getUnionModel()));
                wrapperModel.setSetOperationType(model.getSetOperationType());
                model.setUnionModel(null);
                model.setSetOperationType(0);
                return wrapperModel;
            }
        }
        model.setNestedModel(this.rewriteDistinct(model.getNestedModel()));
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 1; i < n; ++i) {
            joinModels.setQuick(i, this.rewriteDistinct(joinModels.getQuick(i)));
        }
        model.setUnionModel(this.rewriteDistinct(model.getUnionModel()));
        return model;
    }

    private ExpressionNode rewriteGroupBySelectExpression(ExpressionNode topLevelNode, QueryModel groupByModel, ObjList<ExpressionNode> groupByNodes, ObjList<CharSequence> groupByAliases) throws SqlException {
        this.sqlNodeStack.clear();
        ExpressionNode temp = this.replaceIfGroupByExpressionOrAggregate(topLevelNode, groupByModel, groupByNodes, groupByAliases);
        if (temp != topLevelNode) {
            return temp;
        }
        ExpressionNode node = topLevelNode;
        while (!this.sqlNodeStack.isEmpty() || node != null) {
            if (node != null) {
                if (node.paramCount < 3) {
                    if (node.rhs != null) {
                        temp = this.replaceIfGroupByExpressionOrAggregate(node.rhs, groupByModel, groupByNodes, groupByAliases);
                        if (node.rhs == temp) {
                            this.sqlNodeStack.push(node.rhs);
                        } else {
                            node.rhs = temp;
                        }
                    }
                    if (node.lhs != null) {
                        temp = this.replaceIfGroupByExpressionOrAggregate(node.lhs, groupByModel, groupByNodes, groupByAliases);
                        if (temp == node.lhs) {
                            node = node.lhs;
                            continue;
                        }
                        node.lhs = temp;
                        node = null;
                        continue;
                    }
                    node = null;
                    continue;
                }
                int k = node.paramCount;
                for (int i = 1; i < k; ++i) {
                    ExpressionNode e = node.args.getQuick(i);
                    if (e == (temp = this.replaceIfGroupByExpressionOrAggregate(e, groupByModel, groupByNodes, groupByAliases))) {
                        this.sqlNodeStack.push(e);
                        continue;
                    }
                    node.args.setQuick(i, temp);
                }
                ExpressionNode e = node.args.getQuick(0);
                if (e == (temp = this.replaceIfGroupByExpressionOrAggregate(e, groupByModel, groupByNodes, groupByAliases))) {
                    node = e;
                    continue;
                }
                node.args.setQuick(0, temp);
                node = null;
                continue;
            }
            node = this.sqlNodeStack.poll();
        }
        return topLevelNode;
    }

    private void rewriteMultipleTermLimitedOrderByPart1(QueryModel model) {
        if (model != null) {
            if (model.getSelectModelType() == 1 && model.getNestedModel() != null && model.getNestedModel().getSelectModelType() == 0 && model.getNestedModel().getOrderBy() != null && model.getNestedModel().getOrderBy().size() > 1 && model.getNestedModel().getTimestamp() != null && model.getLimitLo() != null && model.getLimitHi() == null && Chars.equals(model.getLimitLo().token, '-')) {
                int i;
                QueryModel nested = model.getNestedModel();
                int firstOrderByDir = nested.getOrderByDirection().get(0);
                if (firstOrderByDir != 0) {
                    return;
                }
                ExpressionNode firstOrderByArg = nested.getOrderBy().get(0);
                if (!Chars.equalsIgnoreCase(firstOrderByArg.token, nested.getTimestamp().token)) {
                    return;
                }
                int n = nested.getOrderBy().size();
                for (i = 0; i < n; ++i) {
                    model.addOrderBy(nested.getOrderBy().get(i), nested.getOrderByDirection().get(i));
                }
                if (nested.getOrderByAdvice().size() == 0) {
                    n = nested.getOrderBy().size();
                    for (i = 0; i < n; ++i) {
                        nested.getOrderByAdvice().add(nested.getOrderBy().get(i));
                        int orderDirection = nested.getOrderByDirection().get(i) == 1 ? 0 : 1;
                        nested.getOrderByDirectionAdvice().add(orderDirection);
                        nested.getOrderByDirection().setQuick(i, orderDirection);
                    }
                    nested.getOrderByDirection().set(0, 1);
                } else {
                    nested.getOrderByDirectionAdvice().set(0, 1);
                }
                nested.setAllowPropagationOfOrderByAdvice(false);
                nested.setLimit(model.getLimitLo().rhs, null);
                model.setLimit(null, null);
                this.rewriteMultipleTermLimitedOrderByPart1(nested.getNestedModel());
            } else {
                this.rewriteMultipleTermLimitedOrderByPart1(model.getNestedModel());
            }
            ObjList<QueryModel> joinModels = model.getJoinModels();
            int n = joinModels.size();
            for (int i = 1; i < n; ++i) {
                this.rewriteMultipleTermLimitedOrderByPart1(joinModels.getQuick(i));
            }
            this.rewriteMultipleTermLimitedOrderByPart1(model.getUnionModel());
        }
    }

    private void rewriteMultipleTermLimitedOrderByPart2(QueryModel model) {
        if (model == null) {
            return;
        }
        if (model.getModelType() == 0 || model.getModelType() == 1) {
            IntList direction = model.getOrderByDirectionAdvice();
            boolean orderDescendingByDesignatedTimestampOnly = direction.size() < 1 ? false : model.getOrderByAdvice().size() == 1 && model.getTimestamp() != null && Chars.equalsIgnoreCase(model.getOrderByAdvice().getQuick((int)0).token, model.getTimestamp().token) && direction.get(0) == 1;
            model.setOrderDescendingByDesignatedTimestampOnly(orderDescendingByDesignatedTimestampOnly);
            model.setForceBackwardScan(orderDescendingByDesignatedTimestampOnly || model.getOrderByAdvice().size() > 1 && model.getTimestamp() != null && Chars.equalsIgnoreCase(model.getOrderByAdvice().getQuick((int)0).token, model.getTimestamp().token) && model.getLimitLo() != null && !Chars.equals(model.getLimitLo().token, '-'));
        }
        this.rewriteMultipleTermLimitedOrderByPart2(model.getNestedModel());
        this.rewriteMultipleTermLimitedOrderByPart2(model.getUnionModel());
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 1; i < n; ++i) {
            this.rewriteMultipleTermLimitedOrderByPart2(joinModels.getQuick(i));
        }
    }

    private QueryModel rewriteOrderBy(QueryModel model) throws SqlException {
        QueryModel rewritten;
        QueryModel union;
        QueryModel rewritten2;
        QueryModel nested;
        QueryModel result = model;
        QueryModel base = model;
        QueryModel baseParent = model;
        QueryModel wrapper = null;
        QueryModel limitModel = model;
        int modelColumnCount = model.getBottomUpColumns().size();
        boolean groupByOrDistinct = false;
        while (base.getBottomUpColumns().size() > 0 && !base.isNestedModelIsSubQuery()) {
            QueryModel rewritten3;
            baseParent = base;
            QueryModel union2 = base.getUnionModel();
            if (union2 != null && (rewritten3 = this.rewriteOrderBy(union2)) != union2) {
                base.setUnionModel(rewritten3);
            }
            if ((base = base.getNestedModel()).getLimitLo() != null) {
                limitModel = base;
            }
            int selectModelType = baseParent.getSelectModelType();
            groupByOrDistinct = groupByOrDistinct || selectModelType == 4 || selectModelType == 5;
        }
        ObjList<ExpressionNode> orderByNodes = base.getOrderBy();
        int sz = orderByNodes.size();
        if (sz > 0) {
            for (int i = 0; i < sz; ++i) {
                ExpressionNode orderBy = orderByNodes.getQuick(i);
                CharSequence column = orderBy.token;
                int dot = Chars.indexOfLastUnquoted(column, '.');
                if (dot > -1 || model.getAliasToColumnMap().excludes(column)) {
                    this.validateColumnAndGetModelIndex(base, null, column, dot, orderBy.position, false);
                    if (base != model) {
                        QueryColumn qc;
                        QueryColumn qc2;
                        LowerCaseCharSequenceObjHashMap<CharSequence> map = baseParent.getColumnNameToAliasMap();
                        CharSequence alias = null;
                        int index = map.keyIndex(column);
                        if (index > -1 && dot > -1) {
                            index = map.keyIndex(column, dot + 1, column.length());
                        }
                        if (index > -1 && (qc2 = this.getQueryColumn(baseParent, column, dot)) != null) {
                            index = map.keyIndex(qc2.getAst().token);
                        }
                        if (index < 0) {
                            orderBy.token = map.valueAtQuick(index);
                            this.tempQueryModel = null;
                            this.tempColumnAlias = null;
                            if (limitModel != baseParent) {
                                CharSequence translatedColumnAlias = this.getTranslatedColumnAlias(limitModel, baseParent, orderBy.token);
                                if (translatedColumnAlias == null) {
                                    alias = SqlUtil.createColumnAlias(this.characterStore, this.tempColumnAlias, Chars.indexOfLastUnquoted(this.tempColumnAlias, '.'), this.tempQueryModel.getAliasToColumnMap());
                                    this.tempQueryModel.addBottomUpColumn(this.nextColumn(alias, this.tempColumnAlias));
                                    for (QueryModel m = limitModel; m != this.tempQueryModel; m = m.getNestedModel()) {
                                        m.addBottomUpColumn(this.nextColumn(alias));
                                    }
                                    this.tempQueryModel = null;
                                    this.tempColumnAlias = null;
                                    orderBy.token = alias;
                                    if (limitModel == model && wrapper == null) {
                                        wrapper = this.queryModelPool.next();
                                        wrapper.setSelectModelType(1);
                                        for (int j = 0; j < modelColumnCount; ++j) {
                                            qc = model.getBottomUpColumns().getQuick(j);
                                            wrapper.addBottomUpColumn(this.nextColumn(qc.getAlias()));
                                        }
                                        result = wrapper;
                                        wrapper.setNestedModel(model);
                                    }
                                } else {
                                    orderBy.token = translatedColumnAlias;
                                }
                            }
                        } else {
                            if (dot > -1 && !base.getModelAliasIndexes().contains(column, 0, dot)) {
                                throw SqlException.invalidColumn(orderBy.position, column);
                            }
                            if (groupByOrDistinct) {
                                throw SqlException.position(orderBy.position).put("ORDER BY expressions must appear in select list. ").put("Invalid column: ").put(column);
                            }
                            if (dot > -1 && base.getModelAliasIndexes().contains(column, 0, dot) && base.getModelAliasIndexes().size() == 1) {
                                column = column.subSequence(dot + 1, column.length());
                                dot = -1;
                            }
                            if (baseParent.getSelectModelType() != 1) {
                                QueryModel synthetic = this.queryModelPool.next();
                                synthetic.setSelectModelType(1);
                                int z = baseParent.getBottomUpColumns().size();
                                for (int j = 0; j < z; ++j) {
                                    qc = baseParent.getBottomUpColumns().getQuick(j);
                                    if (qc.getAst().type == 6 || qc.getAst().type == 9) {
                                        this.emitLiterals(qc.getAst(), synthetic, null, false, baseParent.getNestedModel(), false);
                                        continue;
                                    }
                                    synthetic.addBottomUpColumnIfNotExists(qc);
                                }
                                synthetic.setNestedModel(base);
                                baseParent.setNestedModel(synthetic);
                                baseParent = synthetic;
                                index = synthetic.getColumnNameToAliasMap().keyIndex(column);
                                if (index < 0) {
                                    alias = synthetic.getColumnNameToAliasMap().valueAtQuick(index);
                                }
                            }
                            if (alias == null) {
                                alias = SqlUtil.createColumnAlias(this.characterStore, column, dot, baseParent.getAliasToColumnMap());
                                baseParent.addBottomUpColumn(this.nextColumn(alias, column));
                            }
                            if (model != baseParent) {
                                QueryModel m = model;
                                do {
                                    m.addBottomUpColumn(this.nextColumn(alias));
                                } while ((m = m.getNestedModel()) != baseParent);
                            }
                            orderBy.token = alias;
                            if (wrapper == null) {
                                wrapper = this.queryModelPool.next();
                                wrapper.setSelectModelType(1);
                                for (int j = 0; j < modelColumnCount; ++j) {
                                    QueryColumn qc3 = model.getBottomUpColumns().getQuick(j);
                                    wrapper.addBottomUpColumn(this.nextColumn(qc3.getAlias()));
                                }
                                result = wrapper;
                                wrapper.setNestedModel(model);
                            }
                        }
                    }
                }
                if (base == baseParent || base == limitModel) continue;
                limitModel.addOrderBy(orderBy, base.getOrderByDirection().getQuick(i));
            }
            if (base != model && base != limitModel) {
                base.clearOrderBy();
            }
        }
        if ((nested = base.getNestedModel()) != null && (rewritten2 = this.rewriteOrderBy(nested)) != nested) {
            base.setNestedModel(rewritten2);
        }
        if ((union = base.getUnionModel()) != null && (rewritten = this.rewriteOrderBy(union)) != union) {
            base.setUnionModel(rewritten);
        }
        ObjList<QueryModel> joinModels = base.getJoinModels();
        int n = joinModels.size();
        for (int i = 1; i < n; ++i) {
            this.rewriteOrderBy(joinModels.getQuick(i));
        }
        return result;
    }

    private void rewriteOrderByPosition(QueryModel model) throws SqlException {
        QueryModel nested;
        int i;
        QueryModel base = model;
        QueryModel baseParent = model;
        QueryModel baseGroupBy = null;
        QueryModel baseOuter = null;
        QueryModel baseDistinct = null;
        while (base.getBottomUpColumns().size() > 0) {
            if (!base.isSelectTranslation()) {
                baseParent = base;
            }
            switch (base.getSelectModelType()) {
                case 5: {
                    baseDistinct = base;
                    break;
                }
                case 4: {
                    baseGroupBy = base;
                    break;
                }
                case 1: 
                case 2: {
                    QueryModel nested2 = base.getNestedModel();
                    if (nested2 == null || nested2.getSelectModelType() != 4) break;
                    baseOuter = base;
                }
            }
            base = base.getNestedModel();
        }
        if (baseDistinct != null) {
            baseParent = baseDistinct;
        } else if (baseOuter != null) {
            baseParent = baseOuter;
        } else if (baseGroupBy != null) {
            baseParent = baseGroupBy;
        }
        ObjList<ExpressionNode> orderByNodes = base.getOrderBy();
        int sz = orderByNodes.size();
        if (sz > 0) {
            ObjList<QueryColumn> columns = baseParent.getBottomUpColumns();
            int columnCount = columns.size();
            for (i = 0; i < sz; ++i) {
                ExpressionNode orderBy = orderByNodes.getQuick(i);
                CharSequence column = orderBy.token;
                char first = column.charAt(0);
                if (first < '0' || first > '9') continue;
                try {
                    int position = Numbers.parseInt(column);
                    if (position < 1 || position > columnCount) {
                        if (baseParent.getAliasToColumnMap().get(column) != null) continue;
                        throw SqlException.$(orderBy.position, "order column position is out of range [max=").put(columnCount).put(']');
                    }
                    orderByNodes.setQuick(i, this.expressionNodePool.next().of(7, columns.get(position - 1).getName(), -1, orderBy.position));
                    continue;
                }
                catch (NumericException numericException) {
                    // empty catch block
                }
            }
        }
        if ((nested = base.getNestedModel()) != null) {
            this.rewriteOrderByPosition(nested);
        }
        ObjList<QueryModel> joinModels = base.getJoinModels();
        int n = joinModels.size();
        for (i = 1; i < n; ++i) {
            this.rewriteOrderByPosition(joinModels.getQuick(i));
        }
    }

    private void rewriteOrderByPositionForUnionModels(QueryModel model) throws SqlException {
        QueryModel next = model.getUnionModel();
        if (next != null) {
            this.doRewriteOrderByPositionForUnionModels(model, model, next);
        }
        if ((next = model.getNestedModel()) != null) {
            this.rewriteOrderByPositionForUnionModels(next);
        }
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 1; i < n; ++i) {
            this.rewriteOrderByPositionForUnionModels(joinModels.getQuick(i));
        }
    }

    private QueryModel rewriteSampleBy(@Nullable QueryModel model, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (model == null) {
            return null;
        }
        QueryModel nested = model.getNestedModel();
        if (nested != null) {
            ExpressionNode sampleBy = nested.getSampleBy();
            ExpressionNode sampleByOffset = nested.getSampleByOffset();
            ObjList<ExpressionNode> sampleByFill = nested.getSampleByFill();
            ExpressionNode sampleByTimezoneName = nested.getSampleByTimezoneName() != null && !SqlKeywords.isUTC(nested.getSampleByTimezoneName().token) ? nested.getSampleByTimezoneName() : null;
            ExpressionNode sampleByUnit = nested.getSampleByUnit();
            ExpressionNode timestamp = nested.getTimestamp();
            int sampleByFillSize = sampleByFill.size();
            ExpressionNode sampleByFrom = nested.getSampleByFrom();
            ExpressionNode sampleByTo = nested.getSampleByTo();
            ObjList<ExpressionNode> groupBy = nested.getGroupBy();
            if (sampleBy != null && groupBy != null && groupBy.size() > 0) {
                throw SqlException.$(groupBy.getQuick((int)0).position, "SELECT query must not contain both GROUP BY and SAMPLE BY");
            }
            if (sampleBy != null && timestamp != null && sampleByOffset != null && (sampleByFillSize == 0 || sampleByTimezoneName == null && SqlKeywords.isZeroOffset(sampleByOffset.token)) && (sampleByFillSize == 0 || sampleByFillSize == 1 && !SqlKeywords.isPrevKeyword(sampleByFill.getQuick((int)0).token) && !SqlKeywords.isLinearKeyword(sampleByFill.getQuick((int)0).token)) && sampleByUnit == null && (sampleByFrom == null || sampleByFrom.type != 3 && sampleByFrom.type != 6 && sampleByFrom.type != 9)) {
                boolean orderByMoveRequired;
                int timestampPos;
                ObjList<ExpressionNode> maybeKeyed = new ObjList<ExpressionNode>();
                int n = model.getColumns().size();
                for (int i = 0; i < n; ++i) {
                    QueryColumn column = model.getColumns().getQuick(i);
                    ExpressionNode ast = column.getAst();
                    if (ast.isWildcard()) {
                        throw SqlException.$(column.getAst().position, "wildcard column select is not allowed in sample-by queries");
                    }
                    if (ast.type != 7 && ast.type != 6 && ast.type != 9) continue;
                    maybeKeyed.add(ast);
                }
                if (this.hasNoAggregateQueryColumns(model)) {
                    throw SqlException.$(nested.getSampleBy().position, "at least one aggregation function must be present in 'select' clause");
                }
                this.validateConstOrRuntimeConstFunction(sampleByTimezoneName, sqlExecutionContext);
                int wrapAction = 0;
                if (sampleByTimezoneName != null && !SqlKeywords.isUTC(sampleByTimezoneName.token)) {
                    wrapAction |= 4;
                }
                CharSequence timestampColumn = timestamp.token;
                CharSequence timestampAlias = null;
                int n2 = model.getColumns().size();
                for (int i = 0; i < n2; ++i) {
                    QueryColumn qc = model.getBottomUpColumns().getQuick(i);
                    if (qc.getAst().type != 7 || !Chars.equalsIgnoreCase(qc.getAst().token, timestampColumn)) continue;
                    timestampAlias = qc.getAlias();
                }
                if (timestampAlias == null) {
                    if (nested.getAlias() != null) {
                        CharacterStoreEntry e = this.characterStore.newEntry();
                        ((Utf16Sink)e.put(nested.getAlias().token)).putAscii('.').put(timestamp.token);
                        CharSequence tableAliasPrefixedTimestampColumn = e.toImmutable();
                        timestampAlias = model.getColumnNameToAliasMap().get(tableAliasPrefixedTimestampColumn);
                        if (timestampAlias != null) {
                            timestampColumn = tableAliasPrefixedTimestampColumn;
                        }
                    }
                    if (timestampAlias == null && nested.getTableName() != null) {
                        CharacterStoreEntry e = this.characterStore.newEntry();
                        ((Utf16Sink)e.put(nested.getTableName())).putAscii('.').put(timestamp.token);
                        CharSequence tableNamePrefixedTimestampColumn = e.toImmutable();
                        timestampAlias = model.getColumnNameToAliasMap().get(tableNamePrefixedTimestampColumn);
                        if (timestampAlias != null) {
                            timestampColumn = tableNamePrefixedTimestampColumn;
                        }
                    }
                }
                if (timestampAlias == null && nested.getJoinModels().size() > 1 && this.isAmbiguousColumn(nested, timestampColumn)) {
                    CharSequence tableAlias = nested.getAlias() != null ? nested.getAlias().token : nested.getTableName();
                    CharacterStoreEntry e = this.characterStore.newEntry();
                    ((Utf16Sink)e.put(tableAlias)).putAscii('.').put(timestamp.token);
                    timestampColumn = e.toImmutable();
                }
                if (maybeKeyed.size() > 0 && (sampleByFrom != null || sampleByTo != null || sampleByFillSize > 0 && !SqlKeywords.isNoneKeyword(sampleByFill.getQuick((int)0).token))) {
                    boolean isKeyed = false;
                    CharSequence tableName = nested.getTableName();
                    if (tableName == null) {
                        return model;
                    }
                    int n3 = maybeKeyed.size();
                    block7: for (int i = 0; i < n3; ++i) {
                        ExpressionNode expr = (ExpressionNode)maybeKeyed.getQuick(i);
                        switch (expr.type) {
                            case 7: {
                                if (this.matchesWithOrWithoutTablePrefix(expr.token, tableName, timestamp.token) || this.matchesWithOrWithoutTablePrefix(expr.token, tableName, timestampAlias)) continue block7;
                                isKeyed = true;
                                continue block7;
                            }
                            case 9: {
                                isKeyed = true;
                                continue block7;
                            }
                            case 6: {
                                if (this.functionParser.getFunctionFactoryCache().isGroupBy(expr.token)) continue block7;
                                isKeyed = true;
                            }
                        }
                    }
                    if (isKeyed) {
                        nested.setNestedModel(this.rewriteSampleBy(nested.getNestedModel(), sqlExecutionContext));
                        int m = nested.getJoinModels().size();
                        for (int j = 1; j < m; ++j) {
                            QueryModel joinModel = nested.getJoinModels().getQuick(j);
                            joinModel.setNestedModel(this.rewriteSampleBy(joinModel.getNestedModel(), sqlExecutionContext));
                        }
                        model.setUnionModel(this.rewriteSampleBy(model.getUnionModel(), sqlExecutionContext));
                        return model;
                    }
                }
                ObjList<QueryColumn> insetColumnAliases = new ObjList<QueryColumn>();
                this.tempList.clear();
                this.existsDependedTokens.clear();
                this.existsDependedTokens.add(timestampColumn);
                int needRemoveColumns = 0;
                boolean timestampOnly = true;
                int i = 0;
                int k = 0;
                int n4 = model.getBottomUpColumns().size();
                while (i < n4) {
                    boolean isFunctionWithTsColumn;
                    QueryColumn qc = model.getBottomUpColumns().getQuick(i);
                    boolean bl = isFunctionWithTsColumn = (qc.getAst().type == 6 || qc.getAst().type == 9) && this.nonAggregateFunctionDependsOn(qc.getAst(), nested.getTimestamp());
                    if (isFunctionWithTsColumn || timestampAlias != null && qc.getAst().type == 7 && Chars.equalsIgnoreCase(qc.getAst().token, timestampColumn) && !Chars.equalsIgnoreCase(qc.getAlias(), timestampAlias)) {
                        model.removeColumn(i);
                        this.tempList.add(k);
                        insetColumnAliases.add(qc);
                        --n4;
                        wrapAction |= 2;
                        if (isFunctionWithTsColumn) {
                            timestampOnly = false;
                        }
                    } else {
                        if (!Chars.equalsIgnoreCase(qc.getAst().token, timestampColumn)) {
                            timestampOnly = false;
                        }
                        ++i;
                    }
                    ++k;
                }
                if (timestampAlias == null) {
                    wrapAction |= 1;
                    timestampAlias = this.createColumnAlias(timestampColumn, model);
                    model.addBottomUpColumnIfNotExists(this.nextColumn(timestampAlias, timestamp.position));
                    timestampOnly = false;
                    ++needRemoveColumns;
                }
                if ((wrapAction & 2) != 0) {
                    model.updateColumnAliasIndexes();
                }
                if ((timestampPos = model.getColumnAliasIndex(timestampAlias)) == -1) {
                    throw SqlException.$(timestamp.position, "unexpected timestamp expression");
                }
                ExpressionNode tsFloorFunc = this.expressionNodePool.next();
                tsFloorFunc.token = "timestamp_floor";
                tsFloorFunc.type = 6;
                tsFloorFunc.paramCount = 5;
                CharacterStoreEntry characterStoreEntry = this.characterStore.newEntry();
                ((Utf16Sink)((Utf16Sink)characterStoreEntry.put('\'')).put(sampleBy.token)).put('\'');
                ExpressionNode tsFloorIntervalParam = this.expressionNodePool.next();
                tsFloorIntervalParam.token = characterStoreEntry.toImmutable();
                tsFloorIntervalParam.paramCount = 0;
                tsFloorIntervalParam.type = 4;
                tsFloorIntervalParam.position = sampleBy.position;
                ExpressionNode tsFloorTsParam = this.expressionNodePool.next();
                tsFloorTsParam.token = timestampColumn;
                tsFloorTsParam.position = model.getBottomUpColumns().getQuick((int)timestampPos).getAst().position;
                tsFloorTsParam.paramCount = 0;
                tsFloorTsParam.type = 7;
                if (sampleByTimezoneName != null) {
                    tsFloorFunc.args.add(sampleByTimezoneName);
                } else {
                    ExpressionNode nullTimezone = this.expressionNodePool.next();
                    nullTimezone.type = 4;
                    nullTimezone.token = "null";
                    nullTimezone.precedence = 0;
                    tsFloorFunc.args.add(nullTimezone);
                }
                tsFloorFunc.args.add(sampleByOffset);
                if (sampleByFrom != null) {
                    tsFloorFunc.args.add(sampleByFrom);
                } else {
                    ExpressionNode nullExpr = this.expressionNodePool.next();
                    nullExpr.type = 4;
                    nullExpr.token = "null";
                    nullExpr.precedence = 0;
                    tsFloorFunc.args.add(nullExpr);
                }
                tsFloorFunc.args.add(tsFloorTsParam);
                tsFloorFunc.args.add(tsFloorIntervalParam);
                model.getBottomUpColumns().setQuick(timestampPos, this.queryColumnPool.next().of(timestampAlias, tsFloorFunc));
                if (timestampOnly || nested.getGroupBy().size() > 0) {
                    nested.addGroupBy(tsFloorFunc);
                }
                nested.setFillFrom(sampleByFrom);
                nested.setFillTo(sampleByTo);
                nested.setFillStride(sampleBy);
                nested.setFillValues(sampleByFill);
                nested.setSampleBy(null);
                nested.setSampleByOffset(null);
                nested.setSampleByFromTo(null, null);
                if ((wrapAction & 2) != 0) {
                    int i2;
                    this.missingDependedTokens.clear();
                    int size = insetColumnAliases.size();
                    for (i2 = 0; i2 < size; ++i2) {
                        this.fixAndCollectExprToken(((QueryColumn)insetColumnAliases.get(i2)).getAst(), timestampColumn, timestampAlias, this.existsDependedTokens, this.missingDependedTokens);
                    }
                    size = this.missingDependedTokens.size();
                    for (i2 = 0; i2 < size; ++i2) {
                        model.addBottomUpColumnIfNotExists(this.nextColumn(this.missingDependedTokens.get(i2)));
                    }
                    needRemoveColumns += this.missingDependedTokens.size();
                }
                if (nested.getOrderBy().size() > 0) {
                    ObjList<ExpressionNode> orderBy = nested.getOrderBy();
                    int n5 = orderBy.size();
                    for (int i3 = 0; i3 < n5; ++i3) {
                        this.replaceColumnsWithAliases(orderBy.getQuick(i3), model);
                    }
                }
                QueryModel orderByModel = nested;
                CharSequence orderByTimestamp = timestamp.token;
                if ((wrapAction & 4) != 0) {
                    model = this.wrapWithSelectModel(model, model.getBottomUpColumns().size());
                    model.setSelectModelType(1);
                    orderByModel = model.getNestedModel();
                    orderByTimestamp = timestampAlias;
                    QueryColumn qc = model.getBottomUpColumns().getQuick(timestampPos);
                    if (timestampAlias == null || qc.getAst().type != 7 && !Chars.equalsIgnoreCase(qc.getAlias(), timestampAlias)) {
                        throw SqlException.$(qc.getAst().position, "unexpected non-timestamp column at position ").put(timestampPos);
                    }
                    ExpressionNode toUtcFunc = this.expressionNodePool.next();
                    toUtcFunc.token = "to_utc";
                    toUtcFunc.type = 6;
                    toUtcFunc.paramCount = 2;
                    ExpressionNode toUtcParam = this.expressionNodePool.next();
                    toUtcParam.token = timestampAlias;
                    toUtcParam.position = timestamp.position;
                    toUtcParam.paramCount = 0;
                    toUtcParam.type = 7;
                    toUtcFunc.lhs = toUtcParam;
                    toUtcFunc.rhs = sampleByTimezoneName;
                    qc.of(timestampAlias, toUtcFunc);
                }
                if (nested.getOrderBy().size() == 0) {
                    ExpressionNode orderBy = this.expressionNodePool.next();
                    orderBy.token = timestampAlias;
                    orderBy.type = 7;
                    orderByModel.getOrderBy().add(orderBy);
                    orderByModel.getOrderByDirection().add(0);
                    orderByModel.setTimestamp(this.nextLiteral(orderByTimestamp));
                }
                if ((wrapAction & 2) != 0 && needRemoveColumns > 0) {
                    model = this.wrapWithSelectModel(model, model.getBottomUpColumns().size() - needRemoveColumns);
                    this.addColumnToSelectModel(model, this.tempList, insetColumnAliases, timestampAlias);
                    orderByModel = model.getNestedModel();
                } else if ((wrapAction & 2) != 0) {
                    model = this.wrapWithSelectModel(model, this.tempList, insetColumnAliases, timestampAlias);
                    orderByModel = model.getNestedModel();
                } else if ((wrapAction & 1) != 0) {
                    model = this.wrapWithSelectModel(model, model.getBottomUpColumns().size() - 1);
                    orderByModel = model.getNestedModel();
                }
                boolean bl = orderByMoveRequired = (wrapAction & 4) != 0 || (wrapAction & 2) != 0;
                if (orderByMoveRequired && nested.getOrderBy().size() > 0) {
                    ObjList<ExpressionNode> orderBy = nested.getOrderBy();
                    IntList orderByDirection = nested.getOrderByDirection();
                    int n6 = orderBy.size();
                    for (int i4 = 0; i4 < n6; ++i4) {
                        orderByModel.addOrderBy(orderBy.getQuick(i4), orderByDirection.getQuick(i4));
                    }
                    nested.clearOrderBy();
                }
            }
            nested.setNestedModel(this.rewriteSampleBy(nested.getNestedModel(), sqlExecutionContext));
            int n = nested.getJoinModels().size();
            for (int i = 1; i < n; ++i) {
                QueryModel joinModel = nested.getJoinModels().getQuick(i);
                joinModel.setNestedModel(this.rewriteSampleBy(joinModel.getNestedModel(), sqlExecutionContext));
            }
        }
        model.setUnionModel(this.rewriteSampleBy(model.getUnionModel(), sqlExecutionContext));
        return model;
    }

    private void rewriteSampleByFromTo(QueryModel model) throws SqlException {
        QueryModel whereModel = null;
        if (model == null) {
            return;
        }
        QueryModel fromToModel = model.getNestedModel();
        if (fromToModel == null) {
            return;
        }
        ExpressionNode sampleFrom = fromToModel.getSampleByFrom();
        ExpressionNode sampleTo = fromToModel.getSampleByTo();
        if (sampleFrom != null || sampleTo != null) {
            ExpressionNode intervalClause;
            ExpressionNode geqNode;
            ExpressionNode whereClause = null;
            for (QueryModel curr = model; curr != null && whereClause == null; curr = curr.getNestedModel()) {
                whereClause = curr.getWhereClause();
                if (whereClause == null) continue;
                whereModel = curr;
            }
            ExpressionNode timestamp = fromToModel.getTimestamp();
            QueryModel toAddWhereClause = fromToModel;
            if (timestamp == null && whereClause != null) {
                toAddWhereClause = whereModel;
                timestamp = whereModel.getTimestamp();
            }
            if (timestamp == null) {
                throw SqlException.$(fromToModel.getSampleBy().position, "Sample by requires a designated TIMESTAMP");
            }
            if (Chars.indexOf(timestamp.token, '.') < 0) {
                CharacterStoreEntry e = this.characterStore.newEntry();
                if (Chars.indexOf(toAddWhereClause.getTableName(), '.') != -1) {
                    ((Utf16Sink)e.putAscii('\"').put(toAddWhereClause.getTableName())).putAscii("\".").put(timestamp.token);
                } else {
                    ((Utf16Sink)((Utf16Sink)e.put(toAddWhereClause.getTableName())).put('.')).put(timestamp.token);
                }
                CharSequence prefixedTimestamp = e.toImmutable();
                timestamp = this.expressionNodePool.next().of(7, prefixedTimestamp, timestamp.precedence, timestamp.position);
            }
            if (sampleFrom != null && sampleTo != null) {
                geqNode = this.expressionNodePool.next().of(9, this.opGeq.operator.token, this.opGeq.precedence, 0);
                geqNode.lhs = timestamp;
                geqNode.rhs = sampleFrom;
                geqNode.paramCount = 2;
                ExpressionNode ltNode = this.expressionNodePool.next().of(9, this.opLt.operator.token, this.opLt.precedence, 0);
                ltNode.lhs = timestamp;
                ltNode.rhs = sampleTo;
                ltNode.paramCount = 2;
                ExpressionNode andNode = this.expressionNodePool.next().of(9, this.opAnd.operator.token, this.opAnd.precedence, 0);
                andNode.lhs = geqNode;
                andNode.rhs = ltNode;
                andNode.paramCount = 2;
                intervalClause = andNode;
            } else if (sampleFrom != null) {
                geqNode = this.expressionNodePool.next().of(9, this.opGeq.operator.token, this.opGeq.precedence, 0);
                geqNode.lhs = timestamp;
                geqNode.rhs = sampleFrom;
                geqNode.paramCount = 2;
                intervalClause = geqNode;
            } else {
                ExpressionNode ltNode = this.expressionNodePool.next().of(9, this.opLt.operator.token, this.opLt.precedence, 0);
                ltNode.lhs = timestamp;
                ltNode.rhs = sampleTo;
                ltNode.paramCount = 2;
                intervalClause = ltNode;
            }
            if (whereClause != null) {
                ExpressionNode andNode = this.expressionNodePool.next().of(9, "and", 15, 0);
                andNode.lhs = intervalClause;
                andNode.rhs = whereClause;
                andNode.paramCount = 2;
                toAddWhereClause.setWhereClause(andNode);
            } else {
                toAddWhereClause.setWhereClause(intervalClause);
            }
        }
        this.rewriteSampleByFromTo(fromToModel.getNestedModel());
        int n = fromToModel.getJoinModels().size();
        for (int i = 1; i < n; ++i) {
            QueryModel joinModel = fromToModel.getJoinModels().getQuick(i);
            this.rewriteSampleByFromTo(joinModel.getNestedModel());
        }
        this.rewriteSampleByFromTo(model.getUnionModel());
    }

    @Nullable
    private QueryColumn rewriteSelect0HandleFunction(SqlExecutionContext sqlExecutionContext, SqlParserCallback sqlParserCallback, QueryColumn qc, QueryModel windowModel, QueryModel outerVirtualModel, QueryModel distinctModel, QueryModel translatingModel, QueryModel innerVirtualModel, QueryModel baseModel, boolean useOuterModel, QueryModel groupByModel, ExpressionNode sampleBy, QueryModel cursorModel) throws SqlException {
        if (qc.isWindowColumn()) {
            windowModel.addBottomUpColumn(qc);
            QueryColumn ref = this.nextColumn(qc.getAlias());
            outerVirtualModel.addBottomUpColumn(ref);
            distinctModel.addBottomUpColumn(ref);
            this.emitLiterals(qc.getAst(), translatingModel, innerVirtualModel, true, baseModel, true);
            return null;
        }
        if (this.functionParser.getFunctionFactoryCache().isGroupBy(qc.getAst().token)) {
            this.addMissingTablePrefixesForGroupByQueries(qc.getAst(), baseModel, innerVirtualModel);
            CharSequence matchingCol = this.findColumnByAst(this.groupByNodes, this.groupByAliases, qc.getAst());
            if (useOuterModel && matchingCol != null) {
                QueryColumn ref = this.nextColumn(qc.getAlias(), matchingCol);
                ref = this.ensureAliasUniqueness(outerVirtualModel, ref);
                outerVirtualModel.addBottomUpColumn(ref);
                distinctModel.addBottomUpColumn(ref);
                this.emitLiterals(qc.getAst(), translatingModel, innerVirtualModel, true, baseModel, false);
                return null;
            }
            qc = this.ensureAliasUniqueness(groupByModel, qc);
            groupByModel.addBottomUpColumn(qc);
            this.groupByNodes.add(ExpressionNode.deepClone(this.expressionNodePool, qc.getAst()));
            this.groupByAliases.add(qc.getAlias());
            QueryColumn ref = this.nextColumn(qc.getAlias());
            ref.setIncludeIntoWildcard(qc.isIncludeIntoWildcard());
            outerVirtualModel.addBottomUpColumn(ref);
            distinctModel.addBottomUpColumn(ref);
            this.emitLiterals(qc.getAst(), translatingModel, innerVirtualModel, sampleBy != null, baseModel, false);
            return null;
        }
        if (this.functionParser.getFunctionFactoryCache().isCursor(qc.getAst().token)) {
            this.addCursorFunctionAsCrossJoin(qc.getAst(), qc.getAlias(), cursorModel, innerVirtualModel, translatingModel, baseModel, sqlExecutionContext, sqlParserCallback);
            return null;
        }
        return qc;
    }

    private int rewriteSelect0HandleOperation(SqlExecutionContext sqlExecutionContext, SqlParserCallback sqlParserCallback, QueryColumn qc, boolean explicitGroupBy, AtomicInteger nonAggSelectCount, int rewriteStatus, QueryModel outerVirtualModel, QueryModel distinctModel, QueryModel groupByModel, QueryModel baseModel, QueryModel innerVirtualModel, int columnIndex, QueryModel cursorModel, QueryModel translatingModel, ExpressionNode sampleBy, QueryModel windowModel) throws SqlException {
        if (explicitGroupBy) {
            nonAggSelectCount.incrementAndGet();
            if (this.isEffectivelyConstantExpression(qc.getAst())) {
                rewriteStatus |= 8;
                outerVirtualModel.addBottomUpColumn(qc);
                distinctModel.addBottomUpColumn(qc);
                return rewriteStatus &= 0xFFFFFFDF;
            }
            int beforeSplit = groupByModel.getBottomUpColumns().size();
            ExpressionNode originalNode = qc.getAst();
            ExpressionNode node = this.groupByAliases.indexOf(qc.getAlias()) != -1 ? ExpressionNode.deepClone(this.expressionNodePool, originalNode) : originalNode;
            this.addMissingTablePrefixesForGroupByQueries(node, baseModel, innerVirtualModel);
            node = this.rewriteGroupBySelectExpression(node, groupByModel, this.groupByNodes, this.groupByAliases);
            if (originalNode == node) {
                rewriteStatus |= 8;
            } else {
                if (Chars.equalsIgnoreCase(originalNode.token, qc.getAlias())) {
                    int idx = this.groupByAliases.indexOf(originalNode.token);
                    if (columnIndex != idx) {
                        rewriteStatus |= 8;
                    }
                    this.groupByUsed.set(idx, true);
                } else {
                    rewriteStatus |= 8;
                }
                qc.of(qc.getAlias(), node, qc.isIncludeIntoWildcard(), qc.getColumnType());
            }
            this.emitCursors(qc.getAst(), cursorModel, innerVirtualModel, translatingModel, baseModel, sqlExecutionContext, sqlParserCallback);
            qc = this.ensureAliasUniqueness(outerVirtualModel, qc);
            outerVirtualModel.addBottomUpColumn(qc);
            distinctModel.addBottomUpColumn(this.nextColumn(qc.getAlias()));
            int n = groupByModel.getBottomUpColumns().size();
            for (int j = beforeSplit; j < n; ++j) {
                this.emitLiterals(groupByModel.getBottomUpColumns().getQuick(j).getAst(), translatingModel, innerVirtualModel, true, baseModel, false);
            }
            return rewriteStatus;
        }
        int beforeSplit = groupByModel.getBottomUpColumns().size();
        if (this.checkForChildAggregates(qc.getAst()) || sampleBy != null && this.nonAggregateFunctionDependsOn(qc.getAst(), baseModel.getTimestamp())) {
            this.emitAggregatesAndLiterals(qc.getAst(), groupByModel, translatingModel, innerVirtualModel, baseModel, this.groupByNodes, this.groupByAliases);
            this.emitCursors(qc.getAst(), cursorModel, innerVirtualModel, translatingModel, baseModel, sqlExecutionContext, sqlParserCallback);
            qc = this.ensureAliasUniqueness(outerVirtualModel, qc);
            outerVirtualModel.addBottomUpColumn(qc);
            distinctModel.addBottomUpColumn(this.nextColumn(qc.getAlias()));
            int n = groupByModel.getBottomUpColumns().size();
            for (int j = beforeSplit; j < n; ++j) {
                this.emitLiterals(groupByModel.getBottomUpColumns().getQuick(j).getAst(), translatingModel, innerVirtualModel, true, baseModel, false);
            }
            rewriteStatus |= 8;
        } else {
            this.emitCursors(qc.getAst(), cursorModel, null, translatingModel, baseModel, sqlExecutionContext, sqlParserCallback);
            if ((rewriteStatus & 4) != 0) {
                if (this.isEffectivelyConstantExpression(qc.getAst())) {
                    outerVirtualModel.addBottomUpColumn(qc);
                    distinctModel.addBottomUpColumn(qc);
                    return rewriteStatus &= 0xFFFFFFDF;
                }
                if (sampleBy == null) {
                    qc = this.ensureAliasUniqueness(groupByModel, qc);
                    groupByModel.addBottomUpColumn(qc);
                    QueryColumn ref = this.nextColumn(qc.getAlias());
                    outerVirtualModel.addBottomUpColumn(ref);
                    distinctModel.addBottomUpColumn(ref);
                    this.emitLiterals(qc.getAst(), translatingModel, innerVirtualModel, false, baseModel, false);
                    innerVirtualModel.addBottomUpColumn(qc);
                    return rewriteStatus;
                }
            }
            this.addFunction(qc, baseModel, translatingModel, innerVirtualModel, windowModel, groupByModel, outerVirtualModel, distinctModel);
        }
        return rewriteStatus;
    }

    private QueryModel rewriteSelectClause(QueryModel model, boolean flatParent, SqlExecutionContext sqlExecutionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        QueryModel rewrittenUnionModel;
        if (model.getUnionModel() != null && (rewrittenUnionModel = this.rewriteSelectClause(model.getUnionModel(), true, sqlExecutionContext, sqlParserCallback)) != model.getUnionModel()) {
            model.setUnionModel(rewrittenUnionModel);
        }
        ObjList<QueryModel> models = model.getJoinModels();
        int n = models.size();
        for (int i = 0; i < n; ++i) {
            QueryModel rewritten;
            QueryModel m = models.getQuick(i);
            boolean flatModel = m.getBottomUpColumns().size() == 0;
            QueryModel nestedModel = m.getNestedModel();
            if (nestedModel != null && (rewritten = this.rewriteSelectClause(nestedModel, flatModel, sqlExecutionContext, sqlParserCallback)) != nestedModel) {
                m.setNestedModel(rewritten);
                m.copyColumnsFrom(rewritten, this.queryColumnPool, this.expressionNodePool);
            }
            if (flatModel) {
                if (!flatParent || m.getSampleBy() == null) continue;
                throw SqlException.$(m.getSampleBy().position, "'sample by' must be used with 'select' clause, which contains aggregate expression(s)");
            }
            model.replaceJoinModel(i, this.rewriteSelectClause0(m, sqlExecutionContext, sqlParserCallback));
        }
        return models.getQuick(0);
    }

    @NotNull
    private QueryModel rewriteSelectClause0(QueryModel model, SqlExecutionContext sqlExecutionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        QueryModel limitSource;
        QueryModel root;
        boolean explicitGroupBy;
        assert (model.getNestedModel() != null);
        this.groupByAliases.clear();
        this.groupByNodes.clear();
        QueryModel groupByModel = this.queryModelPool.next();
        groupByModel.setSelectModelType(4);
        QueryModel distinctModel = this.queryModelPool.next();
        distinctModel.setSelectModelType(5);
        QueryModel outerVirtualModel = this.queryModelPool.next();
        outerVirtualModel.setSelectModelType(2);
        QueryModel innerVirtualModel = this.queryModelPool.next();
        innerVirtualModel.setSelectModelType(2);
        QueryModel windowModel = this.queryModelPool.next();
        windowModel.setSelectModelType(3);
        QueryModel translatingModel = this.queryModelPool.next();
        translatingModel.setSelectModelType(1);
        QueryModel cursorModel = this.queryModelPool.next();
        int rewriteStatus = 0;
        if (model.isDistinct()) {
            rewriteStatus |= 0x10;
        }
        ObjList<QueryColumn> columns = model.getBottomUpColumns();
        QueryModel baseModel = model.getNestedModel();
        boolean hasJoins = baseModel.getJoinModels().size() > 1;
        ExpressionNode sampleBy = baseModel.getSampleBy();
        if (sampleBy != null) {
            groupByModel.moveSampleByFrom(baseModel);
        }
        if (baseModel.getGroupBy().size() > 0) {
            groupByModel.moveGroupByFrom(baseModel);
            rewriteStatus |= 4;
        }
        cursorModel.getAliasToColumnMap().putAll(baseModel.getAliasToColumnMap());
        int k = columns.size();
        block7: for (int i = 0; i < k; ++i) {
            QueryColumn qc = columns.getQuick(i);
            boolean window = qc.isWindowColumn();
            if (window && qc.getAst().type != 6) {
                throw SqlException.$(qc.getAst().position, "Window function expected");
            }
            if (qc.getAst().type == 3) {
                rewriteStatus |= 1;
                continue;
            }
            if (qc.getAst().type == 7) continue;
            if (qc.getAst().type == 6) {
                if (window) {
                    rewriteStatus |= 2;
                    continue;
                }
                if (this.functionParser.getFunctionFactoryCache().isGroupBy(qc.getAst().token)) {
                    rewriteStatus |= 4;
                    if (groupByModel.getSampleByFill().size() > 0) continue;
                    ExpressionNode repl = this.rewriteAggregate(qc.getAst(), baseModel);
                    if (repl == qc.getAst()) {
                        if ((rewriteStatus & 8) != 0) continue;
                        for (int j = i + 1; j < k; ++j) {
                            if (!ExpressionNode.compareNodesExact(qc.getAst(), columns.get(j).getAst())) continue;
                            rewriteStatus |= 8;
                            continue block7;
                        }
                        continue;
                    }
                    rewriteStatus |= 8;
                    qc.of(qc.getAlias(), repl);
                } else if (this.functionParser.getFunctionFactoryCache().isCursor(qc.getAst().token)) continue;
            }
            if (this.checkForChildAggregates(qc.getAst())) {
                rewriteStatus |= 4;
                rewriteStatus |= 8;
                continue;
            }
            rewriteStatus |= 1;
        }
        if ((rewriteStatus & 4) != 0 && sampleBy == null) {
            rewriteStatus &= 0xFFFFFFFE;
        }
        rewriteStatus |= 0x20;
        ObjList<ExpressionNode> groupBy = groupByModel.getGroupBy();
        boolean bl = explicitGroupBy = groupBy.size() > 0;
        if (explicitGroupBy) {
            int n = groupBy.size();
            for (int i = 0; i < n; ++i) {
                QueryColumn qc;
                ExpressionNode node = groupBy.getQuick(i);
                CharSequence alias = null;
                int originalNodePosition = -1;
                if (node.type == 7) {
                    qc = model.getAliasToColumnMap().get(node.token);
                    if (!(qc == null || qc.getAst().type == 7 && Chars.equals(node.token, qc.getAst().token))) {
                        originalNodePosition = node.position;
                        node = qc.getAst();
                        alias = qc.getAlias();
                    }
                } else if (node.type == 4) {
                    try {
                        int columnIdx = Numbers.parseInt(node.token);
                        if (columnIdx < 1 || columnIdx > columns.size()) {
                            throw SqlException.$(node.position, "GROUP BY position ").put(columnIdx).put(" is not in select list");
                        }
                        QueryColumn qc2 = columns.getQuick(--columnIdx);
                        originalNodePosition = node.position;
                        node = qc2.getAst();
                        alias = qc2.getAlias();
                    }
                    catch (NumericException columnIdx) {
                        // empty catch block
                    }
                }
                if (node.type == 7 && Chars.endsWith(node.token, '*')) {
                    throw SqlException.$(node.position, "'*' is not allowed in GROUP BY");
                }
                this.addMissingTablePrefixesForGroupByQueries(node, baseModel, innerVirtualModel);
                if (this.findColumnByAst(this.groupByNodes, this.groupByAliases, node) != null) continue;
                this.validateGroupByExpression(node, originalNodePosition);
                if (node.type == 7) {
                    alias = alias == null ? this.createColumnAlias(node, groupByModel) : this.createColumnAlias(alias, innerVirtualModel, true);
                    QueryColumn groupByColumn = this.createGroupByColumn(alias, node, baseModel, translatingModel, innerVirtualModel, groupByModel);
                    this.groupByNodes.add(node);
                    this.groupByAliases.add(groupByColumn.getAlias());
                    continue;
                }
                if (this.isEffectivelyConstantExpression(node) && n > 1) continue;
                alias = this.createColumnAlias(alias != null ? alias : node.token, groupByModel, true);
                qc = this.queryColumnPool.next().of(alias, node);
                groupByModel.addBottomUpColumn(qc);
                this.groupByNodes.add(ExpressionNode.deepClone(this.expressionNodePool, node));
                this.groupByAliases.add(qc.getAlias());
                this.emitLiterals(qc.getAst(), translatingModel, innerVirtualModel, false, baseModel, false);
            }
        }
        this.groupByUsed.setAll(groupBy.size(), false);
        this.nonAggSelectCount.set(0);
        int k2 = columns.size();
        block10: for (int i = 0; i < k2; ++i) {
            QueryColumn qc = columns.getQuick(i);
            switch (qc.getAst().type) {
                case 7: {
                    if (Chars.endsWith(qc.getAst().token, '*')) {
                        this.createSelectColumnsForWildcard(qc, hasJoins, baseModel, translatingModel, innerVirtualModel, windowModel, groupByModel, outerVirtualModel, distinctModel);
                        continue block10;
                    }
                    if (explicitGroupBy) {
                        this.nonAggSelectCount.incrementAndGet();
                        this.addMissingTablePrefixesForGroupByQueries(qc.getAst(), baseModel, innerVirtualModel);
                        int matchingColIdx = this.findColumnIdxByAst(this.groupByNodes, qc.getAst());
                        if (matchingColIdx == -1) {
                            throw SqlException.$(qc.getAst().position, "column must appear in GROUP BY clause or aggregate function");
                        }
                        boolean sameAlias = this.createSelectColumn(qc.getAlias(), this.groupByAliases.get(matchingColIdx), groupByModel, outerVirtualModel, (rewriteStatus & 0x10) != 0 ? distinctModel : null);
                        if (sameAlias && i == matchingColIdx) {
                            this.groupByUsed.set(matchingColIdx, true);
                            continue block10;
                        }
                        rewriteStatus |= 8;
                        continue block10;
                    }
                    if (groupByModel.getAliasToColumnMap().contains(qc.getAlias())) {
                        CharSequence newAlias = this.createColumnAlias(qc.getAst(), groupByModel);
                        qc.setAlias(newAlias, -1);
                    }
                    if (baseModel.getAliasToColumnMap().excludes(qc.getAst().token) && innerVirtualModel.getAliasToColumnMap().contains(qc.getAst().token)) {
                        this.addFunction(qc, baseModel, translatingModel, innerVirtualModel, windowModel, groupByModel, outerVirtualModel, distinctModel);
                        rewriteStatus |= 1;
                        rewriteStatus |= 0x40;
                        continue block10;
                    }
                    this.createSelectColumn(qc.getAlias(), qc.getAst(), false, baseModel, translatingModel, innerVirtualModel, windowModel, groupByModel, outerVirtualModel, (rewriteStatus & 0x10) != 0 ? distinctModel : null);
                    continue block10;
                }
                case 3: {
                    if (explicitGroupBy) {
                        rewriteStatus |= 8;
                        rewriteStatus &= 0xFFFFFFDF;
                        outerVirtualModel.addBottomUpColumn(qc);
                        distinctModel.addBottomUpColumn(qc);
                        continue block10;
                    }
                    this.addFunction(qc, baseModel, translatingModel, innerVirtualModel, windowModel, groupByModel, outerVirtualModel, distinctModel);
                    rewriteStatus |= 1;
                    continue block10;
                }
                case 6: {
                    qc = this.rewriteSelect0HandleFunction(sqlExecutionContext, sqlParserCallback, qc, windowModel, outerVirtualModel, distinctModel, translatingModel, innerVirtualModel, baseModel, (rewriteStatus & 8) != 0, groupByModel, sampleBy, cursorModel);
                    if (qc == null) continue block10;
                }
                default: {
                    rewriteStatus = this.rewriteSelect0HandleOperation(sqlExecutionContext, sqlParserCallback, qc, explicitGroupBy, this.nonAggSelectCount, rewriteStatus, outerVirtualModel, distinctModel, groupByModel, baseModel, innerVirtualModel, i, cursorModel, translatingModel, sampleBy, windowModel);
                }
            }
        }
        if (explicitGroupBy && (rewriteStatus & 0x10) == 0 && (this.nonAggSelectCount.get() != groupBy.size() || this.groupByUsed.getTrueCount() != groupBy.size())) {
            rewriteStatus |= 8;
        }
        if ((rewriteStatus & 2) != 0 && (rewriteStatus & 4) != 0) {
            throw SqlException.$(0, "Window function is not allowed in context of aggregation. Use sub-query.");
        }
        boolean forceTranslatingModel = false;
        if ((rewriteStatus & 2) != 0) {
            int k3 = columns.size();
            for (int i = 0; i < k3; ++i) {
                QueryColumn qc = columns.getQuick(i);
                boolean window = qc.isWindowColumn();
                if (!(window & qc.getAst().type == 6)) continue;
                WindowColumn ac = (WindowColumn)qc;
                int innerColumnsPre = innerVirtualModel.getBottomUpColumns().size();
                this.replaceLiteralList(innerVirtualModel, translatingModel, baseModel, ac.getPartitionBy());
                this.replaceLiteralList(innerVirtualModel, translatingModel, baseModel, ac.getOrderBy());
                int innerColumnsPost = innerVirtualModel.getBottomUpColumns().size();
                forceTranslatingModel |= innerColumnsPre != innerColumnsPost;
            }
        }
        if ((rewriteStatus & 1) != 0 && (rewriteStatus & 0x40) == 0) {
            rewriteStatus &= 0xFFFFFFFE;
            ObjList<QueryColumn> innerColumns = innerVirtualModel.getBottomUpColumns();
            int k4 = innerColumns.size();
            for (int i = 0; i < k4; ++i) {
                QueryColumn qc = innerColumns.getQuick(i);
                if (qc.getAst().type == 7) continue;
                rewriteStatus |= 1;
                break;
            }
        }
        boolean translationIsRedundant = this.checkIfTranslatingModelIsRedundant((rewriteStatus & 1) != 0, (rewriteStatus & 4) != 0, (rewriteStatus & 2) != 0, forceTranslatingModel, true, translatingModel);
        if ((rewriteStatus & 4) != 0 && sampleBy == null && !translationIsRedundant && !model.containsJoin() && SqlUtil.isPlainSelect(model.getNestedModel())) {
            ObjList<QueryColumn> translationColumns = translatingModel.getColumns();
            boolean appearsInFuncArgs = false;
            int n = translationColumns.size();
            for (int i = 0; i < n; ++i) {
                QueryColumn col = translationColumns.getQuick(i);
                if (Chars.equalsIgnoreCase(col.getAst().token, col.getAlias())) continue;
                appearsInFuncArgs |= SqlOptimiser.aliasAppearsInFuncArgs(groupByModel, col.getAlias(), this.sqlNodeStack);
            }
            if (!appearsInFuncArgs) {
                groupByModel.mergePartially(translatingModel, this.queryColumnPool);
                translationIsRedundant = this.checkIfTranslatingModelIsRedundant((rewriteStatus & 1) != 0, true, false, false, false, translatingModel);
            }
        }
        if (sampleBy != null && baseModel.getTimestamp() != null) {
            CharSequence timestamp = baseModel.getTimestamp().token;
            if (innerVirtualModel.getColumnNameToAliasMap().excludes(timestamp)) {
                if (translationIsRedundant) {
                    this.addTimestampToProjection(baseModel.getTimestamp().token, baseModel.getTimestamp(), baseModel, translatingModel, innerVirtualModel, windowModel);
                } else if (translatingModel.getColumnNameToAliasMap().excludes(timestamp)) {
                    CharacterStoreEntry e = this.characterStore.newEntry();
                    ((Utf16Sink)((Utf16Sink)e.put(baseModel.getName())).put('.')).put(timestamp);
                    CharSequence prefixedTimestampName = e.toImmutable();
                    if (translatingModel.getColumnNameToAliasMap().excludes(prefixedTimestampName)) {
                        if (baseModel.getJoinModels().size() > 0 && this.isAmbiguousColumn(baseModel, baseModel.getTimestamp().token)) {
                            this.addTimestampToProjection(prefixedTimestampName, this.nextLiteral(prefixedTimestampName), baseModel, translatingModel, innerVirtualModel, windowModel);
                        } else {
                            this.addTimestampToProjection(baseModel.getTimestamp().token, baseModel.getTimestamp(), baseModel, translatingModel, innerVirtualModel, windowModel);
                        }
                    }
                }
            }
        }
        if (translationIsRedundant) {
            root = baseModel;
            limitSource = model;
        } else {
            root = translatingModel;
            limitSource = translatingModel;
            translatingModel.setNestedModel(baseModel);
            SqlOptimiser.pushDownLimitAdvice(model, baseModel, (rewriteStatus & 0x10) != 0);
            translatingModel.moveLimitFrom(model);
            translatingModel.moveJoinAliasFrom(model);
            translatingModel.setSelectTranslation(true);
            translatingModel.copyHints(model.getHints());
        }
        if ((rewriteStatus & 1) != 0) {
            innerVirtualModel.setNestedModel(root);
            innerVirtualModel.moveLimitFrom(limitSource);
            innerVirtualModel.moveJoinAliasFrom(limitSource);
            innerVirtualModel.copyHints(model.getHints());
            SqlOptimiser.pushDownLimitAdvice(innerVirtualModel, root, (rewriteStatus & 0x10) != 0);
            root = innerVirtualModel;
            limitSource = innerVirtualModel;
        }
        if ((rewriteStatus & 2) != 0) {
            windowModel.setNestedModel(root);
            windowModel.moveLimitFrom(limitSource);
            windowModel.moveJoinAliasFrom(limitSource);
            windowModel.copyHints(model.getHints());
            root = windowModel;
            limitSource = windowModel;
        } else if ((rewriteStatus & 4) != 0) {
            groupByModel.setNestedModel(root);
            groupByModel.moveLimitFrom(limitSource);
            groupByModel.moveJoinAliasFrom(limitSource);
            groupByModel.copyHints(model.getHints());
            root = groupByModel;
            limitSource = groupByModel;
        }
        if ((rewriteStatus & 8) != 0) {
            outerVirtualModel.setNestedModel(root);
            outerVirtualModel.moveLimitFrom(limitSource);
            outerVirtualModel.moveJoinAliasFrom(limitSource);
            outerVirtualModel.copyHints(model.getHints());
            root = outerVirtualModel;
        } else if (root != outerVirtualModel && root.getBottomUpColumns().size() < outerVirtualModel.getBottomUpColumns().size()) {
            outerVirtualModel.setNestedModel(root);
            outerVirtualModel.moveLimitFrom(limitSource);
            outerVirtualModel.moveJoinAliasFrom(limitSource);
            outerVirtualModel.setSelectModelType((rewriteStatus & 0x20) != 0 ? 1 : 2);
            outerVirtualModel.copyHints(model.getHints());
            root = outerVirtualModel;
        }
        if ((rewriteStatus & 0x10) != 0) {
            distinctModel.setNestedModel(root);
            distinctModel.moveLimitFrom(root);
            distinctModel.copyHints(model.getHints());
            root = distinctModel;
        }
        if ((rewriteStatus & 4) == 0 && groupByModel.getSampleBy() != null) {
            throw SqlException.$(groupByModel.getSampleBy().position, "at least one aggregation function must be present in 'select' clause");
        }
        if (model != root) {
            root.setUnionModel(model.getUnionModel());
            root.setSetOperationType(model.getSetOperationType());
            root.setModelPosition(model.getModelPosition());
            if (model.isUpdate()) {
                root.setIsUpdate(true);
                root.copyUpdateTableMetadata(model);
            }
        }
        return root;
    }

    private void rewriteSingleFirstLastGroupBy(QueryModel model) {
        QueryModel union;
        QueryModel nested = model.getNestedModel();
        if (nested != null && nested.getJoinModels().size() == 1 && nested.getNestedModel() == null && nested.getTableName() != null && model.getSampleBy() == null && model.getGroupBy().size() == 0) {
            ObjList<QueryColumn> queryColumns = model.getBottomUpColumns();
            if (nested.getTimestamp() == null || queryColumns.size() > 1) {
                this.rewriteSingleFirstLastGroupBy(nested);
                return;
            }
            CharSequence timestampColumn = nested.getTimestamp().token;
            QueryColumn column = queryColumns.get(0);
            ExpressionNode ast = column.getAst();
            CharSequence token = null;
            CharSequence rhs = null;
            if (ast != null) {
                token = ast.token;
                rhs = ast.rhs == null ? null : ast.rhs.token;
            }
            int optimisationType = 0;
            if (rhs != null && ast.type == 6 && Chars.equals(timestampColumn, rhs)) {
                if (Chars.equalsIgnoreCase("last", token) || Chars.equalsIgnoreCase("max", token)) {
                    optimisationType = 1;
                } else if (Chars.equalsIgnoreCase("first", token) || Chars.equalsIgnoreCase("min", token)) {
                    optimisationType = 2;
                }
            }
            if (optimisationType == 1 || optimisationType == 2) {
                QueryModel newNested = this.queryModelPool.next();
                ExpressionNode lowerLimitNode = this.expressionNodePool.next();
                lowerLimitNode.token = "1";
                lowerLimitNode.type = 4;
                model.setLimit(lowerLimitNode, null);
                model.setSelectModelType(1);
                ast.token = rhs;
                ast.paramCount = 0;
                ast.type = 7;
                ExpressionNode newTimestampNode = this.expressionNodePool.next();
                newTimestampNode.token = timestampColumn;
                if (optimisationType == 1) {
                    newNested.addOrderBy(newTimestampNode, 1);
                }
                newNested.setTableNameExpr(nested.getTableNameExpr());
                newNested.setModelType(nested.getModelType());
                newNested.setTimestamp(nested.getTimestamp());
                newNested.setWhereClause(nested.getWhereClause());
                newNested.copyColumnsFrom(nested, this.queryColumnPool, this.expressionNodePool);
                model.setNestedModel(newNested);
            }
        }
        if (nested != null) {
            this.rewriteSingleFirstLastGroupBy(nested);
        }
        if ((union = model.getUnionModel()) != null) {
            this.rewriteSingleFirstLastGroupBy(union);
        }
        ObjList<QueryModel> joinModels = model.getJoinModels();
        int n = joinModels.size();
        for (int i = 1; i < n; ++i) {
            this.rewriteSingleFirstLastGroupBy(joinModels.getQuick(i));
        }
    }

    private void rewriteTopLevelLiteralsToFunctions(QueryModel model) {
        QueryModel nested = model.getNestedModel();
        if (nested != null) {
            this.rewriteTopLevelLiteralsToFunctions(nested);
            ObjList<QueryColumn> columns = model.getColumns();
            int n = columns.size();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    QueryColumn qc = columns.getQuick(i);
                    ExpressionNode node = qc.getAst();
                    if (node.type == 7) {
                        if (nested.getAliasToColumnMap().contains(node.token) || !this.functionParser.getFunctionFactoryCache().isValidNoArgFunction(node)) continue;
                        node.type = 6;
                        continue;
                    }
                    model.addField(qc);
                }
            } else {
                model.copyColumnsFrom(nested, this.queryColumnPool, this.expressionNodePool);
            }
        }
    }

    private int setAndCopyAdvice(QueryModel model, ObjList<ExpressionNode> advice, int orderByMnemonic, IntList orderByDirectionAdvice) {
        if (model.getAllowPropagationOfOrderByAdvice()) {
            model.setOrderByAdviceMnemonic(orderByMnemonic);
            model.copyOrderByAdvice(advice);
            model.copyOrderByDirectionAdvice(orderByDirectionAdvice);
            return orderByMnemonic;
        }
        return 0;
    }

    private CharSequence setAndGetModelAlias(QueryModel model) {
        CharSequence name = model.getName();
        if (name != null) {
            return name;
        }
        ExpressionNode alias = this.makeJoinAlias();
        model.setAlias(alias);
        return alias.token;
    }

    private QueryModel skipNoneTypeModels(QueryModel model) {
        while (model != null && model.getSelectModelType() == 0 && model.getTableName() == null && model.getTableNameFunction() == null && model.getJoinModels().size() == 1 && model.getWhereClause() == null && model.getLatestBy().size() == 0) {
            model = model.getNestedModel();
        }
        return model;
    }

    private boolean swapJoinOrder(QueryModel parent, int to, int from, JoinContext context) {
        ObjList<QueryModel> joinModels = parent.getJoinModels();
        QueryModel jm = joinModels.getQuick(from);
        if (joinBarriers.contains(jm.getJoinType())) {
            return false;
        }
        JoinContext that = jm.getContext();
        if (that != null && that.parents.contains(to)) {
            this.swapJoinOrder0(parent, jm, to, context);
        }
        return true;
    }

    private void swapJoinOrder0(QueryModel parent, QueryModel jm, int to, JoinContext jc) {
        JoinContext that = jm.getContext();
        this.clausesToSteal.clear();
        int zc = that.aIndexes.size();
        for (int z = 0; z < zc; ++z) {
            if (that.aIndexes.getQuick(z) != to && that.bIndexes.getQuick(z) != to) continue;
            this.clausesToSteal.add(z);
        }
        assert (this.clausesToSteal.size() > 0);
        if (this.clausesToSteal.size() < zc) {
            QueryModel target = parent.getJoinModels().getQuick(to);
            if (jc == null) {
                jc = this.contextPool.next();
                target.setContext(jc);
            }
            jc.slaveIndex = to;
            jm.setContext(this.moveClauses(parent, that, jc, this.clausesToSteal));
            if (target.getJoinType() == 3) {
                target.setJoinType(1);
            }
        }
    }

    private void traverseNamesAndIndices(QueryModel parent, ExpressionNode node) throws SqlException {
        this.literalCollectorAIndexes.clear();
        this.literalCollectorBIndexes.clear();
        this.literalCollectorANames.clear();
        this.literalCollectorBNames.clear();
        this.literalCollector.withModel(parent);
        this.literalCollector.resetCounts();
        this.traversalAlgo.traverse(node.lhs, this.literalCollector.lhs());
        this.traversalAlgo.traverse(node.rhs, this.literalCollector.rhs());
    }

    private CharSequence validateColumnAndGetAlias(QueryModel model, CharSequence columnName, int dot, int position) throws SqlException {
        ObjList<QueryModel> joinModels = model.getJoinModels();
        CharSequence alias = null;
        if (dot == -1) {
            int n = joinModels.size();
            for (int i = 0; i < n; ++i) {
                QueryModel jm = joinModels.getQuick(i);
                if (jm.getColumnNameToAliasMap().excludes(columnName)) continue;
                if (alias != null) {
                    throw SqlException.ambiguousColumn(position, columnName);
                }
                alias = jm.getColumnNameToAliasMap().get(columnName);
            }
        } else {
            int n = joinModels.size();
            for (int i = 0; i < n; ++i) {
                ExpressionNode tableAlias;
                QueryModel jm = joinModels.getQuick(i);
                ExpressionNode expressionNode = tableAlias = jm.getAlias() != null ? jm.getAlias() : jm.getTableNameExpr();
                if (!Chars.equalsIgnoreCase(tableAlias.token, columnName, 0, dot) || (alias = jm.getColumnNameToAliasMap().get(columnName)) != null) continue;
                alias = jm.getColumnNameToAliasMap().get(columnName, dot + 1, columnName.length());
            }
        }
        return alias;
    }

    private int validateColumnAndGetModelIndex(QueryModel baseModel, QueryModel innerVirtualModel, CharSequence literal, int dot, int position, boolean groupByCall) throws SqlException {
        ObjList<QueryModel> joinModels = baseModel.getJoinModels();
        int index = -1;
        if (dot == -1) {
            if (innerVirtualModel != null && innerVirtualModel.getAliasToColumnMap().contains(literal) && !groupByCall) {
                return -1;
            }
            int n = joinModels.size();
            for (int i = 0; i < n; ++i) {
                if (joinModels.getQuick(i).getAliasToColumnMap().excludes(literal)) continue;
                if (index != -1) {
                    throw SqlException.ambiguousColumn(position, literal);
                }
                index = i;
            }
            if (index == -1) {
                throw SqlException.invalidColumn(position, literal);
            }
        } else {
            index = baseModel.getModelAliasIndex(literal, 0, dot);
            if (index == -1) {
                throw SqlException.$(position, "Invalid table name or alias");
            }
            if (joinModels.getQuick(index).getAliasToColumnMap().excludes(literal, dot + 1, literal.length())) {
                throw SqlException.invalidColumn(position, literal);
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateConstOrRuntimeConstFunction(ExpressionNode expr, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (expr != null) {
            Function func = this.functionParser.parseFunction(expr, EmptyRecordMetadata.INSTANCE, sqlExecutionContext);
            try {
                if (!func.isConstant() && !func.isRuntimeConstant()) {
                    throw SqlException.$(expr.position, "timezone must be a constant expression of STRING or CHAR type");
                }
            }
            finally {
                Misc.free(func);
            }
        }
    }

    private void validateGroupByExpression(ExpressionNode node, int originalNodePosition) throws SqlException {
        try {
            this.validateNotAggregateOrWindowFunction(node);
            this.sqlNodeStack.clear();
            while (node != null) {
                if (node.paramCount < 3) {
                    if (node.rhs != null) {
                        this.validateNotAggregateOrWindowFunction(node.rhs);
                        this.sqlNodeStack.push(node.rhs);
                    }
                    if (node.lhs != null) {
                        this.validateNotAggregateOrWindowFunction(node.lhs);
                        node = node.lhs;
                        continue;
                    }
                    if (!this.sqlNodeStack.isEmpty()) {
                        node = this.sqlNodeStack.poll();
                        continue;
                    }
                    node = null;
                    continue;
                }
                int k = node.paramCount;
                for (int i = 1; i < k; ++i) {
                    ExpressionNode e = node.args.getQuick(i);
                    this.validateNotAggregateOrWindowFunction(e);
                    this.sqlNodeStack.push(e);
                }
                ExpressionNode e = node.args.getQuick(0);
                this.validateNotAggregateOrWindowFunction(e);
                node = e;
            }
        }
        catch (SqlException sqle) {
            if (originalNodePosition > -1) {
                sqle.setPosition(originalNodePosition);
            }
            throw sqle;
        }
    }

    private void validateNotAggregateOrWindowFunction(ExpressionNode node) throws SqlException {
        if (node.type == 6) {
            if (this.functionParser.getFunctionFactoryCache().isGroupBy(node.token)) {
                throw SqlException.$(node.position, "aggregate functions are not allowed in GROUP BY");
            }
            if (this.functionParser.getFunctionFactoryCache().isWindow(node.token)) {
                throw SqlException.$(node.position, "window functions are not allowed in GROUP BY");
            }
        }
    }

    private void validateWindowFunctions(QueryModel model, SqlExecutionContext sqlExecutionContext, int recursionLevel) throws SqlException {
        if (model == null) {
            return;
        }
        if (recursionLevel > this.maxRecursion) {
            throw SqlException.$(0, "SQL model is too complex to evaluate");
        }
        if (model.getSelectModelType() == 3) {
            ObjList<QueryColumn> queryColumns = model.getColumns();
            int n = queryColumns.size();
            for (int i = 0; i < n; ++i) {
                QueryColumn qc = queryColumns.getQuick(i);
                if (!qc.isWindowColumn()) continue;
                WindowColumn ac = (WindowColumn)qc;
                long rowsLo = this.evalNonNegativeLongConstantOrDie(ac.getRowsLoExpr(), sqlExecutionContext);
                long rowsHi = this.evalNonNegativeLongConstantOrDie(ac.getRowsHiExpr(), sqlExecutionContext);
                switch (ac.getRowsLoKind()) {
                    case 1: {
                        rowsLo = rowsLo != Long.MAX_VALUE ? -rowsLo : Long.MIN_VALUE;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        rowsLo = 0L;
                    }
                }
                switch (ac.getRowsHiKind()) {
                    case 1: {
                        rowsHi = rowsHi != Long.MAX_VALUE ? -rowsHi : Long.MIN_VALUE;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        rowsHi = 0L;
                    }
                }
                ac.setRowsLo(rowsLo * ac.getRowsLoExprTimeUnit());
                ac.setRowsHi(rowsHi * ac.getRowsHiExprTimeUnit());
            }
        }
        this.validateWindowFunctions(model.getNestedModel(), sqlExecutionContext, recursionLevel + 1);
        int n = model.getJoinModels().size();
        for (int i = 1; i < n; ++i) {
            this.validateWindowFunctions(model.getJoinModels().getQuick(i), sqlExecutionContext, recursionLevel + 1);
        }
        this.validateWindowFunctions(model.getUnionModel(), sqlExecutionContext, recursionLevel + 1);
    }

    @NotNull
    private QueryModel wrapWithSelectModel(QueryModel model, int columnCount) {
        QueryModel outerModel = this.createWrapperModel(model);
        for (int i = 0; i < columnCount; ++i) {
            QueryColumn qcFrom = model.getBottomUpColumns().getQuick(i);
            outerModel.addBottomUpColumnIfNotExists(this.nextColumn(qcFrom.getAlias()));
        }
        return outerModel;
    }

    @NotNull
    private QueryModel wrapWithSelectModel(QueryModel model, IntList insetColumnIndexes, ObjList<QueryColumn> insertColumnAliases, CharSequence timestampAlias) {
        QueryModel _model = this.createWrapperModel(model);
        int src1ColumnCount = model.getBottomUpColumns().size();
        int src2ColumnCount = insetColumnIndexes.size();
        int i = 0;
        int k = 0;
        int m = 0;
        while (i < src1ColumnCount || k < src2ColumnCount) {
            if (k < src2ColumnCount && insetColumnIndexes.getQuick(k) == m) {
                QueryColumn column = insertColumnAliases.get(k);
                if (column.getAst().type == 7) {
                    _model.addBottomUpColumnIfNotExists(this.nextColumn(column.getAlias(), timestampAlias));
                } else {
                    _model.addBottomUpColumnIfNotExists(column);
                }
                ++k;
            } else {
                QueryColumn qcFrom = model.getBottomUpColumns().getQuick(i);
                _model.addBottomUpColumnIfNotExists(this.nextColumn(qcFrom.getAlias()));
                ++i;
            }
            ++m;
        }
        return _model;
    }

    private QueryModel wrapWithSelectWildcard(QueryModel model) throws SqlException {
        QueryModel outerModel = this.createWrapperModel(model);
        outerModel.addBottomUpColumn(this.nextColumn("*"));
        return outerModel;
    }

    protected void authorizeColumnAccess(SqlExecutionContext executionContext, QueryModel model) {
    }

    protected void authorizeUpdate(QueryModel updateQueryModel, TableToken token) {
    }

    QueryModel optimise(QueryModel model, SqlExecutionContext sqlExecutionContext, SqlParserCallback sqlParserCallback) throws SqlException {
        QueryModel rewrittenModel = model;
        try {
            rewrittenModel = this.bubbleUpOrderByAndLimitFromUnion(rewrittenModel);
            this.optimiseExpressionModels(rewrittenModel, sqlExecutionContext, sqlParserCallback);
            this.enumerateTableColumns(rewrittenModel, sqlExecutionContext, sqlParserCallback);
            this.rewriteTopLevelLiteralsToFunctions(rewrittenModel);
            this.rewriteSampleByFromTo(rewrittenModel);
            this.propagateHintsTo(rewrittenModel, rewrittenModel.getHints());
            rewrittenModel = this.rewriteDistinct(rewrittenModel);
            rewrittenModel = this.rewriteSampleBy(rewrittenModel, sqlExecutionContext);
            rewrittenModel = this.moveOrderByFunctionsIntoOuterSelect(rewrittenModel);
            this.rewriteCount(rewrittenModel);
            this.resolveJoinColumns(rewrittenModel);
            this.optimiseBooleanNot(rewrittenModel);
            this.rewriteSingleFirstLastGroupBy(rewrittenModel);
            rewrittenModel = this.rewriteSelectClause(rewrittenModel, true, sqlExecutionContext, sqlParserCallback);
            this.optimiseJoins(rewrittenModel);
            this.collapseStackedChooseModels(rewrittenModel);
            this.rewriteCountDistinct(rewrittenModel);
            this.rewriteMultipleTermLimitedOrderByPart1(rewrittenModel);
            this.pushLimitFromChooseToNone(rewrittenModel, sqlExecutionContext);
            this.validateWindowFunctions(rewrittenModel, sqlExecutionContext, 0);
            this.rewriteOrderByPosition(rewrittenModel);
            this.rewriteOrderByPositionForUnionModels(rewrittenModel);
            rewrittenModel = this.rewriteOrderBy(rewrittenModel);
            this.optimiseOrderBy(rewrittenModel, 0);
            this.createOrderHash(rewrittenModel);
            this.moveWhereInsideSubQueries(rewrittenModel);
            this.eraseColumnPrefixInWhereClauses(rewrittenModel);
            this.moveTimestampToChooseModel(rewrittenModel);
            this.propagateTopDownColumns(rewrittenModel, rewrittenModel.allowsColumnsChange());
            this.rewriteMultipleTermLimitedOrderByPart2(rewrittenModel);
            this.authorizeColumnAccess(sqlExecutionContext, rewrittenModel);
            return rewrittenModel;
        }
        catch (Throwable th) {
            Misc.freeObjListAndClear(this.tableFactoriesInFlight);
            throw th;
        }
    }

    void optimiseUpdate(QueryModel updateQueryModel, SqlExecutionContext sqlExecutionContext, TableRecordMetadata metadata, SqlParserCallback sqlParserCallback) throws SqlException {
        QueryModel selectQueryModel = updateQueryModel.getNestedModel();
        selectQueryModel.setIsUpdate(true);
        QueryModel optimisedNested = this.optimise(selectQueryModel, sqlExecutionContext, sqlParserCallback);
        assert (optimisedNested.isUpdate());
        updateQueryModel.setNestedModel(optimisedNested);
        this.validateUpdateColumns(updateQueryModel, metadata, sqlExecutionContext);
    }

    void validateUpdateColumns(QueryModel updateQueryModel, TableRecordMetadata metadata, SqlExecutionContext sqlExecutionContext) throws SqlException {
        try {
            this.literalCollectorANames.clear();
            this.tempList.clear(metadata.getColumnCount());
            this.tempList.setPos(metadata.getColumnCount());
            int timestampIndex = metadata.getTimestampIndex();
            int updateSetColumnCount = updateQueryModel.getUpdateExpressions().size();
            for (int i = 0; i < updateSetColumnCount; ++i) {
                ExpressionNode columnExpression = updateQueryModel.getUpdateExpressions().get(i);
                int position = columnExpression.position;
                int columnIndex = metadata.getColumnIndexQuiet(columnExpression.token);
                QueryColumn queryColumn = updateQueryModel.getNestedModel().getColumns().get(i);
                if (columnIndex < 0) {
                    throw SqlException.invalidColumn(position, queryColumn.getName());
                }
                if (columnIndex == timestampIndex) {
                    throw SqlException.$(position, "Designated timestamp column cannot be updated");
                }
                if (this.tempList.getQuick(columnIndex) == 1) {
                    throw SqlException.$(position, "Duplicate column ").put(queryColumn.getName()).put(" in SET clause");
                }
                String exactColName = metadata.getColumnName(columnIndex);
                queryColumn.of(exactColName, queryColumn.getAst());
                this.tempList.set(columnIndex, 1);
                this.literalCollectorANames.add(exactColName);
                ExpressionNode rhs = queryColumn.getAst();
                if (rhs.type != 6 || !this.functionParser.getFunctionFactoryCache().isGroupBy(rhs.token)) continue;
                throw SqlException.$(rhs.position, "Unsupported function in SET clause");
            }
            TableToken tableToken = metadata.getTableToken();
            sqlExecutionContext.getSecurityContext().authorizeTableUpdate(tableToken, this.literalCollectorANames);
            if (!sqlExecutionContext.isWalApplication() && !Chars.equalsIgnoreCase(tableToken.getTableName(), updateQueryModel.getTableName())) {
                throw TableReferenceOutOfDateException.of(updateQueryModel.getTableName());
            }
            updateQueryModel.setUpdateTableToken(tableToken);
            this.authorizeUpdate(updateQueryModel, tableToken);
        }
        catch (EntryLockedException e) {
            throw SqlException.position(updateQueryModel.getModelPosition()).put("table is locked: ").put(this.tableLookupSequence);
        }
        catch (CairoException e) {
            if (e.isAuthorizationError()) {
                throw e;
            }
            throw SqlException.position(updateQueryModel.getModelPosition()).put(e);
        }
    }

    static {
        joinOps = new CharSequenceIntHashMap();
        joinsRequiringTimestamp = new boolean[]{false, false, false, false, true, true, true};
        limitTypes = new IntHashSet();
        notOps = new CharSequenceIntHashMap();
        nullConstants = new CharSequenceHashSet();
        notOps.put("not", 1);
        notOps.put("and", 2);
        notOps.put("or", 3);
        notOps.put(">", 4);
        notOps.put(">=", 5);
        notOps.put("<", 6);
        notOps.put("<=", 7);
        notOps.put("=", 8);
        notOps.put("!=", 9);
        notOps.put("<>", 9);
        joinBarriers = new IntHashSet();
        joinBarriers.add(2);
        joinBarriers.add(8);
        joinBarriers.add(4);
        joinBarriers.add(5);
        joinBarriers.add(6);
        nullConstants.add("null");
        nullConstants.add("NaN");
        joinOps.put("=", 1);
        joinOps.put("and", 2);
        joinOps.put("or", 3);
        joinOps.put("~", 4);
        flexColumnModelTypes.add(1);
        flexColumnModelTypes.add(0);
        flexColumnModelTypes.add(5);
        flexColumnModelTypes.add(2);
        flexColumnModelTypes.add(3);
        flexColumnModelTypes.add(4);
        limitTypes.add(6);
        limitTypes.add(2);
        limitTypes.add(3);
        limitTypes.add(5);
    }

    private class ColumnPrefixEraser
    implements PostOrderTreeTraversalAlgo.Visitor {
        private ColumnPrefixEraser() {
        }

        @Override
        public void visit(ExpressionNode node) {
            switch (node.type) {
                case 6: 
                case 9: 
                case 11: {
                    if (node.paramCount < 3) {
                        node.lhs = this.rewrite(node.lhs);
                        node.rhs = this.rewrite(node.rhs);
                        break;
                    }
                    int n = node.paramCount;
                    for (int i = 0; i < n; ++i) {
                        node.args.setQuick(i, this.rewrite(node.args.getQuick(i)));
                    }
                    break;
                }
            }
        }

        private ExpressionNode rewrite(ExpressionNode node) {
            int dot;
            if (node != null && node.type == 7 && (dot = Chars.indexOfLastUnquoted(node.token, '.')) != -1) {
                return SqlOptimiser.this.nextLiteral(node.token.subSequence(dot + 1, node.token.length()));
            }
            return node;
        }
    }

    private static class LiteralCheckingVisitor
    implements PostOrderTreeTraversalAlgo.Visitor {
        private LowerCaseCharSequenceObjHashMap<QueryColumn> nameTypeMap;

        private LiteralCheckingVisitor() {
        }

        @Override
        public void visit(ExpressionNode node) {
            if (node.type == 7) {
                int len = node.token.length();
                int dot = Chars.indexOf(node.token, 0, len, '.');
                int index = this.nameTypeMap.keyIndex(node.token, dot + 1, len);
                assert (index < 0);
                if (this.nameTypeMap.valueAt((int)index).getAst().type != 7) {
                    throw NonLiteralException.INSTANCE;
                }
            }
        }

        PostOrderTreeTraversalAlgo.Visitor of(LowerCaseCharSequenceObjHashMap<QueryColumn> nameTypeMap) {
            this.nameTypeMap = nameTypeMap;
            return this;
        }
    }

    private class LiteralCollector
    implements PostOrderTreeTraversalAlgo.Visitor {
        private int functionCount;
        private IntHashSet indexes;
        private QueryModel model;
        private ObjList<CharSequence> names;
        private int nullCount;

        private LiteralCollector() {
        }

        @Override
        public void visit(ExpressionNode node) throws SqlException {
            switch (node.type) {
                case 7: {
                    int dot = Chars.indexOfLastUnquoted(node.token, '.');
                    CharSequence name = dot == -1 ? node.token : node.token.subSequence(dot + 1, node.token.length());
                    this.indexes.add(SqlOptimiser.this.validateColumnAndGetModelIndex(this.model, null, node.token, dot, node.position, false));
                    if (this.names == null) break;
                    this.names.add(name);
                    break;
                }
                case 4: {
                    if (!nullConstants.contains(node.token)) break;
                    ++this.nullCount;
                    break;
                }
                case 6: 
                case 9: {
                    ++this.functionCount;
                    break;
                }
            }
        }

        private PostOrderTreeTraversalAlgo.Visitor lhs() {
            this.indexes = SqlOptimiser.this.literalCollectorAIndexes;
            this.names = SqlOptimiser.this.literalCollectorANames;
            return this;
        }

        private void resetCounts() {
            this.nullCount = 0;
            this.functionCount = 0;
        }

        private PostOrderTreeTraversalAlgo.Visitor rhs() {
            this.indexes = SqlOptimiser.this.literalCollectorBIndexes;
            this.names = SqlOptimiser.this.literalCollectorBNames;
            return this;
        }

        private PostOrderTreeTraversalAlgo.Visitor to(IntHashSet indexes) {
            this.indexes = indexes;
            this.names = null;
            return this;
        }

        private void withModel(QueryModel model) {
            this.model = model;
        }
    }

    private static class LiteralRewritingVisitor
    implements PostOrderTreeTraversalAlgo.Visitor {
        private LowerCaseCharSequenceObjHashMap<CharSequence> aliasToColumnMap;

        private LiteralRewritingVisitor() {
        }

        @Override
        public void visit(ExpressionNode node) {
            if (node.type == 7) {
                int index;
                int dot = Chars.indexOfLastUnquoted(node.token, '.');
                int n = index = dot == -1 ? this.aliasToColumnMap.keyIndex(node.token) : this.aliasToColumnMap.keyIndex(node.token, dot + 1, node.token.length());
                if (index < 0) {
                    CharSequence column = this.aliasToColumnMap.valueAtQuick(index);
                    assert (column != null);
                    if (!Chars.equals(node.token, column)) {
                        node.token = column;
                    }
                }
            }
        }

        PostOrderTreeTraversalAlgo.Visitor of(LowerCaseCharSequenceObjHashMap<CharSequence> aliasToColumnMap) {
            this.aliasToColumnMap = aliasToColumnMap;
            return this;
        }
    }

    private static class NonLiteralException
    extends RuntimeException {
        private static final NonLiteralException INSTANCE = new NonLiteralException();

        private NonLiteralException() {
        }
    }
}

