/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public interface MultiArgFunction
extends Function {
    @Override
    default public void close() {
        Misc.freeObjList(this.getArgs());
    }

    public ObjList<Function> getArgs();

    @Override
    default public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        Function.init(this.getArgs(), symbolTableSource, executionContext, null);
    }

    @Override
    default public boolean isConstant() {
        ObjList<Function> args = this.getArgs();
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            if (args.getQuick(i).isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    default public boolean isNonDeterministic() {
        ObjList<Function> args = this.getArgs();
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            Function function = args.getQuick(i);
            if (!function.isNonDeterministic()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean isRandom() {
        ObjList<Function> args = this.getArgs();
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            Function function = args.getQuick(i);
            if (!function.isRandom()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean isRuntimeConstant() {
        ObjList<Function> args = this.getArgs();
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            Function function = args.getQuick(i);
            if (function.isRuntimeConstant() || function.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    default public boolean isThreadSafe() {
        ObjList<Function> args = this.getArgs();
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            Function function = args.getQuick(i);
            if (function.isThreadSafe()) continue;
            return false;
        }
        return true;
    }

    @Override
    default public void offerStateTo(Function that) {
        if (that instanceof MultiArgFunction) {
            ObjList<Function> thatArgs = ((MultiArgFunction)that).getArgs();
            ObjList<Function> thisArgs = this.getArgs();
            if (thatArgs.size() == thisArgs.size()) {
                for (int i = 0; i < thisArgs.size(); ++i) {
                    thisArgs.getQuick(i).offerStateTo(thatArgs.getQuick(i));
                }
            }
        }
    }

    @Override
    default public boolean shouldMemoize() {
        ObjList<Function> args = this.getArgs();
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            Function function = args.getQuick(i);
            if (!function.shouldMemoize()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean supportsParallelism() {
        ObjList<Function> args = this.getArgs();
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            Function function = args.getQuick(i);
            if (function.supportsParallelism()) continue;
            return false;
        }
        return true;
    }

    @Override
    default public void toPlan(PlanSink sink) {
        sink.val(this.getName()).val('(').val(this.getArgs()).val(')');
    }

    @Override
    default public void toTop() {
        GroupByUtils.toTop(this.getArgs());
    }
}

