/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bind;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.BindVariableService;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.FunctionExtension;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;

public class IndexedParameterLinkFunction
implements Function,
FunctionExtension {
    private final int position;
    private final int variableIndex;
    private Function base;
    private int type;

    public IndexedParameterLinkFunction(int variableIndex, int type, int position) {
        this.variableIndex = variableIndex;
        this.type = type;
        this.position = position;
    }

    @Override
    public void assignType(int type, BindVariableService bindVariableService) throws SqlException {
        this.type = bindVariableService.define(this.variableIndex, type, this.position);
    }

    @Override
    public void close() {
        this.base = Misc.free(this.base);
    }

    @Override
    public FunctionExtension extendedOps() {
        return this;
    }

    @Override
    public ArrayView getArray(Record rec) {
        return this.getBase().getArray(rec);
    }

    @Override
    public int getArrayLength() {
        return this.getBase().extendedOps().getArrayLength();
    }

    @Override
    public BinarySequence getBin(Record rec) {
        return this.getBase().getBin(rec);
    }

    @Override
    public long getBinLen(Record rec) {
        return this.getBase().getBinLen(rec);
    }

    @Override
    public boolean getBool(Record rec) {
        return this.getBase().getBool(rec);
    }

    @Override
    public byte getByte(Record rec) {
        return this.getBase().getByte(rec);
    }

    @Override
    public char getChar(Record rec) {
        return this.getBase().getChar(rec);
    }

    @Override
    public long getDate(Record rec) {
        return this.getBase().getDate(rec);
    }

    @Override
    public double getDouble(Record rec) {
        return this.getBase().getDouble(rec);
    }

    @Override
    public float getFloat(Record rec) {
        return this.getBase().getFloat(rec);
    }

    @Override
    public byte getGeoByte(Record rec) {
        return this.getBase().getGeoByte(rec);
    }

    @Override
    public int getGeoInt(Record rec) {
        return this.getBase().getGeoInt(rec);
    }

    @Override
    public long getGeoLong(Record rec) {
        return this.getBase().getGeoLong(rec);
    }

    @Override
    public short getGeoShort(Record rec) {
        return this.getBase().getGeoShort(rec);
    }

    @Override
    public final int getIPv4(Record rec) {
        return this.getBase().getIPv4(rec);
    }

    @Override
    public int getInt(Record rec) {
        return this.getBase().getInt(rec);
    }

    @Override
    @NotNull
    public Interval getInterval(Record rec) {
        return this.getBase().getInterval(rec);
    }

    @Override
    public long getLong(Record rec) {
        return this.getBase().getLong(rec);
    }

    @Override
    public long getLong128Hi(Record rec) {
        return this.getBase().getLong128Hi(rec);
    }

    @Override
    public long getLong128Lo(Record rec) {
        return this.getBase().getLong128Lo(rec);
    }

    @Override
    public void getLong256(Record rec, CharSink<?> sink) {
        this.getBase().getLong256(rec, sink);
    }

    @Override
    public Long256 getLong256A(Record rec) {
        return this.getBase().getLong256A(rec);
    }

    @Override
    public Long256 getLong256B(Record rec) {
        return this.getBase().getLong256B(rec);
    }

    @Override
    public Record getRecord(Record rec) {
        return this.getBase().extendedOps().getRecord(rec);
    }

    @Override
    public RecordCursorFactory getRecordCursorFactory() {
        return this.getBase().getRecordCursorFactory();
    }

    @Override
    public short getShort(Record rec) {
        return this.getBase().getShort(rec);
    }

    @Override
    public CharSequence getStrA(Record rec, int arrayIndex) {
        return this.getBase().extendedOps().getStrA(rec, arrayIndex);
    }

    @Override
    public CharSequence getStrA(Record rec) {
        return this.getBase().getStrA(rec);
    }

    @Override
    public CharSequence getStrB(Record rec, int arrayIndex) {
        return this.getBase().extendedOps().getStrB(rec, arrayIndex);
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.getBase().getStrB(rec);
    }

    @Override
    public int getStrLen(Record rec, int arrayIndex) {
        return this.getBase().extendedOps().getStrLen(rec, arrayIndex);
    }

    @Override
    public int getStrLen(Record rec) {
        return this.getBase().getStrLen(rec);
    }

    @Override
    public CharSequence getSymbol(Record rec) {
        return this.getBase().getSymbol(rec);
    }

    @Override
    public CharSequence getSymbolB(Record rec) {
        return this.getBase().getSymbolB(rec);
    }

    @Override
    public long getTimestamp(Record rec) {
        return this.getBase().getTimestamp(rec);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public Utf8Sequence getVarcharA(Record rec) {
        return this.getBase().getVarcharA(rec);
    }

    @Override
    public Utf8Sequence getVarcharB(Record rec) {
        return this.getBase().getVarcharB(rec);
    }

    @Override
    public int getVarcharSize(Record rec) {
        return this.getBase().getVarcharSize(rec);
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        this.base = executionContext.getBindVariableService().getFunction(this.variableIndex);
        if (this.base == null) {
            throw SqlException.position(this.position).put("undefined bind variable: ").put(this.variableIndex);
        }
        this.type = this.base.getType();
        this.base.init(symbolTableSource, executionContext);
    }

    @Override
    public boolean isNonDeterministic() {
        return true;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val("$").val(this.variableIndex).val("::").val(Chars.toLowerCaseAscii(ColumnType.nameOf(this.type)));
    }

    private Function getBase() {
        assert (this.base != null);
        return this.base;
    }
}

