/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.DoubleList;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class InDoubleFunctionFactory
implements FunctionFactory {
    public static double tryParseDouble(CharSequence seq, int position) throws SqlException {
        try {
            return Numbers.parseDouble(seq);
        }
        catch (NumericException e) {
            throw SqlException.position(position).put("invalid DOUBLE value [").put(seq).put(']');
        }
    }

    @Override
    public String getSignature() {
        return "in(DV)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int constCount = 0;
        int runtimeConstCount = 0;
        int argCount = args.size() - 1;
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 0: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 26: 
                case 33: {
                    break;
                }
                default: {
                    throw SqlException.position(argPositions.getQuick(i)).put("cannot compare DOUBLE with type ").put(ColumnType.nameOf(func.getType()));
                }
            }
            if (func.isConstant()) {
                ++constCount;
            }
            if (!func.isRuntimeConstant()) continue;
            ++runtimeConstCount;
        }
        if (constCount == argCount) {
            DoubleList values = new DoubleList(args.size() - 1);
            InDoubleFunctionFactory.parseToDouble(args, argPositions, values);
            return new InDoubleConstFunction(args.getQuick(0), values);
        }
        if (runtimeConstCount == argCount || runtimeConstCount + constCount == argCount) {
            IntList positions = new IntList();
            positions.addAll(argPositions);
            return new InDoubleRuntimeConstFunction(args.getQuick(0), new ObjList<Function>(args), positions);
        }
        return new InDoubleVarFunction(new ObjList<Function>(args));
    }

    private static void parseToDouble(ObjList<Function> args, IntList argPositions, DoubleList outDoubleList) throws SqlException {
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            outDoubleList.add(InDoubleFunctionFactory.parseValue(argPositions, args.getQuick(i), i));
        }
        outDoubleList.sort();
    }

    private static double parseValue(IntList argPositions, Function func, int i) throws SqlException {
        double val;
        switch (ColumnType.tagOf(func.getType())) {
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                val = func.getDouble(null);
                break;
            }
            case 11: 
            case 12: 
            case 26: 
            case 33: {
                CharSequence tsValue = func.getStrA(null);
                val = tsValue != null ? InDoubleFunctionFactory.tryParseDouble(tsValue, argPositions.getQuick(i)) : Double.NaN;
                break;
            }
            default: {
                throw SqlException.inconvertibleTypes(argPositions.getQuick(i), func.getType(), ColumnType.nameOf(func.getType()), 10, ColumnType.nameOf(10));
            }
        }
        return val;
    }

    private static class InDoubleConstFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function func;
        private final DoubleList inList;

        public InDoubleConstFunction(Function func, DoubleList doubleList) {
            this.func = func;
            this.inList = doubleList;
        }

        @Override
        public Function getArg() {
            return this.func;
        }

        @Override
        public boolean getBool(Record rec) {
            double val = this.func.getDouble(rec);
            return this.negated != this.inList.binarySearch(val, -1) >= 0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.func);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ").val(this.inList);
        }
    }

    private static class InDoubleRuntimeConstFunction
    extends NegatableBooleanFunction
    implements MultiArgFunction {
        private final DoubleList inList;
        private final Function keyFunction;
        private final IntList valueFunctionPositions;
        private final ObjList<Function> valueFunctions;

        public InDoubleRuntimeConstFunction(Function keyFunction, ObjList<Function> valueFunctions, IntList valueFunctionPositions) {
            this.keyFunction = keyFunction;
            this.valueFunctions = valueFunctions;
            this.valueFunctionPositions = valueFunctionPositions;
            this.inList = new DoubleList(valueFunctions.size() - 1);
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.valueFunctions;
        }

        @Override
        public boolean getBool(Record rec) {
            double val = this.keyFunction.getDouble(rec);
            return this.negated != this.inList.binarySearch(val, -1) >= 0;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            MultiArgFunction.super.init(symbolTableSource, executionContext);
            this.inList.clear();
            InDoubleFunctionFactory.parseToDouble(this.valueFunctions, this.valueFunctionPositions, this.inList);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.keyFunction);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ").val(this.inList);
        }
    }

    private static class InDoubleVarFunction
    extends NegatableBooleanFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;

        public InDoubleVarFunction(ObjList<Function> args) {
            this.args = args;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public boolean getBool(Record rec) {
            double argVal = this.args.getQuick(0).getDouble(rec);
            int n = this.args.size();
            for (int i = 1; i < n; ++i) {
                Function func = this.args.getQuick(i);
                double val = Double.NaN;
                switch (ColumnType.tagOf(func.getType())) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: {
                        val = func.getDouble(rec);
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 26: {
                        val = Numbers.parseDoubleQuiet(func.getStrA(rec));
                    }
                }
                if (!Numbers.equals(val, argVal)) continue;
                return !this.negated;
            }
            return this.negated;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.args.getQuick(0));
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ");
            sink.val(this.args, 1);
        }
    }
}

