/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToBooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastCharToBooleanFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(At)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CastCharToBooleanFunction(args.getQuick(0));
    }

    public static class CastCharToBooleanFunction
    extends AbstractCastToBooleanFunction {
        public CastCharToBooleanFunction(Function arg) {
            super(arg);
        }

        @Override
        public boolean getBool(Record rec) {
            char c = this.arg.getChar(rec);
            if (c == '0' || (c | 0x20) == 102) {
                return false;
            }
            if (c == '1' || (c | 0x20) == 116) {
                return true;
            }
            throw ImplicitCastException.inconvertibleValue(c, 4, 1);
        }
    }
}

