/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.std.ObjList;

public class BooleanColumn
extends BooleanFunction
implements Function {
    private static final ObjList<BooleanColumn> COLUMNS = new ObjList(32);
    private final int columnIndex;

    private BooleanColumn(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static BooleanColumn newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new BooleanColumn(columnIndex);
    }

    @Override
    public boolean getBool(Record rec) {
        return rec.getBool(this.columnIndex);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.putColumnName(this.columnIndex);
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new BooleanColumn(i));
        }
    }
}

