/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.std.BitSet;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class EqSymTimestampFunctionFactory
implements FunctionFactory {
    public static final int BITSET_OPTIMISATION_THRESHOLD = 0x100000;

    @Override
    public String getSignature() {
        return "=(KN)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function symbolFunc = args.getQuick(0);
        Function timestampFunc = args.getQuick(1);
        if (symbolFunc.isConstant()) {
            long symbolConstant;
            CharSequence value = symbolFunc.getSymbol(null);
            long l = symbolConstant = value != null ? SqlUtil.implicitCastSymbolAsTimestamp(value) : Long.MIN_VALUE;
            if (timestampFunc.isConstant()) {
                return symbolConstant == timestampFunc.getLong(null) ? BooleanConstant.TRUE : BooleanConstant.FALSE;
            }
            return new ConstSymbolVarTimestampFunction(symbolFunc, timestampFunc, symbolConstant);
        }
        if (timestampFunc.isRuntimeConstant() && !symbolFunc.isNonDeterministic()) {
            return new VarSymbolRuntimeConstTimestampFunction(symbolFunc, timestampFunc);
        }
        if (timestampFunc.isConstant() && !symbolFunc.isNonDeterministic()) {
            return new VarSymbolConstTimestampFunction(symbolFunc, timestampFunc, timestampFunc.getTimestamp(null));
        }
        return new VarSymbolVarTimestampFunction(symbolFunc, timestampFunc);
    }

    private static class ConstSymbolVarTimestampFunction
    extends AbstractEqBinaryFunction {
        private final long symbolConstant;

        public ConstSymbolVarTimestampFunction(Function symbolFunc, Function timestampFunc, long symbolConstant) {
            super(symbolFunc, timestampFunc);
            this.symbolConstant = symbolConstant;
        }

        @Override
        public boolean getBool(Record rec) {
            long timestamp = this.right.getTimestamp(rec);
            return this.negated == (timestamp != this.symbolConstant);
        }
    }

    private static class VarSymbolRuntimeConstTimestampFunction
    extends AbstractEqBinaryFunction {
        private VarSymbolConstTimestampFunction innerFunc;

        public VarSymbolRuntimeConstTimestampFunction(Function symbolFunc, Function timestampFunc) {
            super(symbolFunc, timestampFunc);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.innerFunc.getBool(rec);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            long timestampConstant = this.right.getTimestamp(null);
            this.innerFunc = new VarSymbolConstTimestampFunction(this.left, this.right, timestampConstant);
        }
    }

    private static class VarSymbolConstTimestampFunction
    extends AbstractEqBinaryFunction {
        private final BitSet hits;
        private final BitSet misses;
        private final long timestampConstant;

        public VarSymbolConstTimestampFunction(Function symbolFunc, Function timestampFunc, long timestampConstant) {
            super(symbolFunc, timestampFunc);
            this.timestampConstant = timestampConstant;
            this.hits = new BitSet();
            this.misses = new BitSet();
        }

        @Override
        public void clear() {
            super.clear();
            this.hits.clear();
            this.misses.clear();
        }

        @Override
        public boolean getBool(Record rec) {
            long symbol;
            boolean result;
            int id = this.left.getInt(rec);
            if (id >= 0 && id < 0x100000) {
                if (this.hits.get(id)) {
                    return true;
                }
                if (this.misses.get(id)) {
                    return false;
                }
            }
            boolean bl = result = this.negated == ((symbol = this.left.getTimestamp(rec)) != this.timestampConstant);
            if (id >= 0 && id < 0x100000) {
                if (result) {
                    this.hits.set(id);
                } else {
                    this.misses.set(id);
                }
            }
            return result;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }
    }

    private static class VarSymbolVarTimestampFunction
    extends AbstractEqBinaryFunction {
        public VarSymbolVarTimestampFunction(Function symbolFunc, Function timestampFunc) {
            super(symbolFunc, timestampFunc);
        }

        @Override
        public boolean getBool(Record rec) {
            long timestamp;
            long symbol = this.left.getTimestamp(rec);
            return this.negated == (symbol != (timestamp = this.right.getTimestamp(rec)));
        }
    }
}

