/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCovarGroupByFunction
extends DoubleFunction
implements GroupByFunction,
BinaryFunction {
    protected final Function xFunc;
    protected final Function yFunc;
    protected int valueIndex;

    protected AbstractCovarGroupByFunction(@NotNull Function arg0, @NotNull Function arg1) {
        this.yFunc = arg0;
        this.xFunc = arg1;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        double y = this.yFunc.getDouble(record);
        double x = this.xFunc.getDouble(record);
        mapValue.putDouble(this.valueIndex, 0.0);
        mapValue.putDouble(this.valueIndex + 1, 0.0);
        mapValue.putDouble(this.valueIndex + 2, 0.0);
        mapValue.putLong(this.valueIndex + 3, 0L);
        if (Numbers.isFinite(y) && Numbers.isFinite(x)) {
            this.aggregate(mapValue, y, x);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        double y = this.yFunc.getDouble(record);
        double x = this.xFunc.getDouble(record);
        if (Numbers.isFinite(y) && Numbers.isFinite(x)) {
            this.aggregate(mapValue, y, x);
        }
    }

    @Override
    public Function getLeft() {
        return this.yFunc;
    }

    @Override
    public Function getRight() {
        return this.xFunc;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(10);
        columnTypes.add(10);
        columnTypes.add(10);
        columnTypes.add(6);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public void setDouble(MapValue mapValue, double value) {
        mapValue.putDouble(this.valueIndex + 2, value);
        mapValue.putLong(this.valueIndex + 3, 1L);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDouble(this.valueIndex, Double.NaN);
        mapValue.putDouble(this.valueIndex + 1, Double.NaN);
        mapValue.putDouble(this.valueIndex + 2, Double.NaN);
        mapValue.putLong(this.valueIndex + 3, 0L);
    }

    @Override
    public boolean supportsParallelism() {
        return false;
    }

    protected void aggregate(MapValue mapValue, double y, double x) {
        double meanY = mapValue.getDouble(this.valueIndex);
        double meanX = mapValue.getDouble(this.valueIndex + 1);
        double sumXY = mapValue.getDouble(this.valueIndex + 2);
        long count = mapValue.getLong(this.valueIndex + 3) + 1L;
        double oldMeanY = meanY;
        meanY += (y - meanY) / (double)count;
        meanX += (x - meanX) / (double)count;
        mapValue.putDouble(this.valueIndex, meanY);
        mapValue.putDouble(this.valueIndex + 1, meanX);
        mapValue.putDouble(this.valueIndex + 2, sumXY += (y - oldMeanY) * (x - meanX));
        mapValue.addLong(this.valueIndex + 3, 1L);
    }
}

