/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.groupby.FirstFloatGroupByFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public class FirstNotNullFloatGroupByFunction
extends FirstFloatGroupByFunction {
    public FirstNotNullFloatGroupByFunction(@NotNull Function arg) {
        super(arg);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        if (Numbers.isNull(mapValue.getFloat(this.valueIndex + 1))) {
            this.computeFirst(mapValue, record, rowId);
        }
    }

    @Override
    public String getName() {
        return "first_not_null";
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long destRowId;
        float srcVal = srcValue.getFloat(this.valueIndex + 1);
        if (Numbers.isNull(srcVal)) {
            return;
        }
        long srcRowId = srcValue.getLong(this.valueIndex);
        if (srcRowId < (destRowId = destValue.getLong(this.valueIndex)) || destRowId == Long.MIN_VALUE) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putFloat(this.valueIndex + 1, srcVal);
        }
    }
}

