/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class IsLongOrderedGroupByFunction
extends BooleanFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public IsLongOrderedGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putBool(this.valueIndex, true);
        mapValue.putLong(this.valueIndex + 1, this.arg.getLong(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        if (mapValue.getBool(this.valueIndex)) {
            long prev = mapValue.getLong(this.valueIndex + 1);
            long curr = this.arg.getLong(record);
            if (curr < prev) {
                mapValue.putBool(this.valueIndex, false);
            } else {
                mapValue.putLong(this.valueIndex + 1, curr);
            }
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public boolean getBool(Record rec) {
        return rec.getBool(this.valueIndex);
    }

    @Override
    public String getName() {
        return "isOrdered";
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(1);
        columnTypes.add(6);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putBool(this.valueIndex, true);
    }

    @Override
    public boolean supportsParallelism() {
        return false;
    }
}

