/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.groupby.FirstTimestampGroupByFunction;
import org.jetbrains.annotations.NotNull;

public class LastNotNullTimestampGroupByFunction
extends FirstTimestampGroupByFunction {
    public LastNotNullTimestampGroupByFunction(@NotNull Function arg) {
        super(arg);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        if (this.arg.getTimestamp(record) != Long.MIN_VALUE) {
            this.computeFirst(mapValue, record, rowId);
        }
    }

    @Override
    public String getName() {
        return "last_not_null";
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long destRowId;
        long srcVal = srcValue.getTimestamp(this.valueIndex + 1);
        if (srcVal == Long.MIN_VALUE) {
            return;
        }
        long srcRowId = srcValue.getLong(this.valueIndex);
        if (srcRowId > (destRowId = destValue.getLong(this.valueIndex))) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putLong(this.valueIndex + 1, srcVal);
        }
    }
}

