/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.json;

import io.questdb.cairo.sql.Function;
import io.questdb.std.Misc;
import io.questdb.std.QuietCloseable;
import io.questdb.std.json.SimdJsonParser;
import io.questdb.std.json.SimdJsonResult;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8Sink;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonExtractSupportingState
implements QuietCloseable {
    public static final String EXTRACT_FUNCTION_NAME = "json_extract";
    @Nullable
    public StringSink destUtf16Sink;
    @Nullable
    public DirectUtf8Sink destUtf8Sink;
    public DirectUtf8Sequence jsonSeq = null;
    public SimdJsonParser parser = new SimdJsonParser();
    public SimdJsonResult simdJsonResult = new SimdJsonResult();
    private DirectUtf8Sink jsonSink = null;

    JsonExtractSupportingState(@Nullable DirectUtf8Sink destUtf8Sink, boolean useUtf6Sink) {
        this.destUtf8Sink = destUtf8Sink;
        this.destUtf16Sink = useUtf6Sink ? new StringSink() : null;
    }

    public static DirectUtf8Sink varcharConstantToJsonPointer(Function fn) {
        Utf8Sequence seq = fn.getVarcharA(null);
        if (seq == null) {
            return null;
        }
        try (DirectUtf8Sink path = new DirectUtf8Sink(seq.size());){
            path.put(seq);
            DirectUtf8Sink pointer = new DirectUtf8Sink(seq.size());
            SimdJsonParser.convertJsonPathToPointer(path, pointer);
            DirectUtf8Sink directUtf8Sink = pointer;
            return directUtf8Sink;
        }
    }

    @Override
    public void close() {
        this.parser = Misc.free(this.parser);
        this.jsonSink = Misc.free(this.jsonSink);
        this.simdJsonResult = Misc.free(this.simdJsonResult);
        this.destUtf8Sink = Misc.free(this.destUtf8Sink);
    }

    public void deflate() {
        Misc.free(this.destUtf8Sink);
    }

    public DirectUtf8Sequence initPaddedJson(@NotNull Utf8Sequence json) {
        if (json.tailPadding() >= (long)SimdJsonParser.SIMDJSON_PADDING) {
            this.jsonSeq = (DirectUtf8Sequence)json;
        } else {
            this.initPaddedJsonSlow(json);
        }
        return this.jsonSeq;
    }

    public void reopen() {
        if (this.destUtf8Sink != null) {
            this.destUtf8Sink.reopen();
        }
    }

    private void initPaddedJsonSlow(@NotNull Utf8Sequence json) {
        if (this.jsonSink == null) {
            this.jsonSink = new DirectUtf8Sink(json.size() + SimdJsonParser.SIMDJSON_PADDING);
        } else {
            this.jsonSink.clear();
            this.jsonSink.reserve(json.size() + SimdJsonParser.SIMDJSON_PADDING);
        }
        this.jsonSink.put(json);
        this.jsonSeq = this.jsonSink;
    }
}

