/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IPv4Function;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class BitwiseNotIPv4FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "~(X)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new BitwiseNotIPv4Function(args.getQuick(0));
    }

    public static final class BitwiseNotIPv4Function
    extends IPv4Function
    implements UnaryFunction {
        private final Function value;

        public BitwiseNotIPv4Function(Function value) {
            this.value = value;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public int getIPv4(Record rec) {
            int val = this.value.getIPv4(rec);
            return val != 0 ? ~val : 0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val('~').val(this.value);
        }
    }
}

