/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IPv4Function;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.IPv4Constant;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;

public class IPv4VarcharNetmaskFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "netmask(\u00d8)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function varcharFunc = args.getQuick(0);
        if (varcharFunc.isConstant()) {
            CharSequence str = varcharFunc.getStrA(null);
            if (str == null) {
                return IPv4Constant.NULL;
            }
            int val = Numbers.getIPv4Netmask(str);
            return val == 1 ? IPv4Constant.NULL : IPv4Constant.newInstance(val);
        }
        return new Func(varcharFunc);
    }

    private static class Func
    extends IPv4Function
    implements UnaryFunction {
        private final Function arg;

        public Func(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public int getIPv4(Record rec) {
            Utf8Sequence seq = this.arg.getVarcharA(rec);
            if (seq == null) {
                return 0;
            }
            int val = Numbers.getIPv4Netmask(seq.asAsciiCharSequence());
            return val == 1 ? 0 : val;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("netmask(").val(this.arg).val(')');
        }
    }
}

