/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.memoization;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NullRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.Long256Function;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.str.CharSink;

public final class Long256FunctionMemoizer
extends Long256Function
implements UnaryFunction {
    private final Function fn;
    private final Long256Impl valueLeft = new Long256Impl();
    private final Long256Impl valueRight = new Long256Impl();
    private Record recordLeft;
    private Record recordRight;

    public Long256FunctionMemoizer(Function fn) {
        assert (fn.shouldMemoize());
        this.fn = fn;
    }

    @Override
    public Function getArg() {
        return this.fn;
    }

    @Override
    public void getLong256(Record rec, CharSink<?> sink) {
        if (this.recordLeft == rec) {
            this.valueLeft.toSink(sink);
            return;
        }
        if (this.recordRight == rec) {
            this.valueRight.toSink(sink);
            return;
        }
        this.fn.getLong256(rec, sink);
    }

    @Override
    public Long256 getLong256A(Record rec) {
        if (this.recordLeft == rec) {
            return this.valueLeft;
        }
        if (this.recordRight == rec) {
            return this.valueRight;
        }
        return this.fn.getLong256A(rec);
    }

    @Override
    public Long256 getLong256B(Record rec) {
        return this.fn.getLong256B(rec);
    }

    @Override
    public String getName() {
        return "memoize";
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        this.recordLeft = NullRecord.INSTANCE;
        this.recordRight = NullRecord.INSTANCE;
        UnaryFunction.super.init(symbolTableSource, executionContext);
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void memoize(Record record) {
        Long256 long256 = this.fn.getLong256A(record);
        if (this.recordLeft == record) {
            this.valueLeft.setAll(long256.getLong0(), long256.getLong1(), long256.getLong2(), long256.getLong3());
        } else if (this.recordRight == record) {
            this.valueRight.setAll(long256.getLong0(), long256.getLong1(), long256.getLong2(), long256.getLong3());
        } else if (this.recordLeft == NullRecord.INSTANCE) {
            this.recordLeft = record;
            this.valueLeft.setAll(long256.getLong0(), long256.getLong1(), long256.getLong2(), long256.getLong3());
        } else if (this.recordRight == NullRecord.INSTANCE) {
            assert (this.supportsRandomAccess());
            this.recordRight = record;
            this.valueRight.setAll(long256.getLong0(), long256.getLong1(), long256.getLong2(), long256.getLong3());
        } else {
            throw CairoException.nonCritical().put("Long256FunctionMemoizer can only memoize two records, but got more than two: [recordLeft=").put(this.recordLeft.toString()).put(", recordRight=").put(this.recordRight.toString()).put(", newRecord=").put(record.toString()).put(']');
        }
    }

    @Override
    public boolean shouldMemoize() {
        return true;
    }

    @Override
    public boolean supportsRandomAccess() {
        return this.fn.supportsRandomAccess();
    }
}

