/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndIntCCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_int(iii)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int lo = args.getQuick(0).getInt(null);
        int hi = args.getQuick(1).getInt(null);
        int nanRate = args.getQuick(2).getInt(null);
        if (nanRate < 0) {
            throw SqlException.$(argPositions.getQuick(2), "invalid NaN rate");
        }
        if (lo < hi) {
            return new RndFunction(lo, hi, nanRate);
        }
        throw SqlException.position(position).put("invalid range");
    }

    private static class RndFunction
    extends IntFunction
    implements Function {
        private final int lo;
        private final int nanRate;
        private final int range;
        private Rnd rnd;

        public RndFunction(int lo, int hi, int nanRate) {
            this.lo = lo;
            this.range = hi - lo + 1;
            this.nanRate = nanRate + 1;
        }

        @Override
        public int getInt(Record rec) {
            if (this.rnd.nextInt() % this.nanRate == 1) {
                return Integer.MIN_VALUE;
            }
            return this.lo + this.rnd.nextPositiveInt() % this.range;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public boolean shouldMemoize() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_int(").val(this.lo).val(',').val(this.range + this.lo - 1).val(',').val(this.nanRate - 1).val(')');
        }
    }
}

