/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.table.ReadParquetPageFrameCursor;
import io.questdb.griffin.engine.table.PageFrameRecordCursorImpl;
import io.questdb.griffin.engine.table.PageFrameRowCursorFactory;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;
import org.jetbrains.annotations.NotNull;

public class ReadParquetPageFrameRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final PageFrameRecordCursorImpl cursor;
    private final ReadParquetPageFrameCursor pageFrameCursor;
    private Path path;

    public ReadParquetPageFrameRecordCursorFactory(@NotNull CairoConfiguration configuration, Path path, RecordMetadata metadata) {
        super(metadata);
        this.path = new Path().of(path);
        this.cursor = new PageFrameRecordCursorImpl(configuration, metadata, new PageFrameRowCursorFactory(0), true, null);
        this.pageFrameCursor = new ReadParquetPageFrameCursor(configuration.getFilesFacade(), metadata);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        this.pageFrameCursor.of(this.path.$());
        try {
            this.cursor.of(this.pageFrameCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable e) {
            this.pageFrameCursor.close();
            throw e;
        }
    }

    @Override
    public PageFrameCursor getPageFrameCursor(SqlExecutionContext executionContext, int order) throws SqlException {
        assert (order != 1);
        this.pageFrameCursor.of(this.path.$());
        return this.pageFrameCursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public boolean supportsPageFrameCursor() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("parquet page frame scan");
    }

    @Override
    protected void _close() {
        Misc.free(this.cursor);
        Misc.free(this.pageFrameCursor);
        this.path = Misc.free(this.path);
    }
}

