/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.LagDoubleFunctionFactory;
import io.questdb.griffin.engine.functions.window.LeadLagWindowFunctionFactoryHelper;
import io.questdb.griffin.engine.functions.window.WindowDoubleFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class LeadDoubleFunctionFactory
extends AbstractWindowFunctionFactory {
    private static final String SIGNATURE = "lead(DV)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return LeadLagWindowFunctionFactoryHelper.newInstance(position, args, argPositions, configuration, sqlExecutionContext, defaultValue -> {
            if (!ColumnType.isAssignableFrom(defaultValue.getType(), 10)) {
                throw SqlException.$(argPositions.getQuick(2), "default value must be can cast to double");
            }
        }, LeadFunction::new, LagDoubleFunctionFactory.LeadLagValueCurrentRow::new, LeadOverPartitionFunction::new);
    }

    static class LeadOverPartitionFunction
    extends LeadLagWindowFunctionFactoryHelper.BaseLeadOverPartitionFunction
    implements WindowDoubleFunction {
        public LeadOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, MemoryARW memory, Function arg, boolean ignoreNulls, Function defaultValue, long offset) {
            super(map, partitionByRecord, partitionBySink, memory, arg, ignoreNulls, defaultValue, offset);
        }

        @Override
        protected boolean doPass1(long count, long offset, long startOffset, long firstIdx, Record record, long recordOffset, WindowSPI spi) {
            boolean respectNulls;
            double d = this.arg.getDouble(record);
            double leadValue = count < offset ? (this.defaultValue == null ? Double.NaN : this.defaultValue.getDouble(record)) : this.memory.getDouble(startOffset + firstIdx * 8L);
            boolean bl = respectNulls = !this.ignoreNulls || Numbers.isFinite(d);
            if (respectNulls) {
                this.memory.putDouble(startOffset + firstIdx * 8L, d);
            }
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), leadValue);
            return respectNulls;
        }
    }

    static class LeadFunction
    extends LeadLagWindowFunctionFactoryHelper.BaseLeadFunction
    implements Reopenable,
    WindowDoubleFunction {
        public LeadFunction(Function arg, Function defaultValueFunc, long offset, MemoryARW memory, boolean ignoreNulls) {
            super(arg, defaultValueFunc, offset, memory, ignoreNulls);
        }

        @Override
        protected boolean doPass1(Record record, long recordOffset, WindowSPI spi) {
            boolean respectNull;
            double leadValue = this.count < this.offset ? (this.defaultValue == null ? Double.NaN : this.defaultValue.getDouble(record)) : this.buffer.getDouble((long)this.loIdx * 8L);
            double d = this.arg.getDouble(record);
            boolean bl = respectNull = !this.ignoreNulls || Numbers.isFinite(d);
            if (respectNull) {
                this.buffer.putDouble((long)this.loIdx * 8L, d);
            }
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), leadValue);
            return respectNull;
        }
    }
}

