/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnFilter;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.RecordValueSink;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.AbstractSymbolWrapOverCursor;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.SymbolWrapOverJoinRecord;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.IntList;
import io.questdb.std.Misc;

public class LtJoinRecordCursorFactory
extends AbstractJoinRecordCursorFactory {
    private final LtJoinRecordCursor cursor;
    private final int mapEvacuationThreshold;
    private final RecordSink masterKeySink;
    private final IntList slaveColumnIndex;
    private final RecordSink slaveKeySink;
    private final int slaveValueTimestampIndex;
    private final long toleranceInterval;

    public LtJoinRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes mapKeyTypes, ColumnTypes mapValueTypes, ColumnTypes slaveColumnTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, RecordValueSink slaveValueSink, IntList columnIndex, JoinContext joinContext, ColumnFilter masterTableKeyColumns, long toleranceInterval, int slaveValueTimestampIndex) {
        super(metadata, joinContext, masterFactory, slaveFactory);
        try {
            this.masterKeySink = masterKeySink;
            this.slaveKeySink = slaveKeySink;
            Map joinKeyMapA = MapFactory.createUnorderedMap(configuration, mapKeyTypes, mapValueTypes);
            Map joinKeyMapB = toleranceInterval != Long.MIN_VALUE ? MapFactory.createUnorderedMap(configuration, mapKeyTypes, mapValueTypes) : null;
            int slaveWrappedOverMaster = slaveColumnTypes.getColumnCount() - masterTableKeyColumns.getColumnCount();
            this.cursor = new LtJoinRecordCursor(columnSplit, joinKeyMapA, joinKeyMapB, NullRecordFactory.getInstance(slaveColumnTypes), masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex(), slaveValueSink, masterTableKeyColumns, slaveWrappedOverMaster, columnIndex);
            this.slaveColumnIndex = columnIndex;
            this.toleranceInterval = toleranceInterval;
            this.slaveValueTimestampIndex = slaveValueTimestampIndex;
            this.mapEvacuationThreshold = configuration.getSqlAsOfJoinMapEvacuationThreshold();
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.masterFactory.followedOrderByAdvice();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        RecordCursor slaveCursor = null;
        try {
            slaveCursor = this.slaveFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor);
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Lt Join");
        sink.attr("condition").val(this.joinContext);
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        Misc.freeIfCloseable(this.getMetadata());
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
        Misc.free(this.cursor);
    }

    private class LtJoinRecordCursor
    extends AbstractSymbolWrapOverCursor {
        private final Map joinKeyMapA;
        private final Map joinKeyMapB;
        private final int masterTimestampIndex;
        private final SymbolWrapOverJoinRecord record;
        private final int slaveTimestampIndex;
        private final RecordValueSink valueSink;
        private Map currentJoinKeyMap;
        private boolean danglingSlaveRecord;
        private boolean isMasterHasNextPending;
        private boolean isOpen;
        private boolean masterHasNext;
        private Record masterRecord;
        private Record slaveRecord;
        private long slaveTimestamp;

        public LtJoinRecordCursor(int columnSplit, Map joinKeyMapA, Map joinKeyMapB, Record nullRecord, int masterTimestampIndex, int slaveTimestampIndex, RecordValueSink valueSink, ColumnFilter masterTableKeyColumns, int slaveWrappedOverMaster, IntList slaveColumnIndex) {
            super(columnSplit, slaveWrappedOverMaster, masterTableKeyColumns, slaveColumnIndex);
            this.danglingSlaveRecord = false;
            this.slaveTimestamp = Long.MIN_VALUE;
            this.record = new SymbolWrapOverJoinRecord(columnSplit, nullRecord, slaveWrappedOverMaster, masterTableKeyColumns);
            this.joinKeyMapA = joinKeyMapA;
            this.joinKeyMapB = joinKeyMapB;
            this.currentJoinKeyMap = joinKeyMapA;
            this.masterTimestampIndex = masterTimestampIndex;
            this.slaveTimestampIndex = slaveTimestampIndex;
            this.valueSink = valueSink;
            this.isOpen = true;
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            this.masterCursor.calculateSize(circuitBreaker, counter);
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMapA.close();
                if (this.joinKeyMapB != null) {
                    this.joinKeyMapB.close();
                }
                super.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.isMasterHasNextPending) {
                this.masterHasNext = this.masterCursor.hasNext();
                this.isMasterHasNextPending = false;
            }
            if (this.masterHasNext) {
                MapValue value;
                MapKey key;
                long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
                long minSlaveTimestamp = LtJoinRecordCursorFactory.this.toleranceInterval == Long.MIN_VALUE ? Long.MIN_VALUE : masterTimestamp - LtJoinRecordCursorFactory.this.toleranceInterval;
                long slaveTimestamp = this.slaveTimestamp;
                if (slaveTimestamp < masterTimestamp) {
                    if (this.danglingSlaveRecord) {
                        if (slaveTimestamp >= minSlaveTimestamp) {
                            key = this.currentJoinKeyMap.withKey();
                            key.put(this.slaveRecord, LtJoinRecordCursorFactory.this.slaveKeySink);
                            value = key.createValue();
                            this.valueSink.copy(this.slaveRecord, value);
                        }
                        this.danglingSlaveRecord = false;
                    }
                    this.evacuateJoinKeyMap(masterTimestamp);
                    while (this.slaveCursor.hasNext()) {
                        slaveTimestamp = this.slaveRecord.getTimestamp(this.slaveTimestampIndex);
                        if (slaveTimestamp < masterTimestamp) {
                            if (slaveTimestamp < minSlaveTimestamp) continue;
                            key = this.currentJoinKeyMap.withKey();
                            key.put(this.slaveRecord, LtJoinRecordCursorFactory.this.slaveKeySink);
                            value = key.createValue();
                            this.valueSink.copy(this.slaveRecord, value);
                            continue;
                        }
                        this.danglingSlaveRecord = true;
                        break;
                    }
                    this.slaveTimestamp = slaveTimestamp;
                }
                key = this.currentJoinKeyMap.withKey();
                key.put(this.masterRecord, LtJoinRecordCursorFactory.this.masterKeySink);
                value = key.findValue();
                if (value != null) {
                    value.setMapRecordHere();
                    if (LtJoinRecordCursorFactory.this.toleranceInterval == Long.MIN_VALUE) {
                        this.record.hasSlave(true);
                    } else {
                        long minTimestamp;
                        long slaveRecordTimestamp = value.getTimestamp(LtJoinRecordCursorFactory.this.slaveValueTimestampIndex);
                        this.record.hasSlave(slaveRecordTimestamp >= (minTimestamp = masterTimestamp - LtJoinRecordCursorFactory.this.toleranceInterval));
                    }
                } else {
                    this.record.hasSlave(false);
                }
                this.isMasterHasNextPending = true;
                return true;
            }
            return false;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return this.masterCursor.size();
        }

        @Override
        public void toTop() {
            this.currentJoinKeyMap.clear();
            this.currentJoinKeyMap = this.joinKeyMapA;
            assert (this.currentJoinKeyMap.size() == 0L);
            this.slaveTimestamp = Long.MIN_VALUE;
            this.danglingSlaveRecord = false;
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
            this.isMasterHasNextPending = true;
        }

        private void evacuateJoinKeyMap(long masterTimestamp) {
            Map dstMap;
            if (LtJoinRecordCursorFactory.this.toleranceInterval == Long.MIN_VALUE || this.currentJoinKeyMap.size() < (long)LtJoinRecordCursorFactory.this.mapEvacuationThreshold) {
                return;
            }
            assert (this.joinKeyMapB != null) : "Join key map B must not be null";
            Map map = dstMap = this.currentJoinKeyMap == this.joinKeyMapA ? this.joinKeyMapB : this.joinKeyMapA;
            assert (dstMap.size() == 0L) : "Evacuating non-empty map: " + dstMap.size();
            MapRecordCursor srcMapCursor = this.currentJoinKeyMap.getCursor();
            MapRecord srcRecord = this.currentJoinKeyMap.getRecord();
            long minTimestamp = masterTimestamp - LtJoinRecordCursorFactory.this.toleranceInterval;
            while (srcMapCursor.hasNext()) {
                MapValue srcValue = srcRecord.getValue();
                long srcTimestamp = srcValue.getTimestamp(LtJoinRecordCursorFactory.this.slaveValueTimestampIndex);
                if (srcTimestamp < minTimestamp) continue;
                long srcKeyHash = srcRecord.keyHashCode();
                MapKey dstKey = dstMap.withKey();
                srcRecord.copyToKey(dstKey);
                MapValue dstValue = dstKey.createValue(srcKeyHash);
                srcRecord.copyValue(dstValue);
            }
            this.currentJoinKeyMap.clear();
            this.currentJoinKeyMap = dstMap;
            boolean hasSlave = this.record.hasSlave();
            this.record.of(this.masterRecord, this.currentJoinKeyMap.getRecord());
            this.record.hasSlave(hasSlave);
        }

        private void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.joinKeyMapA.reopen();
                if (this.joinKeyMapB != null) {
                    this.joinKeyMapB.reopen();
                }
            }
            this.currentJoinKeyMap = this.joinKeyMapA;
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.slaveTimestamp = Long.MIN_VALUE;
            this.danglingSlaveRecord = false;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecord = slaveCursor.getRecord();
            MapRecord mapRecordA = this.joinKeyMapA.getRecord();
            mapRecordA.setSymbolTableResolver(slaveCursor, LtJoinRecordCursorFactory.this.slaveColumnIndex);
            this.record.of(this.masterRecord, mapRecordA);
            if (this.joinKeyMapB != null) {
                MapRecord mapRecordB = this.joinKeyMapB.getRecord();
                mapRecordB.setSymbolTableResolver(slaveCursor, LtJoinRecordCursorFactory.this.slaveColumnIndex);
            }
            this.isMasterHasNextPending = true;
        }
    }
}

