/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.Reopenable;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordRandomAccess;
import io.questdb.griffin.engine.AbstractRedBlackTree;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.std.DirectIntList;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Utf16Sink;

public class LimitedSizeLongTreeChain
extends AbstractRedBlackTree
implements Reopenable {
    private static final int CHAIN_END = -1;
    private static final long CHAIN_VALUE_SIZE = 12L;
    private static final long FREE_SLOT = -2L;
    private static final long MAX_VALUE_HEAP_SIZE_LIMIT = Integer.toUnsignedLong(-1) - 1L << 2;
    private final DirectIntList chainFreeList;
    private final TreeCursor cursor = new TreeCursor();
    private final DirectIntList freeList;
    private final long initialValueHeapSize;
    private final long maxValueHeapSize;
    private int currentValues = 0;
    private boolean isFirstN;
    private long limit;
    private int minMaxNode = -1;
    private long minMaxRowId = -1L;
    private long valueHeapLimit;
    private long valueHeapPos;
    private long valueHeapSize;
    private long valueHeapStart;

    public LimitedSizeLongTreeChain(long keyPageSize, int keyMaxPages, long valuePageSize, int valueMaxPages) {
        super(keyPageSize, keyMaxPages);
        try {
            this.freeList = new DirectIntList(16L, 59);
            this.chainFreeList = new DirectIntList(16L, 59);
            this.valueHeapSize = this.initialValueHeapSize = valuePageSize;
            this.valueHeapStart = this.valueHeapPos = Unsafe.malloc(this.valueHeapSize, 59);
            this.valueHeapLimit = this.valueHeapStart + this.valueHeapSize;
            this.maxValueHeapSize = Math.min(valuePageSize * (long)valueMaxPages, MAX_VALUE_HEAP_SIZE_LIMIT);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.valueHeapPos = this.valueHeapStart;
        this.minMaxRowId = -1L;
        this.minMaxNode = -1;
        this.currentValues = 0;
        this.cursor.clear();
        this.freeList.clear();
        this.chainFreeList.clear();
    }

    @Override
    public void close() {
        super.close();
        this.clear();
        Misc.free(this.freeList);
        Misc.free(this.chainFreeList);
        if (this.valueHeapStart != 0L) {
            this.valueHeapStart = Unsafe.free(this.valueHeapStart, this.valueHeapSize, 59);
            this.valueHeapPos = 0L;
            this.valueHeapLimit = 0L;
            this.valueHeapSize = 0L;
        }
    }

    public int find(Record searchedRecord, RecordCursor sourceCursor, Record placeholder, RecordComparator comparator) {
        comparator.setLeft(searchedRecord);
        if (this.root == -1) {
            return -1;
        }
        int p = this.root;
        do {
            sourceCursor.recordAt(placeholder, this.rowId(this.refOf(p)));
            int cmp = comparator.compare(placeholder);
            if (cmp < 0) {
                p = this.leftOf(p);
                continue;
            }
            if (cmp > 0) {
                p = this.rightOf(p);
                continue;
            }
            return p;
        } while (p > -1);
        return -1;
    }

    public TreeCursor getCursor() {
        this.cursor.toTop();
        return this.cursor;
    }

    public void print(Utf16Sink sink) {
        this.print(sink, null);
    }

    public void print(Utf16Sink sink, ValuePrinter printer) {
        if (this.root == -1) {
            sink.put("[EMPTY TREE]");
        } else {
            if (printer == null) {
                printer = ValuePrinter::toRowId;
            }
            this.printTree(sink, this.root, 0, false, printer);
        }
    }

    public void put(Record currentRecord, RecordRandomAccess sourceCursor, Record ownedRecord, RecordComparator comparator) {
        int cmp;
        int parent;
        if (this.limit == 0L) {
            return;
        }
        if (this.limit == (long)this.currentValues) {
            int cmp2 = comparator.compare(currentRecord);
            if (this.isFirstN && cmp2 <= 0) {
                return;
            }
            if (!this.isFirstN && cmp2 >= 0) {
                return;
            }
            this.removeAndCache(this.minMaxNode);
        }
        if (this.root == -1) {
            long currentRecordRowId = currentRecord.getRowId();
            this.putParent(currentRecordRowId);
            this.minMaxNode = this.root;
            this.minMaxRowId = currentRecordRowId;
            ++this.currentValues;
            this.prepareComparatorLeftSideIfAtMaxCapacity(sourceCursor, ownedRecord, comparator);
            return;
        }
        comparator.setLeft(currentRecord);
        int p = this.root;
        do {
            parent = p;
            int r = this.refOf(p);
            long rowId = this.rowId(r);
            sourceCursor.recordAt(ownedRecord, rowId);
            cmp = comparator.compare(ownedRecord);
            if (cmp < 0) {
                p = this.leftOf(p);
                continue;
            }
            if (cmp > 0) {
                p = this.rightOf(p);
                continue;
            }
            this.setRef(p, this.appendValue(currentRecord.getRowId(), r));
            if (this.minMaxRowId == -1L) {
                this.refreshMinMaxNode();
            }
            ++this.currentValues;
            this.prepareComparatorLeftSideIfAtMaxCapacity(sourceCursor, ownedRecord, comparator);
            return;
        } while (p > -1);
        p = this.allocateBlock(parent, currentRecord.getRowId());
        if (cmp < 0) {
            this.setLeft(parent, p);
        } else {
            this.setRight(parent, p);
        }
        this.fixInsert(p);
        this.refreshMinMaxNode();
        ++this.currentValues;
        this.prepareComparatorLeftSideIfAtMaxCapacity(sourceCursor, ownedRecord, comparator);
    }

    public void removeAndCache(int node) {
        if (this.hasMoreThanOneValue(node)) {
            this.removeMostRecentChainValue(node);
        } else {
            int nodeToRemove = super.remove(node);
            this.clearBlock(nodeToRemove);
            this.freeList.add(nodeToRemove);
            this.minMaxRowId = -1L;
            this.minMaxNode = -1;
        }
        --this.currentValues;
    }

    @Override
    public void reopen() {
        super.reopen();
        this.freeList.reopen();
        this.chainFreeList.reopen();
        if (this.valueHeapStart == 0L) {
            this.valueHeapSize = this.initialValueHeapSize;
            this.valueHeapStart = this.valueHeapPos = Unsafe.malloc(this.valueHeapSize, 59);
            this.valueHeapLimit = this.valueHeapStart + this.valueHeapSize;
        }
    }

    @Override
    public long size() {
        return this.currentValues;
    }

    public void updateLimits(boolean isFirstN, long limit) {
        this.isFirstN = isFirstN;
        this.limit = limit;
    }

    private static int compressValueOffset(long rawOffset) {
        return (int)(rawOffset >> 2);
    }

    private static long uncompressValueOffset(int offset) {
        return (long)offset << 2;
    }

    private int appendValue(long value, int prevValueOffset) {
        this.checkValueCapacity();
        int offset = LimitedSizeLongTreeChain.compressValueOffset(this.valueHeapPos - this.valueHeapStart);
        Unsafe.getUnsafe().putLong(this.valueHeapPos, value);
        Unsafe.getUnsafe().putInt(this.valueHeapPos + 8L, prevValueOffset);
        this.valueHeapPos += 12L;
        return offset;
    }

    private void checkValueCapacity() {
        if (this.valueHeapPos + 12L > this.valueHeapLimit) {
            long newHeapSize = this.valueHeapSize << 1;
            if (newHeapSize > this.maxValueHeapSize) {
                throw LimitOverflowException.instance().put("limit of ").put(this.maxValueHeapSize).put(" memory exceeded in LimitedSizeLongTreeChain");
            }
            long newHeapPos = Unsafe.realloc(this.valueHeapStart, this.valueHeapSize, newHeapSize, 59);
            this.valueHeapSize = newHeapSize;
            long delta = newHeapPos - this.valueHeapStart;
            this.valueHeapPos += delta;
            this.valueHeapStart = newHeapPos;
            this.valueHeapLimit = newHeapPos + newHeapSize;
        }
    }

    private void clearBlock(int position) {
        this.setParent(position, -1);
        this.setLeft(position, -1);
        this.setRight(position, -1);
        this.setColor(position, (byte)0);
        int refOffset = this.refOf(position);
        assert (this.nextValueOffset(refOffset) == -1);
        this.setRowId(refOffset, -2L);
    }

    private int getChainLength(int chainStart) {
        int counter = 1;
        int nextOffset = this.nextValueOffset(chainStart);
        while (nextOffset != -1) {
            nextOffset = this.nextValueOffset(nextOffset);
            ++counter;
        }
        return counter;
    }

    private boolean hasMoreThanOneValue(int position) {
        int ref = this.refOf(position);
        int previousOffset = this.nextValueOffset(ref);
        return previousOffset != -1;
    }

    private int nextValueOffset(int valueOffset) {
        return Unsafe.getUnsafe().getInt(this.valueHeapStart + LimitedSizeLongTreeChain.uncompressValueOffset(valueOffset) + 8L);
    }

    private void prepareComparatorLeftSideIfAtMaxCapacity(RecordRandomAccess sourceCursor, Record ownedRecord, RecordComparator comparator) {
        if ((long)this.currentValues == this.limit) {
            assert (this.minMaxRowId != -1L);
            sourceCursor.recordAt(ownedRecord, this.minMaxRowId);
            comparator.setLeft(ownedRecord);
        }
    }

    private void putParent(long rowId) {
        this.root = this.allocateBlock(-1, rowId);
    }

    private void refreshMinMaxNode() {
        int p = this.isFirstN ? this.findMaxNode() : this.findMinNode();
        this.minMaxNode = p;
        this.minMaxRowId = this.rowId(this.refOf(p));
    }

    private void removeMostRecentChainValue(int node) {
        int ref = this.refOf(node);
        int previousOffset = this.nextValueOffset(ref);
        this.setRef(node, previousOffset);
        this.setRowId(ref, -1L);
        this.setNextValueOffset(ref, -1);
        this.chainFreeList.add(ref);
    }

    private long rowId(int valueOffset) {
        return Unsafe.getUnsafe().getLong(this.valueHeapStart + LimitedSizeLongTreeChain.uncompressValueOffset(valueOffset));
    }

    private void setNextValueOffset(int valueOffset, int nextValueOffset) {
        Unsafe.getUnsafe().putInt(this.valueHeapStart + LimitedSizeLongTreeChain.uncompressValueOffset(valueOffset) + 8L, nextValueOffset);
    }

    private void setRowId(int valueOffset, long rowId) {
        Unsafe.getUnsafe().putLong(this.valueHeapStart + LimitedSizeLongTreeChain.uncompressValueOffset(valueOffset), rowId);
    }

    protected int allocateBlock(int parent, long recordRowId) {
        int chainOffset;
        if (this.freeList.size() > 0L) {
            int freeNode = this.freeList.get(this.freeList.size() - 1L);
            this.freeList.removeLast();
            this.setParent(freeNode, parent);
            this.setRowId(this.refOf(freeNode), recordRowId);
            return freeNode;
        }
        int newNode = super.allocateBlock();
        this.setParent(newNode, parent);
        if (this.chainFreeList.size() > 0L) {
            chainOffset = this.chainFreeList.get(this.chainFreeList.size() - 1L);
            this.chainFreeList.removeLast();
            this.setRowId(chainOffset, recordRowId);
            this.setNextValueOffset(chainOffset, -1);
        } else {
            chainOffset = this.appendValue(recordRowId, -1);
        }
        this.setRef(newNode, chainOffset);
        return newNode;
    }

    void printTree(Utf16Sink sink, int node, int level, boolean isLeft, ValuePrinter printer) {
        byte color = this.colorOf(node);
        int valueOffset = this.refOf(node);
        long rowId = this.rowId(valueOffset);
        for (int i = 1; i < level; ++i) {
            ((Utf16Sink)sink.put(' ')).put(' ');
        }
        if (level > 0) {
            sink.put(' ');
            sink.put(isLeft ? (char)'L' : 'R');
            sink.put('-');
        }
        sink.put('[');
        sink.put(color == 1 ? "Red" : (color == 0 ? "Black" : "Unkown_Color"));
        sink.put(',');
        sink.put(printer.toString(rowId));
        int chainLength = this.getChainLength(valueOffset);
        if (chainLength > 1) {
            ((Utf16Sink)((Utf16Sink)sink.put('(')).put(chainLength)).put(')');
        }
        sink.put(']');
        sink.put('\n');
        if (this.leftOf(node) != -1) {
            this.printTree(sink, this.leftOf(node), level + 1, true, printer);
        }
        if (this.rightOf(node) != -1) {
            this.printTree(sink, this.rightOf(node), level + 1, false, printer);
        }
    }

    public class TreeCursor {
        private int chainCurrent;
        private int treeCurrent;

        public void clear() {
            this.treeCurrent = 0;
            this.chainCurrent = 0;
        }

        public boolean hasNext() {
            if (this.chainCurrent != -1) {
                return true;
            }
            this.treeCurrent = LimitedSizeLongTreeChain.this.successor(this.treeCurrent);
            if (this.treeCurrent == -1) {
                return false;
            }
            this.chainCurrent = LimitedSizeLongTreeChain.this.refOf(this.treeCurrent);
            return true;
        }

        public long next() {
            int result = this.chainCurrent;
            this.chainCurrent = LimitedSizeLongTreeChain.this.nextValueOffset(this.chainCurrent);
            return LimitedSizeLongTreeChain.this.rowId(result);
        }

        public void toTop() {
            this.setup();
        }

        private void setup() {
            int p = LimitedSizeLongTreeChain.this.root;
            if (p != -1) {
                while (LimitedSizeLongTreeChain.this.leftOf(p) != -1) {
                    p = LimitedSizeLongTreeChain.this.leftOf(p);
                }
            }
            this.treeCurrent = p;
            this.chainCurrent = LimitedSizeLongTreeChain.this.refOf(this.treeCurrent);
        }
    }

    @FunctionalInterface
    public static interface ValuePrinter {
        public static String toRowId(long rowid) {
            return String.valueOf(rowid);
        }

        public String toString(long var1);
    }
}

