/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.table.AbstractTreeSetRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByAllIndexedRecordCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class LatestByAllIndexedRecordCursorFactory
extends AbstractTreeSetRecordCursorFactory {
    protected final DirectLongList prefixes;

    public LatestByAllIndexedRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull PartitionFrameCursorFactory partitionFrameCursorFactory, int columnIndex, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts, @NotNull LongList prefixes) {
        super(configuration, metadata, partitionFrameCursorFactory, columnIndexes, columnSizeShifts);
        try {
            this.prefixes = new DirectLongList(Math.max(2, prefixes.size()), 40);
            for (int i = 0; i < prefixes.size(); ++i) {
                this.prefixes.add(prefixes.get(i));
            }
            this.cursor = new LatestByAllIndexedRecordCursor(configuration, metadata, columnIndex, this.rows, this.prefixes);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("LatestByAllIndexed");
        sink.child(this.cursor);
        sink.child(this.partitionFrameCursorFactory);
    }

    @Override
    public boolean usesIndex() {
        return true;
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.prefixes);
        Misc.free(this.cursor);
    }
}

