/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractLatestByValueRecordCursor;
import org.jetbrains.annotations.NotNull;

class LatestByValueFilteredRecordCursor
extends AbstractLatestByValueRecordCursor {
    private final Function filter;

    public LatestByValueFilteredRecordCursor(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, int columnIndex, int symbolKey, @NotNull Function filter) {
        super(configuration, metadata, columnIndex, symbolKey);
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (!this.isFindPending) {
            this.findRecord();
            this.hasNext = this.isRecordFound;
            this.isFindPending = true;
        }
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public void of(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.frameCursor = pageFrameCursor;
        this.recordA.of(pageFrameCursor);
        this.recordB.of(pageFrameCursor);
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.filter.init(pageFrameCursor, executionContext);
        this.isRecordFound = false;
        this.isFindPending = false;
        super.init();
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public long preComputedStateSize() {
        return this.isFindPending ? 1L : 0L;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Row backward scan");
        sink.attr("symbolFilter").putColumnName(this.columnIndex).val('=').val(this.symbolKey);
        sink.attr("filter").val(this.filter);
    }

    @Override
    public void toTop() {
        this.hasNext = this.isRecordFound;
        this.filter.toTop();
    }

    private void findRecord() {
        PageFrame frame;
        block0: while ((frame = this.frameCursor.next()) != null) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            long partitionLo = frame.getPartitionLo();
            long partitionHi = frame.getPartitionHi() - 1L;
            this.frameAddressCache.add(this.frameCount, frame);
            this.frameMemoryPool.navigateTo(this.frameCount++, this.recordA);
            for (long row = partitionHi - partitionLo; row >= 0L; --row) {
                int key;
                this.recordA.setRowIndex(row);
                if (!this.filter.getBool(this.recordA) || (key = this.recordA.getInt(this.columnIndex)) != this.symbolKey) continue;
                this.isRecordFound = true;
                break block0;
            }
        }
    }
}

