/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractPageFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValueRecordCursor;
import io.questdb.griffin.engine.table.PageFrameRecordCursor;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestByValueFilteredRecordCursorFactory
extends AbstractPageFrameRecordCursorFactory {
    private final PageFrameRecordCursor cursor;
    private final Function filter;

    public LatestByValueFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull PartitionFrameCursorFactory partitionFrameCursorFactory, int columnIndex, int symbolKey, @Nullable Function filter, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts) {
        super(configuration, metadata, partitionFrameCursorFactory, columnIndexes, columnSizeShifts);
        this.cursor = filter == null ? new LatestByValueRecordCursor(configuration, metadata, columnIndex, symbolKey) : new LatestByValueFilteredRecordCursor(configuration, metadata, columnIndex, symbolKey, filter);
        this.filter = filter;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("LatestByValueFiltered");
        sink.child(this.cursor);
        sink.child(this.partitionFrameCursorFactory);
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.filter);
        Misc.free(this.cursor);
    }

    @Override
    protected RecordCursor initRecordCursor(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.cursor.of(pageFrameCursor, executionContext);
        return this.cursor;
    }
}

