/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoColumn;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoTable;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.MetadataCacheReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Misc;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8StringSink;
import org.jetbrains.annotations.NotNull;

public class ShowCreateTableRecordCursorFactory
extends AbstractRecordCursorFactory {
    public static final int N_DDL_COL = 0;
    private static final RecordMetadata METADATA;
    protected final TableToken tableToken;
    protected final int tokenPosition;
    private final ShowCreateTableCursor cursor = new ShowCreateTableCursor();

    public ShowCreateTableRecordCursorFactory(TableToken tableToken, int tokenPosition) {
        super(METADATA);
        this.tableToken = tableToken;
        this.tokenPosition = tokenPosition;
    }

    public static void inVolumeToSink(CairoConfiguration configuration, CairoTable table, CharSink<?> sink) {
        if (table.isSoftLink()) {
            sink.putAscii(", IN VOLUME ");
            Path.clearThreadLocals();
            Path softLinkPath = Path.getThreadLocal(configuration.getDbRoot()).concat(table.getDirectoryName());
            Path otherVolumePath = Path.getThreadLocal2("");
            configuration.getFilesFacade().readLink(softLinkPath, otherVolumePath);
            otherVolumePath.trimTo(otherVolumePath.size() - table.getDirectoryName().length() - 1);
            CharSequence alias = configuration.getVolumeDefinitions().resolvePath(otherVolumePath.asAsciiCharSequence());
            if (alias == null) {
                throw CairoException.nonCritical().put("could not find volume alias for table [table=").put(table.getTableToken()).put(']');
            }
            sink.put(alias);
        }
    }

    public static void ttlToSink(int ttl, CharSink<?> sink) {
        String unit;
        if (ttl == 0) {
            return;
        }
        if (ttl > 0) {
            unit = "HOUR";
            if (ttl % 24 == 0) {
                unit = "DAY";
                if ((ttl /= 24) % 7 == 0) {
                    unit = "WEEK";
                    ttl /= 7;
                }
            }
        } else {
            ttl = -ttl;
            unit = "MONTH";
            if (ttl % 12 == 0) {
                unit = "YEAR";
                ttl /= 12;
            }
        }
        sink.putAscii(" TTL ").put(ttl).put(' ').putAscii(unit);
        if (ttl > 1) {
            sink.put('S');
        }
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        return this.cursor.of(executionContext, this.tableToken, this.tokenPosition);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("show_create_table");
        sink.meta("of").val(this.tableToken.getTableName());
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.cursor);
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("ddl", 26));
        METADATA = metadata;
    }

    public static class ShowCreateTableCursor
    implements NoRandomAccessRecordCursor {
        protected final Utf8StringSink sink = new Utf8StringSink();
        private final ShowCreateTableRecord record = new ShowCreateTableRecord();
        protected SqlExecutionContext executionContext;
        protected CairoTable table;
        private boolean hasRun;
        private TableToken tableToken;

        @Override
        public void close() {
            this.sink.clear();
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasRun) {
                this.sink.clear();
                CairoConfiguration config = this.executionContext.getCairoEngine().getConfiguration();
                this.showCreateTable(config);
                this.hasRun = true;
                return true;
            }
            return false;
        }

        public ShowCreateTableCursor of(SqlExecutionContext executionContext, TableToken tableToken, int tokenPosition) throws SqlException {
            this.tableToken = tableToken;
            this.executionContext = executionContext;
            try (MetadataCacheReader metadataRO = executionContext.getCairoEngine().getMetadataCache().readLock();){
                this.table = metadataRO.getTable(tableToken);
                if (this.table == null) {
                    throw SqlException.$(tokenPosition, "table does not exist [table=").put(tableToken.getTableName()).put(']');
                }
                if (!this.tableToken.equals(this.table.getTableToken())) {
                    throw TableReferenceOutOfDateException.of(this.tableToken);
                }
            }
            this.toTop();
            return this;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.sink.clear();
            this.hasRun = false;
        }

        private void putTtl() {
            ShowCreateTableRecordCursorFactory.ttlToSink(this.table.getTtlHoursOrMonths(), this.sink);
        }

        private void showCreateTable(CairoConfiguration config) {
            this.putCreateTable();
            this.putColumns(config);
            if (this.table.getTimestampIndex() != -1) {
                this.putTimestamp();
                this.putPartitionBy();
                this.putTtl();
                this.putWal();
            }
            this.putWith();
            this.putInVolume(config);
            this.putDedup();
            this.putAdditional();
            this.sink.putAscii(';');
        }

        protected void putAdditional() {
        }

        protected void putColumn(CairoConfiguration config, CairoColumn column) {
            this.sink.put('\t').put(column.getName()).putAscii(' ').put(ColumnType.nameOf(column.getType()));
            if (column.getType() == 12) {
                int symbolCapacity = column.getSymbolCapacity();
                if (symbolCapacity < 2) {
                    symbolCapacity = config.getDefaultSymbolCapacity();
                }
                this.sink.putAscii(" CAPACITY ").put(symbolCapacity);
                this.sink.putAscii(column.isSymbolCached() ? " CACHE" : " NOCACHE");
                if (column.isIndexed()) {
                    this.sink.putAscii(" INDEX CAPACITY ").put(column.getIndexBlockCapacity());
                }
            }
        }

        protected void putColumns(CairoConfiguration configuration) {
            int n = this.table.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.putColumn(configuration, this.table.getColumnQuiet(i));
                if (i < n - 1) {
                    this.sink.putAscii(',');
                }
                this.sink.putAscii('\n');
            }
            this.sink.putAscii(')');
        }

        protected void putCreateTable() {
            this.sink.putAscii("CREATE TABLE '").put(this.tableToken.getTableName()).putAscii("' ( ").putAscii('\n');
        }

        protected void putDedup() {
            if (this.table.hasDedup()) {
                boolean afterFirst = false;
                this.sink.putAscii('\n');
                this.sink.putAscii("DEDUP UPSERT KEYS(");
                int n = this.table.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    CairoColumn column = this.table.getColumnQuiet(i);
                    if (!column.isDedupKey()) continue;
                    if (afterFirst) {
                        this.sink.putAscii(',');
                    } else {
                        afterFirst = true;
                    }
                    this.sink.put(column.getName());
                }
                this.sink.putAscii(')');
            }
        }

        protected void putInVolume(CairoConfiguration configuration) {
            ShowCreateTableRecordCursorFactory.inVolumeToSink(configuration, this.table, this.sink);
        }

        protected void putPartitionBy() {
            this.sink.putAscii(" PARTITION BY ").put(this.table.getPartitionByName());
        }

        protected void putTimestamp() {
            this.sink.putAscii(" timestamp(").put(this.table.getTimestampName()).putAscii(')');
        }

        protected void putWal() {
            if (!this.table.isWalEnabled()) {
                this.sink.putAscii(" BYPASS");
            }
            this.sink.putAscii(" WAL");
        }

        protected void putWith() {
            this.sink.putAscii('\n').putAscii("WITH ");
            this.sink.putAscii("maxUncommittedRows=").put(this.table.getMaxUncommittedRows());
            this.sink.put(", ");
            ((Utf8Sink)this.sink.putAscii("o3MaxLag=").put(this.table.getO3MaxLag())).putAscii("us");
        }

        public class ShowCreateTableRecord
        implements Record {
            @Override
            @NotNull
            public Utf8Sequence getVarcharA(int col) {
                if (col == 0) {
                    return ShowCreateTableCursor.this.sink;
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public Utf8Sequence getVarcharB(int col) {
                return this.getVarcharA(col);
            }

            @Override
            public int getVarcharSize(int col) {
                return this.getVarcharA(col).size();
            }
        }
    }
}

