/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameAddressCache;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.PageFrameMemoryPool;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.TimeFrame;
import io.questdb.cairo.sql.TimeFrameRecordCursor;
import io.questdb.griffin.engine.table.TablePageFrameCursor;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Rows;
import io.questdb.std.Unsafe;
import org.jetbrains.annotations.NotNull;

public final class TimeFrameRecordCursorImpl
implements TimeFrameRecordCursor {
    private final PageFrameAddressCache frameAddressCache;
    private final PageFrameMemoryPool frameMemoryPool;
    private final IntList framePartitionIndexes = new IntList();
    private final LongList frameRowCounts = new LongList();
    private final RecordMetadata metadata;
    private final PageFrameMemoryRecord recordA = new PageFrameMemoryRecord(0);
    private final PageFrameMemoryRecord recordB = new PageFrameMemoryRecord(1);
    private final TableReaderTimeFrame timeFrame = new TableReaderTimeFrame();
    private int frameCount = 0;
    private PageFrameCursor frameCursor;
    private boolean isFrameCacheBuilt;
    private PartitionBy.PartitionCeilMethod partitionCeilMethod;
    private int partitionHi;
    private TableReader reader;

    public TimeFrameRecordCursorImpl(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata) {
        this.metadata = metadata;
        this.frameAddressCache = new PageFrameAddressCache(configuration);
        this.frameMemoryPool = new PageFrameMemoryPool(configuration.getSqlParquetFrameCacheCapacity());
    }

    @Override
    public void close() {
        Misc.free(this.frameMemoryPool);
        this.frameCursor = Misc.free(this.frameCursor);
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public Record getRecordB() {
        return this.recordB;
    }

    @Override
    public StaticSymbolTable getSymbolTable(int columnIndex) {
        return this.frameCursor.getSymbolTable(columnIndex);
    }

    @Override
    public TimeFrame getTimeFrame() {
        return this.timeFrame;
    }

    @Override
    public void jumpTo(int frameIndex) {
        this.buildFrameCache();
        if (frameIndex >= this.frameCount || frameIndex < 0) {
            throw CairoException.nonCritical().put("frame index out of bounds. [frameIndex=]").put(frameIndex).put(", frameCount=").put(this.frameCount).put(']');
        }
        int partitionIndex = this.framePartitionIndexes.getQuick(frameIndex);
        long timestampLo = this.reader.getPartitionTimestampByIndex(partitionIndex);
        long maxTimestampHi = partitionIndex < this.partitionHi - 2 ? this.reader.getPartitionTimestampByIndex(partitionIndex + 1) : Long.MAX_VALUE;
        this.timeFrame.of(frameIndex, timestampLo, this.estimatePartitionHi(timestampLo, maxTimestampHi));
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.frameCursor.newSymbolTable(columnIndex);
    }

    @Override
    public boolean next() {
        this.buildFrameCache();
        int frameIndex = this.timeFrame.frameIndex;
        if (++frameIndex < this.frameCount) {
            int partitionIndex = this.framePartitionIndexes.getQuick(frameIndex);
            long timestampLo = this.reader.getPartitionTimestampByIndex(partitionIndex);
            long maxTimestampHi = partitionIndex < this.partitionHi - 2 ? this.reader.getPartitionTimestampByIndex(partitionIndex + 1) : Long.MAX_VALUE;
            this.timeFrame.of(frameIndex, timestampLo, this.estimatePartitionHi(timestampLo, maxTimestampHi));
            return true;
        }
        this.timeFrame.of(this.frameCount, Long.MIN_VALUE, Long.MIN_VALUE);
        return false;
    }

    public TimeFrameRecordCursor of(TablePageFrameCursor frameCursor) {
        this.frameCursor = frameCursor;
        this.frameAddressCache.of(this.metadata, frameCursor.getColumnIndexes());
        this.frameMemoryPool.of(this.frameAddressCache);
        this.reader = frameCursor.getTableReader();
        this.recordA.of(frameCursor);
        this.recordB.of(frameCursor);
        this.partitionHi = this.reader.getPartitionCount();
        this.partitionCeilMethod = PartitionBy.getPartitionCeilMethod(this.reader.getPartitionedBy());
        this.isFrameCacheBuilt = false;
        this.toTop();
        return this;
    }

    @Override
    public long open() throws DataUnavailableException {
        int frameIndex = this.timeFrame.frameIndex;
        if (frameIndex < 0 || frameIndex >= this.frameCount) {
            throw CairoException.nonCritical().put("open call on uninitialized time frame");
        }
        long rowCount = this.frameRowCounts.getQuick(frameIndex);
        if (rowCount > 0L) {
            this.timeFrame.rowLo = 0L;
            this.timeFrame.rowHi = rowCount;
            PageFrameMemory frameMemory = this.frameMemoryPool.navigateTo(frameIndex);
            long timestampAddress = frameMemory.getPageAddress(this.metadata.getTimestampIndex());
            this.timeFrame.timestampLo = Unsafe.getUnsafe().getLong(timestampAddress);
            this.timeFrame.timestampHi = Unsafe.getUnsafe().getLong(timestampAddress + (rowCount - 1L) * 8L) + 1L;
            return rowCount;
        }
        this.timeFrame.rowLo = 0L;
        this.timeFrame.rowHi = 0L;
        this.timeFrame.timestampLo = this.timeFrame.estimateTimestampLo;
        this.timeFrame.timestampHi = this.timeFrame.estimateTimestampLo;
        return 0L;
    }

    @Override
    public boolean prev() {
        this.buildFrameCache();
        int frameIndex = this.timeFrame.frameIndex;
        if (--frameIndex >= 0) {
            int partitionIndex = this.framePartitionIndexes.getQuick(frameIndex);
            long timestampLo = this.reader.getPartitionTimestampByIndex(partitionIndex);
            long maxTimestampHi = partitionIndex < this.partitionHi - 2 ? this.reader.getPartitionTimestampByIndex(partitionIndex + 1) : Long.MAX_VALUE;
            this.timeFrame.of(frameIndex, timestampLo, this.estimatePartitionHi(timestampLo, maxTimestampHi));
            return true;
        }
        this.timeFrame.of(-1, Long.MIN_VALUE, Long.MIN_VALUE);
        return false;
    }

    @Override
    public void recordAt(Record record, long rowId) {
        PageFrameMemoryRecord frameMemoryRecord = (PageFrameMemoryRecord)record;
        this.frameMemoryPool.navigateTo(Rows.toPartitionIndex(rowId), frameMemoryRecord);
        frameMemoryRecord.setRowIndex(Rows.toLocalRowID(rowId));
    }

    @Override
    public void recordAtRowIndex(Record record, long rowIndex) {
        PageFrameMemoryRecord frameMemoryRecord = (PageFrameMemoryRecord)record;
        frameMemoryRecord.setRowIndex(rowIndex);
    }

    @Override
    public void toTop() {
        this.timeFrame.clear();
        if (!this.isFrameCacheBuilt) {
            this.frameCount = 0;
            this.frameCursor.toTop();
            this.framePartitionIndexes.clear();
            this.frameRowCounts.clear();
        }
    }

    private void buildFrameCache() {
        if (!this.isFrameCacheBuilt) {
            PageFrame frame;
            while ((frame = this.frameCursor.next()) != null) {
                this.framePartitionIndexes.add(frame.getPartitionIndex());
                this.frameRowCounts.add(frame.getPartitionHi() - frame.getPartitionLo());
                this.frameAddressCache.add(this.frameCount++, frame);
            }
            this.isFrameCacheBuilt = true;
        }
    }

    private long estimatePartitionHi(long partitionTimestamp, long maxTimestampHi) {
        long partitionHi = this.partitionCeilMethod != null ? this.partitionCeilMethod.ceil(partitionTimestamp) : Long.MAX_VALUE;
        return Math.min(partitionHi, maxTimestampHi);
    }

    private static class TableReaderTimeFrame
    implements TimeFrame,
    Mutable {
        private long estimateTimestampHi;
        private long estimateTimestampLo;
        private int frameIndex;
        private long rowHi;
        private long rowLo;
        private long timestampHi;
        private long timestampLo;

        private TableReaderTimeFrame() {
        }

        @Override
        public void clear() {
            this.frameIndex = -1;
            this.estimateTimestampLo = Long.MIN_VALUE;
            this.estimateTimestampHi = Long.MIN_VALUE;
            this.timestampLo = Long.MIN_VALUE;
            this.timestampHi = Long.MIN_VALUE;
            this.rowLo = -1L;
            this.rowHi = -1L;
        }

        @Override
        public int getFrameIndex() {
            return this.frameIndex;
        }

        @Override
        public long getRowHi() {
            return this.rowHi;
        }

        @Override
        public long getRowLo() {
            return this.rowLo;
        }

        @Override
        public long getTimestampEstimateHi() {
            return this.estimateTimestampHi;
        }

        @Override
        public long getTimestampEstimateLo() {
            return this.estimateTimestampLo;
        }

        @Override
        public long getTimestampHi() {
            return this.timestampHi;
        }

        @Override
        public long getTimestampLo() {
            return this.timestampLo;
        }

        @Override
        public boolean isOpen() {
            return this.rowLo != -1L && this.rowHi != -1L;
        }

        public void of(int frameIndex, long estimateTimestampLo, long estimateTimestampHi) {
            this.frameIndex = frameIndex;
            this.estimateTimestampLo = estimateTimestampLo;
            this.estimateTimestampHi = estimateTimestampHi;
            this.timestampLo = Long.MIN_VALUE;
            this.timestampHi = Long.MIN_VALUE;
            this.rowLo = -1L;
            this.rowHi = -1L;
        }
    }
}

