/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.union;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.union.AbstractSetRecordCursor;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

abstract class AbstractSetRecordCursorFactory
extends AbstractRecordCursorFactory {
    protected final RecordCursorFactory factoryA;
    protected final RecordCursorFactory factoryB;
    private final ObjList<Function> castFunctionsA;
    private final ObjList<Function> castFunctionsB;
    protected AbstractSetRecordCursor cursor;

    public AbstractSetRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory factoryA, RecordCursorFactory factoryB, ObjList<Function> castFunctionsA, ObjList<Function> castFunctionsB) {
        super(metadata);
        this.factoryA = factoryA;
        this.factoryB = factoryB;
        this.castFunctionsB = castFunctionsB;
        this.castFunctionsA = castFunctionsA;
    }

    @Override
    public String getBaseColumnName(int idx) {
        if (idx < this.factoryA.getMetadata().getColumnCount()) {
            return this.factoryA.getMetadata().getColumnName(idx);
        }
        return this.factoryB.getMetadata().getColumnName(idx);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor cursorA = null;
        RecordCursor cursorB = null;
        try {
            cursorA = this.factoryA.getCursor(executionContext);
            cursorB = this.factoryB.getCursor(executionContext);
            Function.initNc(this.castFunctionsA, cursorA, executionContext, null);
            Function.initNc(this.castFunctionsB, cursorB, executionContext, null);
            this.cursor.of(cursorA, cursorB, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable ex) {
            Misc.free(cursorA);
            Misc.free(cursorB);
            throw ex;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.factoryA.recordCursorSupportsRandomAccess();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type(this.getOperation());
        sink.child(this.factoryA);
        if (this.isSecondFactoryHashed()) {
            sink.child("Hash", this.factoryB);
        } else {
            sink.child(this.factoryB);
        }
    }

    @Override
    protected void _close() {
        Misc.free(this.factoryA);
        Misc.free(this.factoryB);
        Misc.freeObjListAndClear(this.castFunctionsA);
        Misc.freeObjListAndClear(this.castFunctionsB);
    }

    protected abstract CharSequence getOperation();

    protected boolean isSecondFactoryHashed() {
        return false;
    }
}

