/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.griffin.model.ExpressionNode;
import io.questdb.std.Chars;
import io.questdb.std.Mutable;
import io.questdb.std.ObjectFactory;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class QueryColumn
implements Mutable,
Sinkable {
    public static final ObjectFactory<QueryColumn> FACTORY = QueryColumn::new;
    public static final int SYNTHESIZED_ALIAS_POSITION = -1;
    private CharSequence alias;
    private int aliasPosition;
    private ExpressionNode ast;
    private int columnType;
    private boolean includeIntoWildcard = true;

    @Override
    public void clear() {
        this.alias = null;
        this.ast = null;
        this.includeIntoWildcard = true;
        this.columnType = -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryColumn that = (QueryColumn)o;
        return this.includeIntoWildcard == that.includeIntoWildcard && Objects.equals(this.alias, that.alias) && Objects.equals(this.ast, that.ast);
    }

    public CharSequence getAlias() {
        return this.alias;
    }

    public int getAliasPosition() {
        return this.aliasPosition;
    }

    public ExpressionNode getAst() {
        return this.ast;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public CharSequence getName() {
        return this.alias != null ? this.alias : this.ast.token;
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.ast, this.includeIntoWildcard);
    }

    public boolean isIncludeIntoWildcard() {
        return this.includeIntoWildcard;
    }

    public boolean isWindowColumn() {
        return false;
    }

    public QueryColumn of(CharSequence alias, ExpressionNode ast) {
        return this.of(alias, ast, true);
    }

    public QueryColumn of(CharSequence alias, ExpressionNode ast, boolean includeIntoWildcard) {
        return this.of(alias, ast, includeIntoWildcard, -1);
    }

    public QueryColumn of(CharSequence alias, ExpressionNode ast, boolean includeIntoWildcard, int type) {
        this.alias = alias;
        this.ast = ast;
        this.includeIntoWildcard = includeIntoWildcard;
        this.columnType = type;
        return this;
    }

    public void setAlias(CharSequence alias, int aliasPosition) {
        if (this.alias == alias || Chars.equalsNc(alias, this.alias)) {
            return;
        }
        this.alias = alias;
        this.aliasPosition = aliasPosition;
    }

    public void setIncludeIntoWildcard(boolean includeIntoWildcard) {
        this.includeIntoWildcard = includeIntoWildcard;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.put(this.ast).putAscii(" as ").put(this.alias);
    }
}

