/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.Reopenable;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import java.io.Closeable;

public class DirectLongList
implements Mutable,
Closeable,
Reopenable {
    private static final Log LOG = LogFactory.getLog(DirectLongList.class);
    private final long initialCapacity;
    private final int memoryTag;
    private long address;
    private long capacity;
    private long limit;
    private long pos;

    public DirectLongList(long capacity, int memoryTag) {
        this.memoryTag = memoryTag;
        this.capacity = capacity * 8L;
        this.pos = this.address = Unsafe.malloc(this.capacity, memoryTag);
        this.limit = this.pos + this.capacity;
        this.initialCapacity = this.capacity;
    }

    public void add(long value) {
        this.checkCapacity();
        assert (this.pos < this.limit);
        Unsafe.getUnsafe().putLong(this.pos, value);
        this.pos += 8L;
    }

    public final void addAll(DirectLongList that) {
        long thatSize = that.pos - that.address;
        if (this.limit - this.pos < thatSize) {
            this.setCapacityBytes(this.capacity + thatSize - (this.limit - this.pos));
        }
        Vect.memcpy(this.pos, that.address, thatSize);
        this.pos += thatSize;
    }

    public long binarySearch(long value, int scanDir) {
        long high = (this.pos - this.address) / 8L;
        if (high > 0L) {
            return Vect.binarySearch64Bit(this.address, value, 0L, high - 1L, scanDir);
        }
        return -1L;
    }

    @Override
    public void clear() {
        this.pos = this.address;
    }

    @Override
    public void close() {
        if (this.address != 0L) {
            this.address = Unsafe.free(this.address, this.capacity, this.memoryTag);
            this.limit = 0L;
            this.pos = 0L;
            this.capacity = 0L;
        }
    }

    public void fill(int v) {
        Vect.memset(this.address, this.capacity, v);
    }

    public long get(long p) {
        return Unsafe.getUnsafe().getLong(this.address + (p << 3));
    }

    public long getAddress() {
        return this.address;
    }

    public long getCapacity() {
        return this.capacity >>> 3;
    }

    @Override
    public void reopen() {
        if (this.address == 0L) {
            this.resetCapacity();
        }
    }

    public void resetCapacity() {
        this.setCapacityBytes(this.initialCapacity);
    }

    public long scanSearch(long v, long low, long high) {
        for (long i = low; i < high; ++i) {
            long f = this.get(i);
            if (f == v) {
                return i;
            }
            if (f <= v) continue;
            return -(i + 1L);
        }
        return -(high + 1L);
    }

    public void set(long p, long v) {
        assert (p >= 0L && p <= this.limit - this.address >> 3);
        Unsafe.getUnsafe().putLong(this.address + (p << 3), v);
    }

    public void setCapacity(long capacity) {
        assert (capacity > 0L);
        this.setCapacityBytes(capacity << 3);
    }

    public void setPos(long p) {
        assert (p * 8L <= this.capacity);
        this.pos = this.address + (p << 3);
    }

    public void shrink(long newCapacity) {
        if (newCapacity < this.capacity) {
            this.setCapacityBytes(newCapacity << 3);
        }
    }

    public long size() {
        return this.pos - this.address >>> 3;
    }

    public void sortAsUnsigned() {
        Vect.sortULongAscInPlace(this.address, this.size());
    }

    public String toString() {
        StringSink sb = Misc.getThreadLocalSink();
        sb.put('[');
        int maxElementsToPrint = 1000;
        int n = (int)Math.min(1000L, this.size());
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                ((Utf16Sink)sb.put(',')).put(' ');
            }
            sb.put(this.get(i));
        }
        if (this.size() > 1000L) {
            sb.put(", .. ");
        }
        sb.put(']');
        return ((Object)sb).toString();
    }

    public void zero() {
        this.fill(0);
    }

    private void setCapacityBytes(long capacity) {
        if (this.capacity != capacity) {
            if (capacity >>> 3 > 0x80000000L) {
                throw CairoException.nonCritical().put("long list capacity overflow");
            }
            long oldCapacity = this.capacity;
            long oldSize = this.pos - this.address;
            long address = Unsafe.realloc(this.address, oldCapacity, capacity, this.memoryTag);
            this.capacity = capacity;
            this.address = address;
            this.limit = address + capacity;
            this.pos = Math.min(this.limit, address + oldSize);
            LOG.debug().$("resized [old=").$(oldCapacity).$(", new=").$(this.capacity).$(']').$();
        }
    }

    void checkCapacity() {
        if (this.pos < this.limit) {
            return;
        }
        this.setCapacityBytes(this.capacity << 1);
    }
}

