/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;

public class IntLongSortedList
implements Mutable {
    private final LongList buf = new LongList(8);
    private final IntList src = new IntList(8);
    private int size = 0;

    public void add(int index, long value) {
        int p = this.binSearch(value);
        if (p < this.size) {
            this.buf.setPos(this.size + 1);
            this.src.setPos(this.size + 1);
            this.buf.arrayCopy(p, p + 1, this.size - p);
            this.src.arrayCopy(p, p + 1, this.size - p);
        }
        this.buf.extendAndSet(p, value);
        this.src.extendAndSet(p, index);
        ++this.size;
    }

    @Override
    public void clear() {
        this.buf.zero(0);
        this.src.zero(0);
        this.size = 0;
    }

    public boolean hasNext() {
        return this.size > 0;
    }

    public int peekBottom() {
        return this.src.getQuick(this.size - 1);
    }

    public int peekIndex() {
        return this.src.getQuick(0);
    }

    public long pollAndReplace(int index, long value) {
        long v = this.buf.getQuick(0);
        int p = this.binSearch(value);
        if (p > 1) {
            this.buf.arrayCopy(1, 0, --p);
            this.src.arrayCopy(1, 0, p);
            this.buf.setQuick(p, value);
            this.src.setQuick(p, index);
        } else {
            this.buf.setQuick(0, value);
            this.src.setQuick(0, index);
        }
        return v;
    }

    public long pollValue() {
        long v = this.buf.getQuick(0);
        if (this.size > 0) {
            this.buf.arrayCopy(1, 0, --this.size);
            this.src.arrayCopy(1, 0, this.size);
        }
        return v;
    }

    public int size() {
        return this.size;
    }

    private int binSearch(long v) {
        int low = 0;
        int high = this.size;
        while (high - low > 65) {
            int mid = low + high - 1 >>> 1;
            long midVal = this.buf.getQuick(mid);
            if (midVal < v) {
                low = mid + 1;
                continue;
            }
            if (midVal > v) {
                high = mid;
                continue;
            }
            while (++mid < high && this.buf.getQuick(mid) == v) {
            }
            return mid;
        }
        return this.scanSearch(v, low);
    }

    private int scanSearch(long v, int low) {
        for (int i = low; i < this.size; ++i) {
            if (this.buf.getQuick(i) <= v) continue;
            return i;
        }
        return this.size;
    }
}

