/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.CompressionCodecResolver;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.impl.DefaultClaims;
import io.jsonwebtoken.impl.DefaultClock;
import io.jsonwebtoken.impl.DefaultJwtParser;
import io.jsonwebtoken.impl.ImmutableJwtParser;
import io.jsonwebtoken.impl.compression.DefaultCompressionCodecResolver;
import io.jsonwebtoken.impl.lang.Services;
import io.jsonwebtoken.io.Decoder;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.lang.Assert;
import java.security.Key;
import java.util.Date;
import java.util.Map;

public class DefaultJwtParserBuilder
implements JwtParserBuilder {
    private static final int MILLISECONDS_PER_SECOND = 1000;
    static final long MAX_CLOCK_SKEW_MILLIS = 9223372036854775L;
    static final String MAX_CLOCK_SKEW_ILLEGAL_MSG = "Illegal allowedClockSkewMillis value: multiplying this value by 1000 to obtain the number of milliseconds would cause a numeric overflow.";
    private byte[] keyBytes;
    private Key key;
    private SigningKeyResolver signingKeyResolver;
    private CompressionCodecResolver compressionCodecResolver = new DefaultCompressionCodecResolver();
    private Decoder<String, byte[]> base64UrlDecoder = Decoders.BASE64URL;
    private Deserializer<Map<String, ?>> deserializer;
    private Claims expectedClaims = new DefaultClaims();
    private Clock clock = DefaultClock.INSTANCE;
    private long allowedClockSkewMillis = 0L;

    public JwtParserBuilder deserializeJsonWith(Deserializer<Map<String, ?>> deserializer) {
        Assert.notNull(deserializer, (String)"deserializer cannot be null.");
        this.deserializer = deserializer;
        return this;
    }

    public JwtParserBuilder base64UrlDecodeWith(Decoder<String, byte[]> base64UrlDecoder) {
        Assert.notNull(base64UrlDecoder, (String)"base64UrlDecoder cannot be null.");
        this.base64UrlDecoder = base64UrlDecoder;
        return this;
    }

    public JwtParserBuilder requireIssuedAt(Date issuedAt) {
        this.expectedClaims.setIssuedAt(issuedAt);
        return this;
    }

    public JwtParserBuilder requireIssuer(String issuer) {
        this.expectedClaims.setIssuer(issuer);
        return this;
    }

    public JwtParserBuilder requireAudience(String audience) {
        this.expectedClaims.setAudience(audience);
        return this;
    }

    public JwtParserBuilder requireSubject(String subject) {
        this.expectedClaims.setSubject(subject);
        return this;
    }

    public JwtParserBuilder requireId(String id) {
        this.expectedClaims.setId(id);
        return this;
    }

    public JwtParserBuilder requireExpiration(Date expiration) {
        this.expectedClaims.setExpiration(expiration);
        return this;
    }

    public JwtParserBuilder requireNotBefore(Date notBefore) {
        this.expectedClaims.setNotBefore(notBefore);
        return this;
    }

    public JwtParserBuilder require(String claimName, Object value) {
        Assert.hasText((String)claimName, (String)"claim name cannot be null or empty.");
        Assert.notNull((Object)value, (String)("The value cannot be null for claim name: " + claimName));
        this.expectedClaims.put((Object)claimName, value);
        return this;
    }

    public JwtParserBuilder setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"Clock instance cannot be null.");
        this.clock = clock;
        return this;
    }

    public JwtParserBuilder setAllowedClockSkewSeconds(long seconds) throws IllegalArgumentException {
        Assert.isTrue((seconds <= 9223372036854775L ? 1 : 0) != 0, (String)MAX_CLOCK_SKEW_ILLEGAL_MSG);
        this.allowedClockSkewMillis = Math.max(0L, seconds * 1000L);
        return this;
    }

    public JwtParserBuilder setSigningKey(byte[] key) {
        Assert.notEmpty((byte[])key, (String)"signing key cannot be null or empty.");
        this.keyBytes = key;
        return this;
    }

    public JwtParserBuilder setSigningKey(String base64EncodedSecretKey) {
        Assert.hasText((String)base64EncodedSecretKey, (String)"signing key cannot be null or empty.");
        this.keyBytes = (byte[])Decoders.BASE64.decode((Object)base64EncodedSecretKey);
        return this;
    }

    public JwtParserBuilder setSigningKey(Key key) {
        Assert.notNull((Object)key, (String)"signing key cannot be null.");
        this.key = key;
        return this;
    }

    public JwtParserBuilder setSigningKeyResolver(SigningKeyResolver signingKeyResolver) {
        Assert.notNull((Object)signingKeyResolver, (String)"SigningKeyResolver cannot be null.");
        this.signingKeyResolver = signingKeyResolver;
        return this;
    }

    public JwtParserBuilder setCompressionCodecResolver(CompressionCodecResolver compressionCodecResolver) {
        Assert.notNull((Object)compressionCodecResolver, (String)"compressionCodecResolver cannot be null.");
        this.compressionCodecResolver = compressionCodecResolver;
        return this;
    }

    public JwtParser build() {
        if (this.deserializer == null) {
            this.deserializer = Services.loadFirst(Deserializer.class);
        }
        return new ImmutableJwtParser(new DefaultJwtParser(this.signingKeyResolver, this.key, this.keyBytes, this.clock, this.allowedClockSkewMillis, this.expectedClaims, this.base64UrlDecoder, this.deserializer, this.compressionCodecResolver));
    }
}

