/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.log.controller;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.google.rpc.Status;
import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.hertzbeat.log.service.impl.OtlpLogProtocolAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="OTLP Log Controller")
@RestController
@RequestMapping(path={"/api/logs/otlp"})
public class OtlpLogController {
    private static final Logger log = LoggerFactory.getLogger(OtlpLogController.class);
    private static final String CONTENT_TYPE_PROTOBUF = "application/x-protobuf";
    private static final ExportLogsServiceResponse EMPTY_RESPONSE = ExportLogsServiceResponse.newBuilder().build();
    private final OtlpLogProtocolAdapter otlpLogProtocolAdapter;

    public OtlpLogController(OtlpLogProtocolAdapter otlpLogProtocolAdapter) {
        this.otlpLogProtocolAdapter = otlpLogProtocolAdapter;
    }

    @Operation(summary="Ingest OTLP logs (JSON format)")
    @PostMapping(value={"/v1/logs"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<String> ingestJsonLogs(@RequestBody String content) {
        log.debug("Receive OTLP JSON logs, content length: {}", (Object)(content == null ? 0 : content.length()));
        try {
            this.otlpLogProtocolAdapter.ingest(content);
            return ResponseEntity.ok((Object)this.toJsonResponse(EMPTY_RESPONSE));
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.toJsonErrorResponse(e.getMessage()));
        }
        catch (Exception e) {
            log.error("Unexpected error ingesting OTLP JSON logs: {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.toJsonErrorResponse(e.getMessage()));
        }
    }

    @Operation(summary="Ingest OTLP logs (binary Protobuf format)")
    @PostMapping(value={"/v1/logs"}, consumes={"application/x-protobuf"}, produces={"application/x-protobuf"})
    public ResponseEntity<byte[]> ingestBinaryLogs(@RequestBody byte[] content) {
        log.debug("Receive OTLP binary logs, content length: {}", (Object)(content == null ? 0 : content.length));
        try {
            this.otlpLogProtocolAdapter.ingestBinary(content);
            return ResponseEntity.ok((Object)EMPTY_RESPONSE.toByteArray());
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)this.createBinaryErrorResponse(e.getMessage()));
        }
        catch (Exception e) {
            log.error("Unexpected error ingesting OTLP binary logs: {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.createBinaryErrorResponse(e.getMessage()));
        }
    }

    private String toJsonResponse(ExportLogsServiceResponse response) {
        try {
            return JsonFormat.printer().print((MessageOrBuilder)response);
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Failed to convert ExportLogsServiceResponse to JSON: {}", (Object)e.getMessage(), (Object)e);
            return "{}";
        }
    }

    private String toJsonErrorResponse(String message) {
        Status status = Status.newBuilder().setMessage(message != null ? message : "Unknown error").build();
        try {
            return JsonFormat.printer().print((MessageOrBuilder)status);
        }
        catch (InvalidProtocolBufferException e) {
            return "{\"message\":\"" + this.escapeJson(message) + "\"}";
        }
    }

    private String escapeJson(String message) {
        if (message == null) {
            return "";
        }
        char[] escaped = JsonStringEncoder.getInstance().quoteAsString(message);
        return new String(escaped);
    }

    private byte[] createBinaryErrorResponse(String message) {
        return Status.newBuilder().setMessage(message != null ? message : "Unknown error").build().toByteArray();
    }
}

