/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.db;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.common.util.Base64Util;
import org.apache.hertzbeat.warehouse.db.SqlQueryExecutor;
import org.apache.hertzbeat.warehouse.store.history.tsdb.greptime.GreptimeProperties;
import org.apache.hertzbeat.warehouse.store.history.tsdb.greptime.GreptimeSqlQueryContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Component(value="greptimeSqlQueryExecutor")
@ConditionalOnProperty(prefix="warehouse.store.greptime", name={"enabled"}, havingValue="true")
public class GreptimeSqlQueryExecutor
extends SqlQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(GreptimeSqlQueryExecutor.class);
    private static final String QUERY_PATH = "/v1/sql";
    private static final String DATASOURCE = "Greptime-sql";
    private final GreptimeProperties greptimeProperties;

    public GreptimeSqlQueryExecutor(GreptimeProperties greptimeProperties, RestTemplate restTemplate) {
        super(restTemplate, new SqlQueryExecutor.HttpSqlProperties(greptimeProperties.httpEndpoint() + QUERY_PATH, greptimeProperties.username(), greptimeProperties.password()));
        this.greptimeProperties = greptimeProperties;
    }

    @Override
    public List<Map<String, Object>> execute(String queryString) {
        ResponseEntity responseEntity;
        LinkedList<Map<String, Object>> results = new LinkedList<Map<String, Object>>();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        if (StringUtils.hasText((String)this.greptimeProperties.username()) && StringUtils.hasText((String)this.greptimeProperties.password())) {
            String authStr = this.greptimeProperties.username() + ":" + this.greptimeProperties.password();
            String encodedAuth = Base64Util.encode((String)authStr);
            headers.add("Authorization", "Basic " + encodedAuth);
        }
        String requestBody = "sql=" + queryString;
        HttpEntity httpEntity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        String url = this.greptimeProperties.httpEndpoint() + QUERY_PATH;
        if (StringUtils.hasText((String)this.greptimeProperties.database())) {
            url = url + "?db=" + this.greptimeProperties.database();
        }
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, GreptimeSqlQueryContent.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("Exception occurred while querying GreptimeDB SQL: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to execute GreptimeDB SQL query", e);
        }
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            GreptimeSqlQueryContent responseBody = (GreptimeSqlQueryContent)responseEntity.getBody();
            if (responseBody != null && responseBody.getCode() == 0 && responseBody.getOutput() != null && !responseBody.getOutput().isEmpty()) {
                for (GreptimeSqlQueryContent.Output output : responseBody.getOutput()) {
                    if (output.getRecords() == null || output.getRecords().getRows() == null) continue;
                    GreptimeSqlQueryContent.Output.Records.Schema schema = output.getRecords().getSchema();
                    List<List<Object>> rows = output.getRecords().getRows();
                    for (List<Object> row : rows) {
                        HashMap<Object, Object> rowMap = new HashMap<Object, Object>();
                        if (schema != null && schema.getColumnSchemas() != null) {
                            for (i = 0; i < Math.min(schema.getColumnSchemas().size(), row.size()); ++i) {
                                String columnName = schema.getColumnSchemas().get(i).getName();
                                Object value = row.get(i);
                                rowMap.put(columnName, value);
                            }
                        } else {
                            for (i = 0; i < row.size(); ++i) {
                                rowMap.put("col_" + i, row.get(i));
                            }
                        }
                        results.add(rowMap);
                    }
                }
            }
        } else {
            log.error("query metrics data from greptime failed. {}", (Object)responseEntity);
        }
        return results;
    }

    @Override
    public String getDatasource() {
        return DATASOURCE;
    }
}

