/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate;

import java.util.Map;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.hertzbeat.common.util.JexlExpressionRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JexlExprCalculator {
    private static final Logger log = LoggerFactory.getLogger(JexlExprCalculator.class);

    public boolean execAlertExpression(Map<String, Object> fieldValueMap, String expr, boolean ignoreJexlException) {
        Boolean match;
        JexlExpression expression;
        try {
            expression = JexlExpressionRunner.compile((String)expr);
        }
        catch (JexlException jexlException) {
            log.warn("Alarm Rule: {} Compile Error: {}.", (Object)expr, (Object)jexlException.getMessage());
            throw jexlException;
        }
        catch (Exception e) {
            log.error("Alarm Rule: {} Unknown Error: {}.", (Object)expr, (Object)e.getMessage());
            throw e;
        }
        try {
            match = (Boolean)JexlExpressionRunner.evaluate((JexlExpression)expression, fieldValueMap);
        }
        catch (JexlException jexlException) {
            if (ignoreJexlException) {
                log.debug("Alarm Rule: {} Run Error: {}.", (Object)expr, (Object)jexlException.getMessage());
            } else {
                log.error("Alarm Rule: {} Run Error: {}.", (Object)expr, (Object)jexlException.getMessage());
            }
            throw jexlException;
        }
        catch (Exception e) {
            log.error("Alarm Rule: {} Unknown Error: {}.", (Object)expr, (Object)e.getMessage());
            throw e;
        }
        return match != null && match != false;
    }
}

