/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.hertzbeat.alert.service.SmsClient;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.entity.dto.sms.SmslocalSmsProperties;
import org.apache.hertzbeat.common.support.exception.SendMessageException;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsLocalSmsClientImpl
implements SmsClient {
    private static final Logger log = LoggerFactory.getLogger(SmsLocalSmsClientImpl.class);
    private static final String HOST = "secure.smslocal.com";
    private static final String PATH = "/api/service/enterprise-service/external/sms";
    private static final String FROM = "Hertzbeat";
    private static final String SUCCESS_CODE = "200";
    private final SmslocalSmsProperties config;

    public SmsLocalSmsClientImpl(SmslocalSmsProperties smslocalSmsProperties) {
        this.config = smslocalSmsProperties;
    }

    @Override
    public void sendMessage(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) {
        if (Objects.isNull(receiver) || Objects.isNull(alert)) {
            log.warn("receiver and alert can not be null! receiver: {}, alert:{}", (Object)receiver, (Object)alert);
            return;
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String content = (String)alert.getCommonAnnotations().get("summary");
            if (Objects.isNull(content) || Objects.isNull(alert.getCommonAnnotations().get("description"))) {
                content = ((SingleAlert)alert.getAlerts().get(0)).getContent();
            }
            SmsMessage smsMessage = new SmsMessage(FROM, receiver.getPhone(), content);
            String payload = JsonUtil.toJson((Object)smsMessage);
            HttpPost httpPost = new HttpPost("https://secure.smslocal.com/api/service/enterprise-service/external/sms");
            httpPost.setHeader("Content-Type", "application/json; charset=utf-8");
            httpPost.setHeader("Token", this.config.getApiKey());
            httpPost.setEntity((HttpEntity)new StringEntity(payload, StandardCharsets.UTF_8));
            log.debug("Sending SMS request to {}, payload: {}", (Object)httpPost.getURI(), (Object)payload);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                int statusCode = response.getStatusLine().getStatusCode();
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                log.debug("SMS response status: {}, body: {}", (Object)statusCode, (Object)responseBody);
                if (statusCode != 200) {
                    throw new SendMessageException("HTTP request failed with status code: " + statusCode);
                }
                JsonNode jsonResponse = JsonUtil.fromJson((String)responseBody);
                JsonNode jsonNode = jsonResponse.get(0);
                if (Objects.isNull(jsonNode)) {
                    log.warn("jsonResponse parse errorCode failed: {}", (Object)jsonResponse);
                    return;
                }
                String errorCode = jsonNode.get("errorCode").asText();
                if (!SUCCESS_CODE.equals(errorCode)) {
                    String msgid = jsonNode.get("id").asText();
                    throw new SendMessageException(errorCode + ":" + msgid);
                }
                log.info("Successfully sent SMS to phone: {}", (Object)receiver.getPhone());
            }
        }
        catch (Exception e) {
            log.error("Failed to send SMS: {}", (Object)e.getMessage());
            throw new SendMessageException(e.getMessage());
        }
    }

    @Override
    public String getType() {
        return "smslocal";
    }

    @Override
    public boolean checkConfig() {
        if (Objects.isNull(this.config) || Objects.isNull(this.config.getApiKey()) || this.config.getApiKey().isBlank()) {
            log.warn("smslocal properties can not be null: {}", (Object)this.config);
            return false;
        }
        return true;
    }

    private static class SmsMessage {
        String from;
        String to;
        String content;
        final int datacoding = 0;
        final String direction = "mt";

        public SmsMessage(String from, String to, String content) {
            this.from = from;
            this.to = to;
            this.content = content;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public String getContent() {
            return this.content;
        }

        public int getDatacoding() {
            return this.datacoding;
        }

        public String getDirection() {
            return this.direction;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }
}

