/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtils {
    private static final Logger log = LoggerFactory.getLogger(CryptoUtils.class);
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    private CryptoUtils() {
    }

    public static byte[] hmac256(byte[] key, String msg) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, mac.getAlgorithm());
            mac.init(secretKeySpec);
            return mac.doFinal(msg.getBytes(UTF8));
        }
        catch (Exception e) {
            log.error("Failed to calculate HMAC-SHA256: {}", (Object)e.getMessage());
            throw new RuntimeException("Failed to calculate HMAC-SHA256", e);
        }
    }

    public static String sha256Hex(String data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(data.getBytes(UTF8));
            return CryptoUtils.bytesToHex(digest).toLowerCase();
        }
        catch (Exception e) {
            log.error("Failed to calculate SHA256: {}", (Object)e.getMessage());
            throw new RuntimeException("Failed to calculate SHA256", e);
        }
    }

    public static String hmacSha256Base64(String key, String data) {
        byte[] hmacResult = CryptoUtils.hmac256(key.getBytes(UTF8), data);
        return Base64.getEncoder().encodeToString(hmacResult);
    }

    public static String hmacSha256Hex(String key, String data) {
        return CryptoUtils.hmacSha256Hex(key.getBytes(UTF8), data);
    }

    public static String hmacSha256Hex(byte[] key, String data) {
        byte[] hmacResult = CryptoUtils.hmac256(key, data);
        return CryptoUtils.bytesToHex(hmacResult).toLowerCase();
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte byteValue : bytes) {
            result.append(String.format("%02x", byteValue));
        }
        return result.toString();
    }
}

