/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.manager.pojo.dto.MonitorDto;
import org.apache.hertzbeat.manager.service.MonitorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Monitor Manage API")
@RestController
@RequestMapping(path={"/api/monitor"}, produces={"application/json"})
public class MonitorController {
    @Autowired
    private MonitorService monitorService;

    @PostMapping
    @Operation(summary="Add a monitoring application", description="Add a monitoring application")
    public ResponseEntity<Message<Void>> addNewMonitor(@Valid @RequestBody MonitorDto monitorDto) {
        this.monitorService.validate(monitorDto, false);
        this.monitorService.addMonitor(monitorDto.getMonitor(), monitorDto.getParams(), monitorDto.getCollector(), monitorDto.getGrafanaDashboard());
        return ResponseEntity.ok((Object)Message.success((String)"Add success"));
    }

    @PutMapping
    @Operation(summary="Modify an existing monitoring application", description="Modify an existing monitoring application")
    public ResponseEntity<Message<Void>> modifyMonitor(@Valid @RequestBody MonitorDto monitorDto) {
        this.monitorService.validate(monitorDto, true);
        this.monitorService.modifyMonitor(monitorDto.getMonitor(), monitorDto.getParams(), monitorDto.getCollector(), monitorDto.getGrafanaDashboard());
        return ResponseEntity.ok((Object)Message.success((String)"Modify success"));
    }

    @GetMapping(path={"/{id}"})
    @Operation(summary="Obtain monitoring information based on monitoring ID", description="Obtain monitoring information based on monitoring ID")
    public ResponseEntity<Message<MonitorDto>> getMonitor(@Parameter(description="Monitoring task ID", example="6565463543") @PathVariable(value="id") long id) {
        MonitorDto monitorDto = this.monitorService.getMonitorDto(id);
        if (monitorDto == null) {
            return ResponseEntity.ok((Object)Message.fail((byte)3, (String)"Monitor not exist."));
        }
        return ResponseEntity.ok((Object)Message.success((Object)monitorDto));
    }

    @DeleteMapping(path={"/{id}"})
    @Operation(summary="Delete monitoring application based on monitoring ID", description="Delete monitoring application based on monitoring ID")
    public ResponseEntity<Message<Void>> deleteMonitor(@Parameter(description="en: Monitor ID", example="6565463543") @PathVariable(value="id") long id) {
        Monitor monitor = this.monitorService.getMonitor(id);
        if (monitor == null) {
            return ResponseEntity.ok((Object)Message.success((String)"The specified monitoring was not queried, please check whether the parameters are correct"));
        }
        this.monitorService.deleteMonitor(id);
        return ResponseEntity.ok((Object)Message.success((String)"Delete success"));
    }

    @PostMapping(path={"/detect"})
    @Operation(summary="Perform availability detection on this monitoring based on monitoring information", description="Perform availability detection on this monitoring based on monitoring information")
    public ResponseEntity<Message<Void>> detectMonitor(@Valid @RequestBody MonitorDto monitorDto) {
        this.monitorService.validate(monitorDto, null);
        this.monitorService.detectMonitor(monitorDto.getMonitor(), monitorDto.getParams(), monitorDto.getCollector());
        return ResponseEntity.ok((Object)Message.success((String)"Detect success."));
    }

    @PostMapping(value={"/copy/{id}"})
    @Operation(summary="Copy Monitor", description="Copy an existing monitor")
    public ResponseEntity<Message<Void>> copyMonitor(@PathVariable(value="id") Long id) {
        try {
            this.monitorService.copyMonitor(id);
            return ResponseEntity.ok((Object)Message.success((String)"Copy monitor success"));
        }
        catch (Exception e) {
            return ResponseEntity.ok((Object)Message.fail((byte)15, (String)("Copy monitor failed: " + e.getMessage())));
        }
    }
}

